/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable.PurchaseRequisitionHeaderSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
 * PurchaseRequisitionHeader} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class PurchaseRequisitionHeaderByKeyFluentHelper
    extends
    FluentHelperByKey<PurchaseRequisitionHeaderByKeyFluentHelper, PurchaseRequisitionHeader, PurchaseRequisitionHeaderSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     * PurchaseRequisitionHeader} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurchaseRequisitionHeader}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurchaseRequisitionHeader}
     * @param purchaseRequisition
     *            Purchase Requisition Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public PurchaseRequisitionHeaderByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchaseRequisition )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchaseRequisition", purchaseRequisition);
    }

    @Override
    @Nonnull
    protected Class<PurchaseRequisitionHeader> getEntityClass()
    {
        return PurchaseRequisitionHeader.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
