/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.field.PurchaseRequisitionItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.link.PurchaseRequisitionItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.link.PurchaseRequisitionItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable.PurchaseRequisitionItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchaseRequisitionItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchaseRequisitionItem extends VdmEntity<PurchaseRequisitionItem>
{

    /**
     * Selector for all available fields of PurchaseRequisitionItem.
     *
     */
    public final static PurchaseRequisitionItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @Key
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASE_REQUISITION =
        new PurchaseRequisitionItemField<String>("PurchaseRequisition");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @Key
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASE_REQUISITION_ITEM =
        new PurchaseRequisitionItemField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchase Order Number
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASING_DOCUMENT =
        new PurchaseRequisitionItemField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Purchase order item number
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASING_DOCUMENT_ITEM =
        new PurchaseRequisitionItemField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnReleaseStatus</b>
     * </p>
     *
     * @return Requisition Processing State
     */
    @SerializedName( "PurReqnReleaseStatus" )
    @JsonProperty( "PurReqnReleaseStatus" )
    @Nullable
    @ODataField( odataName = "PurReqnReleaseStatus" )
    private String purReqnReleaseStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnReleaseStatus</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_RELEASE_STATUS =
        new PurchaseRequisitionItemField<String>("PurReqnReleaseStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionType</b>
     * </p>
     *
     * @return Purchase Requisition Document Type
     */
    @SerializedName( "PurchaseRequisitionType" )
    @JsonProperty( "PurchaseRequisitionType" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionType" )
    private String purchaseRequisitionType;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionType</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASE_REQUISITION_TYPE =
        new PurchaseRequisitionItemField<String>("PurchaseRequisitionType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentSubtype</b>
     * </p>
     *
     * @return Control indicator for purchasing document type
     */
    @SerializedName( "PurchasingDocumentSubtype" )
    @JsonProperty( "PurchasingDocumentSubtype" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentSubtype" )
    private String purchasingDocumentSubtype;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentSubtype</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASING_DOCUMENT_SUBTYPE =
        new PurchaseRequisitionItemField<String>("PurchasingDocumentSubtype");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @return Item category in purchasing document
     */
    @SerializedName( "PurchasingDocumentItemCategory" )
    @JsonProperty( "PurchasingDocumentItemCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItemCategory" )
    private String purchasingDocumentItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItemCategory</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASING_DOCUMENT_ITEM_CATEGORY =
        new PurchaseRequisitionItemField<String>("PurchasingDocumentItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItemText</b>
     * </p>
     *
     * @return Short Text
     */
    @SerializedName( "PurchaseRequisitionItemText" )
    @JsonProperty( "PurchaseRequisitionItemText" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItemText" )
    private String purchaseRequisitionItemText;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItemText</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASE_REQUISITION_ITEM_TEXT =
        new PurchaseRequisitionItemField<String>("PurchaseRequisitionItemText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @return Account Assignment Category
     */
    @SerializedName( "AccountAssignmentCategory" )
    @JsonProperty( "AccountAssignmentCategory" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentCategory" )
    private String accountAssignmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentCategory</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> ACCOUNT_ASSIGNMENT_CATEGORY =
        new PurchaseRequisitionItemField<String>("AccountAssignmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> MATERIAL =
        new PurchaseRequisitionItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> MATERIAL_GROUP =
        new PurchaseRequisitionItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASING_DOCUMENT_CATEGORY =
        new PurchaseRequisitionItemField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Purchase requisition quantity
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> REQUESTED_QUANTITY =
        new PurchaseRequisitionItemField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Purchase requisition unit of measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> BASE_UNIT =
        new PurchaseRequisitionItemField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionPrice</b>
     * </p>
     *
     * @return Price in Purchase Requisition
     */
    @SerializedName( "PurchaseRequisitionPrice" )
    @JsonProperty( "PurchaseRequisitionPrice" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionPrice" )
    private BigDecimal purchaseRequisitionPrice;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionPrice</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> PURCHASE_REQUISITION_PRICE =
        new PurchaseRequisitionItemField<BigDecimal>("PurchaseRequisitionPrice");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnPriceQuantity</b>
     * </p>
     *
     * @return Price unit
     */
    @SerializedName( "PurReqnPriceQuantity" )
    @JsonProperty( "PurReqnPriceQuantity" )
    @Nullable
    @ODataField( odataName = "PurReqnPriceQuantity" )
    private BigDecimal purReqnPriceQuantity;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnPriceQuantity</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> PUR_REQN_PRICE_QUANTITY =
        new PurchaseRequisitionItemField<BigDecimal>("PurReqnPriceQuantity");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoodsReceiptDuration</b>
     * </p>
     *
     * @return Goods receipt processing time in days
     */
    @SerializedName( "MaterialGoodsReceiptDuration" )
    @JsonProperty( "MaterialGoodsReceiptDuration" )
    @Nullable
    @ODataField( odataName = "MaterialGoodsReceiptDuration" )
    private BigDecimal materialGoodsReceiptDuration;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGoodsReceiptDuration</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> MATERIAL_GOODS_RECEIPT_DURATION =
        new PurchaseRequisitionItemField<BigDecimal>("MaterialGoodsReceiptDuration");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseCode</b>
     * </p>
     *
     * @return Release Indicator
     */
    @SerializedName( "ReleaseCode" )
    @JsonProperty( "ReleaseCode" )
    @Nullable
    @ODataField( odataName = "ReleaseCode" )
    private String releaseCode;
    /**
     * Use with available fluent helpers to apply the <b>ReleaseCode</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> RELEASE_CODE =
        new PurchaseRequisitionItemField<String>("ReleaseCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionReleaseDate</b>
     * </p>
     *
     * @return Purchase Requisition Release Date
     */
    @SerializedName( "PurchaseRequisitionReleaseDate" )
    @JsonProperty( "PurchaseRequisitionReleaseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurchaseRequisitionReleaseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purchaseRequisitionReleaseDate;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionReleaseDate</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<LocalDateTime> PURCHASE_REQUISITION_RELEASE_DATE =
        new PurchaseRequisitionItemField<LocalDateTime>("PurchaseRequisitionReleaseDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASING_ORGANIZATION =
        new PurchaseRequisitionItemField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASING_GROUP =
        new PurchaseRequisitionItemField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PLANT = new PurchaseRequisitionItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code of External System
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> COMPANY_CODE =
        new PurchaseRequisitionItemField<String>("CompanyCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyIsAssigned</b>
     * </p>
     *
     * @return Assigned Source of Supply
     */
    @SerializedName( "SourceOfSupplyIsAssigned" )
    @JsonProperty( "SourceOfSupplyIsAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SourceOfSupplyIsAssigned" )
    private Boolean sourceOfSupplyIsAssigned;
    /**
     * Use with available fluent helpers to apply the <b>SourceOfSupplyIsAssigned</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<Boolean> SOURCE_OF_SUPPLY_IS_ASSIGNED =
        new PurchaseRequisitionItemField<Boolean>("SourceOfSupplyIsAssigned");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @return Supplying (issuing) plant in case of stock transport order
     */
    @SerializedName( "SupplyingPlant" )
    @JsonProperty( "SupplyingPlant" )
    @Nullable
    @ODataField( odataName = "SupplyingPlant" )
    private String supplyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingPlant</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> SUPPLYING_PLANT =
        new PurchaseRequisitionItemField<String>("SupplyingPlant");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderedQuantity</b>
     * </p>
     *
     * @return Quantity ordered against this purchase requisition
     */
    @SerializedName( "OrderedQuantity" )
    @JsonProperty( "OrderedQuantity" )
    @Nullable
    @ODataField( odataName = "OrderedQuantity" )
    private BigDecimal orderedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OrderedQuantity</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> ORDERED_QUANTITY =
        new PurchaseRequisitionItemField<BigDecimal>("OrderedQuantity");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDate</b>
     * </p>
     *
     * @return Item Delivery Date
     */
    @SerializedName( "DeliveryDate" )
    @JsonProperty( "DeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime deliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDate</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<LocalDateTime> DELIVERY_DATE =
        new PurchaseRequisitionItemField<LocalDateTime>("DeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Requisition (Request) Date
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<LocalDateTime> CREATION_DATE =
        new PurchaseRequisitionItemField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @return Processing status of purchase requisition
     */
    @SerializedName( "ProcessingStatus" )
    @JsonProperty( "ProcessingStatus" )
    @Nullable
    @ODataField( odataName = "ProcessingStatus" )
    private String processingStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProcessingStatus</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PROCESSING_STATUS =
        new PurchaseRequisitionItemField<String>("ProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExternalApprovalStatus</b>
     * </p>
     *
     * @return External Processing Status
     */
    @SerializedName( "ExternalApprovalStatus" )
    @JsonProperty( "ExternalApprovalStatus" )
    @Nullable
    @ODataField( odataName = "ExternalApprovalStatus" )
    private String externalApprovalStatus;
    /**
     * Use with available fluent helpers to apply the <b>ExternalApprovalStatus</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> EXTERNAL_APPROVAL_STATUS =
        new PurchaseRequisitionItemField<String>("ExternalApprovalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASING_INFO_RECORD =
        new PurchaseRequisitionItemField<String>("PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Desired Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> SUPPLIER =
        new PurchaseRequisitionItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @ODataField( odataName = "IsDeleted" )
    private String isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> IS_DELETED =
        new PurchaseRequisitionItemField<String>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FixedSupplier</b>
     * </p>
     *
     * @return Fixed Vendor
     */
    @SerializedName( "FixedSupplier" )
    @JsonProperty( "FixedSupplier" )
    @Nullable
    @ODataField( odataName = "FixedSupplier" )
    private String fixedSupplier;
    /**
     * Use with available fluent helpers to apply the <b>FixedSupplier</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> FIXED_SUPPLIER =
        new PurchaseRequisitionItemField<String>("FixedSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RequisitionerName</b>
     * </p>
     *
     * @return Name of requisitioner/requester
     */
    @SerializedName( "RequisitionerName" )
    @JsonProperty( "RequisitionerName" )
    @Nullable
    @ODataField( odataName = "RequisitionerName" )
    private String requisitionerName;
    /**
     * Use with available fluent helpers to apply the <b>RequisitionerName</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> REQUISITIONER_NAME =
        new PurchaseRequisitionItemField<String>("RequisitionerName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> CREATED_BY_USER =
        new PurchaseRequisitionItemField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurReqCreationDate</b>
     * </p>
     *
     * @return Requisition (Request) Date
     */
    @SerializedName( "PurReqCreationDate" )
    @JsonProperty( "PurReqCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurReqCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purReqCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>PurReqCreationDate</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<LocalDateTime> PUR_REQ_CREATION_DATE =
        new PurchaseRequisitionItemField<LocalDateTime>("PurReqCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressID</b>
     * </p>
     *
     * @return Address
     */
    @SerializedName( "DeliveryAddressID" )
    @JsonProperty( "DeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressID" )
    private String deliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressID</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> DELIVERY_ADDRESS_ID =
        new PurchaseRequisitionItemField<String>("DeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualDeliveryAddressID</b>
     * </p>
     *
     * @return Manual address number in purchasing document item
     */
    @SerializedName( "ManualDeliveryAddressID" )
    @JsonProperty( "ManualDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ManualDeliveryAddressID" )
    private String manualDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ManualDeliveryAddressID</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> MANUAL_DELIVERY_ADDRESS_ID =
        new PurchaseRequisitionItemField<String>("ManualDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnItemCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "PurReqnItemCurrency" )
    @JsonProperty( "PurReqnItemCurrency" )
    @Nullable
    @ODataField( odataName = "PurReqnItemCurrency" )
    private String purReqnItemCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnItemCurrency</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_ITEM_CURRENCY =
        new PurchaseRequisitionItemField<String>("PurReqnItemCurrency");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedDeliveryDurn</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "MaterialPlannedDeliveryDurn" )
    @JsonProperty( "MaterialPlannedDeliveryDurn" )
    @Nullable
    @ODataField( odataName = "MaterialPlannedDeliveryDurn" )
    private BigDecimal materialPlannedDeliveryDurn;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPlannedDeliveryDurn</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> MATERIAL_PLANNED_DELIVERY_DURN =
        new PurchaseRequisitionItemField<BigDecimal>("MaterialPlannedDeliveryDurn");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DelivDateCategory</b>
     * </p>
     *
     * @return Category of delivery date
     */
    @SerializedName( "DelivDateCategory" )
    @JsonProperty( "DelivDateCategory" )
    @Nullable
    @ODataField( odataName = "DelivDateCategory" )
    private String delivDateCategory;
    /**
     * Use with available fluent helpers to apply the <b>DelivDateCategory</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> DELIV_DATE_CATEGORY =
        new PurchaseRequisitionItemField<String>("DelivDateCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @return Distribution Indicator for Multiple Account Assignment
     */
    @SerializedName( "MultipleAcctAssgmtDistribution" )
    @JsonProperty( "MultipleAcctAssgmtDistribution" )
    @Nullable
    @ODataField( odataName = "MultipleAcctAssgmtDistribution" )
    private String multipleAcctAssgmtDistribution;
    /**
     * Use with available fluent helpers to apply the <b>MultipleAcctAssgmtDistribution</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> MULTIPLE_ACCT_ASSGMT_DISTRIBUTION =
        new PurchaseRequisitionItemField<String>("MultipleAcctAssgmtDistribution");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> STORAGE_LOCATION =
        new PurchaseRequisitionItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPRequestor</b>
     * </p>
     *
     * @return Requestor
     */
    @SerializedName( "PurReqnSSPRequestor" )
    @JsonProperty( "PurReqnSSPRequestor" )
    @Nullable
    @ODataField( odataName = "PurReqnSSPRequestor" )
    private String purReqnSSPRequestor;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnSSPRequestor</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_SSP_REQUESTOR =
        new PurchaseRequisitionItemField<String>("PurReqnSSPRequestor");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPAuthor</b>
     * </p>
     *
     * @return Author of Requisition
     */
    @SerializedName( "PurReqnSSPAuthor" )
    @JsonProperty( "PurReqnSSPAuthor" )
    @Nullable
    @ODataField( odataName = "PurReqnSSPAuthor" )
    private String purReqnSSPAuthor;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnSSPAuthor</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_SSP_AUTHOR =
        new PurchaseRequisitionItemField<String>("PurReqnSSPAuthor");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @return Number of principal purchase agreement
     */
    @SerializedName( "PurchaseContract" )
    @JsonProperty( "PurchaseContract" )
    @Nullable
    @ODataField( odataName = "PurchaseContract" )
    private String purchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContract</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASE_CONTRACT =
        new PurchaseRequisitionItemField<String>("PurchaseContract");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSourceOfSupplyType</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurReqnSourceOfSupplyType" )
    @JsonProperty( "PurReqnSourceOfSupplyType" )
    @Nullable
    @ODataField( odataName = "PurReqnSourceOfSupplyType" )
    private String purReqnSourceOfSupplyType;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnSourceOfSupplyType</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_SOURCE_OF_SUPPLY_TYPE =
        new PurchaseRequisitionItemField<String>("PurReqnSourceOfSupplyType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Principal Purchase Agreement
     */
    @SerializedName( "PurchaseContractItem" )
    @JsonProperty( "PurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "PurchaseContractItem" )
    private String purchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractItem</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASE_CONTRACT_ITEM =
        new PurchaseRequisitionItemField<String>("PurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionPosting</b>
     * </p>
     *
     * @return Consumption posting
     */
    @SerializedName( "ConsumptionPosting" )
    @JsonProperty( "ConsumptionPosting" )
    @Nullable
    @ODataField( odataName = "ConsumptionPosting" )
    private String consumptionPosting;
    /**
     * Use with available fluent helpers to apply the <b>ConsumptionPosting</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> CONSUMPTION_POSTING =
        new PurchaseRequisitionItemField<String>("ConsumptionPosting");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnOrigin</b>
     * </p>
     *
     * @return Creation indicator (purchase requisition/schedule lines)
     */
    @SerializedName( "PurReqnOrigin" )
    @JsonProperty( "PurReqnOrigin" )
    @Nullable
    @ODataField( odataName = "PurReqnOrigin" )
    private String purReqnOrigin;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnOrigin</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_ORIGIN =
        new PurchaseRequisitionItemField<String>("PurReqnOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPCatalog</b>
     * </p>
     *
     * @return Technical Key of a Web Service (for Example - a Catalog)
     */
    @SerializedName( "PurReqnSSPCatalog" )
    @JsonProperty( "PurReqnSSPCatalog" )
    @Nullable
    @ODataField( odataName = "PurReqnSSPCatalog" )
    private String purReqnSSPCatalog;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnSSPCatalog</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_SSP_CATALOG =
        new PurchaseRequisitionItemField<String>("PurReqnSSPCatalog");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPCatalogItem</b>
     * </p>
     *
     * @return Catalog Item Id
     */
    @SerializedName( "PurReqnSSPCatalogItem" )
    @JsonProperty( "PurReqnSSPCatalogItem" )
    @Nullable
    @ODataField( odataName = "PurReqnSSPCatalogItem" )
    private String purReqnSSPCatalogItem;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnSSPCatalogItem</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_SSP_CATALOG_ITEM =
        new PurchaseRequisitionItemField<String>("PurReqnSSPCatalogItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPCrossCatalogItem</b>
     * </p>
     *
     * @return Catalog Item Key
     */
    @SerializedName( "PurReqnSSPCrossCatalogItem" )
    @JsonProperty( "PurReqnSSPCrossCatalogItem" )
    @Nullable
    @ODataField( odataName = "PurReqnSSPCrossCatalogItem" )
    private Integer purReqnSSPCrossCatalogItem;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnSSPCrossCatalogItem</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<Integer> PUR_REQN_SSP_CROSS_CATALOG_ITEM =
        new PurchaseRequisitionItemField<Integer>("PurReqnSSPCrossCatalogItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsPurReqnBlocked</b>
     * </p>
     *
     * @return Purchase Requisition Blocked
     */
    @SerializedName( "IsPurReqnBlocked" )
    @JsonProperty( "IsPurReqnBlocked" )
    @Nullable
    @ODataField( odataName = "IsPurReqnBlocked" )
    private String isPurReqnBlocked;
    /**
     * Use with available fluent helpers to apply the <b>IsPurReqnBlocked</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> IS_PUR_REQN_BLOCKED =
        new PurchaseRequisitionItemField<String>("IsPurReqnBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ItemDeliveryAddressID</b>
     * </p>
     *
     * @return Number of delivery address
     */
    @SerializedName( "ItemDeliveryAddressID" )
    @JsonProperty( "ItemDeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "ItemDeliveryAddressID" )
    private String itemDeliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>ItemDeliveryAddressID</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> ITEM_DELIVERY_ADDRESS_ID =
        new PurchaseRequisitionItemField<String>("ItemDeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> LANGUAGE =
        new PurchaseRequisitionItemField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsClosed</b>
     * </p>
     *
     * @return Purchase requisition closed
     */
    @SerializedName( "IsClosed" )
    @JsonProperty( "IsClosed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsClosed" )
    private Boolean isClosed;
    /**
     * Use with available fluent helpers to apply the <b>IsClosed</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<Boolean> IS_CLOSED =
        new PurchaseRequisitionItemField<Boolean>("IsClosed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseIsNotCompleted</b>
     * </p>
     *
     * @return Release Not Yet Completely Effected
     */
    @SerializedName( "ReleaseIsNotCompleted" )
    @JsonProperty( "ReleaseIsNotCompleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReleaseIsNotCompleted" )
    private Boolean releaseIsNotCompleted;
    /**
     * Use with available fluent helpers to apply the <b>ReleaseIsNotCompleted</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<Boolean> RELEASE_IS_NOT_COMPLETED =
        new PurchaseRequisitionItemField<Boolean>("ReleaseIsNotCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @return Service Performer
     */
    @SerializedName( "ServicePerformer" )
    @JsonProperty( "ServicePerformer" )
    @Nullable
    @ODataField( odataName = "ServicePerformer" )
    private String servicePerformer;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformer</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> SERVICE_PERFORMER =
        new PurchaseRequisitionItemField<String>("ServicePerformer");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @return Product Type Group
     */
    @SerializedName( "ProductType" )
    @JsonProperty( "ProductType" )
    @Nullable
    @ODataField( odataName = "ProductType" )
    private String productType;
    /**
     * Use with available fluent helpers to apply the <b>ProductType</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PRODUCT_TYPE =
        new PurchaseRequisitionItemField<String>("ProductType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionStatus</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "PurchaseRequisitionStatus" )
    @JsonProperty( "PurchaseRequisitionStatus" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionStatus" )
    private String purchaseRequisitionStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionStatus</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASE_REQUISITION_STATUS =
        new PurchaseRequisitionItemField<String>("PurchaseRequisitionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseStrategy</b>
     * </p>
     *
     * @return Release strategy in the purchase requisition
     */
    @SerializedName( "ReleaseStrategy" )
    @JsonProperty( "ReleaseStrategy" )
    @Nullable
    @ODataField( odataName = "ReleaseStrategy" )
    private String releaseStrategy;
    /**
     * Use with available fluent helpers to apply the <b>ReleaseStrategy</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> RELEASE_STRATEGY =
        new PurchaseRequisitionItemField<String>("ReleaseStrategy");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDate</b>
     * </p>
     *
     * @return Start Date for Period of Performance
     */
    @SerializedName( "PerformancePeriodStartDate" )
    @JsonProperty( "PerformancePeriodStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime performancePeriodStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodStartDate</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<LocalDateTime> PERFORMANCE_PERIOD_START_DATE =
        new PurchaseRequisitionItemField<LocalDateTime>("PerformancePeriodStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDate</b>
     * </p>
     *
     * @return End Date for Period of Performance
     */
    @SerializedName( "PerformancePeriodEndDate" )
    @JsonProperty( "PerformancePeriodEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PerformancePeriodEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime performancePeriodEndDate;
    /**
     * Use with available fluent helpers to apply the <b>PerformancePeriodEndDate</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<LocalDateTime> PERFORMANCE_PERIOD_END_DATE =
        new PurchaseRequisitionItemField<LocalDateTime>("PerformancePeriodEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceType</b>
     * </p>
     *
     * @return Use Requisition Price in Purchase Order
     */
    @SerializedName( "PurchaseOrderPriceType" )
    @JsonProperty( "PurchaseOrderPriceType" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderPriceType" )
    private String purchaseOrderPriceType;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderPriceType</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PURCHASE_ORDER_PRICE_TYPE =
        new PurchaseRequisitionItemField<String>("PurchaseOrderPriceType");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @return Material Number Used by Supplier
     */
    @SerializedName( "SupplierMaterialNumber" )
    @JsonProperty( "SupplierMaterialNumber" )
    @Nullable
    @ODataField( odataName = "SupplierMaterialNumber" )
    private String supplierMaterialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierMaterialNumber</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> SUPPLIER_MATERIAL_NUMBER =
        new PurchaseRequisitionItemField<String>("SupplierMaterialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> BATCH = new PurchaseRequisitionItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRevisionLevel</b>
     * </p>
     *
     * @return Revision Level
     */
    @SerializedName( "MaterialRevisionLevel" )
    @JsonProperty( "MaterialRevisionLevel" )
    @Nullable
    @ODataField( odataName = "MaterialRevisionLevel" )
    private String materialRevisionLevel;
    /**
     * Use with available fluent helpers to apply the <b>MaterialRevisionLevel</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> MATERIAL_REVISION_LEVEL =
        new PurchaseRequisitionItemField<String>("MaterialRevisionLevel");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MinRemainingShelfLife</b>
     * </p>
     *
     * @return Minimum Remaining Shelf Life
     */
    @SerializedName( "MinRemainingShelfLife" )
    @JsonProperty( "MinRemainingShelfLife" )
    @Nullable
    @ODataField( odataName = "MinRemainingShelfLife" )
    private BigDecimal minRemainingShelfLife;
    /**
     * Use with available fluent helpers to apply the <b>MinRemainingShelfLife</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> MIN_REMAINING_SHELF_LIFE =
        new PurchaseRequisitionItemField<BigDecimal>("MinRemainingShelfLife");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetAmount</b>
     * </p>
     *
     * @return The itemNetAmount contained in this entity.
     */
    @SerializedName( "ItemNetAmount" )
    @JsonProperty( "ItemNetAmount" )
    @Nullable
    @ODataField( odataName = "ItemNetAmount" )
    private BigDecimal itemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetAmount</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> ITEM_NET_AMOUNT =
        new PurchaseRequisitionItemField<BigDecimal>("ItemNetAmount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @return Goods Receipt Indicator
     */
    @SerializedName( "GoodsReceiptIsExpected" )
    @JsonProperty( "GoodsReceiptIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsExpected" )
    private Boolean goodsReceiptIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsExpected</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<Boolean> GOODS_RECEIPT_IS_EXPECTED =
        new PurchaseRequisitionItemField<Boolean>("GoodsReceiptIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @return Invoice Receipt Indicator
     */
    @SerializedName( "InvoiceIsExpected" )
    @JsonProperty( "InvoiceIsExpected" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsExpected" )
    private Boolean invoiceIsExpected;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsExpected</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<Boolean> INVOICE_IS_EXPECTED =
        new PurchaseRequisitionItemField<Boolean>("InvoiceIsExpected");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @return Goods Receipt, Non-Valuated
     */
    @SerializedName( "GoodsReceiptIsNonValuated" )
    @JsonProperty( "GoodsReceiptIsNonValuated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GoodsReceiptIsNonValuated" )
    private Boolean goodsReceiptIsNonValuated;
    /**
     * Use with available fluent helpers to apply the <b>GoodsReceiptIsNonValuated</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<Boolean> GOODS_RECEIPT_IS_NON_VALUATED =
        new PurchaseRequisitionItemField<Boolean>("GoodsReceiptIsNonValuated");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTracking</b>
     * </p>
     *
     * @return Requirement Tracking Number
     */
    @SerializedName( "RequirementTracking" )
    @JsonProperty( "RequirementTracking" )
    @Nullable
    @ODataField( odataName = "RequirementTracking" )
    private String requirementTracking;
    /**
     * Use with available fluent helpers to apply the <b>RequirementTracking</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> REQUIREMENT_TRACKING =
        new PurchaseRequisitionItemField<String>("RequirementTracking");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> MRP_CONTROLLER =
        new PurchaseRequisitionItemField<String>("MRPController");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> TAX_CODE =
        new PurchaseRequisitionItemField<String>("TaxCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionIsFixed</b>
     * </p>
     *
     * @return Purchase requisition is fixed
     */
    @SerializedName( "PurchaseRequisitionIsFixed" )
    @JsonProperty( "PurchaseRequisitionIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurchaseRequisitionIsFixed" )
    private Boolean purchaseRequisitionIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionIsFixed</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<Boolean> PURCHASE_REQUISITION_IS_FIXED =
        new PurchaseRequisitionItemField<Boolean>("PurchaseRequisitionIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Manual address number in purchasing document item
     */
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> ADDRESS_ID =
        new PurchaseRequisitionItemField<String>("AddressID");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PurchaseRequisitionItemField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> RESERVATION =
        new PurchaseRequisitionItemField<String>("Reservation");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExpectedOverallLimitAmount</b>
     * </p>
     *
     * @return Expected Value of Overall Limit
     */
    @SerializedName( "ExpectedOverallLimitAmount" )
    @JsonProperty( "ExpectedOverallLimitAmount" )
    @Nullable
    @ODataField( odataName = "ExpectedOverallLimitAmount" )
    private BigDecimal expectedOverallLimitAmount;
    /**
     * Use with available fluent helpers to apply the <b>ExpectedOverallLimitAmount</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> EXPECTED_OVERALL_LIMIT_AMOUNT =
        new PurchaseRequisitionItemField<BigDecimal>("ExpectedOverallLimitAmount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OverallLimitAmount</b>
     * </p>
     *
     * @return Overall Limit
     */
    @SerializedName( "OverallLimitAmount" )
    @JsonProperty( "OverallLimitAmount" )
    @Nullable
    @ODataField( odataName = "OverallLimitAmount" )
    private BigDecimal overallLimitAmount;
    /**
     * Use with available fluent helpers to apply the <b>OverallLimitAmount</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<BigDecimal> OVERALL_LIMIT_AMOUNT =
        new PurchaseRequisitionItemField<BigDecimal>("OverallLimitAmount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurContractForOverallLimit</b>
     * </p>
     *
     * @return Purchase Contract for Enhanced Limit
     */
    @SerializedName( "PurContractForOverallLimit" )
    @JsonProperty( "PurContractForOverallLimit" )
    @Nullable
    @ODataField( odataName = "PurContractForOverallLimit" )
    private String purContractForOverallLimit;
    /**
     * Use with available fluent helpers to apply the <b>PurContractForOverallLimit</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_CONTRACT_FOR_OVERALL_LIMIT =
        new PurchaseRequisitionItemField<String>("PurContractForOverallLimit");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnExternalReference</b>
     * </p>
     *
     * @return Document Number of External Document
     */
    @SerializedName( "PurReqnExternalReference" )
    @JsonProperty( "PurReqnExternalReference" )
    @Nullable
    @ODataField( odataName = "PurReqnExternalReference" )
    private String purReqnExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnExternalReference</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_EXTERNAL_REFERENCE =
        new PurchaseRequisitionItemField<String>("PurReqnExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnItemExternalReference</b>
     * </p>
     *
     * @return Item Number of External Document
     */
    @SerializedName( "PurReqnItemExternalReference" )
    @JsonProperty( "PurReqnItemExternalReference" )
    @Nullable
    @ODataField( odataName = "PurReqnItemExternalReference" )
    private String purReqnItemExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnItemExternalReference</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_ITEM_EXTERNAL_REFERENCE =
        new PurchaseRequisitionItemField<String>("PurReqnItemExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnExternalSystemId</b>
     * </p>
     *
     * @return External System ID
     */
    @SerializedName( "PurReqnExternalSystemId" )
    @JsonProperty( "PurReqnExternalSystemId" )
    @Nullable
    @ODataField( odataName = "PurReqnExternalSystemId" )
    private String purReqnExternalSystemId;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnExternalSystemId</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_EXTERNAL_SYSTEM_ID =
        new PurchaseRequisitionItemField<String>("PurReqnExternalSystemId");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnExternalSystemType</b>
     * </p>
     *
     * @return Type of External System
     */
    @SerializedName( "PurReqnExternalSystemType" )
    @JsonProperty( "PurReqnExternalSystemType" )
    @Nullable
    @ODataField( odataName = "PurReqnExternalSystemType" )
    private String purReqnExternalSystemType;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnExternalSystemType</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_EXTERNAL_SYSTEM_TYPE =
        new PurchaseRequisitionItemField<String>("PurReqnExternalSystemType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnTypeExternalReference</b>
     * </p>
     *
     * @return External Document Type
     */
    @SerializedName( "PurReqnTypeExternalReference" )
    @JsonProperty( "PurReqnTypeExternalReference" )
    @Nullable
    @ODataField( odataName = "PurReqnTypeExternalReference" )
    private String purReqnTypeExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnTypeExternalReference</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_TYPE_EXTERNAL_REFERENCE =
        new PurchaseRequisitionItemField<String>("PurReqnTypeExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnProcessingType</b>
     * </p>
     *
     * @return Processing State
     */
    @SerializedName( "PurReqnProcessingType" )
    @JsonProperty( "PurReqnProcessingType" )
    @Nullable
    @ODataField( odataName = "PurReqnProcessingType" )
    private String purReqnProcessingType;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnProcessingType</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_PROCESSING_TYPE =
        new PurchaseRequisitionItemField<String>("PurReqnProcessingType");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnProcessingDateTime</b>
     * </p>
     *
     * @return Timestamp
     */
    @SerializedName( "PurReqnProcessingDateTime" )
    @JsonProperty( "PurReqnProcessingDateTime" )
    @Nullable
    @ODataField( odataName = "PurReqnProcessingDateTime" )
    private String purReqnProcessingDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PurReqnProcessingDateTime</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PUR_REQN_PROCESSING_DATE_TIME =
        new PurchaseRequisitionItemField<String>("PurReqnProcessingDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBackendBusSyst</b>
     * </p>
     *
     * @return Connected System
     */
    @SerializedName( "ProcmtHubBackendBusSyst" )
    @JsonProperty( "ProcmtHubBackendBusSyst" )
    @Nullable
    @ODataField( odataName = "ProcmtHubBackendBusSyst" )
    private String procmtHubBackendBusSyst;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubBackendBusSyst</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> PROCMT_HUB_BACKEND_BUS_SYST =
        new PurchaseRequisitionItemField<String>("ProcmtHubBackendBusSyst");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SSPAuthorExternalBPIdnNumber</b>
     * </p>
     *
     * @return BP ID of Author
     */
    @SerializedName( "SSPAuthorExternalBPIdnNumber" )
    @JsonProperty( "SSPAuthorExternalBPIdnNumber" )
    @Nullable
    @ODataField( odataName = "SSPAuthorExternalBPIdnNumber" )
    private String sSPAuthorExternalBPIdnNumber;
    /**
     * Use with available fluent helpers to apply the <b>SSPAuthorExternalBPIdnNumber</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> SSP_AUTHOR_EXTERNAL_BP_IDN_NUMBER =
        new PurchaseRequisitionItemField<String>("SSPAuthorExternalBPIdnNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SSPReqrUserId</b>
     * </p>
     *
     * @return Requestor User ID
     */
    @SerializedName( "SSPReqrUserId" )
    @JsonProperty( "SSPReqrUserId" )
    @Nullable
    @ODataField( odataName = "SSPReqrUserId" )
    private String sSPReqrUserId;
    /**
     * Use with available fluent helpers to apply the <b>SSPReqrUserId</b> field to query operations.
     *
     */
    public final static PurchaseRequisitionItemField<String> SSP_REQR_USER_ID =
        new PurchaseRequisitionItemField<String>("SSPReqrUserId");
    /**
     * Navigation property <b>to_PurchaseReqn</b> for <b>PurchaseRequisitionItem</b> to single
     * <b>PurchaseRequisitionHeader</b>.
     *
     */
    @SerializedName( "to_PurchaseReqn" )
    @JsonProperty( "to_PurchaseReqn" )
    @ODataField( odataName = "to_PurchaseReqn" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurchaseRequisitionHeader toPurchaseReqn;
    /**
     * Navigation property <b>to_PurchaseReqnAcctAssgmt</b> for <b>PurchaseRequisitionItem</b> to multiple
     * <b>PurReqnAcctAssgmt</b>.
     *
     */
    @SerializedName( "to_PurchaseReqnAcctAssgmt" )
    @JsonProperty( "to_PurchaseReqnAcctAssgmt" )
    @ODataField( odataName = "to_PurchaseReqnAcctAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurReqnAcctAssgmt> toPurchaseReqnAcctAssgmt;
    /**
     * Navigation property <b>to_PurchaseReqnDeliveryAddress</b> for <b>PurchaseRequisitionItem</b> to single
     * <b>PurReqAddDelivery</b>.
     *
     */
    @SerializedName( "to_PurchaseReqnDeliveryAddress" )
    @JsonProperty( "to_PurchaseReqnDeliveryAddress" )
    @ODataField( odataName = "to_PurchaseReqnDeliveryAddress" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurReqAddDelivery toPurchaseReqnDeliveryAddress;
    /**
     * Navigation property <b>to_PurchaseReqnItemText</b> for <b>PurchaseRequisitionItem</b> to multiple
     * <b>PurchaseReqnItemText</b>.
     *
     */
    @SerializedName( "to_PurchaseReqnItemText" )
    @JsonProperty( "to_PurchaseReqnItemText" )
    @ODataField( odataName = "to_PurchaseReqnItemText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurchaseReqnItemText> toPurchaseReqnItemText;
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseReqn</b> navigation property to query operations.
     *
     */
    public final static PurchaseRequisitionItemOneToOneLink<PurchaseRequisitionHeader> TO_PURCHASE_REQN =
        new PurchaseRequisitionItemOneToOneLink<PurchaseRequisitionHeader>("to_PurchaseReqn");
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseReqnAcctAssgmt</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseRequisitionItemLink<PurReqnAcctAssgmt> TO_PURCHASE_REQN_ACCT_ASSGMT =
        new PurchaseRequisitionItemLink<PurReqnAcctAssgmt>("to_PurchaseReqnAcctAssgmt");
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseReqnDeliveryAddress</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseRequisitionItemOneToOneLink<PurReqAddDelivery> TO_PURCHASE_REQN_DELIVERY_ADDRESS =
        new PurchaseRequisitionItemOneToOneLink<PurReqAddDelivery>("to_PurchaseReqnDeliveryAddress");
    /**
     * Use with available fluent helpers to apply the <b>to_PurchaseReqnItemText</b> navigation property to query
     * operations.
     *
     */
    public final static PurchaseRequisitionItemLink<PurchaseReqnItemText> TO_PURCHASE_REQN_ITEM_TEXT =
        new PurchaseRequisitionItemLink<PurchaseReqnItemText>("to_PurchaseReqnItemText");

    @Nonnull
    @Override
    public Class<PurchaseRequisitionItem> getType()
    {
        return PurchaseRequisitionItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchase Order Number
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Purchase order item number
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnReleaseStatus</b>
     * </p>
     *
     * @param purReqnReleaseStatus
     *            Requisition Processing State
     */
    public void setPurReqnReleaseStatus( @Nullable final String purReqnReleaseStatus )
    {
        rememberChangedField("PurReqnReleaseStatus", this.purReqnReleaseStatus);
        this.purReqnReleaseStatus = purReqnReleaseStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionType</b>
     * </p>
     *
     * @param purchaseRequisitionType
     *            Purchase Requisition Document Type
     */
    public void setPurchaseRequisitionType( @Nullable final String purchaseRequisitionType )
    {
        rememberChangedField("PurchaseRequisitionType", this.purchaseRequisitionType);
        this.purchaseRequisitionType = purchaseRequisitionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentSubtype</b>
     * </p>
     *
     * @param purchasingDocumentSubtype
     *            Control indicator for purchasing document type
     */
    public void setPurchasingDocumentSubtype( @Nullable final String purchasingDocumentSubtype )
    {
        rememberChangedField("PurchasingDocumentSubtype", this.purchasingDocumentSubtype);
        this.purchasingDocumentSubtype = purchasingDocumentSubtype;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItemCategory</b>
     * </p>
     *
     * @param purchasingDocumentItemCategory
     *            Item category in purchasing document
     */
    public void setPurchasingDocumentItemCategory( @Nullable final String purchasingDocumentItemCategory )
    {
        rememberChangedField("PurchasingDocumentItemCategory", this.purchasingDocumentItemCategory);
        this.purchasingDocumentItemCategory = purchasingDocumentItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItemText</b>
     * </p>
     *
     * @param purchaseRequisitionItemText
     *            Short Text
     */
    public void setPurchaseRequisitionItemText( @Nullable final String purchaseRequisitionItemText )
    {
        rememberChangedField("PurchaseRequisitionItemText", this.purchaseRequisitionItemText);
        this.purchaseRequisitionItemText = purchaseRequisitionItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentCategory</b>
     * </p>
     *
     * @param accountAssignmentCategory
     *            Account Assignment Category
     */
    public void setAccountAssignmentCategory( @Nullable final String accountAssignmentCategory )
    {
        rememberChangedField("AccountAssignmentCategory", this.accountAssignmentCategory);
        this.accountAssignmentCategory = accountAssignmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Purchase requisition quantity
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Purchase requisition unit of measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionPrice</b>
     * </p>
     *
     * @param purchaseRequisitionPrice
     *            Price in Purchase Requisition
     */
    public void setPurchaseRequisitionPrice( @Nullable final BigDecimal purchaseRequisitionPrice )
    {
        rememberChangedField("PurchaseRequisitionPrice", this.purchaseRequisitionPrice);
        this.purchaseRequisitionPrice = purchaseRequisitionPrice;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnPriceQuantity</b>
     * </p>
     *
     * @param purReqnPriceQuantity
     *            Price unit
     */
    public void setPurReqnPriceQuantity( @Nullable final BigDecimal purReqnPriceQuantity )
    {
        rememberChangedField("PurReqnPriceQuantity", this.purReqnPriceQuantity);
        this.purReqnPriceQuantity = purReqnPriceQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoodsReceiptDuration</b>
     * </p>
     *
     * @param materialGoodsReceiptDuration
     *            Goods receipt processing time in days
     */
    public void setMaterialGoodsReceiptDuration( @Nullable final BigDecimal materialGoodsReceiptDuration )
    {
        rememberChangedField("MaterialGoodsReceiptDuration", this.materialGoodsReceiptDuration);
        this.materialGoodsReceiptDuration = materialGoodsReceiptDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseCode</b>
     * </p>
     *
     * @param releaseCode
     *            Release Indicator
     */
    public void setReleaseCode( @Nullable final String releaseCode )
    {
        rememberChangedField("ReleaseCode", this.releaseCode);
        this.releaseCode = releaseCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionReleaseDate</b>
     * </p>
     *
     * @param purchaseRequisitionReleaseDate
     *            Purchase Requisition Release Date
     */
    public void setPurchaseRequisitionReleaseDate( @Nullable final LocalDateTime purchaseRequisitionReleaseDate )
    {
        rememberChangedField("PurchaseRequisitionReleaseDate", this.purchaseRequisitionReleaseDate);
        this.purchaseRequisitionReleaseDate = purchaseRequisitionReleaseDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code of External System
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyIsAssigned</b>
     * </p>
     *
     * @param sourceOfSupplyIsAssigned
     *            Assigned Source of Supply
     */
    public void setSourceOfSupplyIsAssigned( @Nullable final Boolean sourceOfSupplyIsAssigned )
    {
        rememberChangedField("SourceOfSupplyIsAssigned", this.sourceOfSupplyIsAssigned);
        this.sourceOfSupplyIsAssigned = sourceOfSupplyIsAssigned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @param supplyingPlant
     *            Supplying (issuing) plant in case of stock transport order
     */
    public void setSupplyingPlant( @Nullable final String supplyingPlant )
    {
        rememberChangedField("SupplyingPlant", this.supplyingPlant);
        this.supplyingPlant = supplyingPlant;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderedQuantity</b>
     * </p>
     *
     * @param orderedQuantity
     *            Quantity ordered against this purchase requisition
     */
    public void setOrderedQuantity( @Nullable final BigDecimal orderedQuantity )
    {
        rememberChangedField("OrderedQuantity", this.orderedQuantity);
        this.orderedQuantity = orderedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDate</b>
     * </p>
     *
     * @param deliveryDate
     *            Item Delivery Date
     */
    public void setDeliveryDate( @Nullable final LocalDateTime deliveryDate )
    {
        rememberChangedField("DeliveryDate", this.deliveryDate);
        this.deliveryDate = deliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Requisition (Request) Date
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @param processingStatus
     *            Processing status of purchase requisition
     */
    public void setProcessingStatus( @Nullable final String processingStatus )
    {
        rememberChangedField("ProcessingStatus", this.processingStatus);
        this.processingStatus = processingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ExternalApprovalStatus</b>
     * </p>
     *
     * @param externalApprovalStatus
     *            External Processing Status
     */
    public void setExternalApprovalStatus( @Nullable final String externalApprovalStatus )
    {
        rememberChangedField("ExternalApprovalStatus", this.externalApprovalStatus);
        this.externalApprovalStatus = externalApprovalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Desired Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Deletion Indicator in Purchasing Document
     */
    public void setIsDeleted( @Nullable final String isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FixedSupplier</b>
     * </p>
     *
     * @param fixedSupplier
     *            Fixed Vendor
     */
    public void setFixedSupplier( @Nullable final String fixedSupplier )
    {
        rememberChangedField("FixedSupplier", this.fixedSupplier);
        this.fixedSupplier = fixedSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RequisitionerName</b>
     * </p>
     *
     * @param requisitionerName
     *            Name of requisitioner/requester
     */
    public void setRequisitionerName( @Nullable final String requisitionerName )
    {
        rememberChangedField("RequisitionerName", this.requisitionerName);
        this.requisitionerName = requisitionerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurReqCreationDate</b>
     * </p>
     *
     * @param purReqCreationDate
     *            Requisition (Request) Date
     */
    public void setPurReqCreationDate( @Nullable final LocalDateTime purReqCreationDate )
    {
        rememberChangedField("PurReqCreationDate", this.purReqCreationDate);
        this.purReqCreationDate = purReqCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressID</b>
     * </p>
     *
     * @param deliveryAddressID
     *            Address
     */
    public void setDeliveryAddressID( @Nullable final String deliveryAddressID )
    {
        rememberChangedField("DeliveryAddressID", this.deliveryAddressID);
        this.deliveryAddressID = deliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ManualDeliveryAddressID</b>
     * </p>
     *
     * @param manualDeliveryAddressID
     *            Manual address number in purchasing document item
     */
    public void setManualDeliveryAddressID( @Nullable final String manualDeliveryAddressID )
    {
        rememberChangedField("ManualDeliveryAddressID", this.manualDeliveryAddressID);
        this.manualDeliveryAddressID = manualDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnItemCurrency</b>
     * </p>
     *
     * @param purReqnItemCurrency
     *            Currency Key
     */
    public void setPurReqnItemCurrency( @Nullable final String purReqnItemCurrency )
    {
        rememberChangedField("PurReqnItemCurrency", this.purReqnItemCurrency);
        this.purReqnItemCurrency = purReqnItemCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedDeliveryDurn</b>
     * </p>
     *
     * @param materialPlannedDeliveryDurn
     *            Planned Delivery Time in Days
     */
    public void setMaterialPlannedDeliveryDurn( @Nullable final BigDecimal materialPlannedDeliveryDurn )
    {
        rememberChangedField("MaterialPlannedDeliveryDurn", this.materialPlannedDeliveryDurn);
        this.materialPlannedDeliveryDurn = materialPlannedDeliveryDurn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DelivDateCategory</b>
     * </p>
     *
     * @param delivDateCategory
     *            Category of delivery date
     */
    public void setDelivDateCategory( @Nullable final String delivDateCategory )
    {
        rememberChangedField("DelivDateCategory", this.delivDateCategory);
        this.delivDateCategory = delivDateCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleAcctAssgmtDistribution</b>
     * </p>
     *
     * @param multipleAcctAssgmtDistribution
     *            Distribution Indicator for Multiple Account Assignment
     */
    public void setMultipleAcctAssgmtDistribution( @Nullable final String multipleAcctAssgmtDistribution )
    {
        rememberChangedField("MultipleAcctAssgmtDistribution", this.multipleAcctAssgmtDistribution);
        this.multipleAcctAssgmtDistribution = multipleAcctAssgmtDistribution;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPRequestor</b>
     * </p>
     *
     * @param purReqnSSPRequestor
     *            Requestor
     */
    public void setPurReqnSSPRequestor( @Nullable final String purReqnSSPRequestor )
    {
        rememberChangedField("PurReqnSSPRequestor", this.purReqnSSPRequestor);
        this.purReqnSSPRequestor = purReqnSSPRequestor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPAuthor</b>
     * </p>
     *
     * @param purReqnSSPAuthor
     *            Author of Requisition
     */
    public void setPurReqnSSPAuthor( @Nullable final String purReqnSSPAuthor )
    {
        rememberChangedField("PurReqnSSPAuthor", this.purReqnSSPAuthor);
        this.purReqnSSPAuthor = purReqnSSPAuthor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     *
     * @param purchaseContract
     *            Number of principal purchase agreement
     */
    public void setPurchaseContract( @Nullable final String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSourceOfSupplyType</b>
     * </p>
     *
     * @param purReqnSourceOfSupplyType
     *            Purchasing Document Category
     */
    public void setPurReqnSourceOfSupplyType( @Nullable final String purReqnSourceOfSupplyType )
    {
        rememberChangedField("PurReqnSourceOfSupplyType", this.purReqnSourceOfSupplyType);
        this.purReqnSourceOfSupplyType = purReqnSourceOfSupplyType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractItem</b>
     * </p>
     *
     * @param purchaseContractItem
     *            Item Number of Principal Purchase Agreement
     */
    public void setPurchaseContractItem( @Nullable final String purchaseContractItem )
    {
        rememberChangedField("PurchaseContractItem", this.purchaseContractItem);
        this.purchaseContractItem = purchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConsumptionPosting</b>
     * </p>
     *
     * @param consumptionPosting
     *            Consumption posting
     */
    public void setConsumptionPosting( @Nullable final String consumptionPosting )
    {
        rememberChangedField("ConsumptionPosting", this.consumptionPosting);
        this.consumptionPosting = consumptionPosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnOrigin</b>
     * </p>
     *
     * @param purReqnOrigin
     *            Creation indicator (purchase requisition/schedule lines)
     */
    public void setPurReqnOrigin( @Nullable final String purReqnOrigin )
    {
        rememberChangedField("PurReqnOrigin", this.purReqnOrigin);
        this.purReqnOrigin = purReqnOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPCatalog</b>
     * </p>
     *
     * @param purReqnSSPCatalog
     *            Technical Key of a Web Service (for Example - a Catalog)
     */
    public void setPurReqnSSPCatalog( @Nullable final String purReqnSSPCatalog )
    {
        rememberChangedField("PurReqnSSPCatalog", this.purReqnSSPCatalog);
        this.purReqnSSPCatalog = purReqnSSPCatalog;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPCatalogItem</b>
     * </p>
     *
     * @param purReqnSSPCatalogItem
     *            Catalog Item Id
     */
    public void setPurReqnSSPCatalogItem( @Nullable final String purReqnSSPCatalogItem )
    {
        rememberChangedField("PurReqnSSPCatalogItem", this.purReqnSSPCatalogItem);
        this.purReqnSSPCatalogItem = purReqnSSPCatalogItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnSSPCrossCatalogItem</b>
     * </p>
     *
     * @param purReqnSSPCrossCatalogItem
     *            Catalog Item Key
     */
    public void setPurReqnSSPCrossCatalogItem( @Nullable final Integer purReqnSSPCrossCatalogItem )
    {
        rememberChangedField("PurReqnSSPCrossCatalogItem", this.purReqnSSPCrossCatalogItem);
        this.purReqnSSPCrossCatalogItem = purReqnSSPCrossCatalogItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsPurReqnBlocked</b>
     * </p>
     *
     * @param isPurReqnBlocked
     *            Purchase Requisition Blocked
     */
    public void setIsPurReqnBlocked( @Nullable final String isPurReqnBlocked )
    {
        rememberChangedField("IsPurReqnBlocked", this.isPurReqnBlocked);
        this.isPurReqnBlocked = isPurReqnBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ItemDeliveryAddressID</b>
     * </p>
     *
     * @param itemDeliveryAddressID
     *            Number of delivery address
     */
    public void setItemDeliveryAddressID( @Nullable final String itemDeliveryAddressID )
    {
        rememberChangedField("ItemDeliveryAddressID", this.itemDeliveryAddressID);
        this.itemDeliveryAddressID = itemDeliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsClosed</b>
     * </p>
     *
     * @param isClosed
     *            Purchase requisition closed
     */
    public void setIsClosed( @Nullable final Boolean isClosed )
    {
        rememberChangedField("IsClosed", this.isClosed);
        this.isClosed = isClosed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseIsNotCompleted</b>
     * </p>
     *
     * @param releaseIsNotCompleted
     *            Release Not Yet Completely Effected
     */
    public void setReleaseIsNotCompleted( @Nullable final Boolean releaseIsNotCompleted )
    {
        rememberChangedField("ReleaseIsNotCompleted", this.releaseIsNotCompleted);
        this.releaseIsNotCompleted = releaseIsNotCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @param servicePerformer
     *            Service Performer
     */
    public void setServicePerformer( @Nullable final String servicePerformer )
    {
        rememberChangedField("ServicePerformer", this.servicePerformer);
        this.servicePerformer = servicePerformer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     *
     * @param productType
     *            Product Type Group
     */
    public void setProductType( @Nullable final String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionStatus</b>
     * </p>
     *
     * @param purchaseRequisitionStatus
     *            Release Status
     */
    public void setPurchaseRequisitionStatus( @Nullable final String purchaseRequisitionStatus )
    {
        rememberChangedField("PurchaseRequisitionStatus", this.purchaseRequisitionStatus);
        this.purchaseRequisitionStatus = purchaseRequisitionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseStrategy</b>
     * </p>
     *
     * @param releaseStrategy
     *            Release strategy in the purchase requisition
     */
    public void setReleaseStrategy( @Nullable final String releaseStrategy )
    {
        rememberChangedField("ReleaseStrategy", this.releaseStrategy);
        this.releaseStrategy = releaseStrategy;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodStartDate</b>
     * </p>
     *
     * @param performancePeriodStartDate
     *            Start Date for Period of Performance
     */
    public void setPerformancePeriodStartDate( @Nullable final LocalDateTime performancePeriodStartDate )
    {
        rememberChangedField("PerformancePeriodStartDate", this.performancePeriodStartDate);
        this.performancePeriodStartDate = performancePeriodStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PerformancePeriodEndDate</b>
     * </p>
     *
     * @param performancePeriodEndDate
     *            End Date for Period of Performance
     */
    public void setPerformancePeriodEndDate( @Nullable final LocalDateTime performancePeriodEndDate )
    {
        rememberChangedField("PerformancePeriodEndDate", this.performancePeriodEndDate);
        this.performancePeriodEndDate = performancePeriodEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceType</b>
     * </p>
     *
     * @param purchaseOrderPriceType
     *            Use Requisition Price in Purchase Order
     */
    public void setPurchaseOrderPriceType( @Nullable final String purchaseOrderPriceType )
    {
        rememberChangedField("PurchaseOrderPriceType", this.purchaseOrderPriceType);
        this.purchaseOrderPriceType = purchaseOrderPriceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @param supplierMaterialNumber
     *            Material Number Used by Supplier
     */
    public void setSupplierMaterialNumber( @Nullable final String supplierMaterialNumber )
    {
        rememberChangedField("SupplierMaterialNumber", this.supplierMaterialNumber);
        this.supplierMaterialNumber = supplierMaterialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRevisionLevel</b>
     * </p>
     *
     * @param materialRevisionLevel
     *            Revision Level
     */
    public void setMaterialRevisionLevel( @Nullable final String materialRevisionLevel )
    {
        rememberChangedField("MaterialRevisionLevel", this.materialRevisionLevel);
        this.materialRevisionLevel = materialRevisionLevel;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MinRemainingShelfLife</b>
     * </p>
     *
     * @param minRemainingShelfLife
     *            Minimum Remaining Shelf Life
     */
    public void setMinRemainingShelfLife( @Nullable final BigDecimal minRemainingShelfLife )
    {
        rememberChangedField("MinRemainingShelfLife", this.minRemainingShelfLife);
        this.minRemainingShelfLife = minRemainingShelfLife;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetAmount</b>
     * </p>
     *
     * @param itemNetAmount
     *            The itemNetAmount to set.
     */
    public void setItemNetAmount( @Nullable final BigDecimal itemNetAmount )
    {
        rememberChangedField("ItemNetAmount", this.itemNetAmount);
        this.itemNetAmount = itemNetAmount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsExpected</b>
     * </p>
     *
     * @param goodsReceiptIsExpected
     *            Goods Receipt Indicator
     */
    public void setGoodsReceiptIsExpected( @Nullable final Boolean goodsReceiptIsExpected )
    {
        rememberChangedField("GoodsReceiptIsExpected", this.goodsReceiptIsExpected);
        this.goodsReceiptIsExpected = goodsReceiptIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsExpected</b>
     * </p>
     *
     * @param invoiceIsExpected
     *            Invoice Receipt Indicator
     */
    public void setInvoiceIsExpected( @Nullable final Boolean invoiceIsExpected )
    {
        rememberChangedField("InvoiceIsExpected", this.invoiceIsExpected);
        this.invoiceIsExpected = invoiceIsExpected;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GoodsReceiptIsNonValuated</b>
     * </p>
     *
     * @param goodsReceiptIsNonValuated
     *            Goods Receipt, Non-Valuated
     */
    public void setGoodsReceiptIsNonValuated( @Nullable final Boolean goodsReceiptIsNonValuated )
    {
        rememberChangedField("GoodsReceiptIsNonValuated", this.goodsReceiptIsNonValuated);
        this.goodsReceiptIsNonValuated = goodsReceiptIsNonValuated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTracking</b>
     * </p>
     *
     * @param requirementTracking
     *            Requirement Tracking Number
     */
    public void setRequirementTracking( @Nullable final String requirementTracking )
    {
        rememberChangedField("RequirementTracking", this.requirementTracking);
        this.requirementTracking = requirementTracking;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            MRP Controller
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionIsFixed</b>
     * </p>
     *
     * @param purchaseRequisitionIsFixed
     *            Purchase requisition is fixed
     */
    public void setPurchaseRequisitionIsFixed( @Nullable final Boolean purchaseRequisitionIsFixed )
    {
        rememberChangedField("PurchaseRequisitionIsFixed", this.purchaseRequisitionIsFixed);
        this.purchaseRequisitionIsFixed = purchaseRequisitionIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Manual address number in purchasing document item
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ExpectedOverallLimitAmount</b>
     * </p>
     *
     * @param expectedOverallLimitAmount
     *            Expected Value of Overall Limit
     */
    public void setExpectedOverallLimitAmount( @Nullable final BigDecimal expectedOverallLimitAmount )
    {
        rememberChangedField("ExpectedOverallLimitAmount", this.expectedOverallLimitAmount);
        this.expectedOverallLimitAmount = expectedOverallLimitAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OverallLimitAmount</b>
     * </p>
     *
     * @param overallLimitAmount
     *            Overall Limit
     */
    public void setOverallLimitAmount( @Nullable final BigDecimal overallLimitAmount )
    {
        rememberChangedField("OverallLimitAmount", this.overallLimitAmount);
        this.overallLimitAmount = overallLimitAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurContractForOverallLimit</b>
     * </p>
     *
     * @param purContractForOverallLimit
     *            Purchase Contract for Enhanced Limit
     */
    public void setPurContractForOverallLimit( @Nullable final String purContractForOverallLimit )
    {
        rememberChangedField("PurContractForOverallLimit", this.purContractForOverallLimit);
        this.purContractForOverallLimit = purContractForOverallLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnExternalReference</b>
     * </p>
     *
     * @param purReqnExternalReference
     *            Document Number of External Document
     */
    public void setPurReqnExternalReference( @Nullable final String purReqnExternalReference )
    {
        rememberChangedField("PurReqnExternalReference", this.purReqnExternalReference);
        this.purReqnExternalReference = purReqnExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnItemExternalReference</b>
     * </p>
     *
     * @param purReqnItemExternalReference
     *            Item Number of External Document
     */
    public void setPurReqnItemExternalReference( @Nullable final String purReqnItemExternalReference )
    {
        rememberChangedField("PurReqnItemExternalReference", this.purReqnItemExternalReference);
        this.purReqnItemExternalReference = purReqnItemExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnExternalSystemId</b>
     * </p>
     *
     * @param purReqnExternalSystemId
     *            External System ID
     */
    public void setPurReqnExternalSystemId( @Nullable final String purReqnExternalSystemId )
    {
        rememberChangedField("PurReqnExternalSystemId", this.purReqnExternalSystemId);
        this.purReqnExternalSystemId = purReqnExternalSystemId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnExternalSystemType</b>
     * </p>
     *
     * @param purReqnExternalSystemType
     *            Type of External System
     */
    public void setPurReqnExternalSystemType( @Nullable final String purReqnExternalSystemType )
    {
        rememberChangedField("PurReqnExternalSystemType", this.purReqnExternalSystemType);
        this.purReqnExternalSystemType = purReqnExternalSystemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnTypeExternalReference</b>
     * </p>
     *
     * @param purReqnTypeExternalReference
     *            External Document Type
     */
    public void setPurReqnTypeExternalReference( @Nullable final String purReqnTypeExternalReference )
    {
        rememberChangedField("PurReqnTypeExternalReference", this.purReqnTypeExternalReference);
        this.purReqnTypeExternalReference = purReqnTypeExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnProcessingType</b>
     * </p>
     *
     * @param purReqnProcessingType
     *            Processing State
     */
    public void setPurReqnProcessingType( @Nullable final String purReqnProcessingType )
    {
        rememberChangedField("PurReqnProcessingType", this.purReqnProcessingType);
        this.purReqnProcessingType = purReqnProcessingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>PurReqnProcessingDateTime</b>
     * </p>
     *
     * @param purReqnProcessingDateTime
     *            Timestamp
     */
    public void setPurReqnProcessingDateTime( @Nullable final String purReqnProcessingDateTime )
    {
        rememberChangedField("PurReqnProcessingDateTime", this.purReqnProcessingDateTime);
        this.purReqnProcessingDateTime = purReqnProcessingDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubBackendBusSyst</b>
     * </p>
     *
     * @param procmtHubBackendBusSyst
     *            Connected System
     */
    public void setProcmtHubBackendBusSyst( @Nullable final String procmtHubBackendBusSyst )
    {
        rememberChangedField("ProcmtHubBackendBusSyst", this.procmtHubBackendBusSyst);
        this.procmtHubBackendBusSyst = procmtHubBackendBusSyst;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SSPAuthorExternalBPIdnNumber</b>
     * </p>
     *
     * @param sSPAuthorExternalBPIdnNumber
     *            BP ID of Author
     */
    public void setSSPAuthorExternalBPIdnNumber( @Nullable final String sSPAuthorExternalBPIdnNumber )
    {
        rememberChangedField("SSPAuthorExternalBPIdnNumber", this.sSPAuthorExternalBPIdnNumber);
        this.sSPAuthorExternalBPIdnNumber = sSPAuthorExternalBPIdnNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SSPReqrUserId</b>
     * </p>
     *
     * @param sSPReqrUserId
     *            Requestor User ID
     */
    public void setSSPReqrUserId( @Nullable final String sSPReqrUserId )
    {
        rememberChangedField("SSPReqrUserId", this.sSPReqrUserId);
        this.sSPReqrUserId = sSPReqrUserId;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchaseRequisitionItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchaseRequisition", getPurchaseRequisition());
        result.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("PurReqnReleaseStatus", getPurReqnReleaseStatus());
        values.put("PurchaseRequisitionType", getPurchaseRequisitionType());
        values.put("PurchasingDocumentSubtype", getPurchasingDocumentSubtype());
        values.put("PurchasingDocumentItemCategory", getPurchasingDocumentItemCategory());
        values.put("PurchaseRequisitionItemText", getPurchaseRequisitionItemText());
        values.put("AccountAssignmentCategory", getAccountAssignmentCategory());
        values.put("Material", getMaterial());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("BaseUnit", getBaseUnit());
        values.put("PurchaseRequisitionPrice", getPurchaseRequisitionPrice());
        values.put("PurReqnPriceQuantity", getPurReqnPriceQuantity());
        values.put("MaterialGoodsReceiptDuration", getMaterialGoodsReceiptDuration());
        values.put("ReleaseCode", getReleaseCode());
        values.put("PurchaseRequisitionReleaseDate", getPurchaseRequisitionReleaseDate());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("Plant", getPlant());
        values.put("CompanyCode", getCompanyCode());
        values.put("SourceOfSupplyIsAssigned", getSourceOfSupplyIsAssigned());
        values.put("SupplyingPlant", getSupplyingPlant());
        values.put("OrderedQuantity", getOrderedQuantity());
        values.put("DeliveryDate", getDeliveryDate());
        values.put("CreationDate", getCreationDate());
        values.put("ProcessingStatus", getProcessingStatus());
        values.put("ExternalApprovalStatus", getExternalApprovalStatus());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("Supplier", getSupplier());
        values.put("IsDeleted", getIsDeleted());
        values.put("FixedSupplier", getFixedSupplier());
        values.put("RequisitionerName", getRequisitionerName());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("PurReqCreationDate", getPurReqCreationDate());
        values.put("DeliveryAddressID", getDeliveryAddressID());
        values.put("ManualDeliveryAddressID", getManualDeliveryAddressID());
        values.put("PurReqnItemCurrency", getPurReqnItemCurrency());
        values.put("MaterialPlannedDeliveryDurn", getMaterialPlannedDeliveryDurn());
        values.put("DelivDateCategory", getDelivDateCategory());
        values.put("MultipleAcctAssgmtDistribution", getMultipleAcctAssgmtDistribution());
        values.put("StorageLocation", getStorageLocation());
        values.put("PurReqnSSPRequestor", getPurReqnSSPRequestor());
        values.put("PurReqnSSPAuthor", getPurReqnSSPAuthor());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("PurReqnSourceOfSupplyType", getPurReqnSourceOfSupplyType());
        values.put("PurchaseContractItem", getPurchaseContractItem());
        values.put("ConsumptionPosting", getConsumptionPosting());
        values.put("PurReqnOrigin", getPurReqnOrigin());
        values.put("PurReqnSSPCatalog", getPurReqnSSPCatalog());
        values.put("PurReqnSSPCatalogItem", getPurReqnSSPCatalogItem());
        values.put("PurReqnSSPCrossCatalogItem", getPurReqnSSPCrossCatalogItem());
        values.put("IsPurReqnBlocked", getIsPurReqnBlocked());
        values.put("ItemDeliveryAddressID", getItemDeliveryAddressID());
        values.put("Language", getLanguage());
        values.put("IsClosed", getIsClosed());
        values.put("ReleaseIsNotCompleted", getReleaseIsNotCompleted());
        values.put("ServicePerformer", getServicePerformer());
        values.put("ProductType", getProductType());
        values.put("PurchaseRequisitionStatus", getPurchaseRequisitionStatus());
        values.put("ReleaseStrategy", getReleaseStrategy());
        values.put("PerformancePeriodStartDate", getPerformancePeriodStartDate());
        values.put("PerformancePeriodEndDate", getPerformancePeriodEndDate());
        values.put("PurchaseOrderPriceType", getPurchaseOrderPriceType());
        values.put("SupplierMaterialNumber", getSupplierMaterialNumber());
        values.put("Batch", getBatch());
        values.put("MaterialRevisionLevel", getMaterialRevisionLevel());
        values.put("MinRemainingShelfLife", getMinRemainingShelfLife());
        values.put("ItemNetAmount", getItemNetAmount());
        values.put("GoodsReceiptIsExpected", getGoodsReceiptIsExpected());
        values.put("InvoiceIsExpected", getInvoiceIsExpected());
        values.put("GoodsReceiptIsNonValuated", getGoodsReceiptIsNonValuated());
        values.put("RequirementTracking", getRequirementTracking());
        values.put("MRPController", getMRPController());
        values.put("TaxCode", getTaxCode());
        values.put("PurchaseRequisitionIsFixed", getPurchaseRequisitionIsFixed());
        values.put("AddressID", getAddressID());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("Reservation", getReservation());
        values.put("ExpectedOverallLimitAmount", getExpectedOverallLimitAmount());
        values.put("OverallLimitAmount", getOverallLimitAmount());
        values.put("PurContractForOverallLimit", getPurContractForOverallLimit());
        values.put("PurReqnExternalReference", getPurReqnExternalReference());
        values.put("PurReqnItemExternalReference", getPurReqnItemExternalReference());
        values.put("PurReqnExternalSystemId", getPurReqnExternalSystemId());
        values.put("PurReqnExternalSystemType", getPurReqnExternalSystemType());
        values.put("PurReqnTypeExternalReference", getPurReqnTypeExternalReference());
        values.put("PurReqnProcessingType", getPurReqnProcessingType());
        values.put("PurReqnProcessingDateTime", getPurReqnProcessingDateTime());
        values.put("ProcmtHubBackendBusSyst", getProcmtHubBackendBusSyst());
        values.put("SSPAuthorExternalBPIdnNumber", getSSPAuthorExternalBPIdnNumber());
        values.put("SSPReqrUserId", getSSPReqrUserId());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PurReqnReleaseStatus") ) {
                final Object value = values.remove("PurReqnReleaseStatus");
                if( (value == null) || (!value.equals(getPurReqnReleaseStatus())) ) {
                    setPurReqnReleaseStatus(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionType") ) {
                final Object value = values.remove("PurchaseRequisitionType");
                if( (value == null) || (!value.equals(getPurchaseRequisitionType())) ) {
                    setPurchaseRequisitionType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentSubtype") ) {
                final Object value = values.remove("PurchasingDocumentSubtype");
                if( (value == null) || (!value.equals(getPurchasingDocumentSubtype())) ) {
                    setPurchasingDocumentSubtype(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItemCategory") ) {
                final Object value = values.remove("PurchasingDocumentItemCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentItemCategory())) ) {
                    setPurchasingDocumentItemCategory(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItemText") ) {
                final Object value = values.remove("PurchaseRequisitionItemText");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItemText())) ) {
                    setPurchaseRequisitionItemText(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentCategory") ) {
                final Object value = values.remove("AccountAssignmentCategory");
                if( (value == null) || (!value.equals(getAccountAssignmentCategory())) ) {
                    setAccountAssignmentCategory(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionPrice") ) {
                final Object value = values.remove("PurchaseRequisitionPrice");
                if( (value == null) || (!value.equals(getPurchaseRequisitionPrice())) ) {
                    setPurchaseRequisitionPrice(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurReqnPriceQuantity") ) {
                final Object value = values.remove("PurReqnPriceQuantity");
                if( (value == null) || (!value.equals(getPurReqnPriceQuantity())) ) {
                    setPurReqnPriceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGoodsReceiptDuration") ) {
                final Object value = values.remove("MaterialGoodsReceiptDuration");
                if( (value == null) || (!value.equals(getMaterialGoodsReceiptDuration())) ) {
                    setMaterialGoodsReceiptDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReleaseCode") ) {
                final Object value = values.remove("ReleaseCode");
                if( (value == null) || (!value.equals(getReleaseCode())) ) {
                    setReleaseCode(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionReleaseDate") ) {
                final Object value = values.remove("PurchaseRequisitionReleaseDate");
                if( (value == null) || (!value.equals(getPurchaseRequisitionReleaseDate())) ) {
                    setPurchaseRequisitionReleaseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("SourceOfSupplyIsAssigned") ) {
                final Object value = values.remove("SourceOfSupplyIsAssigned");
                if( (value == null) || (!value.equals(getSourceOfSupplyIsAssigned())) ) {
                    setSourceOfSupplyIsAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("SupplyingPlant") ) {
                final Object value = values.remove("SupplyingPlant");
                if( (value == null) || (!value.equals(getSupplyingPlant())) ) {
                    setSupplyingPlant(((String) value));
                }
            }
            if( values.containsKey("OrderedQuantity") ) {
                final Object value = values.remove("OrderedQuantity");
                if( (value == null) || (!value.equals(getOrderedQuantity())) ) {
                    setOrderedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("DeliveryDate") ) {
                final Object value = values.remove("DeliveryDate");
                if( (value == null) || (!value.equals(getDeliveryDate())) ) {
                    setDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProcessingStatus") ) {
                final Object value = values.remove("ProcessingStatus");
                if( (value == null) || (!value.equals(getProcessingStatus())) ) {
                    setProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("ExternalApprovalStatus") ) {
                final Object value = values.remove("ExternalApprovalStatus");
                if( (value == null) || (!value.equals(getExternalApprovalStatus())) ) {
                    setExternalApprovalStatus(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((String) value));
                }
            }
            if( values.containsKey("FixedSupplier") ) {
                final Object value = values.remove("FixedSupplier");
                if( (value == null) || (!value.equals(getFixedSupplier())) ) {
                    setFixedSupplier(((String) value));
                }
            }
            if( values.containsKey("RequisitionerName") ) {
                final Object value = values.remove("RequisitionerName");
                if( (value == null) || (!value.equals(getRequisitionerName())) ) {
                    setRequisitionerName(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("PurReqCreationDate") ) {
                final Object value = values.remove("PurReqCreationDate");
                if( (value == null) || (!value.equals(getPurReqCreationDate())) ) {
                    setPurReqCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DeliveryAddressID") ) {
                final Object value = values.remove("DeliveryAddressID");
                if( (value == null) || (!value.equals(getDeliveryAddressID())) ) {
                    setDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("ManualDeliveryAddressID") ) {
                final Object value = values.remove("ManualDeliveryAddressID");
                if( (value == null) || (!value.equals(getManualDeliveryAddressID())) ) {
                    setManualDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("PurReqnItemCurrency") ) {
                final Object value = values.remove("PurReqnItemCurrency");
                if( (value == null) || (!value.equals(getPurReqnItemCurrency())) ) {
                    setPurReqnItemCurrency(((String) value));
                }
            }
            if( values.containsKey("MaterialPlannedDeliveryDurn") ) {
                final Object value = values.remove("MaterialPlannedDeliveryDurn");
                if( (value == null) || (!value.equals(getMaterialPlannedDeliveryDurn())) ) {
                    setMaterialPlannedDeliveryDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("DelivDateCategory") ) {
                final Object value = values.remove("DelivDateCategory");
                if( (value == null) || (!value.equals(getDelivDateCategory())) ) {
                    setDelivDateCategory(((String) value));
                }
            }
            if( values.containsKey("MultipleAcctAssgmtDistribution") ) {
                final Object value = values.remove("MultipleAcctAssgmtDistribution");
                if( (value == null) || (!value.equals(getMultipleAcctAssgmtDistribution())) ) {
                    setMultipleAcctAssgmtDistribution(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("PurReqnSSPRequestor") ) {
                final Object value = values.remove("PurReqnSSPRequestor");
                if( (value == null) || (!value.equals(getPurReqnSSPRequestor())) ) {
                    setPurReqnSSPRequestor(((String) value));
                }
            }
            if( values.containsKey("PurReqnSSPAuthor") ) {
                final Object value = values.remove("PurReqnSSPAuthor");
                if( (value == null) || (!value.equals(getPurReqnSSPAuthor())) ) {
                    setPurReqnSSPAuthor(((String) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurReqnSourceOfSupplyType") ) {
                final Object value = values.remove("PurReqnSourceOfSupplyType");
                if( (value == null) || (!value.equals(getPurReqnSourceOfSupplyType())) ) {
                    setPurReqnSourceOfSupplyType(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractItem") ) {
                final Object value = values.remove("PurchaseContractItem");
                if( (value == null) || (!value.equals(getPurchaseContractItem())) ) {
                    setPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("ConsumptionPosting") ) {
                final Object value = values.remove("ConsumptionPosting");
                if( (value == null) || (!value.equals(getConsumptionPosting())) ) {
                    setConsumptionPosting(((String) value));
                }
            }
            if( values.containsKey("PurReqnOrigin") ) {
                final Object value = values.remove("PurReqnOrigin");
                if( (value == null) || (!value.equals(getPurReqnOrigin())) ) {
                    setPurReqnOrigin(((String) value));
                }
            }
            if( values.containsKey("PurReqnSSPCatalog") ) {
                final Object value = values.remove("PurReqnSSPCatalog");
                if( (value == null) || (!value.equals(getPurReqnSSPCatalog())) ) {
                    setPurReqnSSPCatalog(((String) value));
                }
            }
            if( values.containsKey("PurReqnSSPCatalogItem") ) {
                final Object value = values.remove("PurReqnSSPCatalogItem");
                if( (value == null) || (!value.equals(getPurReqnSSPCatalogItem())) ) {
                    setPurReqnSSPCatalogItem(((String) value));
                }
            }
            if( values.containsKey("PurReqnSSPCrossCatalogItem") ) {
                final Object value = values.remove("PurReqnSSPCrossCatalogItem");
                if( (value == null) || (!value.equals(getPurReqnSSPCrossCatalogItem())) ) {
                    setPurReqnSSPCrossCatalogItem(((Integer) value));
                }
            }
            if( values.containsKey("IsPurReqnBlocked") ) {
                final Object value = values.remove("IsPurReqnBlocked");
                if( (value == null) || (!value.equals(getIsPurReqnBlocked())) ) {
                    setIsPurReqnBlocked(((String) value));
                }
            }
            if( values.containsKey("ItemDeliveryAddressID") ) {
                final Object value = values.remove("ItemDeliveryAddressID");
                if( (value == null) || (!value.equals(getItemDeliveryAddressID())) ) {
                    setItemDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("IsClosed") ) {
                final Object value = values.remove("IsClosed");
                if( (value == null) || (!value.equals(getIsClosed())) ) {
                    setIsClosed(((Boolean) value));
                }
            }
            if( values.containsKey("ReleaseIsNotCompleted") ) {
                final Object value = values.remove("ReleaseIsNotCompleted");
                if( (value == null) || (!value.equals(getReleaseIsNotCompleted())) ) {
                    setReleaseIsNotCompleted(((Boolean) value));
                }
            }
            if( values.containsKey("ServicePerformer") ) {
                final Object value = values.remove("ServicePerformer");
                if( (value == null) || (!value.equals(getServicePerformer())) ) {
                    setServicePerformer(((String) value));
                }
            }
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionStatus") ) {
                final Object value = values.remove("PurchaseRequisitionStatus");
                if( (value == null) || (!value.equals(getPurchaseRequisitionStatus())) ) {
                    setPurchaseRequisitionStatus(((String) value));
                }
            }
            if( values.containsKey("ReleaseStrategy") ) {
                final Object value = values.remove("ReleaseStrategy");
                if( (value == null) || (!value.equals(getReleaseStrategy())) ) {
                    setReleaseStrategy(((String) value));
                }
            }
            if( values.containsKey("PerformancePeriodStartDate") ) {
                final Object value = values.remove("PerformancePeriodStartDate");
                if( (value == null) || (!value.equals(getPerformancePeriodStartDate())) ) {
                    setPerformancePeriodStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PerformancePeriodEndDate") ) {
                final Object value = values.remove("PerformancePeriodEndDate");
                if( (value == null) || (!value.equals(getPerformancePeriodEndDate())) ) {
                    setPerformancePeriodEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurchaseOrderPriceType") ) {
                final Object value = values.remove("PurchaseOrderPriceType");
                if( (value == null) || (!value.equals(getPurchaseOrderPriceType())) ) {
                    setPurchaseOrderPriceType(((String) value));
                }
            }
            if( values.containsKey("SupplierMaterialNumber") ) {
                final Object value = values.remove("SupplierMaterialNumber");
                if( (value == null) || (!value.equals(getSupplierMaterialNumber())) ) {
                    setSupplierMaterialNumber(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("MaterialRevisionLevel") ) {
                final Object value = values.remove("MaterialRevisionLevel");
                if( (value == null) || (!value.equals(getMaterialRevisionLevel())) ) {
                    setMaterialRevisionLevel(((String) value));
                }
            }
            if( values.containsKey("MinRemainingShelfLife") ) {
                final Object value = values.remove("MinRemainingShelfLife");
                if( (value == null) || (!value.equals(getMinRemainingShelfLife())) ) {
                    setMinRemainingShelfLife(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetAmount") ) {
                final Object value = values.remove("ItemNetAmount");
                if( (value == null) || (!value.equals(getItemNetAmount())) ) {
                    setItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsExpected") ) {
                final Object value = values.remove("GoodsReceiptIsExpected");
                if( (value == null) || (!value.equals(getGoodsReceiptIsExpected())) ) {
                    setGoodsReceiptIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("InvoiceIsExpected") ) {
                final Object value = values.remove("InvoiceIsExpected");
                if( (value == null) || (!value.equals(getInvoiceIsExpected())) ) {
                    setInvoiceIsExpected(((Boolean) value));
                }
            }
            if( values.containsKey("GoodsReceiptIsNonValuated") ) {
                final Object value = values.remove("GoodsReceiptIsNonValuated");
                if( (value == null) || (!value.equals(getGoodsReceiptIsNonValuated())) ) {
                    setGoodsReceiptIsNonValuated(((Boolean) value));
                }
            }
            if( values.containsKey("RequirementTracking") ) {
                final Object value = values.remove("RequirementTracking");
                if( (value == null) || (!value.equals(getRequirementTracking())) ) {
                    setRequirementTracking(((String) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionIsFixed") ) {
                final Object value = values.remove("PurchaseRequisitionIsFixed");
                if( (value == null) || (!value.equals(getPurchaseRequisitionIsFixed())) ) {
                    setPurchaseRequisitionIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ExpectedOverallLimitAmount") ) {
                final Object value = values.remove("ExpectedOverallLimitAmount");
                if( (value == null) || (!value.equals(getExpectedOverallLimitAmount())) ) {
                    setExpectedOverallLimitAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("OverallLimitAmount") ) {
                final Object value = values.remove("OverallLimitAmount");
                if( (value == null) || (!value.equals(getOverallLimitAmount())) ) {
                    setOverallLimitAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurContractForOverallLimit") ) {
                final Object value = values.remove("PurContractForOverallLimit");
                if( (value == null) || (!value.equals(getPurContractForOverallLimit())) ) {
                    setPurContractForOverallLimit(((String) value));
                }
            }
            if( values.containsKey("PurReqnExternalReference") ) {
                final Object value = values.remove("PurReqnExternalReference");
                if( (value == null) || (!value.equals(getPurReqnExternalReference())) ) {
                    setPurReqnExternalReference(((String) value));
                }
            }
            if( values.containsKey("PurReqnItemExternalReference") ) {
                final Object value = values.remove("PurReqnItemExternalReference");
                if( (value == null) || (!value.equals(getPurReqnItemExternalReference())) ) {
                    setPurReqnItemExternalReference(((String) value));
                }
            }
            if( values.containsKey("PurReqnExternalSystemId") ) {
                final Object value = values.remove("PurReqnExternalSystemId");
                if( (value == null) || (!value.equals(getPurReqnExternalSystemId())) ) {
                    setPurReqnExternalSystemId(((String) value));
                }
            }
            if( values.containsKey("PurReqnExternalSystemType") ) {
                final Object value = values.remove("PurReqnExternalSystemType");
                if( (value == null) || (!value.equals(getPurReqnExternalSystemType())) ) {
                    setPurReqnExternalSystemType(((String) value));
                }
            }
            if( values.containsKey("PurReqnTypeExternalReference") ) {
                final Object value = values.remove("PurReqnTypeExternalReference");
                if( (value == null) || (!value.equals(getPurReqnTypeExternalReference())) ) {
                    setPurReqnTypeExternalReference(((String) value));
                }
            }
            if( values.containsKey("PurReqnProcessingType") ) {
                final Object value = values.remove("PurReqnProcessingType");
                if( (value == null) || (!value.equals(getPurReqnProcessingType())) ) {
                    setPurReqnProcessingType(((String) value));
                }
            }
            if( values.containsKey("PurReqnProcessingDateTime") ) {
                final Object value = values.remove("PurReqnProcessingDateTime");
                if( (value == null) || (!value.equals(getPurReqnProcessingDateTime())) ) {
                    setPurReqnProcessingDateTime(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubBackendBusSyst") ) {
                final Object value = values.remove("ProcmtHubBackendBusSyst");
                if( (value == null) || (!value.equals(getProcmtHubBackendBusSyst())) ) {
                    setProcmtHubBackendBusSyst(((String) value));
                }
            }
            if( values.containsKey("SSPAuthorExternalBPIdnNumber") ) {
                final Object value = values.remove("SSPAuthorExternalBPIdnNumber");
                if( (value == null) || (!value.equals(getSSPAuthorExternalBPIdnNumber())) ) {
                    setSSPAuthorExternalBPIdnNumber(((String) value));
                }
            }
            if( values.containsKey("SSPReqrUserId") ) {
                final Object value = values.remove("SSPReqrUserId");
                if( (value == null) || (!value.equals(getSSPReqrUserId())) ) {
                    setSSPReqrUserId(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurchaseReqn") ) {
                final Object value = (values).remove("to_PurchaseReqn");
                if( value instanceof Map ) {
                    if( toPurchaseReqn == null ) {
                        toPurchaseReqn = new PurchaseRequisitionHeader();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurchaseReqn.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurchaseReqnAcctAssgmt") ) {
                final Object value = (values).remove("to_PurchaseReqnAcctAssgmt");
                if( value instanceof Iterable ) {
                    if( toPurchaseReqnAcctAssgmt == null ) {
                        toPurchaseReqnAcctAssgmt = Lists.newArrayList();
                    } else {
                        toPurchaseReqnAcctAssgmt = Lists.newArrayList(toPurchaseReqnAcctAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurReqnAcctAssgmt entity;
                        if( toPurchaseReqnAcctAssgmt.size() > i ) {
                            entity = toPurchaseReqnAcctAssgmt.get(i);
                        } else {
                            entity = new PurReqnAcctAssgmt();
                            toPurchaseReqnAcctAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurchaseReqnDeliveryAddress") ) {
                final Object value = (values).remove("to_PurchaseReqnDeliveryAddress");
                if( value instanceof Map ) {
                    if( toPurchaseReqnDeliveryAddress == null ) {
                        toPurchaseReqnDeliveryAddress = new PurReqAddDelivery();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurchaseReqnDeliveryAddress.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurchaseReqnItemText") ) {
                final Object value = (values).remove("to_PurchaseReqnItemText");
                if( value instanceof Iterable ) {
                    if( toPurchaseReqnItemText == null ) {
                        toPurchaseReqnItemText = Lists.newArrayList();
                    } else {
                        toPurchaseReqnItemText = Lists.newArrayList(toPurchaseReqnItemText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurchaseReqnItemText entity;
                        if( toPurchaseReqnItemText.size() > i ) {
                            entity = toPurchaseReqnItemText.get(i);
                        } else {
                            entity = new PurchaseReqnItemText();
                            toPurchaseReqnItemText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurchaseRequisitionItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchaseRequisitionItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchaseRequisitionItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchaseRequisitionItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurchaseReqn != null ) {
            (values).put("to_PurchaseReqn", toPurchaseReqn);
        }
        if( toPurchaseReqnAcctAssgmt != null ) {
            (values).put("to_PurchaseReqnAcctAssgmt", toPurchaseReqnAcctAssgmt);
        }
        if( toPurchaseReqnDeliveryAddress != null ) {
            (values).put("to_PurchaseReqnDeliveryAddress", toPurchaseReqnDeliveryAddress);
        }
        if( toPurchaseReqnItemText != null ) {
            (values).put("to_PurchaseReqnItemText", toPurchaseReqnItemText);
        }
        return values;
    }

    /**
     * Fetches the <b>PurchaseRequisitionHeader</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurchaseReqn</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurchaseRequisitionHeader</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseRequisitionHeader fetchPurchaseReqn()
    {
        return fetchFieldAsSingle("to_PurchaseReqn", PurchaseRequisitionHeader.class);
    }

    /**
     * Retrieval of associated <b>PurchaseRequisitionHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurchaseReqn</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqn</b> of a queried <b>PurchaseRequisitionItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseRequisitionHeader</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchaseRequisitionHeader getPurchaseReqnOrFetch()
    {
        if( toPurchaseReqn == null ) {
            toPurchaseReqn = fetchPurchaseReqn();
        }
        return toPurchaseReqn;
    }

    /**
     * Retrieval of associated <b>PurchaseRequisitionHeader</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurchaseReqn</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseRequisitionItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseReqn</b> is already loaded, the result will
     *         contain the <b>PurchaseRequisitionHeader</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurchaseRequisitionHeader> getPurchaseReqnIfPresent()
    {
        return Option.of(toPurchaseReqn);
    }

    /**
     * Overwrites the associated <b>PurchaseRequisitionHeader</b> entity for the loaded navigation property
     * <b>to_PurchaseReqn</b>.
     *
     * @param value
     *            New <b>PurchaseRequisitionHeader</b> entity.
     */
    public void setPurchaseReqn( final PurchaseRequisitionHeader value )
    {
        toPurchaseReqn = value;
    }

    /**
     * Fetches the <b>PurReqnAcctAssgmt</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurchaseReqnAcctAssgmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurReqnAcctAssgmt</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurReqnAcctAssgmt> fetchPurchaseReqnAcctAssgmt()
    {
        return fetchFieldAsList("to_PurchaseReqnAcctAssgmt", PurReqnAcctAssgmt.class);
    }

    /**
     * Retrieval of associated <b>PurReqnAcctAssgmt</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurchaseReqnAcctAssgmt</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnAcctAssgmt</b> of a queried <b>PurchaseRequisitionItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurReqnAcctAssgmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurReqnAcctAssgmt> getPurchaseReqnAcctAssgmtOrFetch()
    {
        if( toPurchaseReqnAcctAssgmt == null ) {
            toPurchaseReqnAcctAssgmt = fetchPurchaseReqnAcctAssgmt();
        }
        return toPurchaseReqnAcctAssgmt;
    }

    /**
     * Retrieval of associated <b>PurReqnAcctAssgmt</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurchaseReqnAcctAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseRequisitionItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseReqnAcctAssgmt</b> is already loaded, the result
     *         will contain the <b>PurReqnAcctAssgmt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurReqnAcctAssgmt>> getPurchaseReqnAcctAssgmtIfPresent()
    {
        return Option.of(toPurchaseReqnAcctAssgmt);
    }

    /**
     * Overwrites the list of associated <b>PurReqnAcctAssgmt</b> entities for the loaded navigation property
     * <b>to_PurchaseReqnAcctAssgmt</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnAcctAssgmt</b> of a queried <b>PurchaseRequisitionItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurReqnAcctAssgmt</b> entities.
     */
    public void setPurchaseReqnAcctAssgmt( @Nonnull final List<PurReqnAcctAssgmt> value )
    {
        if( toPurchaseReqnAcctAssgmt == null ) {
            toPurchaseReqnAcctAssgmt = Lists.newArrayList();
        }
        toPurchaseReqnAcctAssgmt.clear();
        toPurchaseReqnAcctAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurReqnAcctAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>to_PurchaseReqnAcctAssgmt</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnAcctAssgmt</b> of a queried <b>PurchaseRequisitionItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurReqnAcctAssgmt</b> entities.
     */
    public void addPurchaseReqnAcctAssgmt( PurReqnAcctAssgmt... entity )
    {
        if( toPurchaseReqnAcctAssgmt == null ) {
            toPurchaseReqnAcctAssgmt = Lists.newArrayList();
        }
        toPurchaseReqnAcctAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurReqAddDelivery</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurchaseReqnDeliveryAddress</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurReqAddDelivery</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurReqAddDelivery fetchPurchaseReqnDeliveryAddress()
    {
        return fetchFieldAsSingle("to_PurchaseReqnDeliveryAddress", PurReqAddDelivery.class);
    }

    /**
     * Retrieval of associated <b>PurReqAddDelivery</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseReqnDeliveryAddress</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnDeliveryAddress</b> of a queried <b>PurchaseRequisitionItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurReqAddDelivery</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurReqAddDelivery getPurchaseReqnDeliveryAddressOrFetch()
    {
        if( toPurchaseReqnDeliveryAddress == null ) {
            toPurchaseReqnDeliveryAddress = fetchPurchaseReqnDeliveryAddress();
        }
        return toPurchaseReqnDeliveryAddress;
    }

    /**
     * Retrieval of associated <b>PurReqAddDelivery</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurchaseReqnDeliveryAddress</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseRequisitionItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseReqnDeliveryAddress</b> is already loaded, the
     *         result will contain the <b>PurReqAddDelivery</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurReqAddDelivery> getPurchaseReqnDeliveryAddressIfPresent()
    {
        return Option.of(toPurchaseReqnDeliveryAddress);
    }

    /**
     * Overwrites the associated <b>PurReqAddDelivery</b> entity for the loaded navigation property
     * <b>to_PurchaseReqnDeliveryAddress</b>.
     *
     * @param value
     *            New <b>PurReqAddDelivery</b> entity.
     */
    public void setPurchaseReqnDeliveryAddress( final PurReqAddDelivery value )
    {
        toPurchaseReqnDeliveryAddress = value;
    }

    /**
     * Fetches the <b>PurchaseReqnItemText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurchaseReqnItemText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurchaseReqnItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseReqnItemText> fetchPurchaseReqnItemText()
    {
        return fetchFieldAsList("to_PurchaseReqnItemText", PurchaseReqnItemText.class);
    }

    /**
     * Retrieval of associated <b>PurchaseReqnItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurchaseReqnItemText</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnItemText</b> of a queried <b>PurchaseRequisitionItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchaseReqnItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurchaseReqnItemText> getPurchaseReqnItemTextOrFetch()
    {
        if( toPurchaseReqnItemText == null ) {
            toPurchaseReqnItemText = fetchPurchaseReqnItemText();
        }
        return toPurchaseReqnItemText;
    }

    /**
     * Retrieval of associated <b>PurchaseReqnItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurchaseReqnItemText</b>.
     * <p>
     * If the navigation property for an entity <b>PurchaseRequisitionItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchaseReqnItemText</b> is already loaded, the result
     *         will contain the <b>PurchaseReqnItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurchaseReqnItemText>> getPurchaseReqnItemTextIfPresent()
    {
        return Option.of(toPurchaseReqnItemText);
    }

    /**
     * Overwrites the list of associated <b>PurchaseReqnItemText</b> entities for the loaded navigation property
     * <b>to_PurchaseReqnItemText</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnItemText</b> of a queried <b>PurchaseRequisitionItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurchaseReqnItemText</b> entities.
     */
    public void setPurchaseReqnItemText( @Nonnull final List<PurchaseReqnItemText> value )
    {
        if( toPurchaseReqnItemText == null ) {
            toPurchaseReqnItemText = Lists.newArrayList();
        }
        toPurchaseReqnItemText.clear();
        toPurchaseReqnItemText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurchaseReqnItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_PurchaseReqnItemText</b>.
     * <p>
     * If the navigation property <b>to_PurchaseReqnItemText</b> of a queried <b>PurchaseRequisitionItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurchaseReqnItemText</b> entities.
     */
    public void addPurchaseReqnItemText( PurchaseReqnItemText... entity )
    {
        if( toPurchaseReqnItemText == null ) {
            toPurchaseReqnItemText = Lists.newArrayList();
        }
        toPurchaseReqnItemText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurchaseRequisitionItem instances.
     *
     */
    public final static class PurchaseRequisitionItemBuilder
    {

        private PurchaseRequisitionHeader toPurchaseReqn;
        private List<PurReqnAcctAssgmt> toPurchaseReqnAcctAssgmt = Lists.newArrayList();
        private PurReqAddDelivery toPurchaseReqnDeliveryAddress;
        private List<PurchaseReqnItemText> toPurchaseReqnItemText = Lists.newArrayList();

        private PurchaseRequisitionItem.PurchaseRequisitionItemBuilder toPurchaseReqn(
            final PurchaseRequisitionHeader value )
        {
            toPurchaseReqn = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseReqn</b> for <b>PurchaseRequisitionItem</b> to single
         * <b>PurchaseRequisitionHeader</b>.
         *
         * @param value
         *            The PurchaseRequisitionHeader to build this PurchaseRequisitionItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseRequisitionItem.PurchaseRequisitionItemBuilder purchaseReqn(
            final PurchaseRequisitionHeader value )
        {
            return toPurchaseReqn(value);
        }

        private PurchaseRequisitionItem.PurchaseRequisitionItemBuilder toPurchaseReqnAcctAssgmt(
            final List<PurReqnAcctAssgmt> value )
        {
            toPurchaseReqnAcctAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseReqnAcctAssgmt</b> for <b>PurchaseRequisitionItem</b> to multiple
         * <b>PurReqnAcctAssgmt</b>.
         *
         * @param value
         *            The PurReqnAcctAssgmts to build this PurchaseRequisitionItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseRequisitionItem.PurchaseRequisitionItemBuilder purchaseReqnAcctAssgmt(
            PurReqnAcctAssgmt... value )
        {
            return toPurchaseReqnAcctAssgmt(Lists.newArrayList(value));
        }

        private PurchaseRequisitionItem.PurchaseRequisitionItemBuilder toPurchaseReqnDeliveryAddress(
            final PurReqAddDelivery value )
        {
            toPurchaseReqnDeliveryAddress = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseReqnDeliveryAddress</b> for <b>PurchaseRequisitionItem</b> to single
         * <b>PurReqAddDelivery</b>.
         *
         * @param value
         *            The PurReqAddDelivery to build this PurchaseRequisitionItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseRequisitionItem.PurchaseRequisitionItemBuilder purchaseReqnDeliveryAddress(
            final PurReqAddDelivery value )
        {
            return toPurchaseReqnDeliveryAddress(value);
        }

        private PurchaseRequisitionItem.PurchaseRequisitionItemBuilder toPurchaseReqnItemText(
            final List<PurchaseReqnItemText> value )
        {
            toPurchaseReqnItemText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurchaseReqnItemText</b> for <b>PurchaseRequisitionItem</b> to multiple
         * <b>PurchaseReqnItemText</b>.
         *
         * @param value
         *            The PurchaseReqnItemTexts to build this PurchaseRequisitionItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchaseRequisitionItem.PurchaseRequisitionItemBuilder purchaseReqnItemText(
            PurchaseReqnItemText... value )
        {
            return toPurchaseReqnItemText(Lists.newArrayList(value));
        }

    }

}
