/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PurchaseRequisitionServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService PurchaseRequisitionService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPurchaseRequisitionServiceBatch
    extends
    BatchFluentHelperBasic<PurchaseRequisitionServiceBatch, PurchaseRequisitionServiceBatchChangeSet>
    implements
    PurchaseRequisitionServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPurchaseRequisitionServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchaseRequisitionServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPurchaseRequisitionServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchaseRequisitionServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPurchaseRequisitionServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPurchaseRequisitionServiceBatchChangeSet(this, service);
    }

}
