/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem;

/**
 * Implementation of the {@link PurchaseRequisitionServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService PurchaseRequisitionService}.
 *
 */
public class DefaultPurchaseRequisitionServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PurchaseRequisitionServiceBatch, PurchaseRequisitionServiceBatchChangeSet>
    implements
    PurchaseRequisitionServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService service;

    @SuppressWarnings( "deprecation" )
    DefaultPurchaseRequisitionServiceBatchChangeSet(
        @Nonnull final DefaultPurchaseRequisitionServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPurchaseRequisitionServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet createPurchaseReqnItemText(
        @Nonnull final PurchaseReqnItemText purchaseReqnItemText )
    {
        return addRequestCreate(service::createPurchaseReqnItemText, purchaseReqnItemText);
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet updatePurchaseReqnItemText(
        @Nonnull final PurchaseReqnItemText purchaseReqnItemText )
    {
        return addRequestUpdate(service::updatePurchaseReqnItemText, purchaseReqnItemText);
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet deletePurchaseReqnItemText(
        @Nonnull final PurchaseReqnItemText purchaseReqnItemText )
    {
        return addRequestDelete(service::deletePurchaseReqnItemText, purchaseReqnItemText);
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet createPurchaseRequisitionHeader(
        @Nonnull final PurchaseRequisitionHeader purchaseRequisitionHeader )
    {
        return addRequestCreate(service::createPurchaseRequisitionHeader, purchaseRequisitionHeader);
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet updatePurchaseRequisitionHeader(
        @Nonnull final PurchaseRequisitionHeader purchaseRequisitionHeader )
    {
        return addRequestUpdate(service::updatePurchaseRequisitionHeader, purchaseRequisitionHeader);
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet createPurchaseRequisitionItem(
        @Nonnull final PurchaseRequisitionItem purchaseRequisitionItem )
    {
        return addRequestCreate(service::createPurchaseRequisitionItem, purchaseRequisitionItem);
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet updatePurchaseRequisitionItem(
        @Nonnull final PurchaseRequisitionItem purchaseRequisitionItem )
    {
        return addRequestUpdate(service::updatePurchaseRequisitionItem, purchaseRequisitionItem);
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet updatePurReqAddDelivery(
        @Nonnull final PurReqAddDelivery purReqAddDelivery )
    {
        return addRequestUpdate(service::updatePurReqAddDelivery, purReqAddDelivery);
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet createPurReqnAcctAssgmt(
        @Nonnull final PurReqnAcctAssgmt purReqnAcctAssgmt )
    {
        return addRequestCreate(service::createPurReqnAcctAssgmt, purReqnAcctAssgmt);
    }

    @Nonnull
    @Override
    public PurchaseRequisitionServiceBatchChangeSet updatePurReqnAcctAssgmt(
        @Nonnull final PurReqnAcctAssgmt purReqnAcctAssgmt )
    {
        return addRequestUpdate(service::updatePurReqnAcctAssgmt, purReqnAcctAssgmt);
    }

}
