/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchaseRequisitionService
 * PurchaseRequisitionService}.
 *
 */
public interface PurchaseRequisitionServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PurchaseRequisitionServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PurchaseRequisitionServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     * PurchaseReqnItemText} entity and save it to the S/4HANA system.
     *
     * @param purchaseReqnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *            PurchaseReqnItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        createPurchaseReqnItemText( @Nonnull final PurchaseReqnItemText purchaseReqnItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     * PurchaseReqnItemText} entity and save it to the S/4HANA system.
     *
     * @param purchaseReqnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *            PurchaseReqnItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        updatePurchaseReqnItemText( @Nonnull final PurchaseReqnItemText purchaseReqnItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     * PurchaseReqnItemText} entity in the S/4HANA system.
     *
     * @param purchaseReqnItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
     *            PurchaseReqnItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        deletePurchaseReqnItemText( @Nonnull final PurchaseReqnItemText purchaseReqnItemText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     * PurchaseRequisitionHeader} entity and save it to the S/4HANA system.
     *
     * @param purchaseRequisitionHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     *            PurchaseRequisitionHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        createPurchaseRequisitionHeader( @Nonnull final PurchaseRequisitionHeader purchaseRequisitionHeader );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     * PurchaseRequisitionHeader} entity and save it to the S/4HANA system.
     *
     * @param purchaseRequisitionHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
     *            PurchaseRequisitionHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        updatePurchaseRequisitionHeader( @Nonnull final PurchaseRequisitionHeader purchaseRequisitionHeader );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     * PurchaseRequisitionItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseRequisitionItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     *            PurchaseRequisitionItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        createPurchaseRequisitionItem( @Nonnull final PurchaseRequisitionItem purchaseRequisitionItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     * PurchaseRequisitionItem} entity and save it to the S/4HANA system.
     *
     * @param purchaseRequisitionItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionItem
     *            PurchaseRequisitionItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        updatePurchaseRequisitionItem( @Nonnull final PurchaseRequisitionItem purchaseRequisitionItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     * PurReqAddDelivery} entity and save it to the S/4HANA system.
     *
     * @param purReqAddDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery
     *            PurReqAddDelivery} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        updatePurReqAddDelivery( @Nonnull final PurReqAddDelivery purReqAddDelivery );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     * PurReqnAcctAssgmt} entity and save it to the S/4HANA system.
     *
     * @param purReqnAcctAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     *            PurReqnAcctAssgmt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        createPurReqnAcctAssgmt( @Nonnull final PurReqnAcctAssgmt purReqnAcctAssgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     * PurReqnAcctAssgmt} entity and save it to the S/4HANA system.
     *
     * @param purReqnAcctAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt
     *            PurReqnAcctAssgmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchaseRequisitionServiceBatchChangeSet
        updatePurReqnAcctAssgmt( @Nonnull final PurReqnAcctAssgmt purReqnAcctAssgmt );

}
