/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery PurReqAddDelivery}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.field.PurReqAddDeliveryField
 * PurReqAddDeliveryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.link.PurReqAddDeliveryLink
 * PurReqAddDeliveryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PURCHASE_REQUISITION_ITEM
 * PURCHASE_REQUISITION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#ADDRESS_ID
 * ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#ADDRESS_TYPE
 * ADDRESS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#MANUAL_DELIVERY_ADDRESS_ID
 * MANUAL_DELIVERY_ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#ITEM_DELIVERY_ADDRESS_ID
 * ITEM_DELIVERY_ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#CARE_OF_NAME
 * CARE_OF_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#ADDITIONAL_STREET_SUFFIX_NAME
 * ADDITIONAL_STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#CORRESPONDENCE_LANGUAGE
 * CORRESPONDENCE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PRFRD_COMM_MEDIUM_TYPE
 * PRFRD_COMM_MEDIUM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PO_BOX
 * PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PO_BOX_IS_WITHOUT_NUMBER
 * PO_BOX_IS_WITHOUT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PO_BOX_POSTAL_CODE
 * PO_BOX_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PO_BOX_LOBBY_NAME
 * PO_BOX_LOBBY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PO_BOX_DEVIATING_CITY_NAME
 * PO_BOX_DEVIATING_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PO_BOX_DEVIATING_REGION
 * PO_BOX_DEVIATING_REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PO_BOX_DEVIATING_COUNTRY
 * PO_BOX_DEVIATING_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#DELIVERY_SERVICE_TYPE_CODE
 * DELIVERY_SERVICE_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#DELIVERY_SERVICE_NUMBER
 * DELIVERY_SERVICE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#ADDRESS_TIME_ZONE
 * ADDRESS_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#FULL_NAME
 * FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#DISTRICT
 * DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#CITY_CODE
 * CITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#HOME_CITY_NAME
 * HOME_CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#COMPANY_POSTAL_CODE
 * COMPANY_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#STREET_PREFIX_NAME
 * STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#ADDITIONAL_STREET_PREFIX_NAME
 * ADDITIONAL_STREET_PREFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#STREET_SUFFIX_NAME
 * STREET_SUFFIX_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#HOUSE_NUMBER_SUPPLEMENT_TEXT
 * HOUSE_NUMBER_SUPPLEMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#BUILDING
 * BUILDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#FLOOR
 * FLOOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#ROOM_NUMBER
 * ROOM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#COUNTY
 * COUNTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#BUSINESS_PARTNER_NAME1
 * BUSINESS_PARTNER_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#BUSINESS_PARTNER_NAME2
 * BUSINESS_PARTNER_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#NATION
 * NATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#FAX_NUMBER
 * FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#SEARCH_TERM1
 * SEARCH_TERM1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#STREET_SEARCH
 * STREET_SEARCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#CITY_SEARCH
 * CITY_SEARCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#BUSINESS_PARTNER_NAME3
 * BUSINESS_PARTNER_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#BUSINESS_PARTNER_NAME4
 * BUSINESS_PARTNER_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#TRANSPORT_ZONE
 * TRANSPORT_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#PERSON
 * PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqAddDelivery#ADDRESSEE_FULL_NAME
 * ADDRESSEE_FULL_NAME}</li>
 * </ul>
 *
 */
public interface PurReqAddDeliverySelectable extends EntitySelectable<PurReqAddDelivery>
{

}
