/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt PurReqnAcctAssgmt}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.field.PurReqnAcctAssgmtField
 * PurReqnAcctAssgmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.link.PurReqnAcctAssgmtLink
 * PurReqnAcctAssgmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PURCHASE_REQUISITION_ITEM
 * PURCHASE_REQUISITION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PURCHASE_REQN_ACCT_ASSGMT_NUMBER
 * PURCHASE_REQN_ACCT_ASSGMT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#MULTIPLE_ACCT_ASSGMT_DISTR_PERCENT
 * MULTIPLE_ACCT_ASSGMT_DISTR_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PUR_REQN_ITEM_CURRENCY
 * PUR_REQN_ITEM_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PUR_REQN_NET_AMOUNT
 * PUR_REQN_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#COST_ELEMENT
 * COST_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#SD_DOCUMENT
 * SD_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#SALES_DOCUMENT_ITEM
 * SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#SCHEDULE_LINE
 * SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#SALES_ORDER_SCHEDULE_LINE
 * SALES_ORDER_SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PROCESS_ORDER
 * PROCESS_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PROJECT_NETWORK_INTERNAL_ID
 * PROJECT_NETWORK_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#COMMITMENT_ITEM
 * COMMITMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#FUNDS_CENTER
 * FUNDS_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#FUND FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#GOODS_RECIPIENT_NAME
 * GOODS_RECIPIENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#REAL_ESTATE_OBJECT
 * REAL_ESTATE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#NETWORK_ACTIVITY_INTERNAL_ID
 * NETWORK_ACTIVITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PARTNER_ACCOUNT_NUMBER
 * PARTNER_ACCOUNT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#JOINT_VENTURE_RECOVERY_CODE
 * JOINT_VENTURE_RECOVERY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#SETTLEMENT_REFERENCE_DATE
 * SETTLEMENT_REFERENCE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#ORDER_INTERNAL_ID
 * ORDER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#ORDER_INT_BILL_OF_OPERATIONS_ITEM
 * ORDER_INT_BILL_OF_OPERATIONS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#EARMARKED_FUNDS_DOCUMENT
 * EARMARKED_FUNDS_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#BUSINESS_PROCESS
 * BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#VALIDITY_DATE
 * VALIDITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#CHART_OF_ACCOUNTS
 * CHART_OF_ACCOUNTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#NETWORK_ACTIVITY
 * NETWORK_ACTIVITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PURCHASE_REQUISITION_TYPE
 * PURCHASE_REQUISITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurReqnAcctAssgmt#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * </ul>
 *
 */
public interface PurReqnAcctAssgmtSelectable extends EntitySelectable<PurReqnAcctAssgmt>
{

}
