/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText
 * PurchaseReqnItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.field.PurchaseReqnItemTextField
 * PurchaseReqnItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.link.PurchaseReqnItemTextLink
 * PurchaseReqnItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText#PURCHASE_REQUISITION_ITEM
 * PURCHASE_REQUISITION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText#DOCUMENT_TEXT
 * DOCUMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText#TECHNICAL_OBJECT_TYPE
 * TECHNICAL_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText#ARCH_OBJECT_NUMBER
 * ARCH_OBJECT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText#NOTE_DESCRIPTION
 * NOTE_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseReqnItemText#FIXED_INDICATOR
 * FIXED_INDICATOR}</li>
 * </ul>
 *
 */
public interface PurchaseReqnItemTextSelectable extends EntitySelectable<PurchaseReqnItemText>
{

}
