/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader
 * PurchaseRequisitionHeader}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.field.PurchaseRequisitionHeaderField
 * PurchaseRequisitionHeaderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.link.PurchaseRequisitionHeaderLink
 * PurchaseRequisitionHeaderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader#PURCHASE_REQUISITION
 * PURCHASE_REQUISITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader#PURCHASE_REQUISITION_TYPE
 * PURCHASE_REQUISITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader#PUR_REQN_DESCRIPTION
 * PUR_REQN_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader#SOURCE_DETERMINATION
 * SOURCE_DETERMINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader#PUR_REQN_DO_ONLY_VALIDATION
 * PUR_REQN_DO_ONLY_VALIDATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchaserequisition.PurchaseRequisitionHeader#TO_PURCHASE_REQN_ITEM
 * TO_PURCHASE_REQN_ITEM}</li>
 * </ul>
 *
 */
public interface PurchaseRequisitionHeaderSelectable extends EntitySelectable<PurchaseRequisitionHeader>
{

}
