/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.field.PurgCatField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.link.PurgCatLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.link.PurgCatOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.selectable.PurgCatSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Purchasing Category
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgCatType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgCat extends VdmEntity<PurgCat>
{

    /**
     * Selector for all available fields of PurgCat.
     *
     */
    public final static PurgCatSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @return Purchasing Category UUID
     */
    @Key
    @SerializedName( "PurgCatUUID" )
    @JsonProperty( "PurgCatUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatUUID" )
    private UUID purgCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatUUID</b> field to query operations.
     *
     */
    public final static PurgCatField<UUID> PURG_CAT_UUID = new PurgCatField<UUID>("PurgCatUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCategory</b>
     * </p>
     *
     * @return Purchasing Category ID
     */
    @SerializedName( "PurchasingCategory" )
    @JsonProperty( "PurchasingCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingCategory" )
    private String purchasingCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingCategory</b> field to query operations.
     *
     */
    public final static PurgCatField<String> PURCHASING_CATEGORY = new PurgCatField<String>("PurchasingCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatName</b>
     * </p>
     *
     * @return Name of Purchasing Category
     */
    @SerializedName( "PurgCatName" )
    @JsonProperty( "PurgCatName" )
    @Nullable
    @ODataField( odataName = "PurgCatName" )
    private String purgCatName;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatName</b> field to query operations.
     *
     */
    public final static PurgCatField<String> PURG_CAT_NAME = new PurgCatField<String>("PurgCatName");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static PurgCatField<ZonedDateTime> CREATION_DATE_TIME =
        new PurgCatField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Created-By Name
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static PurgCatField<String> CREATED_BY_USER = new PurgCatField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PurgCatField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PurgCatField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Changed-By Name
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static PurgCatField<String> LAST_CHANGED_BY_USER = new PurgCatField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PurgCatField<String> LANGUAGE = new PurgCatField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatIsInactive</b>
     * </p>
     *
     * @return Inactive Status
     */
    @SerializedName( "PurgCatIsInactive" )
    @JsonProperty( "PurgCatIsInactive" )
    @Nullable
    @ODataField( odataName = "PurgCatIsInactive" )
    private String purgCatIsInactive;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatIsInactive</b> field to query operations.
     *
     */
    public final static PurgCatField<String> PURG_CAT_IS_INACTIVE = new PurgCatField<String>("PurgCatIsInactive");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatTranslationOvrlStatus</b>
     * </p>
     *
     * @return Status of All Translations
     */
    @SerializedName( "PurgCatTranslationOvrlStatus" )
    @JsonProperty( "PurgCatTranslationOvrlStatus" )
    @Nullable
    @ODataField( odataName = "PurgCatTranslationOvrlStatus" )
    private String purgCatTranslationOvrlStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatTranslationOvrlStatus</b> field to query operations.
     *
     */
    public final static PurgCatField<String> PURG_CAT_TRANSLATION_OVRL_STATUS =
        new PurgCatField<String>("PurgCatTranslationOvrlStatus");
    /**
     * Navigation property <b>to_PurgCatDescription</b> for <b>PurgCat</b> to multiple <b>PurgCatDescription</b>.
     *
     */
    @SerializedName( "to_PurgCatDescription" )
    @JsonProperty( "to_PurgCatDescription" )
    @ODataField( odataName = "to_PurgCatDescription" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgCatDescription> toPurgCatDescription;
    /**
     * Navigation property <b>to_PurgCatMaterialGroup</b> for <b>PurgCat</b> to multiple <b>PurgCatMaterialGroup</b>.
     *
     */
    @SerializedName( "to_PurgCatMaterialGroup" )
    @JsonProperty( "to_PurgCatMaterialGroup" )
    @ODataField( odataName = "to_PurgCatMaterialGroup" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgCatMaterialGroup> toPurgCatMaterialGroup;
    /**
     * Navigation property <b>to_PurgCatMember</b> for <b>PurgCat</b> to multiple <b>PurgCatMember</b>.
     *
     */
    @SerializedName( "to_PurgCatMember" )
    @JsonProperty( "to_PurgCatMember" )
    @ODataField( odataName = "to_PurgCatMember" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgCatMember> toPurgCatMember;
    /**
     * Navigation property <b>to_PurgCatPlannedSpend</b> for <b>PurgCat</b> to multiple <b>PurgCatPlannedSpend</b>.
     *
     */
    @SerializedName( "to_PurgCatPlannedSpend" )
    @JsonProperty( "to_PurgCatPlannedSpend" )
    @ODataField( odataName = "to_PurgCatPlannedSpend" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgCatPlannedSpend> toPurgCatPlannedSpend;
    /**
     * Navigation property <b>to_PurgCatPurchaserResponsible</b> for <b>PurgCat</b> to single
     * <b>PurgCatPurchaserResponsible</b>.
     *
     */
    @SerializedName( "to_PurgCatPurchaserResponsible" )
    @JsonProperty( "to_PurgCatPurchaserResponsible" )
    @ODataField( odataName = "to_PurgCatPurchaserResponsible" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurgCatPurchaserResponsible toPurgCatPurchaserResponsible;
    /**
     * Navigation property <b>to_PurgCatSupplier</b> for <b>PurgCat</b> to multiple <b>PurgCatSupplier</b>.
     *
     */
    @SerializedName( "to_PurgCatSupplier" )
    @JsonProperty( "to_PurgCatSupplier" )
    @ODataField( odataName = "to_PurgCatSupplier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgCatSupplier> toPurgCatSupplier;
    /**
     * Navigation property <b>to_PurgCatTranslationStatus</b> for <b>PurgCat</b> to multiple
     * <b>PurgCatTranslationStatus</b>.
     *
     */
    @SerializedName( "to_PurgCatTranslationStatus" )
    @JsonProperty( "to_PurgCatTranslationStatus" )
    @ODataField( odataName = "to_PurgCatTranslationStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgCatTranslationStatus> toPurgCatTranslationStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_PurgCatDescription</b> navigation property to query
     * operations.
     *
     */
    public final static PurgCatLink<PurgCatDescription> TO_PURG_CAT_DESCRIPTION =
        new PurgCatLink<PurgCatDescription>("to_PurgCatDescription");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgCatMaterialGroup</b> navigation property to query
     * operations.
     *
     */
    public final static PurgCatLink<PurgCatMaterialGroup> TO_PURG_CAT_MATERIAL_GROUP =
        new PurgCatLink<PurgCatMaterialGroup>("to_PurgCatMaterialGroup");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgCatMember</b> navigation property to query operations.
     *
     */
    public final static PurgCatLink<PurgCatMember> TO_PURG_CAT_MEMBER =
        new PurgCatLink<PurgCatMember>("to_PurgCatMember");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgCatPlannedSpend</b> navigation property to query
     * operations.
     *
     */
    public final static PurgCatLink<PurgCatPlannedSpend> TO_PURG_CAT_PLANNED_SPEND =
        new PurgCatLink<PurgCatPlannedSpend>("to_PurgCatPlannedSpend");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgCatPurchaserResponsible</b> navigation property to query
     * operations.
     *
     */
    public final static PurgCatOneToOneLink<PurgCatPurchaserResponsible> TO_PURG_CAT_PURCHASER_RESPONSIBLE =
        new PurgCatOneToOneLink<PurgCatPurchaserResponsible>("to_PurgCatPurchaserResponsible");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgCatSupplier</b> navigation property to query operations.
     *
     */
    public final static PurgCatLink<PurgCatSupplier> TO_PURG_CAT_SUPPLIER =
        new PurgCatLink<PurgCatSupplier>("to_PurgCatSupplier");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgCatTranslationStatus</b> navigation property to query
     * operations.
     *
     */
    public final static PurgCatLink<PurgCatTranslationStatus> TO_PURG_CAT_TRANSLATION_STATUS =
        new PurgCatLink<PurgCatTranslationStatus>("to_PurgCatTranslationStatus");

    @Nonnull
    @Override
    public Class<PurgCat> getType()
    {
        return PurgCat.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @param purgCatUUID
     *            Purchasing Category UUID
     */
    public void setPurgCatUUID( @Nullable final UUID purgCatUUID )
    {
        rememberChangedField("PurgCatUUID", this.purgCatUUID);
        this.purgCatUUID = purgCatUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingCategory</b>
     * </p>
     *
     * @param purchasingCategory
     *            Purchasing Category ID
     */
    public void setPurchasingCategory( @Nullable final String purchasingCategory )
    {
        rememberChangedField("PurchasingCategory", this.purchasingCategory);
        this.purchasingCategory = purchasingCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatName</b>
     * </p>
     *
     * @param purgCatName
     *            Name of Purchasing Category
     */
    public void setPurgCatName( @Nullable final String purgCatName )
    {
        rememberChangedField("PurgCatName", this.purgCatName);
        this.purgCatName = purgCatName;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Created On
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Created-By Name
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Changed On
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed-By Name
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatIsInactive</b>
     * </p>
     *
     * @param purgCatIsInactive
     *            Inactive Status
     */
    public void setPurgCatIsInactive( @Nullable final String purgCatIsInactive )
    {
        rememberChangedField("PurgCatIsInactive", this.purgCatIsInactive);
        this.purgCatIsInactive = purgCatIsInactive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatTranslationOvrlStatus</b>
     * </p>
     *
     * @param purgCatTranslationOvrlStatus
     *            Status of All Translations
     */
    public void setPurgCatTranslationOvrlStatus( @Nullable final String purgCatTranslationOvrlStatus )
    {
        rememberChangedField("PurgCatTranslationOvrlStatus", this.purgCatTranslationOvrlStatus);
        this.purgCatTranslationOvrlStatus = purgCatTranslationOvrlStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgCat";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurgCatUUID", getPurgCatUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurgCatUUID", getPurgCatUUID());
        values.put("PurchasingCategory", getPurchasingCategory());
        values.put("PurgCatName", getPurgCatName());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("Language", getLanguage());
        values.put("PurgCatIsInactive", getPurgCatIsInactive());
        values.put("PurgCatTranslationOvrlStatus", getPurgCatTranslationOvrlStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurgCatUUID") ) {
                final Object value = values.remove("PurgCatUUID");
                if( (value == null) || (!value.equals(getPurgCatUUID())) ) {
                    setPurgCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurchasingCategory") ) {
                final Object value = values.remove("PurchasingCategory");
                if( (value == null) || (!value.equals(getPurchasingCategory())) ) {
                    setPurchasingCategory(((String) value));
                }
            }
            if( values.containsKey("PurgCatName") ) {
                final Object value = values.remove("PurgCatName");
                if( (value == null) || (!value.equals(getPurgCatName())) ) {
                    setPurgCatName(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PurgCatIsInactive") ) {
                final Object value = values.remove("PurgCatIsInactive");
                if( (value == null) || (!value.equals(getPurgCatIsInactive())) ) {
                    setPurgCatIsInactive(((String) value));
                }
            }
            if( values.containsKey("PurgCatTranslationOvrlStatus") ) {
                final Object value = values.remove("PurgCatTranslationOvrlStatus");
                if( (value == null) || (!value.equals(getPurgCatTranslationOvrlStatus())) ) {
                    setPurgCatTranslationOvrlStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurgCatDescription") ) {
                final Object value = (values).remove("to_PurgCatDescription");
                if( value instanceof Iterable ) {
                    if( toPurgCatDescription == null ) {
                        toPurgCatDescription = Lists.newArrayList();
                    } else {
                        toPurgCatDescription = Lists.newArrayList(toPurgCatDescription);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgCatDescription entity;
                        if( toPurgCatDescription.size() > i ) {
                            entity = toPurgCatDescription.get(i);
                        } else {
                            entity = new PurgCatDescription();
                            toPurgCatDescription.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurgCatMaterialGroup") ) {
                final Object value = (values).remove("to_PurgCatMaterialGroup");
                if( value instanceof Iterable ) {
                    if( toPurgCatMaterialGroup == null ) {
                        toPurgCatMaterialGroup = Lists.newArrayList();
                    } else {
                        toPurgCatMaterialGroup = Lists.newArrayList(toPurgCatMaterialGroup);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgCatMaterialGroup entity;
                        if( toPurgCatMaterialGroup.size() > i ) {
                            entity = toPurgCatMaterialGroup.get(i);
                        } else {
                            entity = new PurgCatMaterialGroup();
                            toPurgCatMaterialGroup.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurgCatMember") ) {
                final Object value = (values).remove("to_PurgCatMember");
                if( value instanceof Iterable ) {
                    if( toPurgCatMember == null ) {
                        toPurgCatMember = Lists.newArrayList();
                    } else {
                        toPurgCatMember = Lists.newArrayList(toPurgCatMember);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgCatMember entity;
                        if( toPurgCatMember.size() > i ) {
                            entity = toPurgCatMember.get(i);
                        } else {
                            entity = new PurgCatMember();
                            toPurgCatMember.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurgCatPlannedSpend") ) {
                final Object value = (values).remove("to_PurgCatPlannedSpend");
                if( value instanceof Iterable ) {
                    if( toPurgCatPlannedSpend == null ) {
                        toPurgCatPlannedSpend = Lists.newArrayList();
                    } else {
                        toPurgCatPlannedSpend = Lists.newArrayList(toPurgCatPlannedSpend);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgCatPlannedSpend entity;
                        if( toPurgCatPlannedSpend.size() > i ) {
                            entity = toPurgCatPlannedSpend.get(i);
                        } else {
                            entity = new PurgCatPlannedSpend();
                            toPurgCatPlannedSpend.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurgCatPurchaserResponsible") ) {
                final Object value = (values).remove("to_PurgCatPurchaserResponsible");
                if( value instanceof Map ) {
                    if( toPurgCatPurchaserResponsible == null ) {
                        toPurgCatPurchaserResponsible = new PurgCatPurchaserResponsible();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgCatPurchaserResponsible.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurgCatSupplier") ) {
                final Object value = (values).remove("to_PurgCatSupplier");
                if( value instanceof Iterable ) {
                    if( toPurgCatSupplier == null ) {
                        toPurgCatSupplier = Lists.newArrayList();
                    } else {
                        toPurgCatSupplier = Lists.newArrayList(toPurgCatSupplier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgCatSupplier entity;
                        if( toPurgCatSupplier.size() > i ) {
                            entity = toPurgCatSupplier.get(i);
                        } else {
                            entity = new PurgCatSupplier();
                            toPurgCatSupplier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurgCatTranslationStatus") ) {
                final Object value = (values).remove("to_PurgCatTranslationStatus");
                if( value instanceof Iterable ) {
                    if( toPurgCatTranslationStatus == null ) {
                        toPurgCatTranslationStatus = Lists.newArrayList();
                    } else {
                        toPurgCatTranslationStatus = Lists.newArrayList(toPurgCatTranslationStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgCatTranslationStatus entity;
                        if( toPurgCatTranslationStatus.size() > i ) {
                            entity = toPurgCatTranslationStatus.get(i);
                        } else {
                            entity = new PurgCatTranslationStatus();
                            toPurgCatTranslationStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PurgCatField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgCatField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgCatField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgCatField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurgCatDescription != null ) {
            (values).put("to_PurgCatDescription", toPurgCatDescription);
        }
        if( toPurgCatMaterialGroup != null ) {
            (values).put("to_PurgCatMaterialGroup", toPurgCatMaterialGroup);
        }
        if( toPurgCatMember != null ) {
            (values).put("to_PurgCatMember", toPurgCatMember);
        }
        if( toPurgCatPlannedSpend != null ) {
            (values).put("to_PurgCatPlannedSpend", toPurgCatPlannedSpend);
        }
        if( toPurgCatPurchaserResponsible != null ) {
            (values).put("to_PurgCatPurchaserResponsible", toPurgCatPurchaserResponsible);
        }
        if( toPurgCatSupplier != null ) {
            (values).put("to_PurgCatSupplier", toPurgCatSupplier);
        }
        if( toPurgCatTranslationStatus != null ) {
            (values).put("to_PurgCatTranslationStatus", toPurgCatTranslationStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>PurgCatDescription</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurgCatDescription</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgCatDescription</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatDescription> fetchPurgCatDescription()
    {
        return fetchFieldAsList("to_PurgCatDescription", PurgCatDescription.class);
    }

    /**
     * Retrieval of associated <b>PurgCatDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgCatDescription</b>.
     * <p>
     * If the navigation property <b>to_PurgCatDescription</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgCatDescription</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatDescription> getPurgCatDescriptionOrFetch()
    {
        if( toPurgCatDescription == null ) {
            toPurgCatDescription = fetchPurgCatDescription();
        }
        return toPurgCatDescription;
    }

    /**
     * Retrieval of associated <b>PurgCatDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgCatDescription</b>.
     * <p>
     * If the navigation property for an entity <b>PurgCat</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgCatDescription</b> is already loaded, the result
     *         will contain the <b>PurgCatDescription</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgCatDescription>> getPurgCatDescriptionIfPresent()
    {
        return Option.of(toPurgCatDescription);
    }

    /**
     * Overwrites the list of associated <b>PurgCatDescription</b> entities for the loaded navigation property
     * <b>to_PurgCatDescription</b>.
     * <p>
     * If the navigation property <b>to_PurgCatDescription</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgCatDescription</b> entities.
     */
    public void setPurgCatDescription( @Nonnull final List<PurgCatDescription> value )
    {
        if( toPurgCatDescription == null ) {
            toPurgCatDescription = Lists.newArrayList();
        }
        toPurgCatDescription.clear();
        toPurgCatDescription.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgCatDescription</b> entities. This corresponds to the OData
     * navigation property <b>to_PurgCatDescription</b>.
     * <p>
     * If the navigation property <b>to_PurgCatDescription</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgCatDescription</b> entities.
     */
    public void addPurgCatDescription( PurgCatDescription... entity )
    {
        if( toPurgCatDescription == null ) {
            toPurgCatDescription = Lists.newArrayList();
        }
        toPurgCatDescription.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurgCatMaterialGroup</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurgCatMaterialGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgCatMaterialGroup</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatMaterialGroup> fetchPurgCatMaterialGroup()
    {
        return fetchFieldAsList("to_PurgCatMaterialGroup", PurgCatMaterialGroup.class);
    }

    /**
     * Retrieval of associated <b>PurgCatMaterialGroup</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgCatMaterialGroup</b>.
     * <p>
     * If the navigation property <b>to_PurgCatMaterialGroup</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgCatMaterialGroup</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatMaterialGroup> getPurgCatMaterialGroupOrFetch()
    {
        if( toPurgCatMaterialGroup == null ) {
            toPurgCatMaterialGroup = fetchPurgCatMaterialGroup();
        }
        return toPurgCatMaterialGroup;
    }

    /**
     * Retrieval of associated <b>PurgCatMaterialGroup</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgCatMaterialGroup</b>.
     * <p>
     * If the navigation property for an entity <b>PurgCat</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgCatMaterialGroup</b> is already loaded, the result
     *         will contain the <b>PurgCatMaterialGroup</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgCatMaterialGroup>> getPurgCatMaterialGroupIfPresent()
    {
        return Option.of(toPurgCatMaterialGroup);
    }

    /**
     * Overwrites the list of associated <b>PurgCatMaterialGroup</b> entities for the loaded navigation property
     * <b>to_PurgCatMaterialGroup</b>.
     * <p>
     * If the navigation property <b>to_PurgCatMaterialGroup</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgCatMaterialGroup</b> entities.
     */
    public void setPurgCatMaterialGroup( @Nonnull final List<PurgCatMaterialGroup> value )
    {
        if( toPurgCatMaterialGroup == null ) {
            toPurgCatMaterialGroup = Lists.newArrayList();
        }
        toPurgCatMaterialGroup.clear();
        toPurgCatMaterialGroup.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgCatMaterialGroup</b> entities. This corresponds to the OData
     * navigation property <b>to_PurgCatMaterialGroup</b>.
     * <p>
     * If the navigation property <b>to_PurgCatMaterialGroup</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgCatMaterialGroup</b> entities.
     */
    public void addPurgCatMaterialGroup( PurgCatMaterialGroup... entity )
    {
        if( toPurgCatMaterialGroup == null ) {
            toPurgCatMaterialGroup = Lists.newArrayList();
        }
        toPurgCatMaterialGroup.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurgCatMember</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurgCatMember</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgCatMember</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatMember> fetchPurgCatMember()
    {
        return fetchFieldAsList("to_PurgCatMember", PurgCatMember.class);
    }

    /**
     * Retrieval of associated <b>PurgCatMember</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurgCatMember</b>.
     * <p>
     * If the navigation property <b>to_PurgCatMember</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgCatMember</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatMember> getPurgCatMemberOrFetch()
    {
        if( toPurgCatMember == null ) {
            toPurgCatMember = fetchPurgCatMember();
        }
        return toPurgCatMember;
    }

    /**
     * Retrieval of associated <b>PurgCatMember</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurgCatMember</b>.
     * <p>
     * If the navigation property for an entity <b>PurgCat</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgCatMember</b> is already loaded, the result will
     *         contain the <b>PurgCatMember</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgCatMember>> getPurgCatMemberIfPresent()
    {
        return Option.of(toPurgCatMember);
    }

    /**
     * Overwrites the list of associated <b>PurgCatMember</b> entities for the loaded navigation property
     * <b>to_PurgCatMember</b>.
     * <p>
     * If the navigation property <b>to_PurgCatMember</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgCatMember</b> entities.
     */
    public void setPurgCatMember( @Nonnull final List<PurgCatMember> value )
    {
        if( toPurgCatMember == null ) {
            toPurgCatMember = Lists.newArrayList();
        }
        toPurgCatMember.clear();
        toPurgCatMember.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgCatMember</b> entities. This corresponds to the OData navigation
     * property <b>to_PurgCatMember</b>.
     * <p>
     * If the navigation property <b>to_PurgCatMember</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgCatMember</b> entities.
     */
    public void addPurgCatMember( PurgCatMember... entity )
    {
        if( toPurgCatMember == null ) {
            toPurgCatMember = Lists.newArrayList();
        }
        toPurgCatMember.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurgCatPlannedSpend</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurgCatPlannedSpend</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgCatPlannedSpend</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatPlannedSpend> fetchPurgCatPlannedSpend()
    {
        return fetchFieldAsList("to_PurgCatPlannedSpend", PurgCatPlannedSpend.class);
    }

    /**
     * Retrieval of associated <b>PurgCatPlannedSpend</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgCatPlannedSpend</b>.
     * <p>
     * If the navigation property <b>to_PurgCatPlannedSpend</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgCatPlannedSpend</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatPlannedSpend> getPurgCatPlannedSpendOrFetch()
    {
        if( toPurgCatPlannedSpend == null ) {
            toPurgCatPlannedSpend = fetchPurgCatPlannedSpend();
        }
        return toPurgCatPlannedSpend;
    }

    /**
     * Retrieval of associated <b>PurgCatPlannedSpend</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgCatPlannedSpend</b>.
     * <p>
     * If the navigation property for an entity <b>PurgCat</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgCatPlannedSpend</b> is already loaded, the result
     *         will contain the <b>PurgCatPlannedSpend</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgCatPlannedSpend>> getPurgCatPlannedSpendIfPresent()
    {
        return Option.of(toPurgCatPlannedSpend);
    }

    /**
     * Overwrites the list of associated <b>PurgCatPlannedSpend</b> entities for the loaded navigation property
     * <b>to_PurgCatPlannedSpend</b>.
     * <p>
     * If the navigation property <b>to_PurgCatPlannedSpend</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgCatPlannedSpend</b> entities.
     */
    public void setPurgCatPlannedSpend( @Nonnull final List<PurgCatPlannedSpend> value )
    {
        if( toPurgCatPlannedSpend == null ) {
            toPurgCatPlannedSpend = Lists.newArrayList();
        }
        toPurgCatPlannedSpend.clear();
        toPurgCatPlannedSpend.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgCatPlannedSpend</b> entities. This corresponds to the OData
     * navigation property <b>to_PurgCatPlannedSpend</b>.
     * <p>
     * If the navigation property <b>to_PurgCatPlannedSpend</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgCatPlannedSpend</b> entities.
     */
    public void addPurgCatPlannedSpend( PurgCatPlannedSpend... entity )
    {
        if( toPurgCatPlannedSpend == null ) {
            toPurgCatPlannedSpend = Lists.newArrayList();
        }
        toPurgCatPlannedSpend.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurgCatPurchaserResponsible</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PurgCatPurchaserResponsible</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurgCatPurchaserResponsible</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgCatPurchaserResponsible fetchPurgCatPurchaserResponsible()
    {
        return fetchFieldAsSingle("to_PurgCatPurchaserResponsible", PurgCatPurchaserResponsible.class);
    }

    /**
     * Retrieval of associated <b>PurgCatPurchaserResponsible</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgCatPurchaserResponsible</b>.
     * <p>
     * If the navigation property <b>to_PurgCatPurchaserResponsible</b> of a queried <b>PurgCat</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgCatPurchaserResponsible</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgCatPurchaserResponsible getPurgCatPurchaserResponsibleOrFetch()
    {
        if( toPurgCatPurchaserResponsible == null ) {
            toPurgCatPurchaserResponsible = fetchPurgCatPurchaserResponsible();
        }
        return toPurgCatPurchaserResponsible;
    }

    /**
     * Retrieval of associated <b>PurgCatPurchaserResponsible</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgCatPurchaserResponsible</b>.
     * <p>
     * If the navigation property for an entity <b>PurgCat</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgCatPurchaserResponsible</b> is already loaded, the
     *         result will contain the <b>PurgCatPurchaserResponsible</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurgCatPurchaserResponsible> getPurgCatPurchaserResponsibleIfPresent()
    {
        return Option.of(toPurgCatPurchaserResponsible);
    }

    /**
     * Overwrites the associated <b>PurgCatPurchaserResponsible</b> entity for the loaded navigation property
     * <b>to_PurgCatPurchaserResponsible</b>.
     *
     * @param value
     *            New <b>PurgCatPurchaserResponsible</b> entity.
     */
    public void setPurgCatPurchaserResponsible( final PurgCatPurchaserResponsible value )
    {
        toPurgCatPurchaserResponsible = value;
    }

    /**
     * Fetches the <b>PurgCatSupplier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurgCatSupplier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgCatSupplier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatSupplier> fetchPurgCatSupplier()
    {
        return fetchFieldAsList("to_PurgCatSupplier", PurgCatSupplier.class);
    }

    /**
     * Retrieval of associated <b>PurgCatSupplier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurgCatSupplier</b>.
     * <p>
     * If the navigation property <b>to_PurgCatSupplier</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgCatSupplier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatSupplier> getPurgCatSupplierOrFetch()
    {
        if( toPurgCatSupplier == null ) {
            toPurgCatSupplier = fetchPurgCatSupplier();
        }
        return toPurgCatSupplier;
    }

    /**
     * Retrieval of associated <b>PurgCatSupplier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_PurgCatSupplier</b>.
     * <p>
     * If the navigation property for an entity <b>PurgCat</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgCatSupplier</b> is already loaded, the result will
     *         contain the <b>PurgCatSupplier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgCatSupplier>> getPurgCatSupplierIfPresent()
    {
        return Option.of(toPurgCatSupplier);
    }

    /**
     * Overwrites the list of associated <b>PurgCatSupplier</b> entities for the loaded navigation property
     * <b>to_PurgCatSupplier</b>.
     * <p>
     * If the navigation property <b>to_PurgCatSupplier</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgCatSupplier</b> entities.
     */
    public void setPurgCatSupplier( @Nonnull final List<PurgCatSupplier> value )
    {
        if( toPurgCatSupplier == null ) {
            toPurgCatSupplier = Lists.newArrayList();
        }
        toPurgCatSupplier.clear();
        toPurgCatSupplier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgCatSupplier</b> entities. This corresponds to the OData navigation
     * property <b>to_PurgCatSupplier</b>.
     * <p>
     * If the navigation property <b>to_PurgCatSupplier</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgCatSupplier</b> entities.
     */
    public void addPurgCatSupplier( PurgCatSupplier... entity )
    {
        if( toPurgCatSupplier == null ) {
            toPurgCatSupplier = Lists.newArrayList();
        }
        toPurgCatSupplier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurgCatTranslationStatus</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PurgCatTranslationStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgCatTranslationStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatTranslationStatus> fetchPurgCatTranslationStatus()
    {
        return fetchFieldAsList("to_PurgCatTranslationStatus", PurgCatTranslationStatus.class);
    }

    /**
     * Retrieval of associated <b>PurgCatTranslationStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgCatTranslationStatus</b>.
     * <p>
     * If the navigation property <b>to_PurgCatTranslationStatus</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgCatTranslationStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgCatTranslationStatus> getPurgCatTranslationStatusOrFetch()
    {
        if( toPurgCatTranslationStatus == null ) {
            toPurgCatTranslationStatus = fetchPurgCatTranslationStatus();
        }
        return toPurgCatTranslationStatus;
    }

    /**
     * Retrieval of associated <b>PurgCatTranslationStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgCatTranslationStatus</b>.
     * <p>
     * If the navigation property for an entity <b>PurgCat</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgCatTranslationStatus</b> is already loaded, the
     *         result will contain the <b>PurgCatTranslationStatus</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgCatTranslationStatus>> getPurgCatTranslationStatusIfPresent()
    {
        return Option.of(toPurgCatTranslationStatus);
    }

    /**
     * Overwrites the list of associated <b>PurgCatTranslationStatus</b> entities for the loaded navigation property
     * <b>to_PurgCatTranslationStatus</b>.
     * <p>
     * If the navigation property <b>to_PurgCatTranslationStatus</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgCatTranslationStatus</b> entities.
     */
    public void setPurgCatTranslationStatus( @Nonnull final List<PurgCatTranslationStatus> value )
    {
        if( toPurgCatTranslationStatus == null ) {
            toPurgCatTranslationStatus = Lists.newArrayList();
        }
        toPurgCatTranslationStatus.clear();
        toPurgCatTranslationStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgCatTranslationStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_PurgCatTranslationStatus</b>.
     * <p>
     * If the navigation property <b>to_PurgCatTranslationStatus</b> of a queried <b>PurgCat</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgCatTranslationStatus</b> entities.
     */
    public void addPurgCatTranslationStatus( PurgCatTranslationStatus... entity )
    {
        if( toPurgCatTranslationStatus == null ) {
            toPurgCatTranslationStatus = Lists.newArrayList();
        }
        toPurgCatTranslationStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurgCat instances.
     *
     */
    public final static class PurgCatBuilder
    {

        private List<PurgCatDescription> toPurgCatDescription = Lists.newArrayList();
        private List<PurgCatMaterialGroup> toPurgCatMaterialGroup = Lists.newArrayList();
        private List<PurgCatMember> toPurgCatMember = Lists.newArrayList();
        private List<PurgCatPlannedSpend> toPurgCatPlannedSpend = Lists.newArrayList();
        private PurgCatPurchaserResponsible toPurgCatPurchaserResponsible;
        private List<PurgCatSupplier> toPurgCatSupplier = Lists.newArrayList();
        private List<PurgCatTranslationStatus> toPurgCatTranslationStatus = Lists.newArrayList();

        private PurgCat.PurgCatBuilder toPurgCatDescription( final List<PurgCatDescription> value )
        {
            toPurgCatDescription.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurgCatDescription</b> for <b>PurgCat</b> to multiple <b>PurgCatDescription</b>.
         *
         * @param value
         *            The PurgCatDescriptions to build this PurgCat with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgCat.PurgCatBuilder purgCatDescription( PurgCatDescription... value )
        {
            return toPurgCatDescription(Lists.newArrayList(value));
        }

        private PurgCat.PurgCatBuilder toPurgCatMaterialGroup( final List<PurgCatMaterialGroup> value )
        {
            toPurgCatMaterialGroup.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurgCatMaterialGroup</b> for <b>PurgCat</b> to multiple
         * <b>PurgCatMaterialGroup</b>.
         *
         * @param value
         *            The PurgCatMaterialGroups to build this PurgCat with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgCat.PurgCatBuilder purgCatMaterialGroup( PurgCatMaterialGroup... value )
        {
            return toPurgCatMaterialGroup(Lists.newArrayList(value));
        }

        private PurgCat.PurgCatBuilder toPurgCatMember( final List<PurgCatMember> value )
        {
            toPurgCatMember.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurgCatMember</b> for <b>PurgCat</b> to multiple <b>PurgCatMember</b>.
         *
         * @param value
         *            The PurgCatMembers to build this PurgCat with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgCat.PurgCatBuilder purgCatMember( PurgCatMember... value )
        {
            return toPurgCatMember(Lists.newArrayList(value));
        }

        private PurgCat.PurgCatBuilder toPurgCatPlannedSpend( final List<PurgCatPlannedSpend> value )
        {
            toPurgCatPlannedSpend.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurgCatPlannedSpend</b> for <b>PurgCat</b> to multiple <b>PurgCatPlannedSpend</b>.
         *
         * @param value
         *            The PurgCatPlannedSpends to build this PurgCat with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgCat.PurgCatBuilder purgCatPlannedSpend( PurgCatPlannedSpend... value )
        {
            return toPurgCatPlannedSpend(Lists.newArrayList(value));
        }

        private PurgCat.PurgCatBuilder toPurgCatPurchaserResponsible( final PurgCatPurchaserResponsible value )
        {
            toPurgCatPurchaserResponsible = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgCatPurchaserResponsible</b> for <b>PurgCat</b> to single
         * <b>PurgCatPurchaserResponsible</b>.
         *
         * @param value
         *            The PurgCatPurchaserResponsible to build this PurgCat with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgCat.PurgCatBuilder purgCatPurchaserResponsible( final PurgCatPurchaserResponsible value )
        {
            return toPurgCatPurchaserResponsible(value);
        }

        private PurgCat.PurgCatBuilder toPurgCatSupplier( final List<PurgCatSupplier> value )
        {
            toPurgCatSupplier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurgCatSupplier</b> for <b>PurgCat</b> to multiple <b>PurgCatSupplier</b>.
         *
         * @param value
         *            The PurgCatSuppliers to build this PurgCat with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgCat.PurgCatBuilder purgCatSupplier( PurgCatSupplier... value )
        {
            return toPurgCatSupplier(Lists.newArrayList(value));
        }

        private PurgCat.PurgCatBuilder toPurgCatTranslationStatus( final List<PurgCatTranslationStatus> value )
        {
            toPurgCatTranslationStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurgCatTranslationStatus</b> for <b>PurgCat</b> to multiple
         * <b>PurgCatTranslationStatus</b>.
         *
         * @param value
         *            The PurgCatTranslationStatuss to build this PurgCat with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgCat.PurgCatBuilder purgCatTranslationStatus( PurgCatTranslationStatus... value )
        {
            return toPurgCatTranslationStatus(Lists.newArrayList(value));
        }

    }

}
