/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.field.PurgCatDescriptionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.selectable.PurgCatDescriptionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgCatDescriptionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgCatDescription extends VdmEntity<PurgCatDescription>
{

    /**
     * Selector for all available fields of PurgCatDescription.
     *
     */
    public final static PurgCatDescriptionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatDescriptionUUID</b>
     * </p>
     *
     * @return Purchasing Category Description UUID
     */
    @Key
    @SerializedName( "PurgCatDescriptionUUID" )
    @JsonProperty( "PurgCatDescriptionUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatDescriptionUUID" )
    private UUID purgCatDescriptionUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatDescriptionUUID</b> field to query operations.
     *
     */
    public final static PurgCatDescriptionField<UUID> PURG_CAT_DESCRIPTION_UUID =
        new PurgCatDescriptionField<UUID>("PurgCatDescriptionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PurgCatDescriptionField<String> LANGUAGE = new PurgCatDescriptionField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @return Purchasing Category UUID
     */
    @SerializedName( "PurgCatUUID" )
    @JsonProperty( "PurgCatUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatUUID" )
    private UUID purgCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatUUID</b> field to query operations.
     *
     */
    public final static PurgCatDescriptionField<UUID> PURG_CAT_UUID = new PurgCatDescriptionField<UUID>("PurgCatUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatDescription</b>
     * </p>
     *
     * @return Description of Purchasing Category
     */
    @SerializedName( "PurgCatDescription" )
    @JsonProperty( "PurgCatDescription" )
    @Nullable
    @ODataField( odataName = "PurgCatDescription" )
    private String purgCatDescription;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatDescription</b> field to query operations.
     *
     */
    public final static PurgCatDescriptionField<String> PURG_CAT_DESCRIPTION =
        new PurgCatDescriptionField<String>("PurgCatDescription");

    @Nonnull
    @Override
    public Class<PurgCatDescription> getType()
    {
        return PurgCatDescription.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatDescriptionUUID</b>
     * </p>
     *
     * @param purgCatDescriptionUUID
     *            Purchasing Category Description UUID
     */
    public void setPurgCatDescriptionUUID( @Nullable final UUID purgCatDescriptionUUID )
    {
        rememberChangedField("PurgCatDescriptionUUID", this.purgCatDescriptionUUID);
        this.purgCatDescriptionUUID = purgCatDescriptionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @param purgCatUUID
     *            Purchasing Category UUID
     */
    public void setPurgCatUUID( @Nullable final UUID purgCatUUID )
    {
        rememberChangedField("PurgCatUUID", this.purgCatUUID);
        this.purgCatUUID = purgCatUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatDescription</b>
     * </p>
     *
     * @param purgCatDescription
     *            Description of Purchasing Category
     */
    public void setPurgCatDescription( @Nullable final String purgCatDescription )
    {
        rememberChangedField("PurgCatDescription", this.purgCatDescription);
        this.purgCatDescription = purgCatDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgCatDescription";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurgCatDescriptionUUID", getPurgCatDescriptionUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurgCatDescriptionUUID", getPurgCatDescriptionUUID());
        values.put("Language", getLanguage());
        values.put("PurgCatUUID", getPurgCatUUID());
        values.put("PurgCatDescription", getPurgCatDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurgCatDescriptionUUID") ) {
                final Object value = values.remove("PurgCatDescriptionUUID");
                if( (value == null) || (!value.equals(getPurgCatDescriptionUUID())) ) {
                    setPurgCatDescriptionUUID(((UUID) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PurgCatUUID") ) {
                final Object value = values.remove("PurgCatUUID");
                if( (value == null) || (!value.equals(getPurgCatUUID())) ) {
                    setPurgCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurgCatDescription") ) {
                final Object value = values.remove("PurgCatDescription");
                if( (value == null) || (!value.equals(getPurgCatDescription())) ) {
                    setPurgCatDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgCatDescriptionField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgCatDescriptionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgCatDescriptionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgCatDescriptionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService.DEFAULT_SERVICE_PATH);
    }

}
