/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.field.PurgCatMaterialGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.selectable.PurgCatMaterialGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Material Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgCatMaterialGroupType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgCatMaterialGroup extends VdmEntity<PurgCatMaterialGroup>
{

    /**
     * Selector for all available fields of PurgCatMaterialGroup.
     *
     */
    public final static PurgCatMaterialGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurCatMaterialGroupUUID</b>
     * </p>
     *
     * @return Purchasing Category Material Group Reference UUID
     */
    @Key
    @SerializedName( "PurCatMaterialGroupUUID" )
    @JsonProperty( "PurCatMaterialGroupUUID" )
    @Nullable
    @ODataField( odataName = "PurCatMaterialGroupUUID" )
    private UUID purCatMaterialGroupUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurCatMaterialGroupUUID</b> field to query operations.
     *
     */
    public final static PurgCatMaterialGroupField<UUID> PUR_CAT_MATERIAL_GROUP_UUID =
        new PurgCatMaterialGroupField<UUID>("PurCatMaterialGroupUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @return Purchasing Category UUID
     */
    @SerializedName( "PurgCatUUID" )
    @JsonProperty( "PurgCatUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatUUID" )
    private UUID purgCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatUUID</b> field to query operations.
     *
     */
    public final static PurgCatMaterialGroupField<UUID> PURG_CAT_UUID =
        new PurgCatMaterialGroupField<UUID>("PurgCatUUID");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static PurgCatMaterialGroupField<String> MATERIAL_GROUP =
        new PurgCatMaterialGroupField<String>("MaterialGroup");

    @Nonnull
    @Override
    public Class<PurgCatMaterialGroup> getType()
    {
        return PurgCatMaterialGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurCatMaterialGroupUUID</b>
     * </p>
     *
     * @param purCatMaterialGroupUUID
     *            Purchasing Category Material Group Reference UUID
     */
    public void setPurCatMaterialGroupUUID( @Nullable final UUID purCatMaterialGroupUUID )
    {
        rememberChangedField("PurCatMaterialGroupUUID", this.purCatMaterialGroupUUID);
        this.purCatMaterialGroupUUID = purCatMaterialGroupUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @param purgCatUUID
     *            Purchasing Category UUID
     */
    public void setPurgCatUUID( @Nullable final UUID purgCatUUID )
    {
        rememberChangedField("PurgCatUUID", this.purgCatUUID);
        this.purgCatUUID = purgCatUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgCatMaterialGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurCatMaterialGroupUUID", getPurCatMaterialGroupUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurCatMaterialGroupUUID", getPurCatMaterialGroupUUID());
        values.put("PurgCatUUID", getPurgCatUUID());
        values.put("MaterialGroup", getMaterialGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurCatMaterialGroupUUID") ) {
                final Object value = values.remove("PurCatMaterialGroupUUID");
                if( (value == null) || (!value.equals(getPurCatMaterialGroupUUID())) ) {
                    setPurCatMaterialGroupUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurgCatUUID") ) {
                final Object value = values.remove("PurgCatUUID");
                if( (value == null) || (!value.equals(getPurgCatUUID())) ) {
                    setPurgCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgCatMaterialGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgCatMaterialGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgCatMaterialGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgCatMaterialGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService.DEFAULT_SERVICE_PATH);
    }

}
