/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.field.PurgCatPlannedSpendField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.selectable.PurgCatPlannedSpendSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Planned Spend
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgCatPlannedSpendType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgCatPlannedSpend extends VdmEntity<PurgCatPlannedSpend>
{

    /**
     * Selector for all available fields of PurgCatPlannedSpend.
     *
     */
    public final static PurgCatPlannedSpendSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendUUID</b>
     * </p>
     *
     * @return Planned Spend for a Purchasing Category
     */
    @Key
    @SerializedName( "PurgCatPlndSpendUUID" )
    @JsonProperty( "PurgCatPlndSpendUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatPlndSpendUUID" )
    private UUID purgCatPlndSpendUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatPlndSpendUUID</b> field to query operations.
     *
     */
    public final static PurgCatPlannedSpendField<UUID> PURG_CAT_PLND_SPEND_UUID =
        new PurgCatPlannedSpendField<UUID>("PurgCatPlndSpendUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @return Purchasing Category UUID
     */
    @SerializedName( "PurgCatUUID" )
    @JsonProperty( "PurgCatUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatUUID" )
    private UUID purgCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatUUID</b> field to query operations.
     *
     */
    public final static PurgCatPlannedSpendField<UUID> PURG_CAT_UUID =
        new PurgCatPlannedSpendField<UUID>("PurgCatUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendValidFromDate</b>
     * </p>
     *
     * @return "Valid From" Date of Planned Spend
     */
    @SerializedName( "PurgCatPlndSpendValidFromDate" )
    @JsonProperty( "PurgCatPlndSpendValidFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurgCatPlndSpendValidFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purgCatPlndSpendValidFromDate;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatPlndSpendValidFromDate</b> field to query operations.
     *
     */
    public final static PurgCatPlannedSpendField<LocalDateTime> PURG_CAT_PLND_SPEND_VALID_FROM_DATE =
        new PurgCatPlannedSpendField<LocalDateTime>("PurgCatPlndSpendValidFromDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendValidToDate</b>
     * </p>
     *
     * @return "Valid To" Date of Planned Spend
     */
    @SerializedName( "PurgCatPlndSpendValidToDate" )
    @JsonProperty( "PurgCatPlndSpendValidToDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurgCatPlndSpendValidToDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purgCatPlndSpendValidToDate;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatPlndSpendValidToDate</b> field to query operations.
     *
     */
    public final static PurgCatPlannedSpendField<LocalDateTime> PURG_CAT_PLND_SPEND_VALID_TO_DATE =
        new PurgCatPlannedSpendField<LocalDateTime>("PurgCatPlndSpendValidToDate");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendAmount</b>
     * </p>
     *
     * @return Amount of Planned Spend
     */
    @SerializedName( "PurgCatPlndSpendAmount" )
    @JsonProperty( "PurgCatPlndSpendAmount" )
    @Nullable
    @ODataField( odataName = "PurgCatPlndSpendAmount" )
    private BigDecimal purgCatPlndSpendAmount;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatPlndSpendAmount</b> field to query operations.
     *
     */
    public final static PurgCatPlannedSpendField<BigDecimal> PURG_CAT_PLND_SPEND_AMOUNT =
        new PurgCatPlannedSpendField<BigDecimal>("PurgCatPlndSpendAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendCurrency</b>
     * </p>
     *
     * @return Currency of Planned Spend
     */
    @SerializedName( "PurgCatPlndSpendCurrency" )
    @JsonProperty( "PurgCatPlndSpendCurrency" )
    @Nullable
    @ODataField( odataName = "PurgCatPlndSpendCurrency" )
    private String purgCatPlndSpendCurrency;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatPlndSpendCurrency</b> field to query operations.
     *
     */
    public final static PurgCatPlannedSpendField<String> PURG_CAT_PLND_SPEND_CURRENCY =
        new PurgCatPlannedSpendField<String>("PurgCatPlndSpendCurrency");

    @Nonnull
    @Override
    public Class<PurgCatPlannedSpend> getType()
    {
        return PurgCatPlannedSpend.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendUUID</b>
     * </p>
     *
     * @param purgCatPlndSpendUUID
     *            Planned Spend for a Purchasing Category
     */
    public void setPurgCatPlndSpendUUID( @Nullable final UUID purgCatPlndSpendUUID )
    {
        rememberChangedField("PurgCatPlndSpendUUID", this.purgCatPlndSpendUUID);
        this.purgCatPlndSpendUUID = purgCatPlndSpendUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @param purgCatUUID
     *            Purchasing Category UUID
     */
    public void setPurgCatUUID( @Nullable final UUID purgCatUUID )
    {
        rememberChangedField("PurgCatUUID", this.purgCatUUID);
        this.purgCatUUID = purgCatUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendValidFromDate</b>
     * </p>
     *
     * @param purgCatPlndSpendValidFromDate
     *            "Valid From" Date of Planned Spend
     */
    public void setPurgCatPlndSpendValidFromDate( @Nullable final LocalDateTime purgCatPlndSpendValidFromDate )
    {
        rememberChangedField("PurgCatPlndSpendValidFromDate", this.purgCatPlndSpendValidFromDate);
        this.purgCatPlndSpendValidFromDate = purgCatPlndSpendValidFromDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendValidToDate</b>
     * </p>
     *
     * @param purgCatPlndSpendValidToDate
     *            "Valid To" Date of Planned Spend
     */
    public void setPurgCatPlndSpendValidToDate( @Nullable final LocalDateTime purgCatPlndSpendValidToDate )
    {
        rememberChangedField("PurgCatPlndSpendValidToDate", this.purgCatPlndSpendValidToDate);
        this.purgCatPlndSpendValidToDate = purgCatPlndSpendValidToDate;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendAmount</b>
     * </p>
     *
     * @param purgCatPlndSpendAmount
     *            Amount of Planned Spend
     */
    public void setPurgCatPlndSpendAmount( @Nullable final BigDecimal purgCatPlndSpendAmount )
    {
        rememberChangedField("PurgCatPlndSpendAmount", this.purgCatPlndSpendAmount);
        this.purgCatPlndSpendAmount = purgCatPlndSpendAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatPlndSpendCurrency</b>
     * </p>
     *
     * @param purgCatPlndSpendCurrency
     *            Currency of Planned Spend
     */
    public void setPurgCatPlndSpendCurrency( @Nullable final String purgCatPlndSpendCurrency )
    {
        rememberChangedField("PurgCatPlndSpendCurrency", this.purgCatPlndSpendCurrency);
        this.purgCatPlndSpendCurrency = purgCatPlndSpendCurrency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgCatPlannedSpend";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurgCatPlndSpendUUID", getPurgCatPlndSpendUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurgCatPlndSpendUUID", getPurgCatPlndSpendUUID());
        values.put("PurgCatUUID", getPurgCatUUID());
        values.put("PurgCatPlndSpendValidFromDate", getPurgCatPlndSpendValidFromDate());
        values.put("PurgCatPlndSpendValidToDate", getPurgCatPlndSpendValidToDate());
        values.put("PurgCatPlndSpendAmount", getPurgCatPlndSpendAmount());
        values.put("PurgCatPlndSpendCurrency", getPurgCatPlndSpendCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurgCatPlndSpendUUID") ) {
                final Object value = values.remove("PurgCatPlndSpendUUID");
                if( (value == null) || (!value.equals(getPurgCatPlndSpendUUID())) ) {
                    setPurgCatPlndSpendUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurgCatUUID") ) {
                final Object value = values.remove("PurgCatUUID");
                if( (value == null) || (!value.equals(getPurgCatUUID())) ) {
                    setPurgCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurgCatPlndSpendValidFromDate") ) {
                final Object value = values.remove("PurgCatPlndSpendValidFromDate");
                if( (value == null) || (!value.equals(getPurgCatPlndSpendValidFromDate())) ) {
                    setPurgCatPlndSpendValidFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurgCatPlndSpendValidToDate") ) {
                final Object value = values.remove("PurgCatPlndSpendValidToDate");
                if( (value == null) || (!value.equals(getPurgCatPlndSpendValidToDate())) ) {
                    setPurgCatPlndSpendValidToDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PurgCatPlndSpendAmount") ) {
                final Object value = values.remove("PurgCatPlndSpendAmount");
                if( (value == null) || (!value.equals(getPurgCatPlndSpendAmount())) ) {
                    setPurgCatPlndSpendAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurgCatPlndSpendCurrency") ) {
                final Object value = values.remove("PurgCatPlndSpendCurrency");
                if( (value == null) || (!value.equals(getPurgCatPlndSpendCurrency())) ) {
                    setPurgCatPlndSpendCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgCatPlannedSpendField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgCatPlannedSpendField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgCatPlannedSpendField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgCatPlannedSpendField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService.DEFAULT_SERVICE_PATH);
    }

}
