/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.field.PurgCatTranslationStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.selectable.PurgCatTranslationStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Translation Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgCatTranslationStatusType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgCatTranslationStatus extends VdmEntity<PurgCatTranslationStatus>
{

    /**
     * Selector for all available fields of PurgCatTranslationStatus.
     *
     */
    public final static PurgCatTranslationStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatTranslationUUID</b>
     * </p>
     *
     * @return Purchasing Category Translation UUID
     */
    @Key
    @SerializedName( "PurgCatTranslationUUID" )
    @JsonProperty( "PurgCatTranslationUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatTranslationUUID" )
    private UUID purgCatTranslationUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatTranslationUUID</b> field to query operations.
     *
     */
    public final static PurgCatTranslationStatusField<UUID> PURG_CAT_TRANSLATION_UUID =
        new PurgCatTranslationStatusField<UUID>("PurgCatTranslationUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @return Purchasing Category UUID
     */
    @SerializedName( "PurgCatUUID" )
    @JsonProperty( "PurgCatUUID" )
    @Nullable
    @ODataField( odataName = "PurgCatUUID" )
    private UUID purgCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatUUID</b> field to query operations.
     *
     */
    public final static PurgCatTranslationStatusField<UUID> PURG_CAT_UUID =
        new PurgCatTranslationStatusField<UUID>("PurgCatUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatTranslationTgtLang</b>
     * </p>
     *
     * @return Target Language
     */
    @SerializedName( "PurgCatTranslationTgtLang" )
    @JsonProperty( "PurgCatTranslationTgtLang" )
    @Nullable
    @ODataField( odataName = "PurgCatTranslationTgtLang" )
    private String purgCatTranslationTgtLang;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatTranslationTgtLang</b> field to query operations.
     *
     */
    public final static PurgCatTranslationStatusField<String> PURG_CAT_TRANSLATION_TGT_LANG =
        new PurgCatTranslationStatusField<String>("PurgCatTranslationTgtLang");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatTranslationTgtLangSts</b>
     * </p>
     *
     * @return Status of Target Language
     */
    @SerializedName( "PurgCatTranslationTgtLangSts" )
    @JsonProperty( "PurgCatTranslationTgtLangSts" )
    @Nullable
    @ODataField( odataName = "PurgCatTranslationTgtLangSts" )
    private String purgCatTranslationTgtLangSts;
    /**
     * Use with available fluent helpers to apply the <b>PurgCatTranslationTgtLangSts</b> field to query operations.
     *
     */
    public final static PurgCatTranslationStatusField<String> PURG_CAT_TRANSLATION_TGT_LANG_STS =
        new PurgCatTranslationStatusField<String>("PurgCatTranslationTgtLangSts");

    @Nonnull
    @Override
    public Class<PurgCatTranslationStatus> getType()
    {
        return PurgCatTranslationStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatTranslationUUID</b>
     * </p>
     *
     * @param purgCatTranslationUUID
     *            Purchasing Category Translation UUID
     */
    public void setPurgCatTranslationUUID( @Nullable final UUID purgCatTranslationUUID )
    {
        rememberChangedField("PurgCatTranslationUUID", this.purgCatTranslationUUID);
        this.purgCatTranslationUUID = purgCatTranslationUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatUUID</b>
     * </p>
     *
     * @param purgCatUUID
     *            Purchasing Category UUID
     */
    public void setPurgCatUUID( @Nullable final UUID purgCatUUID )
    {
        rememberChangedField("PurgCatUUID", this.purgCatUUID);
        this.purgCatUUID = purgCatUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatTranslationTgtLang</b>
     * </p>
     *
     * @param purgCatTranslationTgtLang
     *            Target Language
     */
    public void setPurgCatTranslationTgtLang( @Nullable final String purgCatTranslationTgtLang )
    {
        rememberChangedField("PurgCatTranslationTgtLang", this.purgCatTranslationTgtLang);
        this.purgCatTranslationTgtLang = purgCatTranslationTgtLang;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgCatTranslationTgtLangSts</b>
     * </p>
     *
     * @param purgCatTranslationTgtLangSts
     *            Status of Target Language
     */
    public void setPurgCatTranslationTgtLangSts( @Nullable final String purgCatTranslationTgtLangSts )
    {
        rememberChangedField("PurgCatTranslationTgtLangSts", this.purgCatTranslationTgtLangSts);
        this.purgCatTranslationTgtLangSts = purgCatTranslationTgtLangSts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgCatTranslationStatus";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurgCatTranslationUUID", getPurgCatTranslationUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurgCatTranslationUUID", getPurgCatTranslationUUID());
        values.put("PurgCatUUID", getPurgCatUUID());
        values.put("PurgCatTranslationTgtLang", getPurgCatTranslationTgtLang());
        values.put("PurgCatTranslationTgtLangSts", getPurgCatTranslationTgtLangSts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurgCatTranslationUUID") ) {
                final Object value = values.remove("PurgCatTranslationUUID");
                if( (value == null) || (!value.equals(getPurgCatTranslationUUID())) ) {
                    setPurgCatTranslationUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurgCatUUID") ) {
                final Object value = values.remove("PurgCatUUID");
                if( (value == null) || (!value.equals(getPurgCatUUID())) ) {
                    setPurgCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurgCatTranslationTgtLang") ) {
                final Object value = values.remove("PurgCatTranslationTgtLang");
                if( (value == null) || (!value.equals(getPurgCatTranslationTgtLang())) ) {
                    setPurgCatTranslationTgtLang(((String) value));
                }
            }
            if( values.containsKey("PurgCatTranslationTgtLangSts") ) {
                final Object value = values.remove("PurgCatTranslationTgtLangSts");
                if( (value == null) || (!value.equals(getPurgCatTranslationTgtLangSts())) ) {
                    setPurgCatTranslationTgtLangSts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgCatTranslationStatusField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgCatTranslationStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgCatTranslationStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgCatTranslationStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService.DEFAULT_SERVICE_PATH);
    }

}
