/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PurchasingCategoryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService PurchasingCategoryService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPurchasingCategoryServiceBatch
    extends
    BatchFluentHelperBasic<PurchasingCategoryServiceBatch, PurchasingCategoryServiceBatchChangeSet>
    implements
    PurchasingCategoryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPurchasingCategoryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingCategoryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPurchasingCategoryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingCategoryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingCategoryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPurchasingCategoryServiceBatchChangeSet(this, service);
    }

}
