/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCat;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMember;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPurchaserResponsible;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus;

/**
 * Implementation of the {@link PurchasingCategoryServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService PurchasingCategoryService}.
 *
 */
public class DefaultPurchasingCategoryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PurchasingCategoryServiceBatch, PurchasingCategoryServiceBatchChangeSet>
    implements
    PurchasingCategoryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService service;

    @SuppressWarnings( "deprecation" )
    DefaultPurchasingCategoryServiceBatchChangeSet(
        @Nonnull final DefaultPurchasingCategoryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingCategoryServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet createPurgCat( @Nonnull final PurgCat purgCat )
    {
        return addRequestCreate(service::createPurgCat, purgCat);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet updatePurgCat( @Nonnull final PurgCat purgCat )
    {
        return addRequestUpdate(service::updatePurgCat, purgCat);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet createPurgCatDescription(
        @Nonnull final PurgCatDescription purgCatDescription )
    {
        return addRequestCreate(service::createPurgCatDescription, purgCatDescription);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet updatePurgCatDescription(
        @Nonnull final PurgCatDescription purgCatDescription )
    {
        return addRequestUpdate(service::updatePurgCatDescription, purgCatDescription);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet deletePurgCatDescription(
        @Nonnull final PurgCatDescription purgCatDescription )
    {
        return addRequestDelete(service::deletePurgCatDescription, purgCatDescription);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet createPurgCatMaterialGroup(
        @Nonnull final PurgCatMaterialGroup purgCatMaterialGroup )
    {
        return addRequestCreate(service::createPurgCatMaterialGroup, purgCatMaterialGroup);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet updatePurgCatMaterialGroup(
        @Nonnull final PurgCatMaterialGroup purgCatMaterialGroup )
    {
        return addRequestUpdate(service::updatePurgCatMaterialGroup, purgCatMaterialGroup);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet deletePurgCatMaterialGroup(
        @Nonnull final PurgCatMaterialGroup purgCatMaterialGroup )
    {
        return addRequestDelete(service::deletePurgCatMaterialGroup, purgCatMaterialGroup);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet createPurgCatMember( @Nonnull final PurgCatMember purgCatMember )
    {
        return addRequestCreate(service::createPurgCatMember, purgCatMember);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet updatePurgCatMember( @Nonnull final PurgCatMember purgCatMember )
    {
        return addRequestUpdate(service::updatePurgCatMember, purgCatMember);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet deletePurgCatMember( @Nonnull final PurgCatMember purgCatMember )
    {
        return addRequestDelete(service::deletePurgCatMember, purgCatMember);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet createPurgCatPlannedSpend(
        @Nonnull final PurgCatPlannedSpend purgCatPlannedSpend )
    {
        return addRequestCreate(service::createPurgCatPlannedSpend, purgCatPlannedSpend);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet updatePurgCatPlannedSpend(
        @Nonnull final PurgCatPlannedSpend purgCatPlannedSpend )
    {
        return addRequestUpdate(service::updatePurgCatPlannedSpend, purgCatPlannedSpend);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet deletePurgCatPlannedSpend(
        @Nonnull final PurgCatPlannedSpend purgCatPlannedSpend )
    {
        return addRequestDelete(service::deletePurgCatPlannedSpend, purgCatPlannedSpend);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet updatePurgCatPurchaserResponsible(
        @Nonnull final PurgCatPurchaserResponsible purgCatPurchaserResponsible )
    {
        return addRequestUpdate(service::updatePurgCatPurchaserResponsible, purgCatPurchaserResponsible);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet createPurgCatSupplier(
        @Nonnull final PurgCatSupplier purgCatSupplier )
    {
        return addRequestCreate(service::createPurgCatSupplier, purgCatSupplier);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet updatePurgCatSupplier(
        @Nonnull final PurgCatSupplier purgCatSupplier )
    {
        return addRequestUpdate(service::updatePurgCatSupplier, purgCatSupplier);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet deletePurgCatSupplier(
        @Nonnull final PurgCatSupplier purgCatSupplier )
    {
        return addRequestDelete(service::deletePurgCatSupplier, purgCatSupplier);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet createPurgCatTranslationStatus(
        @Nonnull final PurgCatTranslationStatus purgCatTranslationStatus )
    {
        return addRequestCreate(service::createPurgCatTranslationStatus, purgCatTranslationStatus);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet updatePurgCatTranslationStatus(
        @Nonnull final PurgCatTranslationStatus purgCatTranslationStatus )
    {
        return addRequestUpdate(service::updatePurgCatTranslationStatus, purgCatTranslationStatus);
    }

    @Nonnull
    @Override
    public PurchasingCategoryServiceBatchChangeSet deletePurgCatTranslationStatus(
        @Nonnull final PurgCatTranslationStatus purgCatTranslationStatus )
    {
        return addRequestDelete(service::deletePurgCatTranslationStatus, purgCatTranslationStatus);
    }

}
