/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCat;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMember;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPurchaserResponsible;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplier;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingCategoryService
 * PurchasingCategoryService}.
 *
 */
public interface PurchasingCategoryServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PurchasingCategoryServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PurchasingCategoryServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCat PurgCat}
     * entity and save it to the S/4HANA system.
     *
     * @param purgCat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCat PurgCat} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet createPurgCat( @Nonnull final PurgCat purgCat );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCat PurgCat}
     * entity and save it to the S/4HANA system.
     *
     * @param purgCat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCat PurgCat} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet updatePurgCat( @Nonnull final PurgCat purgCat );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription
     * PurgCatDescription} entity and save it to the S/4HANA system.
     *
     * @param purgCatDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription
     *            PurgCatDescription} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        createPurgCatDescription( @Nonnull final PurgCatDescription purgCatDescription );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription
     * PurgCatDescription} entity and save it to the S/4HANA system.
     *
     * @param purgCatDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription
     *            PurgCatDescription} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        updatePurgCatDescription( @Nonnull final PurgCatDescription purgCatDescription );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription
     * PurgCatDescription} entity in the S/4HANA system.
     *
     * @param purgCatDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription
     *            PurgCatDescription} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        deletePurgCatDescription( @Nonnull final PurgCatDescription purgCatDescription );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup
     * PurgCatMaterialGroup} entity and save it to the S/4HANA system.
     *
     * @param purgCatMaterialGroup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup
     *            PurgCatMaterialGroup} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        createPurgCatMaterialGroup( @Nonnull final PurgCatMaterialGroup purgCatMaterialGroup );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup
     * PurgCatMaterialGroup} entity and save it to the S/4HANA system.
     *
     * @param purgCatMaterialGroup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup
     *            PurgCatMaterialGroup} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        updatePurgCatMaterialGroup( @Nonnull final PurgCatMaterialGroup purgCatMaterialGroup );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup
     * PurgCatMaterialGroup} entity in the S/4HANA system.
     *
     * @param purgCatMaterialGroup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup
     *            PurgCatMaterialGroup} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        deletePurgCatMaterialGroup( @Nonnull final PurgCatMaterialGroup purgCatMaterialGroup );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMember
     * PurgCatMember} entity and save it to the S/4HANA system.
     *
     * @param purgCatMember
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMember
     *            PurgCatMember} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet createPurgCatMember( @Nonnull final PurgCatMember purgCatMember );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMember
     * PurgCatMember} entity and save it to the S/4HANA system.
     *
     * @param purgCatMember
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMember
     *            PurgCatMember} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet updatePurgCatMember( @Nonnull final PurgCatMember purgCatMember );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMember
     * PurgCatMember} entity in the S/4HANA system.
     *
     * @param purgCatMember
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMember
     *            PurgCatMember} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet deletePurgCatMember( @Nonnull final PurgCatMember purgCatMember );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend
     * PurgCatPlannedSpend} entity and save it to the S/4HANA system.
     *
     * @param purgCatPlannedSpend
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend
     *            PurgCatPlannedSpend} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        createPurgCatPlannedSpend( @Nonnull final PurgCatPlannedSpend purgCatPlannedSpend );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend
     * PurgCatPlannedSpend} entity and save it to the S/4HANA system.
     *
     * @param purgCatPlannedSpend
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend
     *            PurgCatPlannedSpend} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        updatePurgCatPlannedSpend( @Nonnull final PurgCatPlannedSpend purgCatPlannedSpend );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend
     * PurgCatPlannedSpend} entity in the S/4HANA system.
     *
     * @param purgCatPlannedSpend
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend
     *            PurgCatPlannedSpend} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        deletePurgCatPlannedSpend( @Nonnull final PurgCatPlannedSpend purgCatPlannedSpend );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPurchaserResponsible
     * PurgCatPurchaserResponsible} entity and save it to the S/4HANA system.
     *
     * @param purgCatPurchaserResponsible
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPurchaserResponsible
     *            PurgCatPurchaserResponsible} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        updatePurgCatPurchaserResponsible( @Nonnull final PurgCatPurchaserResponsible purgCatPurchaserResponsible );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplier
     * PurgCatSupplier} entity and save it to the S/4HANA system.
     *
     * @param purgCatSupplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplier
     *            PurgCatSupplier} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet createPurgCatSupplier( @Nonnull final PurgCatSupplier purgCatSupplier );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplier
     * PurgCatSupplier} entity and save it to the S/4HANA system.
     *
     * @param purgCatSupplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplier
     *            PurgCatSupplier} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet updatePurgCatSupplier( @Nonnull final PurgCatSupplier purgCatSupplier );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplier
     * PurgCatSupplier} entity in the S/4HANA system.
     *
     * @param purgCatSupplier
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatSupplier
     *            PurgCatSupplier} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet deletePurgCatSupplier( @Nonnull final PurgCatSupplier purgCatSupplier );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus
     * PurgCatTranslationStatus} entity and save it to the S/4HANA system.
     *
     * @param purgCatTranslationStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus
     *            PurgCatTranslationStatus} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        createPurgCatTranslationStatus( @Nonnull final PurgCatTranslationStatus purgCatTranslationStatus );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus
     * PurgCatTranslationStatus} entity and save it to the S/4HANA system.
     *
     * @param purgCatTranslationStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus
     *            PurgCatTranslationStatus} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        updatePurgCatTranslationStatus( @Nonnull final PurgCatTranslationStatus purgCatTranslationStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus
     * PurgCatTranslationStatus} entity in the S/4HANA system.
     *
     * @param purgCatTranslationStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus
     *            PurgCatTranslationStatus} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingCategoryServiceBatchChangeSet
        deletePurgCatTranslationStatus( @Nonnull final PurgCatTranslationStatus purgCatTranslationStatus );

}
