/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription PurgCatDescription}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.field.PurgCatDescriptionField
 * PurgCatDescriptionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.link.PurgCatDescriptionLink
 * PurgCatDescriptionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription#PURG_CAT_DESCRIPTION_UUID
 * PURG_CAT_DESCRIPTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription#PURG_CAT_UUID
 * PURG_CAT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatDescription#PURG_CAT_DESCRIPTION
 * PURG_CAT_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface PurgCatDescriptionSelectable extends EntitySelectable<PurgCatDescription>
{

}
