/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup
 * PurgCatMaterialGroup}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.field.PurgCatMaterialGroupField
 * PurgCatMaterialGroupField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.link.PurgCatMaterialGroupLink
 * PurgCatMaterialGroupLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup#PUR_CAT_MATERIAL_GROUP_UUID
 * PUR_CAT_MATERIAL_GROUP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup#PURG_CAT_UUID
 * PURG_CAT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatMaterialGroup#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * </ul>
 *
 */
public interface PurgCatMaterialGroupSelectable extends EntitySelectable<PurgCatMaterialGroup>
{

}
