/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend
 * PurgCatPlannedSpend}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.field.PurgCatPlannedSpendField
 * PurgCatPlannedSpendField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.link.PurgCatPlannedSpendLink
 * PurgCatPlannedSpendLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend#PURG_CAT_PLND_SPEND_UUID
 * PURG_CAT_PLND_SPEND_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend#PURG_CAT_UUID
 * PURG_CAT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend#PURG_CAT_PLND_SPEND_VALID_FROM_DATE
 * PURG_CAT_PLND_SPEND_VALID_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend#PURG_CAT_PLND_SPEND_VALID_TO_DATE
 * PURG_CAT_PLND_SPEND_VALID_TO_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend#PURG_CAT_PLND_SPEND_AMOUNT
 * PURG_CAT_PLND_SPEND_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatPlannedSpend#PURG_CAT_PLND_SPEND_CURRENCY
 * PURG_CAT_PLND_SPEND_CURRENCY}</li>
 * </ul>
 *
 */
public interface PurgCatPlannedSpendSelectable extends EntitySelectable<PurgCatPlannedSpend>
{

}
