/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus
 * PurgCatTranslationStatus}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.field.PurgCatTranslationStatusField
 * PurgCatTranslationStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.link.PurgCatTranslationStatusLink
 * PurgCatTranslationStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus#PURG_CAT_TRANSLATION_UUID
 * PURG_CAT_TRANSLATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus#PURG_CAT_UUID
 * PURG_CAT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus#PURG_CAT_TRANSLATION_TGT_LANG
 * PURG_CAT_TRANSLATION_TGT_LANG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingcategory.PurgCatTranslationStatus#PURG_CAT_TRANSLATION_TGT_LANG_STS
 * PURG_CAT_TRANSLATION_TGT_LANG_STS}</li>
 * </ul>
 *
 */
public interface PurgCatTranslationStatusSelectable extends EntitySelectable<PurgCatTranslationStatus>
{

}
