/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.field.PurInfoRecdPrcgCndnScaleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.selectable.PurInfoRecdPrcgCndnScaleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Pricing Condition Scales
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurInfoRecdPrcgCndnScaleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurInfoRecdPrcgCndnScale extends VdmEntity<PurInfoRecdPrcgCndnScale>
{

    /**
     * Selector for all available fields of PurInfoRecdPrcgCndnScale.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<String> CONDITION_RECORD =
        new PurInfoRecdPrcgCndnScaleField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential number of the condition
     */
    @Key
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<String> CONDITION_SEQUENTIAL_NUMBER =
        new PurInfoRecdPrcgCndnScaleField<String>("ConditionSequentialNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     *
     * @return Current number of the line scale
     */
    @Key
    @SerializedName( "ConditionScaleLine" )
    @JsonProperty( "ConditionScaleLine" )
    @Nullable
    @ODataField( odataName = "ConditionScaleLine" )
    private String conditionScaleLine;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleLine</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<String> CONDITION_SCALE_LINE =
        new PurInfoRecdPrcgCndnScaleField<String>("ConditionScaleLine");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @return Condition Scale Quantity
     */
    @SerializedName( "ConditionScaleQuantity" )
    @JsonProperty( "ConditionScaleQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantity" )
    private BigDecimal conditionScaleQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantity</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<BigDecimal> CONDITION_SCALE_QUANTITY =
        new PurInfoRecdPrcgCndnScaleField<BigDecimal>("ConditionScaleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleQuantityUnit" )
    @JsonProperty( "ConditionScaleQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantityUnit" )
    private String conditionScaleQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantityUnit</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<String> CONDITION_SCALE_QUANTITY_UNIT =
        new PurInfoRecdPrcgCndnScaleField<String>("ConditionScaleQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @return Scale Value
     */
    @SerializedName( "ConditionScaleAmount" )
    @JsonProperty( "ConditionScaleAmount" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmount" )
    private BigDecimal conditionScaleAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmount</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<BigDecimal> CONDITION_SCALE_AMOUNT =
        new PurInfoRecdPrcgCndnScaleField<BigDecimal>("ConditionScaleAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleAmountCurrency" )
    @JsonProperty( "ConditionScaleAmountCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmountCurrency" )
    private String conditionScaleAmountCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmountCurrency</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<String> CONDITION_SCALE_AMOUNT_CURRENCY =
        new PurInfoRecdPrcgCndnScaleField<String>("ConditionScaleAmountCurrency");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<BigDecimal> CONDITION_RATE_VALUE =
        new PurInfoRecdPrcgCndnScaleField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionRateValueUnit" )
    @JsonProperty( "ConditionRateValueUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateValueUnit" )
    private String conditionRateValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValueUnit</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<String> CONDITION_RATE_VALUE_UNIT =
        new PurInfoRecdPrcgCndnScaleField<String>("ConditionRateValueUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "ConditionRateRatioUnit" )
    @JsonProperty( "ConditionRateRatioUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatioUnit" )
    private String conditionRateRatioUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatioUnit</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<String> CONDITION_RATE_RATIO_UNIT =
        new PurInfoRecdPrcgCndnScaleField<String>("ConditionRateRatioUnit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @return Condition Ratio (in Percent or Per Mille)
     */
    @SerializedName( "ConditionRateRatio" )
    @JsonProperty( "ConditionRateRatio" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatio" )
    private BigDecimal conditionRateRatio;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatio</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<BigDecimal> CONDITION_RATE_RATIO =
        new PurInfoRecdPrcgCndnScaleField<BigDecimal>("ConditionRateRatio");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<String> CONDITION_CURRENCY =
        new PurInfoRecdPrcgCndnScaleField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateAmount" )
    @JsonProperty( "ConditionRateAmount" )
    @Nullable
    @ODataField( odataName = "ConditionRateAmount" )
    private BigDecimal conditionRateAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateAmount</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<BigDecimal> CONDITION_RATE_AMOUNT =
        new PurInfoRecdPrcgCndnScaleField<BigDecimal>("ConditionRateAmount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator for Condition Record
     */
    @SerializedName( "ConditionScaleIsDeleted" )
    @JsonProperty( "ConditionScaleIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionScaleIsDeleted" )
    private Boolean conditionScaleIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleIsDeleted</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnScaleField<Boolean> CONDITION_SCALE_IS_DELETED =
        new PurInfoRecdPrcgCndnScaleField<Boolean>("ConditionScaleIsDeleted");

    @Nonnull
    @Override
    public Class<PurInfoRecdPrcgCndnScale> getType()
    {
        return PurInfoRecdPrcgCndnScale.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     *
     * @param conditionScaleLine
     *            Current number of the line scale
     */
    public void setConditionScaleLine( @Nullable final String conditionScaleLine )
    {
        rememberChangedField("ConditionScaleLine", this.conditionScaleLine);
        this.conditionScaleLine = conditionScaleLine;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @param conditionScaleQuantity
     *            Condition Scale Quantity
     */
    public void setConditionScaleQuantity( @Nullable final BigDecimal conditionScaleQuantity )
    {
        rememberChangedField("ConditionScaleQuantity", this.conditionScaleQuantity);
        this.conditionScaleQuantity = conditionScaleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @param conditionScaleQuantityUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleQuantityUnit( @Nullable final String conditionScaleQuantityUnit )
    {
        rememberChangedField("ConditionScaleQuantityUnit", this.conditionScaleQuantityUnit);
        this.conditionScaleQuantityUnit = conditionScaleQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @param conditionScaleAmount
     *            Scale Value
     */
    public void setConditionScaleAmount( @Nullable final BigDecimal conditionScaleAmount )
    {
        rememberChangedField("ConditionScaleAmount", this.conditionScaleAmount);
        this.conditionScaleAmount = conditionScaleAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @param conditionScaleAmountCurrency
     *            Scale Currency
     */
    public void setConditionScaleAmountCurrency( @Nullable final String conditionScaleAmountCurrency )
    {
        rememberChangedField("ConditionScaleAmountCurrency", this.conditionScaleAmountCurrency);
        this.conditionScaleAmountCurrency = conditionScaleAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Amount or Percentage
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @param conditionRateValueUnit
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionRateValueUnit( @Nullable final String conditionRateValueUnit )
    {
        rememberChangedField("ConditionRateValueUnit", this.conditionRateValueUnit);
        this.conditionRateValueUnit = conditionRateValueUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     *
     * @param conditionRateRatioUnit
     *            Unit of Measure
     */
    public void setConditionRateRatioUnit( @Nullable final String conditionRateRatioUnit )
    {
        rememberChangedField("ConditionRateRatioUnit", this.conditionRateRatioUnit);
        this.conditionRateRatioUnit = conditionRateRatioUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @param conditionRateRatio
     *            Condition Ratio (in Percent or Per Mille)
     */
    public void setConditionRateRatio( @Nullable final BigDecimal conditionRateRatio )
    {
        rememberChangedField("ConditionRateRatio", this.conditionRateRatio);
        this.conditionRateRatio = conditionRateRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     *
     * @param conditionRateAmount
     *            Condition Amount or Percentage
     */
    public void setConditionRateAmount( @Nullable final BigDecimal conditionRateAmount )
    {
        rememberChangedField("ConditionRateAmount", this.conditionRateAmount);
        this.conditionRateAmount = conditionRateAmount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleIsDeleted</b>
     * </p>
     *
     * @param conditionScaleIsDeleted
     *            Deletion Indicator for Condition Record
     */
    public void setConditionScaleIsDeleted( @Nullable final Boolean conditionScaleIsDeleted )
    {
        rememberChangedField("ConditionScaleIsDeleted", this.conditionScaleIsDeleted);
        this.conditionScaleIsDeleted = conditionScaleIsDeleted;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurInfoRecdPrcgCndnScale";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionSequentialNumber", getConditionSequentialNumber());
        result.put("ConditionScaleLine", getConditionScaleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("ConditionScaleLine", getConditionScaleLine());
        values.put("ConditionScaleQuantity", getConditionScaleQuantity());
        values.put("ConditionScaleQuantityUnit", getConditionScaleQuantityUnit());
        values.put("ConditionScaleAmount", getConditionScaleAmount());
        values.put("ConditionScaleAmountCurrency", getConditionScaleAmountCurrency());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionRateValueUnit", getConditionRateValueUnit());
        values.put("ConditionRateRatioUnit", getConditionRateRatioUnit());
        values.put("ConditionRateRatio", getConditionRateRatio());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionRateAmount", getConditionRateAmount());
        values.put("ConditionScaleIsDeleted", getConditionScaleIsDeleted());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleLine") ) {
                final Object value = values.remove("ConditionScaleLine");
                if( (value == null) || (!value.equals(getConditionScaleLine())) ) {
                    setConditionScaleLine(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantity") ) {
                final Object value = values.remove("ConditionScaleQuantity");
                if( (value == null) || (!value.equals(getConditionScaleQuantity())) ) {
                    setConditionScaleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantityUnit") ) {
                final Object value = values.remove("ConditionScaleQuantityUnit");
                if( (value == null) || (!value.equals(getConditionScaleQuantityUnit())) ) {
                    setConditionScaleQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleAmount") ) {
                final Object value = values.remove("ConditionScaleAmount");
                if( (value == null) || (!value.equals(getConditionScaleAmount())) ) {
                    setConditionScaleAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleAmountCurrency") ) {
                final Object value = values.remove("ConditionScaleAmountCurrency");
                if( (value == null) || (!value.equals(getConditionScaleAmountCurrency())) ) {
                    setConditionScaleAmountCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateValueUnit") ) {
                final Object value = values.remove("ConditionRateValueUnit");
                if( (value == null) || (!value.equals(getConditionRateValueUnit())) ) {
                    setConditionRateValueUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnit") ) {
                final Object value = values.remove("ConditionRateRatioUnit");
                if( (value == null) || (!value.equals(getConditionRateRatioUnit())) ) {
                    setConditionRateRatioUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateRatio") ) {
                final Object value = values.remove("ConditionRateRatio");
                if( (value == null) || (!value.equals(getConditionRateRatio())) ) {
                    setConditionRateRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionRateAmount") ) {
                final Object value = values.remove("ConditionRateAmount");
                if( (value == null) || (!value.equals(getConditionRateAmount())) ) {
                    setConditionRateAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleIsDeleted") ) {
                final Object value = values.remove("ConditionScaleIsDeleted");
                if( (value == null) || (!value.equals(getConditionScaleIsDeleted())) ) {
                    setConditionScaleIsDeleted(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurInfoRecdPrcgCndnScaleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurInfoRecdPrcgCndnScaleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurInfoRecdPrcgCndnScaleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurInfoRecdPrcgCndnScaleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService.DEFAULT_SERVICE_PATH);
    }

}
