/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.field.PurInfoRecdPrcgCndnValidityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.link.PurInfoRecdPrcgCndnValidityOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.selectable.PurInfoRecdPrcgCndnValiditySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Pricing Condition Validity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurInfoRecdPrcgCndnValidityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurInfoRecdPrcgCndnValidity extends VdmEntity<PurInfoRecdPrcgCndnValidity>
{

    /**
     * Selector for all available fields of PurInfoRecdPrcgCndnValidity.
     *
     */
    public final static PurInfoRecdPrcgCndnValiditySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> CONDITION_RECORD =
        new PurInfoRecdPrcgCndnValidityField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return Validity end date of the condition record
     */
    @Key
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new PurInfoRecdPrcgCndnValidityField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @return Validity start date of the condition record
     */
    @SerializedName( "ConditionValidityStartDate" )
    @JsonProperty( "ConditionValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityStartDate</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<LocalDateTime> CONDITION_VALIDITY_START_DATE =
        new PurInfoRecdPrcgCndnValidityField<LocalDateTime>("ConditionValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> CONDITION_APPLICATION =
        new PurInfoRecdPrcgCndnValidityField<String>("ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> CONDITION_TYPE =
        new PurInfoRecdPrcgCndnValidityField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurgDocOrderQuantityUnit" )
    @JsonProperty( "PurgDocOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurgDocOrderQuantityUnit" )
    private String purgDocOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> PURG_DOC_ORDER_QUANTITY_UNIT =
        new PurInfoRecdPrcgCndnValidityField<String>("PurgDocOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> PURCHASING_ORGANIZATION =
        new PurInfoRecdPrcgCndnValidityField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordCategory</b>
     * </p>
     *
     * @return Purchasing info record category
     */
    @SerializedName( "PurchasingInfoRecordCategory" )
    @JsonProperty( "PurchasingInfoRecordCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecordCategory" )
    private String purchasingInfoRecordCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecordCategory</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> PURCHASING_INFO_RECORD_CATEGORY =
        new PurInfoRecdPrcgCndnValidityField<String>("PurchasingInfoRecordCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> PURCHASING_INFO_RECORD =
        new PurInfoRecdPrcgCndnValidityField<String>("PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> SUPPLIER =
        new PurInfoRecdPrcgCndnValidityField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> MATERIAL_GROUP =
        new PurInfoRecdPrcgCndnValidityField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> MATERIAL =
        new PurInfoRecdPrcgCndnValidityField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityField<String> PLANT =
        new PurInfoRecdPrcgCndnValidityField<String>("Plant");
    /**
     * Navigation property <b>to_PurgInfoRecd</b> for <b>PurInfoRecdPrcgCndnValidity</b> to single
     * <b>PurchasingInfoRecord</b>.
     *
     */
    @SerializedName( "to_PurgInfoRecd" )
    @JsonProperty( "to_PurgInfoRecd" )
    @ODataField( odataName = "to_PurgInfoRecd" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurchasingInfoRecord toPurgInfoRecd;
    /**
     * Navigation property <b>to_PurgInfoRecdOrgPlantData</b> for <b>PurInfoRecdPrcgCndnValidity</b> to single
     * <b>PurgInfoRecdOrgPlantData</b>.
     *
     */
    @SerializedName( "to_PurgInfoRecdOrgPlantData" )
    @JsonProperty( "to_PurgInfoRecdOrgPlantData" )
    @ODataField( odataName = "to_PurgInfoRecdOrgPlantData" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurgInfoRecdOrgPlantData toPurgInfoRecdOrgPlantData;
    /**
     * Navigation property <b>to_PurInfoRecdPrcgCndn</b> for <b>PurInfoRecdPrcgCndnValidity</b> to single
     * <b>PurInfoRecdPrcgCndn</b>.
     *
     */
    @SerializedName( "to_PurInfoRecdPrcgCndn" )
    @JsonProperty( "to_PurInfoRecdPrcgCndn" )
    @ODataField( odataName = "to_PurInfoRecdPrcgCndn" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurInfoRecdPrcgCndn toPurInfoRecdPrcgCndn;
    /**
     * Use with available fluent helpers to apply the <b>to_PurgInfoRecd</b> navigation property to query operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityOneToOneLink<PurchasingInfoRecord> TO_PURG_INFO_RECD =
        new PurInfoRecdPrcgCndnValidityOneToOneLink<PurchasingInfoRecord>("to_PurgInfoRecd");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgInfoRecdOrgPlantData</b> navigation property to query
     * operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityOneToOneLink<PurgInfoRecdOrgPlantData> TO_PURG_INFO_RECD_ORG_PLANT_DATA =
        new PurInfoRecdPrcgCndnValidityOneToOneLink<PurgInfoRecdOrgPlantData>("to_PurgInfoRecdOrgPlantData");
    /**
     * Use with available fluent helpers to apply the <b>to_PurInfoRecdPrcgCndn</b> navigation property to query
     * operations.
     *
     */
    public final static PurInfoRecdPrcgCndnValidityOneToOneLink<PurInfoRecdPrcgCndn> TO_PUR_INFO_RECD_PRCG_CNDN =
        new PurInfoRecdPrcgCndnValidityOneToOneLink<PurInfoRecdPrcgCndn>("to_PurInfoRecdPrcgCndn");

    @Nonnull
    @Override
    public Class<PurInfoRecdPrcgCndnValidity> getType()
    {
        return PurInfoRecdPrcgCndnValidity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @param conditionValidityStartDate
     *            Validity start date of the condition record
     */
    public void setConditionValidityStartDate( @Nullable final LocalDateTime conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderQuantityUnit</b>
     * </p>
     *
     * @param purgDocOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurgDocOrderQuantityUnit( @Nullable final String purgDocOrderQuantityUnit )
    {
        rememberChangedField("PurgDocOrderQuantityUnit", this.purgDocOrderQuantityUnit);
        this.purgDocOrderQuantityUnit = purgDocOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordCategory</b>
     * </p>
     *
     * @param purchasingInfoRecordCategory
     *            Purchasing info record category
     */
    public void setPurchasingInfoRecordCategory( @Nullable final String purchasingInfoRecordCategory )
    {
        rememberChangedField("PurchasingInfoRecordCategory", this.purchasingInfoRecordCategory);
        this.purchasingInfoRecordCategory = purchasingInfoRecordCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurInfoRecdPrcgCndnValidity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionValidityEndDate", getConditionValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("PurgDocOrderQuantityUnit", getPurgDocOrderQuantityUnit());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingInfoRecordCategory", getPurchasingInfoRecordCategory());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("Supplier", getSupplier());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("PurgDocOrderQuantityUnit") ) {
                final Object value = values.remove("PurgDocOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurgDocOrderQuantityUnit())) ) {
                    setPurgDocOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecordCategory") ) {
                final Object value = values.remove("PurchasingInfoRecordCategory");
                if( (value == null) || (!value.equals(getPurchasingInfoRecordCategory())) ) {
                    setPurchasingInfoRecordCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurgInfoRecd") ) {
                final Object value = (values).remove("to_PurgInfoRecd");
                if( value instanceof Map ) {
                    if( toPurgInfoRecd == null ) {
                        toPurgInfoRecd = new PurchasingInfoRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgInfoRecd.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurgInfoRecdOrgPlantData") ) {
                final Object value = (values).remove("to_PurgInfoRecdOrgPlantData");
                if( value instanceof Map ) {
                    if( toPurgInfoRecdOrgPlantData == null ) {
                        toPurgInfoRecdOrgPlantData = new PurgInfoRecdOrgPlantData();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgInfoRecdOrgPlantData.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurInfoRecdPrcgCndn") ) {
                final Object value = (values).remove("to_PurInfoRecdPrcgCndn");
                if( value instanceof Map ) {
                    if( toPurInfoRecdPrcgCndn == null ) {
                        toPurInfoRecdPrcgCndn = new PurInfoRecdPrcgCndn();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurInfoRecdPrcgCndn.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PurInfoRecdPrcgCndnValidityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new PurInfoRecdPrcgCndnValidityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurInfoRecdPrcgCndnValidityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurInfoRecdPrcgCndnValidityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurgInfoRecd != null ) {
            (values).put("to_PurgInfoRecd", toPurgInfoRecd);
        }
        if( toPurgInfoRecdOrgPlantData != null ) {
            (values).put("to_PurgInfoRecdOrgPlantData", toPurgInfoRecdOrgPlantData);
        }
        if( toPurInfoRecdPrcgCndn != null ) {
            (values).put("to_PurInfoRecdPrcgCndn", toPurInfoRecdPrcgCndn);
        }
        return values;
    }

    /**
     * Fetches the <b>PurchasingInfoRecord</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurgInfoRecd</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurchasingInfoRecord</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchasingInfoRecord fetchPurgInfoRecd()
    {
        return fetchFieldAsSingle("to_PurgInfoRecd", PurchasingInfoRecord.class);
    }

    /**
     * Retrieval of associated <b>PurchasingInfoRecord</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurgInfoRecd</b>.
     * <p>
     * If the navigation property <b>to_PurgInfoRecd</b> of a queried <b>PurInfoRecdPrcgCndnValidity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchasingInfoRecord</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchasingInfoRecord getPurgInfoRecdOrFetch()
    {
        if( toPurgInfoRecd == null ) {
            toPurgInfoRecd = fetchPurgInfoRecd();
        }
        return toPurgInfoRecd;
    }

    /**
     * Retrieval of associated <b>PurchasingInfoRecord</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurgInfoRecd</b>.
     * <p>
     * If the navigation property for an entity <b>PurInfoRecdPrcgCndnValidity</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgInfoRecd</b> is already loaded, the result will
     *         contain the <b>PurchasingInfoRecord</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurchasingInfoRecord> getPurgInfoRecdIfPresent()
    {
        return Option.of(toPurgInfoRecd);
    }

    /**
     * Overwrites the associated <b>PurchasingInfoRecord</b> entity for the loaded navigation property
     * <b>to_PurgInfoRecd</b>.
     *
     * @param value
     *            New <b>PurchasingInfoRecord</b> entity.
     */
    public void setPurgInfoRecd( final PurchasingInfoRecord value )
    {
        toPurgInfoRecd = value;
    }

    /**
     * Fetches the <b>PurgInfoRecdOrgPlantData</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurgInfoRecdOrgPlantData</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurgInfoRecdOrgPlantData</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgInfoRecdOrgPlantData fetchPurgInfoRecdOrgPlantData()
    {
        return fetchFieldAsSingle("to_PurgInfoRecdOrgPlantData", PurgInfoRecdOrgPlantData.class);
    }

    /**
     * Retrieval of associated <b>PurgInfoRecdOrgPlantData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgInfoRecdOrgPlantData</b>.
     * <p>
     * If the navigation property <b>to_PurgInfoRecdOrgPlantData</b> of a queried <b>PurInfoRecdPrcgCndnValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgInfoRecdOrgPlantData</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgInfoRecdOrgPlantData getPurgInfoRecdOrgPlantDataOrFetch()
    {
        if( toPurgInfoRecdOrgPlantData == null ) {
            toPurgInfoRecdOrgPlantData = fetchPurgInfoRecdOrgPlantData();
        }
        return toPurgInfoRecdOrgPlantData;
    }

    /**
     * Retrieval of associated <b>PurgInfoRecdOrgPlantData</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgInfoRecdOrgPlantData</b>.
     * <p>
     * If the navigation property for an entity <b>PurInfoRecdPrcgCndnValidity</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgInfoRecdOrgPlantData</b> is already loaded, the
     *         result will contain the <b>PurgInfoRecdOrgPlantData</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurgInfoRecdOrgPlantData> getPurgInfoRecdOrgPlantDataIfPresent()
    {
        return Option.of(toPurgInfoRecdOrgPlantData);
    }

    /**
     * Overwrites the associated <b>PurgInfoRecdOrgPlantData</b> entity for the loaded navigation property
     * <b>to_PurgInfoRecdOrgPlantData</b>.
     *
     * @param value
     *            New <b>PurgInfoRecdOrgPlantData</b> entity.
     */
    public void setPurgInfoRecdOrgPlantData( final PurgInfoRecdOrgPlantData value )
    {
        toPurgInfoRecdOrgPlantData = value;
    }

    /**
     * Fetches the <b>PurInfoRecdPrcgCndn</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurInfoRecdPrcgCndn</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurInfoRecdPrcgCndn</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurInfoRecdPrcgCndn fetchPurInfoRecdPrcgCndn()
    {
        return fetchFieldAsSingle("to_PurInfoRecdPrcgCndn", PurInfoRecdPrcgCndn.class);
    }

    /**
     * Retrieval of associated <b>PurInfoRecdPrcgCndn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurInfoRecdPrcgCndn</b>.
     * <p>
     * If the navigation property <b>to_PurInfoRecdPrcgCndn</b> of a queried <b>PurInfoRecdPrcgCndnValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurInfoRecdPrcgCndn</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurInfoRecdPrcgCndn getPurInfoRecdPrcgCndnOrFetch()
    {
        if( toPurInfoRecdPrcgCndn == null ) {
            toPurInfoRecdPrcgCndn = fetchPurInfoRecdPrcgCndn();
        }
        return toPurInfoRecdPrcgCndn;
    }

    /**
     * Retrieval of associated <b>PurInfoRecdPrcgCndn</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurInfoRecdPrcgCndn</b>.
     * <p>
     * If the navigation property for an entity <b>PurInfoRecdPrcgCndnValidity</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurInfoRecdPrcgCndn</b> is already loaded, the result
     *         will contain the <b>PurInfoRecdPrcgCndn</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurInfoRecdPrcgCndn> getPurInfoRecdPrcgCndnIfPresent()
    {
        return Option.of(toPurInfoRecdPrcgCndn);
    }

    /**
     * Overwrites the associated <b>PurInfoRecdPrcgCndn</b> entity for the loaded navigation property
     * <b>to_PurInfoRecdPrcgCndn</b>.
     *
     * @param value
     *            New <b>PurInfoRecdPrcgCndn</b> entity.
     */
    public void setPurInfoRecdPrcgCndn( final PurInfoRecdPrcgCndn value )
    {
        toPurInfoRecdPrcgCndn = value;
    }

    /**
     * Helper class to allow for fluent creation of PurInfoRecdPrcgCndnValidity instances.
     *
     */
    public final static class PurInfoRecdPrcgCndnValidityBuilder
    {

        private PurchasingInfoRecord toPurgInfoRecd;
        private PurgInfoRecdOrgPlantData toPurgInfoRecdOrgPlantData;
        private PurInfoRecdPrcgCndn toPurInfoRecdPrcgCndn;

        private PurInfoRecdPrcgCndnValidity.PurInfoRecdPrcgCndnValidityBuilder toPurgInfoRecd(
            final PurchasingInfoRecord value )
        {
            toPurgInfoRecd = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgInfoRecd</b> for <b>PurInfoRecdPrcgCndnValidity</b> to single
         * <b>PurchasingInfoRecord</b>.
         *
         * @param value
         *            The PurchasingInfoRecord to build this PurInfoRecdPrcgCndnValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurInfoRecdPrcgCndnValidity.PurInfoRecdPrcgCndnValidityBuilder purgInfoRecd(
            final PurchasingInfoRecord value )
        {
            return toPurgInfoRecd(value);
        }

        private PurInfoRecdPrcgCndnValidity.PurInfoRecdPrcgCndnValidityBuilder toPurgInfoRecdOrgPlantData(
            final PurgInfoRecdOrgPlantData value )
        {
            toPurgInfoRecdOrgPlantData = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgInfoRecdOrgPlantData</b> for <b>PurInfoRecdPrcgCndnValidity</b> to single
         * <b>PurgInfoRecdOrgPlantData</b>.
         *
         * @param value
         *            The PurgInfoRecdOrgPlantData to build this PurInfoRecdPrcgCndnValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurInfoRecdPrcgCndnValidity.PurInfoRecdPrcgCndnValidityBuilder purgInfoRecdOrgPlantData(
            final PurgInfoRecdOrgPlantData value )
        {
            return toPurgInfoRecdOrgPlantData(value);
        }

        private PurInfoRecdPrcgCndnValidity.PurInfoRecdPrcgCndnValidityBuilder toPurInfoRecdPrcgCndn(
            final PurInfoRecdPrcgCndn value )
        {
            toPurInfoRecdPrcgCndn = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurInfoRecdPrcgCndn</b> for <b>PurInfoRecdPrcgCndnValidity</b> to single
         * <b>PurInfoRecdPrcgCndn</b>.
         *
         * @param value
         *            The PurInfoRecdPrcgCndn to build this PurInfoRecdPrcgCndnValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurInfoRecdPrcgCndnValidity.PurInfoRecdPrcgCndnValidityBuilder purInfoRecdPrcgCndn(
            final PurInfoRecdPrcgCndn value )
        {
            return toPurInfoRecdPrcgCndn(value);
        }

    }

}
