/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.field.PurchasingInfoRecordField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.link.PurchasingInfoRecordLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.selectable.PurchasingInfoRecordSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Purchasing Info Record
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchasingInfoRecordType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchasingInfoRecord extends VdmEntity<PurchasingInfoRecord>
{

    /**
     * Selector for all available fields of PurchasingInfoRecord.
     *
     */
    public final static PurchasingInfoRecordSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @Key
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> PURCHASING_INFO_RECORD =
        new PurchasingInfoRecordField<String>("PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> SUPPLIER = new PurchasingInfoRecordField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> MATERIAL = new PurchasingInfoRecordField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> MATERIAL_GROUP =
        new PurchasingInfoRecordField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<LocalDateTime> CREATION_DATE =
        new PurchasingInfoRecordField<LocalDateTime>("CreationDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Purchasing info: General data flagged for deletion
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<Boolean> IS_DELETED =
        new PurchasingInfoRecordField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordDesc</b>
     * </p>
     *
     * @return Short Text for Purchasing Info Record
     */
    @SerializedName( "PurchasingInfoRecordDesc" )
    @JsonProperty( "PurchasingInfoRecordDesc" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecordDesc" )
    private String purchasingInfoRecordDesc;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecordDesc</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> PURCHASING_INFO_RECORD_DESC =
        new PurchasingInfoRecordField<String>("PurchasingInfoRecordDesc");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurgInfoRecNonStockItmSortTerm</b>
     * </p>
     *
     * @return Sort Term for Non-Stock Info Records
     */
    @SerializedName( "PurgInfoRecNonStockItmSortTerm" )
    @JsonProperty( "PurgInfoRecNonStockItmSortTerm" )
    @Nullable
    @ODataField( odataName = "PurgInfoRecNonStockItmSortTerm" )
    private String purgInfoRecNonStockItmSortTerm;
    /**
     * Use with available fluent helpers to apply the <b>PurgInfoRecNonStockItmSortTerm</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> PURG_INFO_REC_NON_STOCK_ITM_SORT_TERM =
        new PurchasingInfoRecordField<String>("PurgInfoRecNonStockItmSortTerm");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurgDocOrderQuantityUnit" )
    @JsonProperty( "PurgDocOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurgDocOrderQuantityUnit" )
    private String purgDocOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> PURG_DOC_ORDER_QUANTITY_UNIT =
        new PurchasingInfoRecordField<String>("PurgDocOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @return Numerator for Conversion of Order Unit to Base Unit
     */
    @SerializedName( "OrderItemQtyToBaseQtyNmrtr" )
    @JsonProperty( "OrderItemQtyToBaseQtyNmrtr" )
    @Nullable
    @ODataField( odataName = "OrderItemQtyToBaseQtyNmrtr" )
    private BigDecimal orderItemQtyToBaseQtyNmrtr;
    /**
     * Use with available fluent helpers to apply the <b>OrderItemQtyToBaseQtyNmrtr</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<BigDecimal> ORDER_ITEM_QTY_TO_BASE_QTY_NMRTR =
        new PurchasingInfoRecordField<BigDecimal>("OrderItemQtyToBaseQtyNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @return Denominator for Conversion of Order Unit to Base Unit
     */
    @SerializedName( "OrderItemQtyToBaseQtyDnmntr" )
    @JsonProperty( "OrderItemQtyToBaseQtyDnmntr" )
    @Nullable
    @ODataField( odataName = "OrderItemQtyToBaseQtyDnmntr" )
    private BigDecimal orderItemQtyToBaseQtyDnmntr;
    /**
     * Use with available fluent helpers to apply the <b>OrderItemQtyToBaseQtyDnmntr</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<BigDecimal> ORDER_ITEM_QTY_TO_BASE_QTY_DNMNTR =
        new PurchasingInfoRecordField<BigDecimal>("OrderItemQtyToBaseQtyDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @return Material Number Used by Supplier
     */
    @SerializedName( "SupplierMaterialNumber" )
    @JsonProperty( "SupplierMaterialNumber" )
    @Nullable
    @ODataField( odataName = "SupplierMaterialNumber" )
    private String supplierMaterialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierMaterialNumber</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> SUPPLIER_MATERIAL_NUMBER =
        new PurchasingInfoRecordField<String>("SupplierMaterialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @return Salesperson Responsible in the Event of Queries
     */
    @SerializedName( "SupplierRespSalesPersonName" )
    @JsonProperty( "SupplierRespSalesPersonName" )
    @Nullable
    @ODataField( odataName = "SupplierRespSalesPersonName" )
    private String supplierRespSalesPersonName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierRespSalesPersonName</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> SUPPLIER_RESP_SALES_PERSON_NAME =
        new PurchasingInfoRecordField<String>("SupplierRespSalesPersonName");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @return Supplier's Telephone Number
     */
    @SerializedName( "SupplierPhoneNumber" )
    @JsonProperty( "SupplierPhoneNumber" )
    @Nullable
    @ODataField( odataName = "SupplierPhoneNumber" )
    private String supplierPhoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierPhoneNumber</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> SUPPLIER_PHONE_NUMBER =
        new PurchasingInfoRecordField<String>("SupplierPhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> BASE_UNIT = new PurchasingInfoRecordField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialGroup</b>
     * </p>
     *
     * @return Supplier Material Group
     */
    @SerializedName( "SupplierMaterialGroup" )
    @JsonProperty( "SupplierMaterialGroup" )
    @Nullable
    @ODataField( odataName = "SupplierMaterialGroup" )
    private String supplierMaterialGroup;
    /**
     * Use with available fluent helpers to apply the <b>SupplierMaterialGroup</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> SUPPLIER_MATERIAL_GROUP =
        new PurchasingInfoRecordField<String>("SupplierMaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PriorSupplier</b>
     * </p>
     *
     * @return Prior Supplier
     */
    @SerializedName( "PriorSupplier" )
    @JsonProperty( "PriorSupplier" )
    @Nullable
    @ODataField( odataName = "PriorSupplier" )
    private String priorSupplier;
    /**
     * Use with available fluent helpers to apply the <b>PriorSupplier</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> PRIOR_SUPPLIER =
        new PurchasingInfoRecordField<String>("PriorSupplier");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityStartDate</b>
     * </p>
     *
     * @return Available (Deliverable) From
     */
    @SerializedName( "AvailabilityStartDate" )
    @JsonProperty( "AvailabilityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "AvailabilityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime availabilityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityStartDate</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<LocalDateTime> AVAILABILITY_START_DATE =
        new PurchasingInfoRecordField<LocalDateTime>("AvailabilityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityEndDate</b>
     * </p>
     *
     * @return Available (Deliverable) Until
     */
    @SerializedName( "AvailabilityEndDate" )
    @JsonProperty( "AvailabilityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "AvailabilityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime availabilityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityEndDate</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<LocalDateTime> AVAILABILITY_END_DATE =
        new PurchasingInfoRecordField<LocalDateTime>("AvailabilityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VarblPurOrdUnitIsActive</b>
     * </p>
     *
     * @return Variable Purchase Order Unit Active
     */
    @SerializedName( "VarblPurOrdUnitIsActive" )
    @JsonProperty( "VarblPurOrdUnitIsActive" )
    @Nullable
    @ODataField( odataName = "VarblPurOrdUnitIsActive" )
    private String varblPurOrdUnitIsActive;
    /**
     * Use with available fluent helpers to apply the <b>VarblPurOrdUnitIsActive</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> VARBL_PUR_ORD_UNIT_IS_ACTIVE =
        new PurchasingInfoRecordField<String>("VarblPurOrdUnitIsActive");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     *
     * @return Manufacturer
     */
    @SerializedName( "Manufacturer" )
    @JsonProperty( "Manufacturer" )
    @Nullable
    @ODataField( odataName = "Manufacturer" )
    private String manufacturer;
    /**
     * Use with available fluent helpers to apply the <b>Manufacturer</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> MANUFACTURER =
        new PurchasingInfoRecordField<String>("Manufacturer");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRegularSupplier</b>
     * </p>
     *
     * @return Regular Supplier
     */
    @SerializedName( "IsRegularSupplier" )
    @JsonProperty( "IsRegularSupplier" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsRegularSupplier" )
    private Boolean isRegularSupplier;
    /**
     * Use with available fluent helpers to apply the <b>IsRegularSupplier</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<Boolean> IS_REGULAR_SUPPLIER =
        new PurchasingInfoRecordField<Boolean>("IsRegularSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     *
     * @return Supplier Subrange
     */
    @SerializedName( "SupplierSubrange" )
    @JsonProperty( "SupplierSubrange" )
    @Nullable
    @ODataField( odataName = "SupplierSubrange" )
    private String supplierSubrange;
    /**
     * Use with available fluent helpers to apply the <b>SupplierSubrange</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> SUPPLIER_SUBRANGE =
        new PurchasingInfoRecordField<String>("SupplierSubrange");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder1</b>
     * </p>
     *
     * @return Number of Days for First Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder1" )
    @JsonProperty( "NoDaysReminder1" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder1" )
    private BigDecimal noDaysReminder1;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder1</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<BigDecimal> NO_DAYS_REMINDER1 =
        new PurchasingInfoRecordField<BigDecimal>("NoDaysReminder1");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder2</b>
     * </p>
     *
     * @return Number of Days for Second Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder2" )
    @JsonProperty( "NoDaysReminder2" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder2" )
    private BigDecimal noDaysReminder2;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder2</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<BigDecimal> NO_DAYS_REMINDER2 =
        new PurchasingInfoRecordField<BigDecimal>("NoDaysReminder2");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder3</b>
     * </p>
     *
     * @return Number of Days for Third Reminder/Expediter
     */
    @SerializedName( "NoDaysReminder3" )
    @JsonProperty( "NoDaysReminder3" )
    @Nullable
    @ODataField( odataName = "NoDaysReminder3" )
    private BigDecimal noDaysReminder3;
    /**
     * Use with available fluent helpers to apply the <b>NoDaysReminder3</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<BigDecimal> NO_DAYS_REMINDER3 =
        new PurchasingInfoRecordField<BigDecimal>("NoDaysReminder3");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductPurchasePointsQty</b>
     * </p>
     *
     * @return Number of Points
     */
    @SerializedName( "ProductPurchasePointsQty" )
    @JsonProperty( "ProductPurchasePointsQty" )
    @Nullable
    @ODataField( odataName = "ProductPurchasePointsQty" )
    private BigDecimal productPurchasePointsQty;
    /**
     * Use with available fluent helpers to apply the <b>ProductPurchasePointsQty</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<BigDecimal> PRODUCT_PURCHASE_POINTS_QTY =
        new PurchasingInfoRecordField<BigDecimal>("ProductPurchasePointsQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductPurchasePointsQtyUnit</b>
     * </p>
     *
     * @return Points Unit
     */
    @SerializedName( "ProductPurchasePointsQtyUnit" )
    @JsonProperty( "ProductPurchasePointsQtyUnit" )
    @Nullable
    @ODataField( odataName = "ProductPurchasePointsQtyUnit" )
    private String productPurchasePointsQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProductPurchasePointsQtyUnit</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> PRODUCT_PURCHASE_POINTS_QTY_UNIT =
        new PurchasingInfoRecordField<String>("ProductPurchasePointsQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrangeSortNumber</b>
     * </p>
     *
     * @return Sort Sequence Number
     */
    @SerializedName( "SupplierSubrangeSortNumber" )
    @JsonProperty( "SupplierSubrangeSortNumber" )
    @Nullable
    @ODataField( odataName = "SupplierSubrangeSortNumber" )
    private String supplierSubrangeSortNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierSubrangeSortNumber</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> SUPPLIER_SUBRANGE_SORT_NUMBER =
        new PurchasingInfoRecordField<String>("SupplierSubrangeSortNumber");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PurchasingInfoRecordField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @return Business Purpose Completed
     */
    @SerializedName( "IsEndOfPurposeBlocked" )
    @JsonProperty( "IsEndOfPurposeBlocked" )
    @Nullable
    @ODataField( odataName = "IsEndOfPurposeBlocked" )
    private String isEndOfPurposeBlocked;
    /**
     * Use with available fluent helpers to apply the <b>IsEndOfPurposeBlocked</b> field to query operations.
     *
     */
    public final static PurchasingInfoRecordField<String> IS_END_OF_PURPOSE_BLOCKED =
        new PurchasingInfoRecordField<String>("IsEndOfPurposeBlocked");
    /**
     * Navigation property <b>to_PurgInfoRecdOrgPlantData</b> for <b>PurchasingInfoRecord</b> to multiple
     * <b>PurgInfoRecdOrgPlantData</b>.
     *
     */
    @SerializedName( "to_PurgInfoRecdOrgPlantData" )
    @JsonProperty( "to_PurgInfoRecdOrgPlantData" )
    @ODataField( odataName = "to_PurgInfoRecdOrgPlantData" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgInfoRecdOrgPlantData> toPurgInfoRecdOrgPlantData;
    /**
     * Use with available fluent helpers to apply the <b>to_PurgInfoRecdOrgPlantData</b> navigation property to query
     * operations.
     *
     */
    public final static PurchasingInfoRecordLink<PurgInfoRecdOrgPlantData> TO_PURG_INFO_RECD_ORG_PLANT_DATA =
        new PurchasingInfoRecordLink<PurgInfoRecdOrgPlantData>("to_PurgInfoRecdOrgPlantData");

    @Nonnull
    @Override
    public Class<PurchasingInfoRecord> getType()
    {
        return PurchasingInfoRecord.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Purchasing info: General data flagged for deletion
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordDesc</b>
     * </p>
     *
     * @param purchasingInfoRecordDesc
     *            Short Text for Purchasing Info Record
     */
    public void setPurchasingInfoRecordDesc( @Nullable final String purchasingInfoRecordDesc )
    {
        rememberChangedField("PurchasingInfoRecordDesc", this.purchasingInfoRecordDesc);
        this.purchasingInfoRecordDesc = purchasingInfoRecordDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurgInfoRecNonStockItmSortTerm</b>
     * </p>
     *
     * @param purgInfoRecNonStockItmSortTerm
     *            Sort Term for Non-Stock Info Records
     */
    public void setPurgInfoRecNonStockItmSortTerm( @Nullable final String purgInfoRecNonStockItmSortTerm )
    {
        rememberChangedField("PurgInfoRecNonStockItmSortTerm", this.purgInfoRecNonStockItmSortTerm);
        this.purgInfoRecNonStockItmSortTerm = purgInfoRecNonStockItmSortTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderQuantityUnit</b>
     * </p>
     *
     * @param purgDocOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurgDocOrderQuantityUnit( @Nullable final String purgDocOrderQuantityUnit )
    {
        rememberChangedField("PurgDocOrderQuantityUnit", this.purgDocOrderQuantityUnit);
        this.purgDocOrderQuantityUnit = purgDocOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyNmrtr</b>
     * </p>
     *
     * @param orderItemQtyToBaseQtyNmrtr
     *            Numerator for Conversion of Order Unit to Base Unit
     */
    public void setOrderItemQtyToBaseQtyNmrtr( @Nullable final BigDecimal orderItemQtyToBaseQtyNmrtr )
    {
        rememberChangedField("OrderItemQtyToBaseQtyNmrtr", this.orderItemQtyToBaseQtyNmrtr);
        this.orderItemQtyToBaseQtyNmrtr = orderItemQtyToBaseQtyNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>OrderItemQtyToBaseQtyDnmntr</b>
     * </p>
     *
     * @param orderItemQtyToBaseQtyDnmntr
     *            Denominator for Conversion of Order Unit to Base Unit
     */
    public void setOrderItemQtyToBaseQtyDnmntr( @Nullable final BigDecimal orderItemQtyToBaseQtyDnmntr )
    {
        rememberChangedField("OrderItemQtyToBaseQtyDnmntr", this.orderItemQtyToBaseQtyDnmntr);
        this.orderItemQtyToBaseQtyDnmntr = orderItemQtyToBaseQtyDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialNumber</b>
     * </p>
     *
     * @param supplierMaterialNumber
     *            Material Number Used by Supplier
     */
    public void setSupplierMaterialNumber( @Nullable final String supplierMaterialNumber )
    {
        rememberChangedField("SupplierMaterialNumber", this.supplierMaterialNumber);
        this.supplierMaterialNumber = supplierMaterialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @param supplierRespSalesPersonName
     *            Salesperson Responsible in the Event of Queries
     */
    public void setSupplierRespSalesPersonName( @Nullable final String supplierRespSalesPersonName )
    {
        rememberChangedField("SupplierRespSalesPersonName", this.supplierRespSalesPersonName);
        this.supplierRespSalesPersonName = supplierRespSalesPersonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @param supplierPhoneNumber
     *            Supplier's Telephone Number
     */
    public void setSupplierPhoneNumber( @Nullable final String supplierPhoneNumber )
    {
        rememberChangedField("SupplierPhoneNumber", this.supplierPhoneNumber);
        this.supplierPhoneNumber = supplierPhoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SupplierMaterialGroup</b>
     * </p>
     *
     * @param supplierMaterialGroup
     *            Supplier Material Group
     */
    public void setSupplierMaterialGroup( @Nullable final String supplierMaterialGroup )
    {
        rememberChangedField("SupplierMaterialGroup", this.supplierMaterialGroup);
        this.supplierMaterialGroup = supplierMaterialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PriorSupplier</b>
     * </p>
     *
     * @param priorSupplier
     *            Prior Supplier
     */
    public void setPriorSupplier( @Nullable final String priorSupplier )
    {
        rememberChangedField("PriorSupplier", this.priorSupplier);
        this.priorSupplier = priorSupplier;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityStartDate</b>
     * </p>
     *
     * @param availabilityStartDate
     *            Available (Deliverable) From
     */
    public void setAvailabilityStartDate( @Nullable final LocalDateTime availabilityStartDate )
    {
        rememberChangedField("AvailabilityStartDate", this.availabilityStartDate);
        this.availabilityStartDate = availabilityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityEndDate</b>
     * </p>
     *
     * @param availabilityEndDate
     *            Available (Deliverable) Until
     */
    public void setAvailabilityEndDate( @Nullable final LocalDateTime availabilityEndDate )
    {
        rememberChangedField("AvailabilityEndDate", this.availabilityEndDate);
        this.availabilityEndDate = availabilityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>VarblPurOrdUnitIsActive</b>
     * </p>
     *
     * @param varblPurOrdUnitIsActive
     *            Variable Purchase Order Unit Active
     */
    public void setVarblPurOrdUnitIsActive( @Nullable final String varblPurOrdUnitIsActive )
    {
        rememberChangedField("VarblPurOrdUnitIsActive", this.varblPurOrdUnitIsActive);
        this.varblPurOrdUnitIsActive = varblPurOrdUnitIsActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     *
     * @param manufacturer
     *            Manufacturer
     */
    public void setManufacturer( @Nullable final String manufacturer )
    {
        rememberChangedField("Manufacturer", this.manufacturer);
        this.manufacturer = manufacturer;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsRegularSupplier</b>
     * </p>
     *
     * @param isRegularSupplier
     *            Regular Supplier
     */
    public void setIsRegularSupplier( @Nullable final Boolean isRegularSupplier )
    {
        rememberChangedField("IsRegularSupplier", this.isRegularSupplier);
        this.isRegularSupplier = isRegularSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     *
     * @param supplierSubrange
     *            Supplier Subrange
     */
    public void setSupplierSubrange( @Nullable final String supplierSubrange )
    {
        rememberChangedField("SupplierSubrange", this.supplierSubrange);
        this.supplierSubrange = supplierSubrange;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder1</b>
     * </p>
     *
     * @param noDaysReminder1
     *            Number of Days for First Reminder/Expediter
     */
    public void setNoDaysReminder1( @Nullable final BigDecimal noDaysReminder1 )
    {
        rememberChangedField("NoDaysReminder1", this.noDaysReminder1);
        this.noDaysReminder1 = noDaysReminder1;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder2</b>
     * </p>
     *
     * @param noDaysReminder2
     *            Number of Days for Second Reminder/Expediter
     */
    public void setNoDaysReminder2( @Nullable final BigDecimal noDaysReminder2 )
    {
        rememberChangedField("NoDaysReminder2", this.noDaysReminder2);
        this.noDaysReminder2 = noDaysReminder2;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoDaysReminder3</b>
     * </p>
     *
     * @param noDaysReminder3
     *            Number of Days for Third Reminder/Expediter
     */
    public void setNoDaysReminder3( @Nullable final BigDecimal noDaysReminder3 )
    {
        rememberChangedField("NoDaysReminder3", this.noDaysReminder3);
        this.noDaysReminder3 = noDaysReminder3;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductPurchasePointsQty</b>
     * </p>
     *
     * @param productPurchasePointsQty
     *            Number of Points
     */
    public void setProductPurchasePointsQty( @Nullable final BigDecimal productPurchasePointsQty )
    {
        rememberChangedField("ProductPurchasePointsQty", this.productPurchasePointsQty);
        this.productPurchasePointsQty = productPurchasePointsQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductPurchasePointsQtyUnit</b>
     * </p>
     *
     * @param productPurchasePointsQtyUnit
     *            Points Unit
     */
    public void setProductPurchasePointsQtyUnit( @Nullable final String productPurchasePointsQtyUnit )
    {
        rememberChangedField("ProductPurchasePointsQtyUnit", this.productPurchasePointsQtyUnit);
        this.productPurchasePointsQtyUnit = productPurchasePointsQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrangeSortNumber</b>
     * </p>
     *
     * @param supplierSubrangeSortNumber
     *            Sort Sequence Number
     */
    public void setSupplierSubrangeSortNumber( @Nullable final String supplierSubrangeSortNumber )
    {
        rememberChangedField("SupplierSubrangeSortNumber", this.supplierSubrangeSortNumber);
        this.supplierSubrangeSortNumber = supplierSubrangeSortNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *            Business Purpose Completed
     */
    public void setIsEndOfPurposeBlocked( @Nullable final String isEndOfPurposeBlocked )
    {
        rememberChangedField("IsEndOfPurposeBlocked", this.isEndOfPurposeBlocked);
        this.isEndOfPurposeBlocked = isEndOfPurposeBlocked;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchasingInfoRecord";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("Supplier", getSupplier());
        values.put("Material", getMaterial());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("CreationDate", getCreationDate());
        values.put("IsDeleted", getIsDeleted());
        values.put("PurchasingInfoRecordDesc", getPurchasingInfoRecordDesc());
        values.put("PurgInfoRecNonStockItmSortTerm", getPurgInfoRecNonStockItmSortTerm());
        values.put("PurgDocOrderQuantityUnit", getPurgDocOrderQuantityUnit());
        values.put("OrderItemQtyToBaseQtyNmrtr", getOrderItemQtyToBaseQtyNmrtr());
        values.put("OrderItemQtyToBaseQtyDnmntr", getOrderItemQtyToBaseQtyDnmntr());
        values.put("SupplierMaterialNumber", getSupplierMaterialNumber());
        values.put("SupplierRespSalesPersonName", getSupplierRespSalesPersonName());
        values.put("SupplierPhoneNumber", getSupplierPhoneNumber());
        values.put("BaseUnit", getBaseUnit());
        values.put("SupplierMaterialGroup", getSupplierMaterialGroup());
        values.put("PriorSupplier", getPriorSupplier());
        values.put("AvailabilityStartDate", getAvailabilityStartDate());
        values.put("AvailabilityEndDate", getAvailabilityEndDate());
        values.put("VarblPurOrdUnitIsActive", getVarblPurOrdUnitIsActive());
        values.put("Manufacturer", getManufacturer());
        values.put("IsRegularSupplier", getIsRegularSupplier());
        values.put("SupplierSubrange", getSupplierSubrange());
        values.put("NoDaysReminder1", getNoDaysReminder1());
        values.put("NoDaysReminder2", getNoDaysReminder2());
        values.put("NoDaysReminder3", getNoDaysReminder3());
        values.put("ProductPurchasePointsQty", getProductPurchasePointsQty());
        values.put("ProductPurchasePointsQtyUnit", getProductPurchasePointsQtyUnit());
        values.put("SupplierSubrangeSortNumber", getSupplierSubrangeSortNumber());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("IsEndOfPurposeBlocked", getIsEndOfPurposeBlocked());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecordDesc") ) {
                final Object value = values.remove("PurchasingInfoRecordDesc");
                if( (value == null) || (!value.equals(getPurchasingInfoRecordDesc())) ) {
                    setPurchasingInfoRecordDesc(((String) value));
                }
            }
            if( values.containsKey("PurgInfoRecNonStockItmSortTerm") ) {
                final Object value = values.remove("PurgInfoRecNonStockItmSortTerm");
                if( (value == null) || (!value.equals(getPurgInfoRecNonStockItmSortTerm())) ) {
                    setPurgInfoRecNonStockItmSortTerm(((String) value));
                }
            }
            if( values.containsKey("PurgDocOrderQuantityUnit") ) {
                final Object value = values.remove("PurgDocOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurgDocOrderQuantityUnit())) ) {
                    setPurgDocOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderItemQtyToBaseQtyNmrtr") ) {
                final Object value = values.remove("OrderItemQtyToBaseQtyNmrtr");
                if( (value == null) || (!value.equals(getOrderItemQtyToBaseQtyNmrtr())) ) {
                    setOrderItemQtyToBaseQtyNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderItemQtyToBaseQtyDnmntr") ) {
                final Object value = values.remove("OrderItemQtyToBaseQtyDnmntr");
                if( (value == null) || (!value.equals(getOrderItemQtyToBaseQtyDnmntr())) ) {
                    setOrderItemQtyToBaseQtyDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierMaterialNumber") ) {
                final Object value = values.remove("SupplierMaterialNumber");
                if( (value == null) || (!value.equals(getSupplierMaterialNumber())) ) {
                    setSupplierMaterialNumber(((String) value));
                }
            }
            if( values.containsKey("SupplierRespSalesPersonName") ) {
                final Object value = values.remove("SupplierRespSalesPersonName");
                if( (value == null) || (!value.equals(getSupplierRespSalesPersonName())) ) {
                    setSupplierRespSalesPersonName(((String) value));
                }
            }
            if( values.containsKey("SupplierPhoneNumber") ) {
                final Object value = values.remove("SupplierPhoneNumber");
                if( (value == null) || (!value.equals(getSupplierPhoneNumber())) ) {
                    setSupplierPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("SupplierMaterialGroup") ) {
                final Object value = values.remove("SupplierMaterialGroup");
                if( (value == null) || (!value.equals(getSupplierMaterialGroup())) ) {
                    setSupplierMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("PriorSupplier") ) {
                final Object value = values.remove("PriorSupplier");
                if( (value == null) || (!value.equals(getPriorSupplier())) ) {
                    setPriorSupplier(((String) value));
                }
            }
            if( values.containsKey("AvailabilityStartDate") ) {
                final Object value = values.remove("AvailabilityStartDate");
                if( (value == null) || (!value.equals(getAvailabilityStartDate())) ) {
                    setAvailabilityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AvailabilityEndDate") ) {
                final Object value = values.remove("AvailabilityEndDate");
                if( (value == null) || (!value.equals(getAvailabilityEndDate())) ) {
                    setAvailabilityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("VarblPurOrdUnitIsActive") ) {
                final Object value = values.remove("VarblPurOrdUnitIsActive");
                if( (value == null) || (!value.equals(getVarblPurOrdUnitIsActive())) ) {
                    setVarblPurOrdUnitIsActive(((String) value));
                }
            }
            if( values.containsKey("Manufacturer") ) {
                final Object value = values.remove("Manufacturer");
                if( (value == null) || (!value.equals(getManufacturer())) ) {
                    setManufacturer(((String) value));
                }
            }
            if( values.containsKey("IsRegularSupplier") ) {
                final Object value = values.remove("IsRegularSupplier");
                if( (value == null) || (!value.equals(getIsRegularSupplier())) ) {
                    setIsRegularSupplier(((Boolean) value));
                }
            }
            if( values.containsKey("SupplierSubrange") ) {
                final Object value = values.remove("SupplierSubrange");
                if( (value == null) || (!value.equals(getSupplierSubrange())) ) {
                    setSupplierSubrange(((String) value));
                }
            }
            if( values.containsKey("NoDaysReminder1") ) {
                final Object value = values.remove("NoDaysReminder1");
                if( (value == null) || (!value.equals(getNoDaysReminder1())) ) {
                    setNoDaysReminder1(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoDaysReminder2") ) {
                final Object value = values.remove("NoDaysReminder2");
                if( (value == null) || (!value.equals(getNoDaysReminder2())) ) {
                    setNoDaysReminder2(((BigDecimal) value));
                }
            }
            if( values.containsKey("NoDaysReminder3") ) {
                final Object value = values.remove("NoDaysReminder3");
                if( (value == null) || (!value.equals(getNoDaysReminder3())) ) {
                    setNoDaysReminder3(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductPurchasePointsQty") ) {
                final Object value = values.remove("ProductPurchasePointsQty");
                if( (value == null) || (!value.equals(getProductPurchasePointsQty())) ) {
                    setProductPurchasePointsQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductPurchasePointsQtyUnit") ) {
                final Object value = values.remove("ProductPurchasePointsQtyUnit");
                if( (value == null) || (!value.equals(getProductPurchasePointsQtyUnit())) ) {
                    setProductPurchasePointsQtyUnit(((String) value));
                }
            }
            if( values.containsKey("SupplierSubrangeSortNumber") ) {
                final Object value = values.remove("SupplierSubrangeSortNumber");
                if( (value == null) || (!value.equals(getSupplierSubrangeSortNumber())) ) {
                    setSupplierSubrangeSortNumber(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("IsEndOfPurposeBlocked") ) {
                final Object value = values.remove("IsEndOfPurposeBlocked");
                if( (value == null) || (!value.equals(getIsEndOfPurposeBlocked())) ) {
                    setIsEndOfPurposeBlocked(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurgInfoRecdOrgPlantData") ) {
                final Object value = (values).remove("to_PurgInfoRecdOrgPlantData");
                if( value instanceof Iterable ) {
                    if( toPurgInfoRecdOrgPlantData == null ) {
                        toPurgInfoRecdOrgPlantData = Lists.newArrayList();
                    } else {
                        toPurgInfoRecdOrgPlantData = Lists.newArrayList(toPurgInfoRecdOrgPlantData);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgInfoRecdOrgPlantData entity;
                        if( toPurgInfoRecdOrgPlantData.size() > i ) {
                            entity = toPurgInfoRecdOrgPlantData.get(i);
                        } else {
                            entity = new PurgInfoRecdOrgPlantData();
                            toPurgInfoRecdOrgPlantData.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurchasingInfoRecordField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchasingInfoRecordField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchasingInfoRecordField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchasingInfoRecordField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurgInfoRecdOrgPlantData != null ) {
            (values).put("to_PurgInfoRecdOrgPlantData", toPurgInfoRecdOrgPlantData);
        }
        return values;
    }

    /**
     * Fetches the <b>PurgInfoRecdOrgPlantData</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PurgInfoRecdOrgPlantData</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgInfoRecdOrgPlantData</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgInfoRecdOrgPlantData> fetchPurgInfoRecdOrgPlantData()
    {
        return fetchFieldAsList("to_PurgInfoRecdOrgPlantData", PurgInfoRecdOrgPlantData.class);
    }

    /**
     * Retrieval of associated <b>PurgInfoRecdOrgPlantData</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgInfoRecdOrgPlantData</b>.
     * <p>
     * If the navigation property <b>to_PurgInfoRecdOrgPlantData</b> of a queried <b>PurchasingInfoRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgInfoRecdOrgPlantData</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgInfoRecdOrgPlantData> getPurgInfoRecdOrgPlantDataOrFetch()
    {
        if( toPurgInfoRecdOrgPlantData == null ) {
            toPurgInfoRecdOrgPlantData = fetchPurgInfoRecdOrgPlantData();
        }
        return toPurgInfoRecdOrgPlantData;
    }

    /**
     * Retrieval of associated <b>PurgInfoRecdOrgPlantData</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgInfoRecdOrgPlantData</b>.
     * <p>
     * If the navigation property for an entity <b>PurchasingInfoRecord</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgInfoRecdOrgPlantData</b> is already loaded, the
     *         result will contain the <b>PurgInfoRecdOrgPlantData</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgInfoRecdOrgPlantData>> getPurgInfoRecdOrgPlantDataIfPresent()
    {
        return Option.of(toPurgInfoRecdOrgPlantData);
    }

    /**
     * Overwrites the list of associated <b>PurgInfoRecdOrgPlantData</b> entities for the loaded navigation property
     * <b>to_PurgInfoRecdOrgPlantData</b>.
     * <p>
     * If the navigation property <b>to_PurgInfoRecdOrgPlantData</b> of a queried <b>PurchasingInfoRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgInfoRecdOrgPlantData</b> entities.
     */
    public void setPurgInfoRecdOrgPlantData( @Nonnull final List<PurgInfoRecdOrgPlantData> value )
    {
        if( toPurgInfoRecdOrgPlantData == null ) {
            toPurgInfoRecdOrgPlantData = Lists.newArrayList();
        }
        toPurgInfoRecdOrgPlantData.clear();
        toPurgInfoRecdOrgPlantData.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgInfoRecdOrgPlantData</b> entities. This corresponds to the OData
     * navigation property <b>to_PurgInfoRecdOrgPlantData</b>.
     * <p>
     * If the navigation property <b>to_PurgInfoRecdOrgPlantData</b> of a queried <b>PurchasingInfoRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgInfoRecdOrgPlantData</b> entities.
     */
    public void addPurgInfoRecdOrgPlantData( PurgInfoRecdOrgPlantData... entity )
    {
        if( toPurgInfoRecdOrgPlantData == null ) {
            toPurgInfoRecdOrgPlantData = Lists.newArrayList();
        }
        toPurgInfoRecdOrgPlantData.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurchasingInfoRecord instances.
     *
     */
    public final static class PurchasingInfoRecordBuilder
    {

        private List<PurgInfoRecdOrgPlantData> toPurgInfoRecdOrgPlantData = Lists.newArrayList();

        private PurchasingInfoRecord.PurchasingInfoRecordBuilder toPurgInfoRecdOrgPlantData(
            final List<PurgInfoRecdOrgPlantData> value )
        {
            toPurgInfoRecdOrgPlantData.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurgInfoRecdOrgPlantData</b> for <b>PurchasingInfoRecord</b> to multiple
         * <b>PurgInfoRecdOrgPlantData</b>.
         *
         * @param value
         *            The PurgInfoRecdOrgPlantDatas to build this PurchasingInfoRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchasingInfoRecord.PurchasingInfoRecordBuilder purgInfoRecdOrgPlantData(
            PurgInfoRecdOrgPlantData... value )
        {
            return toPurgInfoRecdOrgPlantData(Lists.newArrayList(value));
        }

    }

}
