/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.selectable.PurchasingInfoRecordSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
 * PurchasingInfoRecord} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class PurchasingInfoRecordByKeyFluentHelper
    extends
    FluentHelperByKey<PurchasingInfoRecordByKeyFluentHelper, PurchasingInfoRecord, PurchasingInfoRecordSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     * PurchasingInfoRecord} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurchasingInfoRecord}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurchasingInfoRecord}
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public PurchasingInfoRecordByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchasingInfoRecord )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchasingInfoRecord", purchasingInfoRecord);
    }

    @Override
    @Nonnull
    protected Class<PurchasingInfoRecord> getEntityClass()
    {
        return PurchasingInfoRecord.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
