/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.field.PurgInfoRecdOrgPlantDataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.link.PurgInfoRecdOrgPlantDataLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.link.PurgInfoRecdOrgPlantDataOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.selectable.PurgInfoRecdOrgPlantDataSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Purchasing Info Record Purch. Org. Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgInfoRecdOrgPlantDataType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgInfoRecdOrgPlantData extends VdmEntity<PurgInfoRecdOrgPlantData>
{

    /**
     * Selector for all available fields of PurgInfoRecdOrgPlantData.
     *
     */
    public final static PurgInfoRecdOrgPlantDataSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @Key
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> PURCHASING_INFO_RECORD =
        new PurgInfoRecdOrgPlantDataField<String>("PurchasingInfoRecord");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordCategory</b>
     * </p>
     *
     * @return Purchasing info record category
     */
    @Key
    @SerializedName( "PurchasingInfoRecordCategory" )
    @JsonProperty( "PurchasingInfoRecordCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecordCategory" )
    private String purchasingInfoRecordCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecordCategory</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> PURCHASING_INFO_RECORD_CATEGORY =
        new PurgInfoRecdOrgPlantDataField<String>("PurchasingInfoRecordCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @Key
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> PURCHASING_ORGANIZATION =
        new PurgInfoRecdOrgPlantDataField<String>("PurchasingOrganization");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> PLANT =
        new PurgInfoRecdOrgPlantDataField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> CREATED_BY_USER =
        new PurgInfoRecdOrgPlantDataField<String>("CreatedByUser");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Purch. info: Purch. organization data flagged for deletion
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<Boolean> IS_MARKED_FOR_DELETION =
        new PurgInfoRecdOrgPlantDataField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> PURCHASING_GROUP =
        new PurgInfoRecdOrgPlantDataField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> CURRENCY =
        new PurgInfoRecdOrgPlantDataField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumPurchaseOrderQuantity</b>
     * </p>
     *
     * @return Minimum Purchase Order Quantity
     */
    @SerializedName( "MinimumPurchaseOrderQuantity" )
    @JsonProperty( "MinimumPurchaseOrderQuantity" )
    @Nullable
    @ODataField( odataName = "MinimumPurchaseOrderQuantity" )
    private BigDecimal minimumPurchaseOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MinimumPurchaseOrderQuantity</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<BigDecimal> MINIMUM_PURCHASE_ORDER_QUANTITY =
        new PurgInfoRecdOrgPlantDataField<BigDecimal>("MinimumPurchaseOrderQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardPurchaseOrderQuantity</b>
     * </p>
     *
     * @return Standard Purchase Order Quantity
     */
    @SerializedName( "StandardPurchaseOrderQuantity" )
    @JsonProperty( "StandardPurchaseOrderQuantity" )
    @Nullable
    @ODataField( odataName = "StandardPurchaseOrderQuantity" )
    private BigDecimal standardPurchaseOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>StandardPurchaseOrderQuantity</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<BigDecimal> STANDARD_PURCHASE_ORDER_QUANTITY =
        new PurgInfoRecdOrgPlantDataField<BigDecimal>("StandardPurchaseOrderQuantity");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedDeliveryDurn</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "MaterialPlannedDeliveryDurn" )
    @JsonProperty( "MaterialPlannedDeliveryDurn" )
    @Nullable
    @ODataField( odataName = "MaterialPlannedDeliveryDurn" )
    private BigDecimal materialPlannedDeliveryDurn;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPlannedDeliveryDurn</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<BigDecimal> MATERIAL_PLANNED_DELIVERY_DURN =
        new PurgInfoRecdOrgPlantDataField<BigDecimal>("MaterialPlannedDeliveryDurn");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Overdelivery Tolerance
     */
    @SerializedName( "OverdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "OverdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "OverdelivTolrtdLmtRatioInPct" )
    private BigDecimal overdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>OverdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<BigDecimal> OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new PurgInfoRecdOrgPlantDataField<BigDecimal>("OverdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @return Underdelivery Tolerance
     */
    @SerializedName( "UnderdelivTolrtdLmtRatioInPct" )
    @JsonProperty( "UnderdelivTolrtdLmtRatioInPct" )
    @Nullable
    @ODataField( odataName = "UnderdelivTolrtdLmtRatioInPct" )
    private BigDecimal underdelivTolrtdLmtRatioInPct;
    /**
     * Use with available fluent helpers to apply the <b>UnderdelivTolrtdLmtRatioInPct</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<BigDecimal> UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT =
        new PurgInfoRecdOrgPlantDataField<BigDecimal>("UnderdelivTolrtdLmtRatioInPct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @return Unlimited Overdelivery Allowed
     */
    @SerializedName( "UnlimitedOverdeliveryIsAllowed" )
    @JsonProperty( "UnlimitedOverdeliveryIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "UnlimitedOverdeliveryIsAllowed" )
    private Boolean unlimitedOverdeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>UnlimitedOverdeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<Boolean> UNLIMITED_OVERDELIVERY_IS_ALLOWED =
        new PurgInfoRecdOrgPlantDataField<Boolean>("UnlimitedOverdeliveryIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LastReferencingPurchaseOrder</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "LastReferencingPurchaseOrder" )
    @JsonProperty( "LastReferencingPurchaseOrder" )
    @Nullable
    @ODataField( odataName = "LastReferencingPurchaseOrder" )
    private String lastReferencingPurchaseOrder;
    /**
     * Use with available fluent helpers to apply the <b>LastReferencingPurchaseOrder</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> LAST_REFERENCING_PURCHASE_ORDER =
        new PurgInfoRecdOrgPlantDataField<String>("LastReferencingPurchaseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LastReferencingPurOrderItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "LastReferencingPurOrderItem" )
    @JsonProperty( "LastReferencingPurOrderItem" )
    @Nullable
    @ODataField( odataName = "LastReferencingPurOrderItem" )
    private String lastReferencingPurOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>LastReferencingPurOrderItem</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> LAST_REFERENCING_PUR_ORDER_ITEM =
        new PurgInfoRecdOrgPlantDataField<String>("LastReferencingPurOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> MATERIAL =
        new PurgInfoRecdOrgPlantDataField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> SUPPLIER =
        new PurgInfoRecdOrgPlantDataField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> MATERIAL_GROUP =
        new PurgInfoRecdOrgPlantDataField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurgDocOrderQuantityUnit" )
    @JsonProperty( "PurgDocOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurgDocOrderQuantityUnit" )
    private String purgDocOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> PURG_DOC_ORDER_QUANTITY_UNIT =
        new PurgInfoRecdOrgPlantDataField<String>("PurgDocOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantityUnit</b>
     * </p>
     *
     * @return The netPriceQuantityUnit contained in this entity.
     */
    @SerializedName( "NetPriceQuantityUnit" )
    @JsonProperty( "NetPriceQuantityUnit" )
    @Nullable
    @ODataField( odataName = "NetPriceQuantityUnit" )
    private String netPriceQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceQuantityUnit</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> NET_PRICE_QUANTITY_UNIT =
        new PurgInfoRecdOrgPlantDataField<String>("NetPriceQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @return Net Price in Purchasing Info Record
     */
    @SerializedName( "NetPriceAmount" )
    @JsonProperty( "NetPriceAmount" )
    @Nullable
    @ODataField( odataName = "NetPriceAmount" )
    private BigDecimal netPriceAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetPriceAmount</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<BigDecimal> NET_PRICE_AMOUNT =
        new PurgInfoRecdOrgPlantDataField<BigDecimal>("NetPriceAmount");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     * </p>
     *
     * @return Price unit
     */
    @SerializedName( "MaterialPriceUnitQty" )
    @JsonProperty( "MaterialPriceUnitQty" )
    @Nullable
    @ODataField( odataName = "MaterialPriceUnitQty" )
    private BigDecimal materialPriceUnitQty;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPriceUnitQty</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<BigDecimal> MATERIAL_PRICE_UNIT_QTY =
        new PurgInfoRecdOrgPlantDataField<BigDecimal>("MaterialPriceUnitQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnit</b>
     * </p>
     *
     * @return Order Price Unit (Purchasing)
     */
    @SerializedName( "PurchaseOrderPriceUnit" )
    @JsonProperty( "PurchaseOrderPriceUnit" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderPriceUnit" )
    private String purchaseOrderPriceUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderPriceUnit</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> PURCHASE_ORDER_PRICE_UNIT =
        new PurgInfoRecdOrgPlantDataField<String>("PurchaseOrderPriceUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceValidityEndDate</b>
     * </p>
     *
     * @return Price Valid Until
     */
    @SerializedName( "PriceValidityEndDate" )
    @JsonProperty( "PriceValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PriceValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime priceValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>PriceValidityEndDate</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<LocalDateTime> PRICE_VALIDITY_END_DATE =
        new PurgInfoRecdOrgPlantDataField<LocalDateTime>("PriceValidityEndDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @return Indicator: GR-Based Invoice Verification
     */
    @SerializedName( "InvoiceIsGoodsReceiptBased" )
    @JsonProperty( "InvoiceIsGoodsReceiptBased" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InvoiceIsGoodsReceiptBased" )
    private Boolean invoiceIsGoodsReceiptBased;
    /**
     * Use with available fluent helpers to apply the <b>InvoiceIsGoodsReceiptBased</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<Boolean> INVOICE_IS_GOODS_RECEIPT_BASED =
        new PurgInfoRecdOrgPlantDataField<Boolean>("InvoiceIsGoodsReceiptBased");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> TAX_CODE =
        new PurgInfoRecdOrgPlantDataField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> INCOTERMS_CLASSIFICATION =
        new PurgInfoRecdOrgPlantDataField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> INCOTERMS_TRANSFER_LOCATION =
        new PurgInfoRecdOrgPlantDataField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> INCOTERMS_LOCATION1 =
        new PurgInfoRecdOrgPlantDataField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumOrderQuantity</b>
     * </p>
     *
     * @return Maximum Purchase Order Quantity
     */
    @SerializedName( "MaximumOrderQuantity" )
    @JsonProperty( "MaximumOrderQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumOrderQuantity" )
    private BigDecimal maximumOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumOrderQuantity</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<BigDecimal> MAXIMUM_ORDER_QUANTITY =
        new PurgInfoRecdOrgPlantDataField<BigDecimal>("MaximumOrderQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAutomSrcg</b>
     * </p>
     *
     * @return Relevant for Automatic Sourcing
     */
    @SerializedName( "IsRelevantForAutomSrcg" )
    @JsonProperty( "IsRelevantForAutomSrcg" )
    @Nullable
    @ODataField( odataName = "IsRelevantForAutomSrcg" )
    private String isRelevantForAutomSrcg;
    /**
     * Use with available fluent helpers to apply the <b>IsRelevantForAutomSrcg</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> IS_RELEVANT_FOR_AUTOM_SRCG =
        new PurgInfoRecdOrgPlantDataField<String>("IsRelevantForAutomSrcg");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @return Quotation Number
     */
    @SerializedName( "SupplierQuotation" )
    @JsonProperty( "SupplierQuotation" )
    @Nullable
    @ODataField( odataName = "SupplierQuotation" )
    private String supplierQuotation;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotation</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> SUPPLIER_QUOTATION =
        new PurgInfoRecdOrgPlantDataField<String>("SupplierQuotation");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationDate</b>
     * </p>
     *
     * @return Quotation Validity Date
     */
    @SerializedName( "SupplierQuotationDate" )
    @JsonProperty( "SupplierQuotationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SupplierQuotationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime supplierQuotationDate;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotationDate</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<LocalDateTime> SUPPLIER_QUOTATION_DATE =
        new PurgInfoRecdOrgPlantDataField<LocalDateTime>("SupplierQuotationDate");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MinRemainingShelfLife</b>
     * </p>
     *
     * @return Minimum Remaining Shelf Life
     */
    @SerializedName( "MinRemainingShelfLife" )
    @JsonProperty( "MinRemainingShelfLife" )
    @Nullable
    @ODataField( odataName = "MinRemainingShelfLife" )
    private BigDecimal minRemainingShelfLife;
    /**
     * Use with available fluent helpers to apply the <b>MinRemainingShelfLife</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<BigDecimal> MIN_REMAINING_SHELF_LIFE =
        new PurgInfoRecdOrgPlantDataField<BigDecimal>("MinRemainingShelfLife");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEvaluatedRcptSettlmtAllowed</b>
     * </p>
     *
     * @return No Evaluated Receipt Settlement (ERS)
     */
    @SerializedName( "IsEvaluatedRcptSettlmtAllowed" )
    @JsonProperty( "IsEvaluatedRcptSettlmtAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsEvaluatedRcptSettlmtAllowed" )
    private Boolean isEvaluatedRcptSettlmtAllowed;
    /**
     * Use with available fluent helpers to apply the <b>IsEvaluatedRcptSettlmtAllowed</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<Boolean> IS_EVALUATED_RCPT_SETTLMT_ALLOWED =
        new PurgInfoRecdOrgPlantDataField<Boolean>("IsEvaluatedRcptSettlmtAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPurOrderAllwdForInbDeliv</b>
     * </p>
     *
     * @return Create Purchase Order for Delivery Without Reference
     */
    @SerializedName( "IsPurOrderAllwdForInbDeliv" )
    @JsonProperty( "IsPurOrderAllwdForInbDeliv" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsPurOrderAllwdForInbDeliv" )
    private Boolean isPurOrderAllwdForInbDeliv;
    /**
     * Use with available fluent helpers to apply the <b>IsPurOrderAllwdForInbDeliv</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<Boolean> IS_PUR_ORDER_ALLWD_FOR_INB_DELIV =
        new PurgInfoRecdOrgPlantDataField<Boolean>("IsPurOrderAllwdForInbDeliv");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOrderAcknRqd</b>
     * </p>
     *
     * @return Order Acknowledgment Requirement
     */
    @SerializedName( "IsOrderAcknRqd" )
    @JsonProperty( "IsOrderAcknRqd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsOrderAcknRqd" )
    private Boolean isOrderAcknRqd;
    /**
     * Use with available fluent helpers to apply the <b>IsOrderAcknRqd</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<Boolean> IS_ORDER_ACKN_RQD =
        new PurgInfoRecdOrgPlantDataField<Boolean>("IsOrderAcknRqd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsRetMatlAuthznRqdBySupplier</b>
     * </p>
     *
     * @return Supplier RMA Number Required
     */
    @SerializedName( "IsRetMatlAuthznRqdBySupplier" )
    @JsonProperty( "IsRetMatlAuthznRqdBySupplier" )
    @Nullable
    @ODataField( odataName = "IsRetMatlAuthznRqdBySupplier" )
    private String isRetMatlAuthznRqdBySupplier;
    /**
     * Use with available fluent helpers to apply the <b>IsRetMatlAuthznRqdBySupplier</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> IS_RET_MATL_AUTHZN_RQD_BY_SUPPLIER =
        new PurgInfoRecdOrgPlantDataField<String>("IsRetMatlAuthznRqdBySupplier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCashDiscountGranted</b>
     * </p>
     *
     * @return Item Does Not Qualify for Cash Discount
     */
    @SerializedName( "IsCashDiscountGranted" )
    @JsonProperty( "IsCashDiscountGranted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsCashDiscountGranted" )
    private Boolean isCashDiscountGranted;
    /**
     * Use with available fluent helpers to apply the <b>IsCashDiscountGranted</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<Boolean> IS_CASH_DISCOUNT_GRANTED =
        new PurgInfoRecdOrgPlantDataField<Boolean>("IsCashDiscountGranted");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialConditionGroup</b>
     * </p>
     *
     * @return Condition Group with Supplier
     */
    @SerializedName( "MaterialConditionGroup" )
    @JsonProperty( "MaterialConditionGroup" )
    @Nullable
    @ODataField( odataName = "MaterialConditionGroup" )
    private String materialConditionGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialConditionGroup</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> MATERIAL_CONDITION_GROUP =
        new PurgInfoRecdOrgPlantDataField<String>("MaterialConditionGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDate</b>
     * </p>
     *
     * @return Date of Last PO or Sched. Agreement Document in Info Record
     */
    @SerializedName( "PurchasingDocumentDate" )
    @JsonProperty( "PurchasingDocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PurchasingDocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime purchasingDocumentDate;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentDate</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<LocalDateTime> PURCHASING_DOCUMENT_DATE =
        new PurgInfoRecdOrgPlantDataField<LocalDateTime>("PurchasingDocumentDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDatePeriod</b>
     * </p>
     *
     * @return Period Indicator for Shelf Life Expiration Date
     */
    @SerializedName( "ShelfLifeExpirationDatePeriod" )
    @JsonProperty( "ShelfLifeExpirationDatePeriod" )
    @Nullable
    @ODataField( odataName = "ShelfLifeExpirationDatePeriod" )
    private String shelfLifeExpirationDatePeriod;
    /**
     * Use with available fluent helpers to apply the <b>ShelfLifeExpirationDatePeriod</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> SHELF_LIFE_EXPIRATION_DATE_PERIOD =
        new PurgInfoRecdOrgPlantDataField<String>("ShelfLifeExpirationDatePeriod");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @return Business Purpose Completed
     */
    @SerializedName( "IsEndOfPurposeBlocked" )
    @JsonProperty( "IsEndOfPurposeBlocked" )
    @Nullable
    @ODataField( odataName = "IsEndOfPurposeBlocked" )
    private String isEndOfPurposeBlocked;
    /**
     * Use with available fluent helpers to apply the <b>IsEndOfPurposeBlocked</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> IS_END_OF_PURPOSE_BLOCKED =
        new PurgInfoRecdOrgPlantDataField<String>("IsEndOfPurposeBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierConfirmationControlKey</b>
     * </p>
     *
     * @return Confirmation Control Key
     */
    @SerializedName( "SupplierConfirmationControlKey" )
    @JsonProperty( "SupplierConfirmationControlKey" )
    @Nullable
    @ODataField( odataName = "SupplierConfirmationControlKey" )
    private String supplierConfirmationControlKey;
    /**
     * Use with available fluent helpers to apply the <b>SupplierConfirmationControlKey</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> SUPPLIER_CONFIRMATION_CONTROL_KEY =
        new PurgInfoRecdOrgPlantDataField<String>("SupplierConfirmationControlKey");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateControl</b>
     * </p>
     *
     * @return Price Determination (Pricing) Date Control
     */
    @SerializedName( "PricingDateControl" )
    @JsonProperty( "PricingDateControl" )
    @Nullable
    @ODataField( odataName = "PricingDateControl" )
    private String pricingDateControl;
    /**
     * Use with available fluent helpers to apply the <b>PricingDateControl</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> PRICING_DATE_CONTROL =
        new PurgInfoRecdOrgPlantDataField<String>("PricingDateControl");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TimeDependentTaxValidFromDate</b>
     * </p>
     *
     * @return Valid-From Date of the Tax Rate
     */
    @SerializedName( "TimeDependentTaxValidFromDate" )
    @JsonProperty( "TimeDependentTaxValidFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TimeDependentTaxValidFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime timeDependentTaxValidFromDate;
    /**
     * Use with available fluent helpers to apply the <b>TimeDependentTaxValidFromDate</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<LocalDateTime> TIME_DEPENDENT_TAX_VALID_FROM_DATE =
        new PurgInfoRecdOrgPlantDataField<LocalDateTime>("TimeDependentTaxValidFromDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @return Tax Reporting Country/Region
     */
    @SerializedName( "TaxCountry" )
    @JsonProperty( "TaxCountry" )
    @Nullable
    @ODataField( odataName = "TaxCountry" )
    private String taxCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxCountry</b> field to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataField<String> TAX_COUNTRY =
        new PurgInfoRecdOrgPlantDataField<String>("TaxCountry");
    /**
     * Navigation property <b>to_PurgInfoRecd</b> for <b>PurgInfoRecdOrgPlantData</b> to single
     * <b>PurchasingInfoRecord</b>.
     *
     */
    @SerializedName( "to_PurgInfoRecd" )
    @JsonProperty( "to_PurgInfoRecd" )
    @ODataField( odataName = "to_PurgInfoRecd" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurchasingInfoRecord toPurgInfoRecd;
    /**
     * Navigation property <b>to_PurInfoRecdPrcgCndnValidity</b> for <b>PurgInfoRecdOrgPlantData</b> to multiple
     * <b>PurInfoRecdPrcgCndnValidity</b>.
     *
     */
    @SerializedName( "to_PurInfoRecdPrcgCndnValidity" )
    @JsonProperty( "to_PurInfoRecdPrcgCndnValidity" )
    @ODataField( odataName = "to_PurInfoRecdPrcgCndnValidity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurInfoRecdPrcgCndnValidity> toPurInfoRecdPrcgCndnValidity;
    /**
     * Use with available fluent helpers to apply the <b>to_PurgInfoRecd</b> navigation property to query operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataOneToOneLink<PurchasingInfoRecord> TO_PURG_INFO_RECD =
        new PurgInfoRecdOrgPlantDataOneToOneLink<PurchasingInfoRecord>("to_PurgInfoRecd");
    /**
     * Use with available fluent helpers to apply the <b>to_PurInfoRecdPrcgCndnValidity</b> navigation property to query
     * operations.
     *
     */
    public final static PurgInfoRecdOrgPlantDataLink<PurInfoRecdPrcgCndnValidity> TO_PUR_INFO_RECD_PRCG_CNDN_VALIDITY =
        new PurgInfoRecdOrgPlantDataLink<PurInfoRecdPrcgCndnValidity>("to_PurInfoRecdPrcgCndnValidity");

    @Nonnull
    @Override
    public Class<PurgInfoRecdOrgPlantData> getType()
    {
        return PurgInfoRecdOrgPlantData.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordCategory</b>
     * </p>
     *
     * @param purchasingInfoRecordCategory
     *            Purchasing info record category
     */
    public void setPurchasingInfoRecordCategory( @Nullable final String purchasingInfoRecordCategory )
    {
        rememberChangedField("PurchasingInfoRecordCategory", this.purchasingInfoRecordCategory);
        this.purchasingInfoRecordCategory = purchasingInfoRecordCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Purch. info: Purch. organization data flagged for deletion
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinimumPurchaseOrderQuantity</b>
     * </p>
     *
     * @param minimumPurchaseOrderQuantity
     *            Minimum Purchase Order Quantity
     */
    public void setMinimumPurchaseOrderQuantity( @Nullable final BigDecimal minimumPurchaseOrderQuantity )
    {
        rememberChangedField("MinimumPurchaseOrderQuantity", this.minimumPurchaseOrderQuantity);
        this.minimumPurchaseOrderQuantity = minimumPurchaseOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StandardPurchaseOrderQuantity</b>
     * </p>
     *
     * @param standardPurchaseOrderQuantity
     *            Standard Purchase Order Quantity
     */
    public void setStandardPurchaseOrderQuantity( @Nullable final BigDecimal standardPurchaseOrderQuantity )
    {
        rememberChangedField("StandardPurchaseOrderQuantity", this.standardPurchaseOrderQuantity);
        this.standardPurchaseOrderQuantity = standardPurchaseOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPlannedDeliveryDurn</b>
     * </p>
     *
     * @param materialPlannedDeliveryDurn
     *            Planned Delivery Time in Days
     */
    public void setMaterialPlannedDeliveryDurn( @Nullable final BigDecimal materialPlannedDeliveryDurn )
    {
        rememberChangedField("MaterialPlannedDeliveryDurn", this.materialPlannedDeliveryDurn);
        this.materialPlannedDeliveryDurn = materialPlannedDeliveryDurn;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param overdelivTolrtdLmtRatioInPct
     *            Overdelivery Tolerance
     */
    public void setOverdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal overdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("OverdelivTolrtdLmtRatioInPct", this.overdelivTolrtdLmtRatioInPct);
        this.overdelivTolrtdLmtRatioInPct = overdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>UnderdelivTolrtdLmtRatioInPct</b>
     * </p>
     *
     * @param underdelivTolrtdLmtRatioInPct
     *            Underdelivery Tolerance
     */
    public void setUnderdelivTolrtdLmtRatioInPct( @Nullable final BigDecimal underdelivTolrtdLmtRatioInPct )
    {
        rememberChangedField("UnderdelivTolrtdLmtRatioInPct", this.underdelivTolrtdLmtRatioInPct);
        this.underdelivTolrtdLmtRatioInPct = underdelivTolrtdLmtRatioInPct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnlimitedOverdeliveryIsAllowed</b>
     * </p>
     *
     * @param unlimitedOverdeliveryIsAllowed
     *            Unlimited Overdelivery Allowed
     */
    public void setUnlimitedOverdeliveryIsAllowed( @Nullable final Boolean unlimitedOverdeliveryIsAllowed )
    {
        rememberChangedField("UnlimitedOverdeliveryIsAllowed", this.unlimitedOverdeliveryIsAllowed);
        this.unlimitedOverdeliveryIsAllowed = unlimitedOverdeliveryIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LastReferencingPurchaseOrder</b>
     * </p>
     *
     * @param lastReferencingPurchaseOrder
     *            Purchasing Document Number
     */
    public void setLastReferencingPurchaseOrder( @Nullable final String lastReferencingPurchaseOrder )
    {
        rememberChangedField("LastReferencingPurchaseOrder", this.lastReferencingPurchaseOrder);
        this.lastReferencingPurchaseOrder = lastReferencingPurchaseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>LastReferencingPurOrderItem</b>
     * </p>
     *
     * @param lastReferencingPurOrderItem
     *            Item Number of Purchasing Document
     */
    public void setLastReferencingPurOrderItem( @Nullable final String lastReferencingPurOrderItem )
    {
        rememberChangedField("LastReferencingPurOrderItem", this.lastReferencingPurOrderItem);
        this.lastReferencingPurOrderItem = lastReferencingPurOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderQuantityUnit</b>
     * </p>
     *
     * @param purgDocOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurgDocOrderQuantityUnit( @Nullable final String purgDocOrderQuantityUnit )
    {
        rememberChangedField("PurgDocOrderQuantityUnit", this.purgDocOrderQuantityUnit);
        this.purgDocOrderQuantityUnit = purgDocOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantityUnit</b>
     * </p>
     *
     * @param netPriceQuantityUnit
     *            The netPriceQuantityUnit to set.
     */
    public void setNetPriceQuantityUnit( @Nullable final String netPriceQuantityUnit )
    {
        rememberChangedField("NetPriceQuantityUnit", this.netPriceQuantityUnit);
        this.netPriceQuantityUnit = netPriceQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     *
     * @param netPriceAmount
     *            Net Price in Purchasing Info Record
     */
    public void setNetPriceAmount( @Nullable final BigDecimal netPriceAmount )
    {
        rememberChangedField("NetPriceAmount", this.netPriceAmount);
        this.netPriceAmount = netPriceAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPriceUnitQty</b>
     * </p>
     *
     * @param materialPriceUnitQty
     *            Price unit
     */
    public void setMaterialPriceUnitQty( @Nullable final BigDecimal materialPriceUnitQty )
    {
        rememberChangedField("MaterialPriceUnitQty", this.materialPriceUnitQty);
        this.materialPriceUnitQty = materialPriceUnitQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderPriceUnit</b>
     * </p>
     *
     * @param purchaseOrderPriceUnit
     *            Order Price Unit (Purchasing)
     */
    public void setPurchaseOrderPriceUnit( @Nullable final String purchaseOrderPriceUnit )
    {
        rememberChangedField("PurchaseOrderPriceUnit", this.purchaseOrderPriceUnit);
        this.purchaseOrderPriceUnit = purchaseOrderPriceUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PriceValidityEndDate</b>
     * </p>
     *
     * @param priceValidityEndDate
     *            Price Valid Until
     */
    public void setPriceValidityEndDate( @Nullable final LocalDateTime priceValidityEndDate )
    {
        rememberChangedField("PriceValidityEndDate", this.priceValidityEndDate);
        this.priceValidityEndDate = priceValidityEndDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvoiceIsGoodsReceiptBased</b>
     * </p>
     *
     * @param invoiceIsGoodsReceiptBased
     *            Indicator: GR-Based Invoice Verification
     */
    public void setInvoiceIsGoodsReceiptBased( @Nullable final Boolean invoiceIsGoodsReceiptBased )
    {
        rememberChangedField("InvoiceIsGoodsReceiptBased", this.invoiceIsGoodsReceiptBased);
        this.invoiceIsGoodsReceiptBased = invoiceIsGoodsReceiptBased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumOrderQuantity</b>
     * </p>
     *
     * @param maximumOrderQuantity
     *            Maximum Purchase Order Quantity
     */
    public void setMaximumOrderQuantity( @Nullable final BigDecimal maximumOrderQuantity )
    {
        rememberChangedField("MaximumOrderQuantity", this.maximumOrderQuantity);
        this.maximumOrderQuantity = maximumOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAutomSrcg</b>
     * </p>
     *
     * @param isRelevantForAutomSrcg
     *            Relevant for Automatic Sourcing
     */
    public void setIsRelevantForAutomSrcg( @Nullable final String isRelevantForAutomSrcg )
    {
        rememberChangedField("IsRelevantForAutomSrcg", this.isRelevantForAutomSrcg);
        this.isRelevantForAutomSrcg = isRelevantForAutomSrcg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @param supplierQuotation
     *            Quotation Number
     */
    public void setSupplierQuotation( @Nullable final String supplierQuotation )
    {
        rememberChangedField("SupplierQuotation", this.supplierQuotation);
        this.supplierQuotation = supplierQuotation;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotationDate</b>
     * </p>
     *
     * @param supplierQuotationDate
     *            Quotation Validity Date
     */
    public void setSupplierQuotationDate( @Nullable final LocalDateTime supplierQuotationDate )
    {
        rememberChangedField("SupplierQuotationDate", this.supplierQuotationDate);
        this.supplierQuotationDate = supplierQuotationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MinRemainingShelfLife</b>
     * </p>
     *
     * @param minRemainingShelfLife
     *            Minimum Remaining Shelf Life
     */
    public void setMinRemainingShelfLife( @Nullable final BigDecimal minRemainingShelfLife )
    {
        rememberChangedField("MinRemainingShelfLife", this.minRemainingShelfLife);
        this.minRemainingShelfLife = minRemainingShelfLife;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsEvaluatedRcptSettlmtAllowed</b>
     * </p>
     *
     * @param isEvaluatedRcptSettlmtAllowed
     *            No Evaluated Receipt Settlement (ERS)
     */
    public void setIsEvaluatedRcptSettlmtAllowed( @Nullable final Boolean isEvaluatedRcptSettlmtAllowed )
    {
        rememberChangedField("IsEvaluatedRcptSettlmtAllowed", this.isEvaluatedRcptSettlmtAllowed);
        this.isEvaluatedRcptSettlmtAllowed = isEvaluatedRcptSettlmtAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsPurOrderAllwdForInbDeliv</b>
     * </p>
     *
     * @param isPurOrderAllwdForInbDeliv
     *            Create Purchase Order for Delivery Without Reference
     */
    public void setIsPurOrderAllwdForInbDeliv( @Nullable final Boolean isPurOrderAllwdForInbDeliv )
    {
        rememberChangedField("IsPurOrderAllwdForInbDeliv", this.isPurOrderAllwdForInbDeliv);
        this.isPurOrderAllwdForInbDeliv = isPurOrderAllwdForInbDeliv;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsOrderAcknRqd</b>
     * </p>
     *
     * @param isOrderAcknRqd
     *            Order Acknowledgment Requirement
     */
    public void setIsOrderAcknRqd( @Nullable final Boolean isOrderAcknRqd )
    {
        rememberChangedField("IsOrderAcknRqd", this.isOrderAcknRqd);
        this.isOrderAcknRqd = isOrderAcknRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsRetMatlAuthznRqdBySupplier</b>
     * </p>
     *
     * @param isRetMatlAuthznRqdBySupplier
     *            Supplier RMA Number Required
     */
    public void setIsRetMatlAuthznRqdBySupplier( @Nullable final String isRetMatlAuthznRqdBySupplier )
    {
        rememberChangedField("IsRetMatlAuthznRqdBySupplier", this.isRetMatlAuthznRqdBySupplier);
        this.isRetMatlAuthznRqdBySupplier = isRetMatlAuthznRqdBySupplier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsCashDiscountGranted</b>
     * </p>
     *
     * @param isCashDiscountGranted
     *            Item Does Not Qualify for Cash Discount
     */
    public void setIsCashDiscountGranted( @Nullable final Boolean isCashDiscountGranted )
    {
        rememberChangedField("IsCashDiscountGranted", this.isCashDiscountGranted);
        this.isCashDiscountGranted = isCashDiscountGranted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialConditionGroup</b>
     * </p>
     *
     * @param materialConditionGroup
     *            Condition Group with Supplier
     */
    public void setMaterialConditionGroup( @Nullable final String materialConditionGroup )
    {
        rememberChangedField("MaterialConditionGroup", this.materialConditionGroup);
        this.materialConditionGroup = materialConditionGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDate</b>
     * </p>
     *
     * @param purchasingDocumentDate
     *            Date of Last PO or Sched. Agreement Document in Info Record
     */
    public void setPurchasingDocumentDate( @Nullable final LocalDateTime purchasingDocumentDate )
    {
        rememberChangedField("PurchasingDocumentDate", this.purchasingDocumentDate);
        this.purchasingDocumentDate = purchasingDocumentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ShelfLifeExpirationDatePeriod</b>
     * </p>
     *
     * @param shelfLifeExpirationDatePeriod
     *            Period Indicator for Shelf Life Expiration Date
     */
    public void setShelfLifeExpirationDatePeriod( @Nullable final String shelfLifeExpirationDatePeriod )
    {
        rememberChangedField("ShelfLifeExpirationDatePeriod", this.shelfLifeExpirationDatePeriod);
        this.shelfLifeExpirationDatePeriod = shelfLifeExpirationDatePeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsEndOfPurposeBlocked</b>
     * </p>
     *
     * @param isEndOfPurposeBlocked
     *            Business Purpose Completed
     */
    public void setIsEndOfPurposeBlocked( @Nullable final String isEndOfPurposeBlocked )
    {
        rememberChangedField("IsEndOfPurposeBlocked", this.isEndOfPurposeBlocked);
        this.isEndOfPurposeBlocked = isEndOfPurposeBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierConfirmationControlKey</b>
     * </p>
     *
     * @param supplierConfirmationControlKey
     *            Confirmation Control Key
     */
    public void setSupplierConfirmationControlKey( @Nullable final String supplierConfirmationControlKey )
    {
        rememberChangedField("SupplierConfirmationControlKey", this.supplierConfirmationControlKey);
        this.supplierConfirmationControlKey = supplierConfirmationControlKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingDateControl</b>
     * </p>
     *
     * @param pricingDateControl
     *            Price Determination (Pricing) Date Control
     */
    public void setPricingDateControl( @Nullable final String pricingDateControl )
    {
        rememberChangedField("PricingDateControl", this.pricingDateControl);
        this.pricingDateControl = pricingDateControl;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TimeDependentTaxValidFromDate</b>
     * </p>
     *
     * @param timeDependentTaxValidFromDate
     *            Valid-From Date of the Tax Rate
     */
    public void setTimeDependentTaxValidFromDate( @Nullable final LocalDateTime timeDependentTaxValidFromDate )
    {
        rememberChangedField("TimeDependentTaxValidFromDate", this.timeDependentTaxValidFromDate);
        this.timeDependentTaxValidFromDate = timeDependentTaxValidFromDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     *
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgInfoRecdOrgPlantData";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        result.put("PurchasingInfoRecordCategory", getPurchasingInfoRecordCategory());
        result.put("PurchasingOrganization", getPurchasingOrganization());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("PurchasingInfoRecordCategory", getPurchasingInfoRecordCategory());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("Plant", getPlant());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("Currency", getCurrency());
        values.put("MinimumPurchaseOrderQuantity", getMinimumPurchaseOrderQuantity());
        values.put("StandardPurchaseOrderQuantity", getStandardPurchaseOrderQuantity());
        values.put("MaterialPlannedDeliveryDurn", getMaterialPlannedDeliveryDurn());
        values.put("OverdelivTolrtdLmtRatioInPct", getOverdelivTolrtdLmtRatioInPct());
        values.put("UnderdelivTolrtdLmtRatioInPct", getUnderdelivTolrtdLmtRatioInPct());
        values.put("UnlimitedOverdeliveryIsAllowed", getUnlimitedOverdeliveryIsAllowed());
        values.put("LastReferencingPurchaseOrder", getLastReferencingPurchaseOrder());
        values.put("LastReferencingPurOrderItem", getLastReferencingPurOrderItem());
        values.put("Material", getMaterial());
        values.put("Supplier", getSupplier());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("PurgDocOrderQuantityUnit", getPurgDocOrderQuantityUnit());
        values.put("NetPriceQuantityUnit", getNetPriceQuantityUnit());
        values.put("NetPriceAmount", getNetPriceAmount());
        values.put("MaterialPriceUnitQty", getMaterialPriceUnitQty());
        values.put("PurchaseOrderPriceUnit", getPurchaseOrderPriceUnit());
        values.put("PriceValidityEndDate", getPriceValidityEndDate());
        values.put("InvoiceIsGoodsReceiptBased", getInvoiceIsGoodsReceiptBased());
        values.put("TaxCode", getTaxCode());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("MaximumOrderQuantity", getMaximumOrderQuantity());
        values.put("IsRelevantForAutomSrcg", getIsRelevantForAutomSrcg());
        values.put("SupplierQuotation", getSupplierQuotation());
        values.put("SupplierQuotationDate", getSupplierQuotationDate());
        values.put("MinRemainingShelfLife", getMinRemainingShelfLife());
        values.put("IsEvaluatedRcptSettlmtAllowed", getIsEvaluatedRcptSettlmtAllowed());
        values.put("IsPurOrderAllwdForInbDeliv", getIsPurOrderAllwdForInbDeliv());
        values.put("IsOrderAcknRqd", getIsOrderAcknRqd());
        values.put("IsRetMatlAuthznRqdBySupplier", getIsRetMatlAuthznRqdBySupplier());
        values.put("IsCashDiscountGranted", getIsCashDiscountGranted());
        values.put("MaterialConditionGroup", getMaterialConditionGroup());
        values.put("PurchasingDocumentDate", getPurchasingDocumentDate());
        values.put("ShelfLifeExpirationDatePeriod", getShelfLifeExpirationDatePeriod());
        values.put("IsEndOfPurposeBlocked", getIsEndOfPurposeBlocked());
        values.put("SupplierConfirmationControlKey", getSupplierConfirmationControlKey());
        values.put("PricingDateControl", getPricingDateControl());
        values.put("TimeDependentTaxValidFromDate", getTimeDependentTaxValidFromDate());
        values.put("TaxCountry", getTaxCountry());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecordCategory") ) {
                final Object value = values.remove("PurchasingInfoRecordCategory");
                if( (value == null) || (!value.equals(getPurchasingInfoRecordCategory())) ) {
                    setPurchasingInfoRecordCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("MinimumPurchaseOrderQuantity") ) {
                final Object value = values.remove("MinimumPurchaseOrderQuantity");
                if( (value == null) || (!value.equals(getMinimumPurchaseOrderQuantity())) ) {
                    setMinimumPurchaseOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("StandardPurchaseOrderQuantity") ) {
                final Object value = values.remove("StandardPurchaseOrderQuantity");
                if( (value == null) || (!value.equals(getStandardPurchaseOrderQuantity())) ) {
                    setStandardPurchaseOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialPlannedDeliveryDurn") ) {
                final Object value = values.remove("MaterialPlannedDeliveryDurn");
                if( (value == null) || (!value.equals(getMaterialPlannedDeliveryDurn())) ) {
                    setMaterialPlannedDeliveryDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("OverdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("OverdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getOverdelivTolrtdLmtRatioInPct())) ) {
                    setOverdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnderdelivTolrtdLmtRatioInPct") ) {
                final Object value = values.remove("UnderdelivTolrtdLmtRatioInPct");
                if( (value == null) || (!value.equals(getUnderdelivTolrtdLmtRatioInPct())) ) {
                    setUnderdelivTolrtdLmtRatioInPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnlimitedOverdeliveryIsAllowed") ) {
                final Object value = values.remove("UnlimitedOverdeliveryIsAllowed");
                if( (value == null) || (!value.equals(getUnlimitedOverdeliveryIsAllowed())) ) {
                    setUnlimitedOverdeliveryIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("LastReferencingPurchaseOrder") ) {
                final Object value = values.remove("LastReferencingPurchaseOrder");
                if( (value == null) || (!value.equals(getLastReferencingPurchaseOrder())) ) {
                    setLastReferencingPurchaseOrder(((String) value));
                }
            }
            if( values.containsKey("LastReferencingPurOrderItem") ) {
                final Object value = values.remove("LastReferencingPurOrderItem");
                if( (value == null) || (!value.equals(getLastReferencingPurOrderItem())) ) {
                    setLastReferencingPurOrderItem(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("PurgDocOrderQuantityUnit") ) {
                final Object value = values.remove("PurgDocOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurgDocOrderQuantityUnit())) ) {
                    setPurgDocOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("NetPriceQuantityUnit") ) {
                final Object value = values.remove("NetPriceQuantityUnit");
                if( (value == null) || (!value.equals(getNetPriceQuantityUnit())) ) {
                    setNetPriceQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("NetPriceAmount") ) {
                final Object value = values.remove("NetPriceAmount");
                if( (value == null) || (!value.equals(getNetPriceAmount())) ) {
                    setNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialPriceUnitQty") ) {
                final Object value = values.remove("MaterialPriceUnitQty");
                if( (value == null) || (!value.equals(getMaterialPriceUnitQty())) ) {
                    setMaterialPriceUnitQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseOrderPriceUnit") ) {
                final Object value = values.remove("PurchaseOrderPriceUnit");
                if( (value == null) || (!value.equals(getPurchaseOrderPriceUnit())) ) {
                    setPurchaseOrderPriceUnit(((String) value));
                }
            }
            if( values.containsKey("PriceValidityEndDate") ) {
                final Object value = values.remove("PriceValidityEndDate");
                if( (value == null) || (!value.equals(getPriceValidityEndDate())) ) {
                    setPriceValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InvoiceIsGoodsReceiptBased") ) {
                final Object value = values.remove("InvoiceIsGoodsReceiptBased");
                if( (value == null) || (!value.equals(getInvoiceIsGoodsReceiptBased())) ) {
                    setInvoiceIsGoodsReceiptBased(((Boolean) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("MaximumOrderQuantity") ) {
                final Object value = values.remove("MaximumOrderQuantity");
                if( (value == null) || (!value.equals(getMaximumOrderQuantity())) ) {
                    setMaximumOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("IsRelevantForAutomSrcg") ) {
                final Object value = values.remove("IsRelevantForAutomSrcg");
                if( (value == null) || (!value.equals(getIsRelevantForAutomSrcg())) ) {
                    setIsRelevantForAutomSrcg(((String) value));
                }
            }
            if( values.containsKey("SupplierQuotation") ) {
                final Object value = values.remove("SupplierQuotation");
                if( (value == null) || (!value.equals(getSupplierQuotation())) ) {
                    setSupplierQuotation(((String) value));
                }
            }
            if( values.containsKey("SupplierQuotationDate") ) {
                final Object value = values.remove("SupplierQuotationDate");
                if( (value == null) || (!value.equals(getSupplierQuotationDate())) ) {
                    setSupplierQuotationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MinRemainingShelfLife") ) {
                final Object value = values.remove("MinRemainingShelfLife");
                if( (value == null) || (!value.equals(getMinRemainingShelfLife())) ) {
                    setMinRemainingShelfLife(((BigDecimal) value));
                }
            }
            if( values.containsKey("IsEvaluatedRcptSettlmtAllowed") ) {
                final Object value = values.remove("IsEvaluatedRcptSettlmtAllowed");
                if( (value == null) || (!value.equals(getIsEvaluatedRcptSettlmtAllowed())) ) {
                    setIsEvaluatedRcptSettlmtAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("IsPurOrderAllwdForInbDeliv") ) {
                final Object value = values.remove("IsPurOrderAllwdForInbDeliv");
                if( (value == null) || (!value.equals(getIsPurOrderAllwdForInbDeliv())) ) {
                    setIsPurOrderAllwdForInbDeliv(((Boolean) value));
                }
            }
            if( values.containsKey("IsOrderAcknRqd") ) {
                final Object value = values.remove("IsOrderAcknRqd");
                if( (value == null) || (!value.equals(getIsOrderAcknRqd())) ) {
                    setIsOrderAcknRqd(((Boolean) value));
                }
            }
            if( values.containsKey("IsRetMatlAuthznRqdBySupplier") ) {
                final Object value = values.remove("IsRetMatlAuthznRqdBySupplier");
                if( (value == null) || (!value.equals(getIsRetMatlAuthznRqdBySupplier())) ) {
                    setIsRetMatlAuthznRqdBySupplier(((String) value));
                }
            }
            if( values.containsKey("IsCashDiscountGranted") ) {
                final Object value = values.remove("IsCashDiscountGranted");
                if( (value == null) || (!value.equals(getIsCashDiscountGranted())) ) {
                    setIsCashDiscountGranted(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialConditionGroup") ) {
                final Object value = values.remove("MaterialConditionGroup");
                if( (value == null) || (!value.equals(getMaterialConditionGroup())) ) {
                    setMaterialConditionGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentDate") ) {
                final Object value = values.remove("PurchasingDocumentDate");
                if( (value == null) || (!value.equals(getPurchasingDocumentDate())) ) {
                    setPurchasingDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShelfLifeExpirationDatePeriod") ) {
                final Object value = values.remove("ShelfLifeExpirationDatePeriod");
                if( (value == null) || (!value.equals(getShelfLifeExpirationDatePeriod())) ) {
                    setShelfLifeExpirationDatePeriod(((String) value));
                }
            }
            if( values.containsKey("IsEndOfPurposeBlocked") ) {
                final Object value = values.remove("IsEndOfPurposeBlocked");
                if( (value == null) || (!value.equals(getIsEndOfPurposeBlocked())) ) {
                    setIsEndOfPurposeBlocked(((String) value));
                }
            }
            if( values.containsKey("SupplierConfirmationControlKey") ) {
                final Object value = values.remove("SupplierConfirmationControlKey");
                if( (value == null) || (!value.equals(getSupplierConfirmationControlKey())) ) {
                    setSupplierConfirmationControlKey(((String) value));
                }
            }
            if( values.containsKey("PricingDateControl") ) {
                final Object value = values.remove("PricingDateControl");
                if( (value == null) || (!value.equals(getPricingDateControl())) ) {
                    setPricingDateControl(((String) value));
                }
            }
            if( values.containsKey("TimeDependentTaxValidFromDate") ) {
                final Object value = values.remove("TimeDependentTaxValidFromDate");
                if( (value == null) || (!value.equals(getTimeDependentTaxValidFromDate())) ) {
                    setTimeDependentTaxValidFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurgInfoRecd") ) {
                final Object value = (values).remove("to_PurgInfoRecd");
                if( value instanceof Map ) {
                    if( toPurgInfoRecd == null ) {
                        toPurgInfoRecd = new PurchasingInfoRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgInfoRecd.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurInfoRecdPrcgCndnValidity") ) {
                final Object value = (values).remove("to_PurInfoRecdPrcgCndnValidity");
                if( value instanceof Iterable ) {
                    if( toPurInfoRecdPrcgCndnValidity == null ) {
                        toPurInfoRecdPrcgCndnValidity = Lists.newArrayList();
                    } else {
                        toPurInfoRecdPrcgCndnValidity = Lists.newArrayList(toPurInfoRecdPrcgCndnValidity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurInfoRecdPrcgCndnValidity entity;
                        if( toPurInfoRecdPrcgCndnValidity.size() > i ) {
                            entity = toPurInfoRecdPrcgCndnValidity.get(i);
                        } else {
                            entity = new PurInfoRecdPrcgCndnValidity();
                            toPurInfoRecdPrcgCndnValidity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgInfoRecdOrgPlantDataField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgInfoRecdOrgPlantDataField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgInfoRecdOrgPlantDataField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgInfoRecdOrgPlantDataField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurgInfoRecd != null ) {
            (values).put("to_PurgInfoRecd", toPurgInfoRecd);
        }
        if( toPurInfoRecdPrcgCndnValidity != null ) {
            (values).put("to_PurInfoRecdPrcgCndnValidity", toPurInfoRecdPrcgCndnValidity);
        }
        return values;
    }

    /**
     * Fetches the <b>PurchasingInfoRecord</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurgInfoRecd</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurchasingInfoRecord</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchasingInfoRecord fetchPurgInfoRecd()
    {
        return fetchFieldAsSingle("to_PurgInfoRecd", PurchasingInfoRecord.class);
    }

    /**
     * Retrieval of associated <b>PurchasingInfoRecord</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurgInfoRecd</b>.
     * <p>
     * If the navigation property <b>to_PurgInfoRecd</b> of a queried <b>PurgInfoRecdOrgPlantData</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchasingInfoRecord</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchasingInfoRecord getPurgInfoRecdOrFetch()
    {
        if( toPurgInfoRecd == null ) {
            toPurgInfoRecd = fetchPurgInfoRecd();
        }
        return toPurgInfoRecd;
    }

    /**
     * Retrieval of associated <b>PurchasingInfoRecord</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurgInfoRecd</b>.
     * <p>
     * If the navigation property for an entity <b>PurgInfoRecdOrgPlantData</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgInfoRecd</b> is already loaded, the result will
     *         contain the <b>PurchasingInfoRecord</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurchasingInfoRecord> getPurgInfoRecdIfPresent()
    {
        return Option.of(toPurgInfoRecd);
    }

    /**
     * Overwrites the associated <b>PurchasingInfoRecord</b> entity for the loaded navigation property
     * <b>to_PurgInfoRecd</b>.
     *
     * @param value
     *            New <b>PurchasingInfoRecord</b> entity.
     */
    public void setPurgInfoRecd( final PurchasingInfoRecord value )
    {
        toPurgInfoRecd = value;
    }

    /**
     * Fetches the <b>PurInfoRecdPrcgCndnValidity</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PurInfoRecdPrcgCndnValidity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurInfoRecdPrcgCndnValidity</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurInfoRecdPrcgCndnValidity> fetchPurInfoRecdPrcgCndnValidity()
    {
        return fetchFieldAsList("to_PurInfoRecdPrcgCndnValidity", PurInfoRecdPrcgCndnValidity.class);
    }

    /**
     * Retrieval of associated <b>PurInfoRecdPrcgCndnValidity</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurInfoRecdPrcgCndnValidity</b>.
     * <p>
     * If the navigation property <b>to_PurInfoRecdPrcgCndnValidity</b> of a queried <b>PurgInfoRecdOrgPlantData</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurInfoRecdPrcgCndnValidity</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurInfoRecdPrcgCndnValidity> getPurInfoRecdPrcgCndnValidityOrFetch()
    {
        if( toPurInfoRecdPrcgCndnValidity == null ) {
            toPurInfoRecdPrcgCndnValidity = fetchPurInfoRecdPrcgCndnValidity();
        }
        return toPurInfoRecdPrcgCndnValidity;
    }

    /**
     * Retrieval of associated <b>PurInfoRecdPrcgCndnValidity</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurInfoRecdPrcgCndnValidity</b>.
     * <p>
     * If the navigation property for an entity <b>PurgInfoRecdOrgPlantData</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurInfoRecdPrcgCndnValidity</b> is already loaded, the
     *         result will contain the <b>PurInfoRecdPrcgCndnValidity</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurInfoRecdPrcgCndnValidity>> getPurInfoRecdPrcgCndnValidityIfPresent()
    {
        return Option.of(toPurInfoRecdPrcgCndnValidity);
    }

    /**
     * Overwrites the list of associated <b>PurInfoRecdPrcgCndnValidity</b> entities for the loaded navigation property
     * <b>to_PurInfoRecdPrcgCndnValidity</b>.
     * <p>
     * If the navigation property <b>to_PurInfoRecdPrcgCndnValidity</b> of a queried <b>PurgInfoRecdOrgPlantData</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurInfoRecdPrcgCndnValidity</b> entities.
     */
    public void setPurInfoRecdPrcgCndnValidity( @Nonnull final List<PurInfoRecdPrcgCndnValidity> value )
    {
        if( toPurInfoRecdPrcgCndnValidity == null ) {
            toPurInfoRecdPrcgCndnValidity = Lists.newArrayList();
        }
        toPurInfoRecdPrcgCndnValidity.clear();
        toPurInfoRecdPrcgCndnValidity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurInfoRecdPrcgCndnValidity</b> entities. This corresponds to the
     * OData navigation property <b>to_PurInfoRecdPrcgCndnValidity</b>.
     * <p>
     * If the navigation property <b>to_PurInfoRecdPrcgCndnValidity</b> of a queried <b>PurgInfoRecdOrgPlantData</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurInfoRecdPrcgCndnValidity</b> entities.
     */
    public void addPurInfoRecdPrcgCndnValidity( PurInfoRecdPrcgCndnValidity... entity )
    {
        if( toPurInfoRecdPrcgCndnValidity == null ) {
            toPurInfoRecdPrcgCndnValidity = Lists.newArrayList();
        }
        toPurInfoRecdPrcgCndnValidity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurgInfoRecdOrgPlantData instances.
     *
     */
    public final static class PurgInfoRecdOrgPlantDataBuilder
    {

        private PurchasingInfoRecord toPurgInfoRecd;
        private List<PurInfoRecdPrcgCndnValidity> toPurInfoRecdPrcgCndnValidity = Lists.newArrayList();

        private PurgInfoRecdOrgPlantData.PurgInfoRecdOrgPlantDataBuilder toPurgInfoRecd(
            final PurchasingInfoRecord value )
        {
            toPurgInfoRecd = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgInfoRecd</b> for <b>PurgInfoRecdOrgPlantData</b> to single
         * <b>PurchasingInfoRecord</b>.
         *
         * @param value
         *            The PurchasingInfoRecord to build this PurgInfoRecdOrgPlantData with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgInfoRecdOrgPlantData.PurgInfoRecdOrgPlantDataBuilder purgInfoRecd( final PurchasingInfoRecord value )
        {
            return toPurgInfoRecd(value);
        }

        private PurgInfoRecdOrgPlantData.PurgInfoRecdOrgPlantDataBuilder toPurInfoRecdPrcgCndnValidity(
            final List<PurInfoRecdPrcgCndnValidity> value )
        {
            toPurInfoRecdPrcgCndnValidity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurInfoRecdPrcgCndnValidity</b> for <b>PurgInfoRecdOrgPlantData</b> to multiple
         * <b>PurInfoRecdPrcgCndnValidity</b>.
         *
         * @param value
         *            The PurInfoRecdPrcgCndnValiditys to build this PurgInfoRecdOrgPlantData with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgInfoRecdOrgPlantData.PurgInfoRecdOrgPlantDataBuilder purInfoRecdPrcgCndnValidity(
            PurInfoRecdPrcgCndnValidity... value )
        {
            return toPurInfoRecdPrcgCndnValidity(Lists.newArrayList(value));
        }

    }

}
