/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.selectable.PurgInfoRecdOrgPlantDataSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
 * PurgInfoRecdOrgPlantData} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class PurgInfoRecdOrgPlantDataByKeyFluentHelper
    extends
    FluentHelperByKey<PurgInfoRecdOrgPlantDataByKeyFluentHelper, PurgInfoRecdOrgPlantData, PurgInfoRecdOrgPlantDataSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     * PurgInfoRecdOrgPlantData} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurgInfoRecdOrgPlantData}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurgInfoRecdOrgPlantData}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchasingOrganization
     *            Purchasing Organization
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param purchasingInfoRecordCategory
     *            Purchasing info record category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public PurgInfoRecdOrgPlantDataByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String purchasingInfoRecord,
        final String purchasingInfoRecordCategory,
        final String purchasingOrganization,
        final String plant )
    {
        super(servicePath, entityCollection);
        this.key.put("PurchasingInfoRecord", purchasingInfoRecord);
        this.key.put("PurchasingInfoRecordCategory", purchasingInfoRecordCategory);
        this.key.put("PurchasingOrganization", purchasingOrganization);
        this.key.put("Plant", plant);
    }

    @Override
    @Nonnull
    protected Class<PurgInfoRecdOrgPlantData> getEntityClass()
    {
        return PurgInfoRecdOrgPlantData.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
