/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PurchasingInfoRecordServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService PurchasingInfoRecordService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPurchasingInfoRecordServiceBatch
    extends
    BatchFluentHelperBasic<PurchasingInfoRecordServiceBatch, PurchasingInfoRecordServiceBatchChangeSet>
    implements
    PurchasingInfoRecordServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPurchasingInfoRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingInfoRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPurchasingInfoRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingInfoRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingInfoRecordServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPurchasingInfoRecordServiceBatchChangeSet(this, service);
    }

}
