/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData;

/**
 * Implementation of the {@link PurchasingInfoRecordServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService PurchasingInfoRecordService}.
 *
 */
public class DefaultPurchasingInfoRecordServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PurchasingInfoRecordServiceBatch, PurchasingInfoRecordServiceBatchChangeSet>
    implements
    PurchasingInfoRecordServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService service;

    @SuppressWarnings( "deprecation" )
    DefaultPurchasingInfoRecordServiceBatchChangeSet(
        @Nonnull final DefaultPurchasingInfoRecordServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingInfoRecordServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet createPurchasingInfoRecord(
        @Nonnull final PurchasingInfoRecord purchasingInfoRecord )
    {
        return addRequestCreate(service::createPurchasingInfoRecord, purchasingInfoRecord);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet updatePurchasingInfoRecord(
        @Nonnull final PurchasingInfoRecord purchasingInfoRecord )
    {
        return addRequestUpdate(service::updatePurchasingInfoRecord, purchasingInfoRecord);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet createPurgInfoRecdOrgPlantData(
        @Nonnull final PurgInfoRecdOrgPlantData purgInfoRecdOrgPlantData )
    {
        return addRequestCreate(service::createPurgInfoRecdOrgPlantData, purgInfoRecdOrgPlantData);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet updatePurgInfoRecdOrgPlantData(
        @Nonnull final PurgInfoRecdOrgPlantData purgInfoRecdOrgPlantData )
    {
        return addRequestUpdate(service::updatePurgInfoRecdOrgPlantData, purgInfoRecdOrgPlantData);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet createPurInfoRecdPrcgCndn(
        @Nonnull final PurInfoRecdPrcgCndn purInfoRecdPrcgCndn )
    {
        return addRequestCreate(service::createPurInfoRecdPrcgCndn, purInfoRecdPrcgCndn);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet updatePurInfoRecdPrcgCndn(
        @Nonnull final PurInfoRecdPrcgCndn purInfoRecdPrcgCndn )
    {
        return addRequestUpdate(service::updatePurInfoRecdPrcgCndn, purInfoRecdPrcgCndn);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet createPurInfoRecdPrcgCndnScale(
        @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale )
    {
        return addRequestCreate(service::createPurInfoRecdPrcgCndnScale, purInfoRecdPrcgCndnScale);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet updatePurInfoRecdPrcgCndnScale(
        @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale )
    {
        return addRequestUpdate(service::updatePurInfoRecdPrcgCndnScale, purInfoRecdPrcgCndnScale);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet deletePurInfoRecdPrcgCndnScale(
        @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale )
    {
        return addRequestDelete(service::deletePurInfoRecdPrcgCndnScale, purInfoRecdPrcgCndnScale);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet createPurInfoRecdPrcgCndnValidity(
        @Nonnull final PurInfoRecdPrcgCndnValidity purInfoRecdPrcgCndnValidity )
    {
        return addRequestCreate(service::createPurInfoRecdPrcgCndnValidity, purInfoRecdPrcgCndnValidity);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet updatePurInfoRecdPrcgCndnValidity(
        @Nonnull final PurInfoRecdPrcgCndnValidity purInfoRecdPrcgCndnValidity )
    {
        return addRequestUpdate(service::updatePurInfoRecdPrcgCndnValidity, purInfoRecdPrcgCndnValidity);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet createPurInfoRecdSuplmntPrcgCndn(
        @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn )
    {
        return addRequestCreate(service::createPurInfoRecdSuplmntPrcgCndn, purInfoRecdSuplmntPrcgCndn);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet updatePurInfoRecdSuplmntPrcgCndn(
        @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn )
    {
        return addRequestUpdate(service::updatePurInfoRecdSuplmntPrcgCndn, purInfoRecdSuplmntPrcgCndn);
    }

    @Nonnull
    @Override
    public PurchasingInfoRecordServiceBatchChangeSet deletePurInfoRecdSuplmntPrcgCndn(
        @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn )
    {
        return addRequestDelete(service::deletePurInfoRecdSuplmntPrcgCndn, purInfoRecdSuplmntPrcgCndn);
    }

}
