/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingInfoRecordService
 * PurchasingInfoRecordService}.
 *
 */
public interface PurchasingInfoRecordServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PurchasingInfoRecordServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PurchasingInfoRecordServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     * PurchasingInfoRecord} entity and save it to the S/4HANA system.
     *
     * @param purchasingInfoRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     *            PurchasingInfoRecord} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        createPurchasingInfoRecord( @Nonnull final PurchasingInfoRecord purchasingInfoRecord );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     * PurchasingInfoRecord} entity and save it to the S/4HANA system.
     *
     * @param purchasingInfoRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
     *            PurchasingInfoRecord} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        updatePurchasingInfoRecord( @Nonnull final PurchasingInfoRecord purchasingInfoRecord );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     * PurgInfoRecdOrgPlantData} entity and save it to the S/4HANA system.
     *
     * @param purgInfoRecdOrgPlantData
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     *            PurgInfoRecdOrgPlantData} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        createPurgInfoRecdOrgPlantData( @Nonnull final PurgInfoRecdOrgPlantData purgInfoRecdOrgPlantData );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     * PurgInfoRecdOrgPlantData} entity and save it to the S/4HANA system.
     *
     * @param purgInfoRecdOrgPlantData
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
     *            PurgInfoRecdOrgPlantData} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        updatePurgInfoRecdOrgPlantData( @Nonnull final PurgInfoRecdOrgPlantData purgInfoRecdOrgPlantData );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     * PurInfoRecdPrcgCndn} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     *            PurInfoRecdPrcgCndn} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        createPurInfoRecdPrcgCndn( @Nonnull final PurInfoRecdPrcgCndn purInfoRecdPrcgCndn );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     * PurInfoRecdPrcgCndn} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndn
     *            PurInfoRecdPrcgCndn} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        updatePurInfoRecdPrcgCndn( @Nonnull final PurInfoRecdPrcgCndn purInfoRecdPrcgCndn );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     * PurInfoRecdPrcgCndnScale} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *            PurInfoRecdPrcgCndnScale} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        createPurInfoRecdPrcgCndnScale( @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     * PurInfoRecdPrcgCndnScale} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *            PurInfoRecdPrcgCndnScale} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        updatePurInfoRecdPrcgCndnScale( @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     * PurInfoRecdPrcgCndnScale} entity in the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
     *            PurInfoRecdPrcgCndnScale} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        deletePurInfoRecdPrcgCndnScale( @Nonnull final PurInfoRecdPrcgCndnScale purInfoRecdPrcgCndnScale );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     * PurInfoRecdPrcgCndnValidity} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnValidity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     *            PurInfoRecdPrcgCndnValidity} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        createPurInfoRecdPrcgCndnValidity( @Nonnull final PurInfoRecdPrcgCndnValidity purInfoRecdPrcgCndnValidity );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     * PurInfoRecdPrcgCndnValidity} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdPrcgCndnValidity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnValidity
     *            PurInfoRecdPrcgCndnValidity} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        updatePurInfoRecdPrcgCndnValidity( @Nonnull final PurInfoRecdPrcgCndnValidity purInfoRecdPrcgCndnValidity );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     * PurInfoRecdSuplmntPrcgCndn} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdSuplmntPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *            PurInfoRecdSuplmntPrcgCndn} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        createPurInfoRecdSuplmntPrcgCndn( @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     * PurInfoRecdSuplmntPrcgCndn} entity and save it to the S/4HANA system.
     *
     * @param purInfoRecdSuplmntPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *            PurInfoRecdSuplmntPrcgCndn} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        updatePurInfoRecdSuplmntPrcgCndn( @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     * PurInfoRecdSuplmntPrcgCndn} entity in the S/4HANA system.
     *
     * @param purInfoRecdSuplmntPrcgCndn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdSuplmntPrcgCndn
     *            PurInfoRecdSuplmntPrcgCndn} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingInfoRecordServiceBatchChangeSet
        deletePurInfoRecdSuplmntPrcgCndn( @Nonnull final PurInfoRecdSuplmntPrcgCndn purInfoRecdSuplmntPrcgCndn );

}
