/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale
 * PurInfoRecdPrcgCndnScale}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.field.PurInfoRecdPrcgCndnScaleField
 * PurInfoRecdPrcgCndnScaleField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.link.PurInfoRecdPrcgCndnScaleLink
 * PurInfoRecdPrcgCndnScaleLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_SCALE_LINE
 * CONDITION_SCALE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_SCALE_QUANTITY
 * CONDITION_SCALE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_SCALE_QUANTITY_UNIT
 * CONDITION_SCALE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_SCALE_AMOUNT
 * CONDITION_SCALE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_SCALE_AMOUNT_CURRENCY
 * CONDITION_SCALE_AMOUNT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_RATE_VALUE_UNIT
 * CONDITION_RATE_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_RATE_RATIO_UNIT
 * CONDITION_RATE_RATIO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_RATE_RATIO
 * CONDITION_RATE_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_RATE_AMOUNT
 * CONDITION_RATE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurInfoRecdPrcgCndnScale#CONDITION_SCALE_IS_DELETED
 * CONDITION_SCALE_IS_DELETED}</li>
 * </ul>
 *
 */
public interface PurInfoRecdPrcgCndnScaleSelectable extends EntitySelectable<PurInfoRecdPrcgCndnScale>
{

}
