/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord
 * PurchasingInfoRecord}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.field.PurchasingInfoRecordField
 * PurchasingInfoRecordField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.link.PurchasingInfoRecordLink
 * PurchasingInfoRecordLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#PURCHASING_INFO_RECORD
 * PURCHASING_INFO_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#PURCHASING_INFO_RECORD_DESC
 * PURCHASING_INFO_RECORD_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#PURG_INFO_REC_NON_STOCK_ITM_SORT_TERM
 * PURG_INFO_REC_NON_STOCK_ITM_SORT_TERM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#PURG_DOC_ORDER_QUANTITY_UNIT
 * PURG_DOC_ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#ORDER_ITEM_QTY_TO_BASE_QTY_NMRTR
 * ORDER_ITEM_QTY_TO_BASE_QTY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#ORDER_ITEM_QTY_TO_BASE_QTY_DNMNTR
 * ORDER_ITEM_QTY_TO_BASE_QTY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#SUPPLIER_MATERIAL_NUMBER
 * SUPPLIER_MATERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#SUPPLIER_RESP_SALES_PERSON_NAME
 * SUPPLIER_RESP_SALES_PERSON_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#SUPPLIER_PHONE_NUMBER
 * SUPPLIER_PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#SUPPLIER_MATERIAL_GROUP
 * SUPPLIER_MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#PRIOR_SUPPLIER
 * PRIOR_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#AVAILABILITY_START_DATE
 * AVAILABILITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#AVAILABILITY_END_DATE
 * AVAILABILITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#VARBL_PUR_ORD_UNIT_IS_ACTIVE
 * VARBL_PUR_ORD_UNIT_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#MANUFACTURER
 * MANUFACTURER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#IS_REGULAR_SUPPLIER
 * IS_REGULAR_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#SUPPLIER_SUBRANGE
 * SUPPLIER_SUBRANGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#NO_DAYS_REMINDER1
 * NO_DAYS_REMINDER1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#NO_DAYS_REMINDER2
 * NO_DAYS_REMINDER2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#NO_DAYS_REMINDER3
 * NO_DAYS_REMINDER3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#PRODUCT_PURCHASE_POINTS_QTY
 * PRODUCT_PURCHASE_POINTS_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#PRODUCT_PURCHASE_POINTS_QTY_UNIT
 * PRODUCT_PURCHASE_POINTS_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#SUPPLIER_SUBRANGE_SORT_NUMBER
 * SUPPLIER_SUBRANGE_SORT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#IS_END_OF_PURPOSE_BLOCKED
 * IS_END_OF_PURPOSE_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurchasingInfoRecord#TO_PURG_INFO_RECD_ORG_PLANT_DATA
 * TO_PURG_INFO_RECD_ORG_PLANT_DATA}</li>
 * </ul>
 *
 */
public interface PurchasingInfoRecordSelectable extends EntitySelectable<PurchasingInfoRecord>
{

}
