/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData
 * PurgInfoRecdOrgPlantData}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.field.PurgInfoRecdOrgPlantDataField
 * PurgInfoRecdOrgPlantDataField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.link.PurgInfoRecdOrgPlantDataLink
 * PurgInfoRecdOrgPlantDataLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PURCHASING_INFO_RECORD
 * PURCHASING_INFO_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PURCHASING_INFO_RECORD_CATEGORY
 * PURCHASING_INFO_RECORD_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#MINIMUM_PURCHASE_ORDER_QUANTITY
 * MINIMUM_PURCHASE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#STANDARD_PURCHASE_ORDER_QUANTITY
 * STANDARD_PURCHASE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#MATERIAL_PLANNED_DELIVERY_DURN
 * MATERIAL_PLANNED_DELIVERY_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT
 * UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#UNLIMITED_OVERDELIVERY_IS_ALLOWED
 * UNLIMITED_OVERDELIVERY_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#LAST_REFERENCING_PURCHASE_ORDER
 * LAST_REFERENCING_PURCHASE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#LAST_REFERENCING_PUR_ORDER_ITEM
 * LAST_REFERENCING_PUR_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PURG_DOC_ORDER_QUANTITY_UNIT
 * PURG_DOC_ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#NET_PRICE_QUANTITY_UNIT
 * NET_PRICE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#NET_PRICE_AMOUNT
 * NET_PRICE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#MATERIAL_PRICE_UNIT_QTY
 * MATERIAL_PRICE_UNIT_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PURCHASE_ORDER_PRICE_UNIT
 * PURCHASE_ORDER_PRICE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PRICE_VALIDITY_END_DATE
 * PRICE_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#INVOICE_IS_GOODS_RECEIPT_BASED
 * INVOICE_IS_GOODS_RECEIPT_BASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#MAXIMUM_ORDER_QUANTITY
 * MAXIMUM_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#IS_RELEVANT_FOR_AUTOM_SRCG
 * IS_RELEVANT_FOR_AUTOM_SRCG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#SUPPLIER_QUOTATION
 * SUPPLIER_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#SUPPLIER_QUOTATION_DATE
 * SUPPLIER_QUOTATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#MIN_REMAINING_SHELF_LIFE
 * MIN_REMAINING_SHELF_LIFE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#IS_EVALUATED_RCPT_SETTLMT_ALLOWED
 * IS_EVALUATED_RCPT_SETTLMT_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#IS_PUR_ORDER_ALLWD_FOR_INB_DELIV
 * IS_PUR_ORDER_ALLWD_FOR_INB_DELIV}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#IS_ORDER_ACKN_RQD
 * IS_ORDER_ACKN_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#IS_RET_MATL_AUTHZN_RQD_BY_SUPPLIER
 * IS_RET_MATL_AUTHZN_RQD_BY_SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#IS_CASH_DISCOUNT_GRANTED
 * IS_CASH_DISCOUNT_GRANTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#MATERIAL_CONDITION_GROUP
 * MATERIAL_CONDITION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PURCHASING_DOCUMENT_DATE
 * PURCHASING_DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#SHELF_LIFE_EXPIRATION_DATE_PERIOD
 * SHELF_LIFE_EXPIRATION_DATE_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#IS_END_OF_PURPOSE_BLOCKED
 * IS_END_OF_PURPOSE_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#SUPPLIER_CONFIRMATION_CONTROL_KEY
 * SUPPLIER_CONFIRMATION_CONTROL_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#PRICING_DATE_CONTROL
 * PRICING_DATE_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#TIME_DEPENDENT_TAX_VALID_FROM_DATE
 * TIME_DEPENDENT_TAX_VALID_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#TAX_COUNTRY
 * TAX_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#TO_PURG_INFO_RECD
 * TO_PURG_INFO_RECD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasinginforecord.PurgInfoRecdOrgPlantData#TO_PUR_INFO_RECD_PRCG_CNDN_VALIDITY
 * TO_PUR_INFO_RECD_PRCG_CNDN_VALIDITY}</li>
 * </ul>
 *
 */
public interface PurgInfoRecdOrgPlantDataSelectable extends EntitySelectable<PurgInfoRecdOrgPlantData>
{

}
