/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.selectable.PurgPrcgCndnRecdSuplmntSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
 * PurgPrcgCndnRecdSuplmnt} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class PurgPrcgCndnRecdSuplmntByKeyFluentHelper
    extends
    FluentHelperByKey<PurgPrcgCndnRecdSuplmntByKeyFluentHelper, PurgPrcgCndnRecdSuplmnt, PurgPrcgCndnRecdSuplmntSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
     * PurgPrcgCndnRecdSuplmnt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurgPrcgCndnRecdSuplmnt}
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurgPrcgCndnRecdSuplmnt}
     * @param conditionRecord
     *            Number of Condition Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public PurgPrcgCndnRecdSuplmntByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String conditionRecord,
        final String conditionSequentialNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("ConditionRecord", conditionRecord);
        this.key.put("ConditionSequentialNumber", conditionSequentialNumber);
    }

    @Override
    @Nonnull
    protected Class<PurgPrcgCndnRecdSuplmnt> getEntityClass()
    {
        return PurgPrcgCndnRecdSuplmnt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
