/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
 * PurgPrcgCndnRecdSuplmnt} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class PurgPrcgCndnRecdSuplmntUpdateFluentHelper
    extends
    FluentHelperUpdate<PurgPrcgCndnRecdSuplmntUpdateFluentHelper, PurgPrcgCndnRecdSuplmnt>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
     * PurgPrcgCndnRecdSuplmnt} entity object that will be updated in the S/4HANA system.
     *
     */
    private final PurgPrcgCndnRecdSuplmnt entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
     * PurgPrcgCndnRecdSuplmnt} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The PurgPrcgCndnRecdSuplmnt to take the updated values from.
     */
    public PurgPrcgCndnRecdSuplmntUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final PurgPrcgCndnRecdSuplmnt entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected PurgPrcgCndnRecdSuplmnt getEntity()
    {
        return entity;
    }

}
