/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.field.PurgPrcgCndnRecdValidityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.link.PurgPrcgCndnRecdValidityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.link.PurgPrcgCndnRecdValidityOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.selectable.PurgPrcgCndnRecdValiditySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Record Validity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgPrcgCndnRecdValidityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgPrcgCndnRecdValidity extends VdmEntity<PurgPrcgCndnRecdValidity>
{

    /**
     * Selector for all available fields of PurgPrcgCndnRecdValidity.
     *
     */
    public final static PurgPrcgCndnRecdValiditySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> CONDITION_RECORD =
        new PurgPrcgCndnRecdValidityField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return Validity end date of the condition record
     */
    @Key
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new PurgPrcgCndnRecdValidityField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @return Validity start date of the condition record
     */
    @SerializedName( "ConditionValidityStartDate" )
    @JsonProperty( "ConditionValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityStartDate</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<LocalDateTime> CONDITION_VALIDITY_START_DATE =
        new PurgPrcgCndnRecdValidityField<LocalDateTime>("ConditionValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> CONDITION_APPLICATION =
        new PurgPrcgCndnRecdValidityField<String>("ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> CONDITION_TYPE =
        new PurgPrcgCndnRecdValidityField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ConditionReleaseStatus" )
    @JsonProperty( "ConditionReleaseStatus" )
    @Nullable
    @ODataField( odataName = "ConditionReleaseStatus" )
    private String conditionReleaseStatus;
    /**
     * Use with available fluent helpers to apply the <b>ConditionReleaseStatus</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> CONDITION_RELEASE_STATUS =
        new PurgPrcgCndnRecdValidityField<String>("ConditionReleaseStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "PurgDocOrderQuantityUnit" )
    @JsonProperty( "PurgDocOrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "PurgDocOrderQuantityUnit" )
    private String purgDocOrderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocOrderQuantityUnit</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> PURG_DOC_ORDER_QUANTITY_UNIT =
        new PurgPrcgCndnRecdValidityField<String>("PurgDocOrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> COMPANY_CODE =
        new PurgPrcgCndnRecdValidityField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     *
     * @return Condition Contract
     */
    @SerializedName( "ConditionContract" )
    @JsonProperty( "ConditionContract" )
    @Nullable
    @ODataField( odataName = "ConditionContract" )
    private String conditionContract;
    /**
     * Use with available fluent helpers to apply the <b>ConditionContract</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> CONDITION_CONTRACT =
        new PurgPrcgCndnRecdValidityField<String>("ConditionContract");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialConditionGroup</b>
     * </p>
     *
     * @return Condition Group with Supplier
     */
    @SerializedName( "MaterialConditionGroup" )
    @JsonProperty( "MaterialConditionGroup" )
    @Nullable
    @ODataField( odataName = "MaterialConditionGroup" )
    private String materialConditionGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialConditionGroup</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> MATERIAL_CONDITION_GROUP =
        new PurgPrcgCndnRecdValidityField<String>("MaterialConditionGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> PURCHASING_ORGANIZATION =
        new PurgPrcgCndnRecdValidityField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordCategory</b>
     * </p>
     *
     * @return Purchasing info record category
     */
    @SerializedName( "PurchasingInfoRecordCategory" )
    @JsonProperty( "PurchasingInfoRecordCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecordCategory" )
    private String purchasingInfoRecordCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecordCategory</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> PURCHASING_INFO_RECORD_CATEGORY =
        new PurgPrcgCndnRecdValidityField<String>("PurchasingInfoRecordCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> PURCHASING_DOCUMENT =
        new PurgPrcgCndnRecdValidityField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> PURCHASING_DOCUMENT_ITEM =
        new PurgPrcgCndnRecdValidityField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> INCOTERMS_CLASSIFICATION =
        new PurgPrcgCndnRecdValidityField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @return Number of purchasing info record
     */
    @SerializedName( "PurchasingInfoRecord" )
    @JsonProperty( "PurchasingInfoRecord" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecord" )
    private String purchasingInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecord</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> PURCHASING_INFO_RECORD =
        new PurgPrcgCndnRecdValidityField<String>("PurchasingInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountTaxType</b>
     * </p>
     *
     * @return Tax Type
     */
    @SerializedName( "AccountTaxType" )
    @JsonProperty( "AccountTaxType" )
    @Nullable
    @ODataField( odataName = "AccountTaxType" )
    private String accountTaxType;
    /**
     * Use with available fluent helpers to apply the <b>AccountTaxType</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> ACCOUNT_TAX_TYPE =
        new PurgPrcgCndnRecdValidityField<String>("AccountTaxType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-to Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> BILL_TO_PARTY =
        new PurgPrcgCndnRecdValidityField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForBillToParty</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BPForBillToParty" )
    @JsonProperty( "BPForBillToParty" )
    @Nullable
    @ODataField( odataName = "BPForBillToParty" )
    private String bPForBillToParty;
    /**
     * Use with available fluent helpers to apply the <b>BPForBillToParty</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> BP_FOR_BILL_TO_PARTY =
        new PurgPrcgCndnRecdValidityField<String>("BPForBillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> COUNTRY =
        new PurgPrcgCndnRecdValidityField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> SUPPLIER =
        new PurgPrcgCndnRecdValidityField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForSupplier</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BPForSupplier" )
    @JsonProperty( "BPForSupplier" )
    @Nullable
    @ODataField( odataName = "BPForSupplier" )
    private String bPForSupplier;
    /**
     * Use with available fluent helpers to apply the <b>BPForSupplier</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> BP_FOR_SUPPLIER =
        new PurgPrcgCndnRecdValidityField<String>("BPForSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     *
     * @return Different Invoicing Party
     */
    @SerializedName( "InvoicingParty" )
    @JsonProperty( "InvoicingParty" )
    @Nullable
    @ODataField( odataName = "InvoicingParty" )
    private String invoicingParty;
    /**
     * Use with available fluent helpers to apply the <b>InvoicingParty</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> INVOICING_PARTY =
        new PurgPrcgCndnRecdValidityField<String>("InvoicingParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForInvoicingParty</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @SerializedName( "BPForInvoicingParty" )
    @JsonProperty( "BPForInvoicingParty" )
    @Nullable
    @ODataField( odataName = "BPForInvoicingParty" )
    private String bPForInvoicingParty;
    /**
     * Use with available fluent helpers to apply the <b>BPForInvoicingParty</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> BP_FOR_INVOICING_PARTY =
        new PurgPrcgCndnRecdValidityField<String>("BPForInvoicingParty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DestinationCountry</b>
     * </p>
     *
     * @return Destination Country/Region
     */
    @SerializedName( "DestinationCountry" )
    @JsonProperty( "DestinationCountry" )
    @Nullable
    @ODataField( odataName = "DestinationCountry" )
    private String destinationCountry;
    /**
     * Use with available fluent helpers to apply the <b>DestinationCountry</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> DESTINATION_COUNTRY =
        new PurgPrcgCndnRecdValidityField<String>("DestinationCountry");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActiveSupplierSubrange</b>
     * </p>
     *
     * @return Supplier Subrange
     */
    @SerializedName( "ActiveSupplierSubrange" )
    @JsonProperty( "ActiveSupplierSubrange" )
    @Nullable
    @ODataField( odataName = "ActiveSupplierSubrange" )
    private String activeSupplierSubrange;
    /**
     * Use with available fluent helpers to apply the <b>ActiveSupplierSubrange</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> ACTIVE_SUPPLIER_SUBRANGE =
        new PurgPrcgCndnRecdValidityField<String>("ActiveSupplierSubrange");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> MATERIAL_GROUP =
        new PurgPrcgCndnRecdValidityField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> MATERIAL =
        new PurgPrcgCndnRecdValidityField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialType</b>
     * </p>
     *
     * @return Material Type
     */
    @SerializedName( "MaterialType" )
    @JsonProperty( "MaterialType" )
    @Nullable
    @ODataField( odataName = "MaterialType" )
    private String materialType;
    /**
     * Use with available fluent helpers to apply the <b>MaterialType</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> MATERIAL_TYPE =
        new PurgPrcgCndnRecdValidityField<String>("MaterialType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @return Tax on Sales/Purchases Code
     */
    @SerializedName( "TaxCode" )
    @JsonProperty( "TaxCode" )
    @Nullable
    @ODataField( odataName = "TaxCode" )
    private String taxCode;
    /**
     * Use with available fluent helpers to apply the <b>TaxCode</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> TAX_CODE =
        new PurgPrcgCndnRecdValidityField<String>("TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> REGION =
        new PurgPrcgCndnRecdValidityField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockSegment</b>
     * </p>
     *
     * @return Stock Segment
     */
    @SerializedName( "StockSegment" )
    @JsonProperty( "StockSegment" )
    @Nullable
    @ODataField( odataName = "StockSegment" )
    private String stockSegment;
    /**
     * Use with available fluent helpers to apply the <b>StockSegment</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> STOCK_SEGMENT =
        new PurgPrcgCndnRecdValidityField<String>("StockSegment");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AcctAssgmtTaxClassification</b>
     * </p>
     *
     * @return Tax Indicator: Account Assignment (Purchasing)
     */
    @SerializedName( "AcctAssgmtTaxClassification" )
    @JsonProperty( "AcctAssgmtTaxClassification" )
    @Nullable
    @ODataField( odataName = "AcctAssgmtTaxClassification" )
    private String acctAssgmtTaxClassification;
    /**
     * Use with available fluent helpers to apply the <b>AcctAssgmtTaxClassification</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> ACCT_ASSGMT_TAX_CLASSIFICATION =
        new PurgPrcgCndnRecdValidityField<String>("AcctAssgmtTaxClassification");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ImportTaxClassification</b>
     * </p>
     *
     * @return Tax indicator: Import
     */
    @SerializedName( "ImportTaxClassification" )
    @JsonProperty( "ImportTaxClassification" )
    @Nullable
    @ODataField( odataName = "ImportTaxClassification" )
    private String importTaxClassification;
    /**
     * Use with available fluent helpers to apply the <b>ImportTaxClassification</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> IMPORT_TAX_CLASSIFICATION =
        new PurgPrcgCndnRecdValidityField<String>("ImportTaxClassification");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaxIndicator</b>
     * </p>
     *
     * @return Tax indicator for material (Purchasing)
     */
    @SerializedName( "TaxIndicator" )
    @JsonProperty( "TaxIndicator" )
    @Nullable
    @ODataField( odataName = "TaxIndicator" )
    private String taxIndicator;
    /**
     * Use with available fluent helpers to apply the <b>TaxIndicator</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> TAX_INDICATOR =
        new PurgPrcgCndnRecdValidityField<String>("TaxIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RegionTaxClassification</b>
     * </p>
     *
     * @return Tax indicator: Region (Intrastat)
     */
    @SerializedName( "RegionTaxClassification" )
    @JsonProperty( "RegionTaxClassification" )
    @Nullable
    @ODataField( odataName = "RegionTaxClassification" )
    private String regionTaxClassification;
    /**
     * Use with available fluent helpers to apply the <b>RegionTaxClassification</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> REGION_TAX_CLASSIFICATION =
        new PurgPrcgCndnRecdValidityField<String>("RegionTaxClassification");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlantTaxClassification</b>
     * </p>
     *
     * @return Tax Indicator: Plant (Purchasing)
     */
    @SerializedName( "PlantTaxClassification" )
    @JsonProperty( "PlantTaxClassification" )
    @Nullable
    @ODataField( odataName = "PlantTaxClassification" )
    private String plantTaxClassification;
    /**
     * Use with available fluent helpers to apply the <b>PlantTaxClassification</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> PLANT_TAX_CLASSIFICATION =
        new PurgPrcgCndnRecdValidityField<String>("PlantTaxClassification");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TradingContract</b>
     * </p>
     *
     * @return Trading Contract
     */
    @SerializedName( "TradingContract" )
    @JsonProperty( "TradingContract" )
    @Nullable
    @ODataField( odataName = "TradingContract" )
    private String tradingContract;
    /**
     * Use with available fluent helpers to apply the <b>TradingContract</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> TRADING_CONTRACT =
        new PurgPrcgCndnRecdValidityField<String>("TradingContract");
    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     *
     * @return Variant Condition Key
     */
    @SerializedName( "VariantCondition" )
    @JsonProperty( "VariantCondition" )
    @Nullable
    @ODataField( odataName = "VariantCondition" )
    private String variantCondition;
    /**
     * Use with available fluent helpers to apply the <b>VariantCondition</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> VARIANT_CONDITION =
        new PurgPrcgCndnRecdValidityField<String>("VariantCondition");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValueAddedServiceChargeCode</b>
     * </p>
     *
     * @return VAS Charge Codes
     */
    @SerializedName( "ValueAddedServiceChargeCode" )
    @JsonProperty( "ValueAddedServiceChargeCode" )
    @Nullable
    @ODataField( odataName = "ValueAddedServiceChargeCode" )
    private String valueAddedServiceChargeCode;
    /**
     * Use with available fluent helpers to apply the <b>ValueAddedServiceChargeCode</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> VALUE_ADDED_SERVICE_CHARGE_CODE =
        new PurgPrcgCndnRecdValidityField<String>("ValueAddedServiceChargeCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IN_GSTSupplierClassification</b>
     * </p>
     *
     * @return Vendor Classification for GST
     */
    @SerializedName( "IN_GSTSupplierClassification" )
    @JsonProperty( "IN_GSTSupplierClassification" )
    @Nullable
    @ODataField( odataName = "IN_GSTSupplierClassification" )
    private String iN_GSTSupplierClassification;
    /**
     * Use with available fluent helpers to apply the <b>IN_GSTSupplierClassification</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> INGST_SUPPLIER_CLASSIFICATION =
        new PurgPrcgCndnRecdValidityField<String>("IN_GSTSupplierClassification");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> PLANT =
        new PurgPrcgCndnRecdValidityField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantRegion</b>
     * </p>
     *
     * @return Region in which plant is located
     */
    @SerializedName( "PlantRegion" )
    @JsonProperty( "PlantRegion" )
    @Nullable
    @ODataField( odataName = "PlantRegion" )
    private String plantRegion;
    /**
     * Use with available fluent helpers to apply the <b>PlantRegion</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> PLANT_REGION =
        new PurgPrcgCndnRecdValidityField<String>("PlantRegion");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> TAX_JURISDICTION =
        new PurgPrcgCndnRecdValidityField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @return The eTag contained in this entity.
     */
    @SerializedName( "ETag" )
    @JsonProperty( "ETag" )
    @Nullable
    @ODataField( odataName = "ETag" )
    private String eTag;
    /**
     * Use with available fluent helpers to apply the <b>ETag</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityField<String> E_TAG = new PurgPrcgCndnRecdValidityField<String>("ETag");
    /**
     * Navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> for <b>PurgPrcgCndnRecdValidity</b> to multiple
     * <b>PurgPrcgCndnRecdSuplmnt</b>.
     *
     */
    @SerializedName( "to_PurgPrcgCndnRecdSuplmnt" )
    @JsonProperty( "to_PurgPrcgCndnRecdSuplmnt" )
    @ODataField( odataName = "to_PurgPrcgCndnRecdSuplmnt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgPrcgCndnRecdSuplmnt> toPurgPrcgCndnRecdSuplmnt;
    /**
     * Navigation property <b>to_PurgPrcgConditionRecord</b> for <b>PurgPrcgCndnRecdValidity</b> to single
     * <b>PurgPrcgConditionRecord</b>.
     *
     */
    @SerializedName( "to_PurgPrcgConditionRecord" )
    @JsonProperty( "to_PurgPrcgConditionRecord" )
    @ODataField( odataName = "to_PurgPrcgConditionRecord" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurgPrcgConditionRecord toPurgPrcgConditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>to_PurgPrcgCndnRecdSuplmnt</b> navigation property to query
     * operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityLink<PurgPrcgCndnRecdSuplmnt> TO_PURG_PRCG_CNDN_RECD_SUPLMNT =
        new PurgPrcgCndnRecdValidityLink<PurgPrcgCndnRecdSuplmnt>("to_PurgPrcgCndnRecdSuplmnt");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgPrcgConditionRecord</b> navigation property to query
     * operations.
     *
     */
    public final static PurgPrcgCndnRecdValidityOneToOneLink<PurgPrcgConditionRecord> TO_PURG_PRCG_CONDITION_RECORD =
        new PurgPrcgCndnRecdValidityOneToOneLink<PurgPrcgConditionRecord>("to_PurgPrcgConditionRecord");

    @Nonnull
    @Override
    public Class<PurgPrcgCndnRecdValidity> getType()
    {
        return PurgPrcgCndnRecdValidity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @param conditionValidityStartDate
     *            Validity start date of the condition record
     */
    public void setConditionValidityStartDate( @Nullable final LocalDateTime conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionReleaseStatus</b>
     * </p>
     *
     * @param conditionReleaseStatus
     *            Release Status
     */
    public void setConditionReleaseStatus( @Nullable final String conditionReleaseStatus )
    {
        rememberChangedField("ConditionReleaseStatus", this.conditionReleaseStatus);
        this.conditionReleaseStatus = conditionReleaseStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocOrderQuantityUnit</b>
     * </p>
     *
     * @param purgDocOrderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setPurgDocOrderQuantityUnit( @Nullable final String purgDocOrderQuantityUnit )
    {
        rememberChangedField("PurgDocOrderQuantityUnit", this.purgDocOrderQuantityUnit);
        this.purgDocOrderQuantityUnit = purgDocOrderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     *
     * @param conditionContract
     *            Condition Contract
     */
    public void setConditionContract( @Nullable final String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialConditionGroup</b>
     * </p>
     *
     * @param materialConditionGroup
     *            Condition Group with Supplier
     */
    public void setMaterialConditionGroup( @Nullable final String materialConditionGroup )
    {
        rememberChangedField("MaterialConditionGroup", this.materialConditionGroup);
        this.materialConditionGroup = materialConditionGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordCategory</b>
     * </p>
     *
     * @param purchasingInfoRecordCategory
     *            Purchasing info record category
     */
    public void setPurchasingInfoRecordCategory( @Nullable final String purchasingInfoRecordCategory )
    {
        rememberChangedField("PurchasingInfoRecordCategory", this.purchasingInfoRecordCategory);
        this.purchasingInfoRecordCategory = purchasingInfoRecordCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document Number
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Item Number of Purchasing Document
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecord</b>
     * </p>
     *
     * @param purchasingInfoRecord
     *            Number of purchasing info record
     */
    public void setPurchasingInfoRecord( @Nullable final String purchasingInfoRecord )
    {
        rememberChangedField("PurchasingInfoRecord", this.purchasingInfoRecord);
        this.purchasingInfoRecord = purchasingInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountTaxType</b>
     * </p>
     *
     * @param accountTaxType
     *            Tax Type
     */
    public void setAccountTaxType( @Nullable final String accountTaxType )
    {
        rememberChangedField("AccountTaxType", this.accountTaxType);
        this.accountTaxType = accountTaxType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-to Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForBillToParty</b>
     * </p>
     *
     * @param bPForBillToParty
     *            Business Partner Number
     */
    public void setBPForBillToParty( @Nullable final String bPForBillToParty )
    {
        rememberChangedField("BPForBillToParty", this.bPForBillToParty);
        this.bPForBillToParty = bPForBillToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForSupplier</b>
     * </p>
     *
     * @param bPForSupplier
     *            Business Partner Number
     */
    public void setBPForSupplier( @Nullable final String bPForSupplier )
    {
        rememberChangedField("BPForSupplier", this.bPForSupplier);
        this.bPForSupplier = bPForSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     *
     * @param invoicingParty
     *            Different Invoicing Party
     */
    public void setInvoicingParty( @Nullable final String invoicingParty )
    {
        rememberChangedField("InvoicingParty", this.invoicingParty);
        this.invoicingParty = invoicingParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BPForInvoicingParty</b>
     * </p>
     *
     * @param bPForInvoicingParty
     *            Business Partner Number
     */
    public void setBPForInvoicingParty( @Nullable final String bPForInvoicingParty )
    {
        rememberChangedField("BPForInvoicingParty", this.bPForInvoicingParty);
        this.bPForInvoicingParty = bPForInvoicingParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DestinationCountry</b>
     * </p>
     *
     * @param destinationCountry
     *            Destination Country/Region
     */
    public void setDestinationCountry( @Nullable final String destinationCountry )
    {
        rememberChangedField("DestinationCountry", this.destinationCountry);
        this.destinationCountry = destinationCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActiveSupplierSubrange</b>
     * </p>
     *
     * @param activeSupplierSubrange
     *            Supplier Subrange
     */
    public void setActiveSupplierSubrange( @Nullable final String activeSupplierSubrange )
    {
        rememberChangedField("ActiveSupplierSubrange", this.activeSupplierSubrange);
        this.activeSupplierSubrange = activeSupplierSubrange;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialType</b>
     * </p>
     *
     * @param materialType
     *            Material Type
     */
    public void setMaterialType( @Nullable final String materialType )
    {
        rememberChangedField("MaterialType", this.materialType);
        this.materialType = materialType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     *
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockSegment</b>
     * </p>
     *
     * @param stockSegment
     *            Stock Segment
     */
    public void setStockSegment( @Nullable final String stockSegment )
    {
        rememberChangedField("StockSegment", this.stockSegment);
        this.stockSegment = stockSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AcctAssgmtTaxClassification</b>
     * </p>
     *
     * @param acctAssgmtTaxClassification
     *            Tax Indicator: Account Assignment (Purchasing)
     */
    public void setAcctAssgmtTaxClassification( @Nullable final String acctAssgmtTaxClassification )
    {
        rememberChangedField("AcctAssgmtTaxClassification", this.acctAssgmtTaxClassification);
        this.acctAssgmtTaxClassification = acctAssgmtTaxClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ImportTaxClassification</b>
     * </p>
     *
     * @param importTaxClassification
     *            Tax indicator: Import
     */
    public void setImportTaxClassification( @Nullable final String importTaxClassification )
    {
        rememberChangedField("ImportTaxClassification", this.importTaxClassification);
        this.importTaxClassification = importTaxClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaxIndicator</b>
     * </p>
     *
     * @param taxIndicator
     *            Tax indicator for material (Purchasing)
     */
    public void setTaxIndicator( @Nullable final String taxIndicator )
    {
        rememberChangedField("TaxIndicator", this.taxIndicator);
        this.taxIndicator = taxIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RegionTaxClassification</b>
     * </p>
     *
     * @param regionTaxClassification
     *            Tax indicator: Region (Intrastat)
     */
    public void setRegionTaxClassification( @Nullable final String regionTaxClassification )
    {
        rememberChangedField("RegionTaxClassification", this.regionTaxClassification);
        this.regionTaxClassification = regionTaxClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PlantTaxClassification</b>
     * </p>
     *
     * @param plantTaxClassification
     *            Tax Indicator: Plant (Purchasing)
     */
    public void setPlantTaxClassification( @Nullable final String plantTaxClassification )
    {
        rememberChangedField("PlantTaxClassification", this.plantTaxClassification);
        this.plantTaxClassification = plantTaxClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TradingContract</b>
     * </p>
     *
     * @param tradingContract
     *            Trading Contract
     */
    public void setTradingContract( @Nullable final String tradingContract )
    {
        rememberChangedField("TradingContract", this.tradingContract);
        this.tradingContract = tradingContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     *
     * @param variantCondition
     *            Variant Condition Key
     */
    public void setVariantCondition( @Nullable final String variantCondition )
    {
        rememberChangedField("VariantCondition", this.variantCondition);
        this.variantCondition = variantCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ValueAddedServiceChargeCode</b>
     * </p>
     *
     * @param valueAddedServiceChargeCode
     *            VAS Charge Codes
     */
    public void setValueAddedServiceChargeCode( @Nullable final String valueAddedServiceChargeCode )
    {
        rememberChangedField("ValueAddedServiceChargeCode", this.valueAddedServiceChargeCode);
        this.valueAddedServiceChargeCode = valueAddedServiceChargeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IN_GSTSupplierClassification</b>
     * </p>
     *
     * @param iN_GSTSupplierClassification
     *            Vendor Classification for GST
     */
    public void setIN_GSTSupplierClassification( @Nullable final String iN_GSTSupplierClassification )
    {
        rememberChangedField("IN_GSTSupplierClassification", this.iN_GSTSupplierClassification);
        this.iN_GSTSupplierClassification = iN_GSTSupplierClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantRegion</b>
     * </p>
     *
     * @param plantRegion
     *            Region in which plant is located
     */
    public void setPlantRegion( @Nullable final String plantRegion )
    {
        rememberChangedField("PlantRegion", this.plantRegion);
        this.plantRegion = plantRegion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @param eTag
     *            The eTag to set.
     */
    public void setETag( @Nullable final String eTag )
    {
        rememberChangedField("ETag", this.eTag);
        this.eTag = eTag;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgPrcgCndnRecdValidity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionValidityEndDate", getConditionValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("ConditionReleaseStatus", getConditionReleaseStatus());
        values.put("PurgDocOrderQuantityUnit", getPurgDocOrderQuantityUnit());
        values.put("CompanyCode", getCompanyCode());
        values.put("ConditionContract", getConditionContract());
        values.put("MaterialConditionGroup", getMaterialConditionGroup());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingInfoRecordCategory", getPurchasingInfoRecordCategory());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("PurchasingInfoRecord", getPurchasingInfoRecord());
        values.put("AccountTaxType", getAccountTaxType());
        values.put("BillToParty", getBillToParty());
        values.put("BPForBillToParty", getBPForBillToParty());
        values.put("Country", getCountry());
        values.put("Supplier", getSupplier());
        values.put("BPForSupplier", getBPForSupplier());
        values.put("InvoicingParty", getInvoicingParty());
        values.put("BPForInvoicingParty", getBPForInvoicingParty());
        values.put("DestinationCountry", getDestinationCountry());
        values.put("ActiveSupplierSubrange", getActiveSupplierSubrange());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("Material", getMaterial());
        values.put("MaterialType", getMaterialType());
        values.put("TaxCode", getTaxCode());
        values.put("Region", getRegion());
        values.put("StockSegment", getStockSegment());
        values.put("AcctAssgmtTaxClassification", getAcctAssgmtTaxClassification());
        values.put("ImportTaxClassification", getImportTaxClassification());
        values.put("TaxIndicator", getTaxIndicator());
        values.put("RegionTaxClassification", getRegionTaxClassification());
        values.put("PlantTaxClassification", getPlantTaxClassification());
        values.put("TradingContract", getTradingContract());
        values.put("VariantCondition", getVariantCondition());
        values.put("ValueAddedServiceChargeCode", getValueAddedServiceChargeCode());
        values.put("IN_GSTSupplierClassification", getIN_GSTSupplierClassification());
        values.put("Plant", getPlant());
        values.put("PlantRegion", getPlantRegion());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("ETag", getETag());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionReleaseStatus") ) {
                final Object value = values.remove("ConditionReleaseStatus");
                if( (value == null) || (!value.equals(getConditionReleaseStatus())) ) {
                    setConditionReleaseStatus(((String) value));
                }
            }
            if( values.containsKey("PurgDocOrderQuantityUnit") ) {
                final Object value = values.remove("PurgDocOrderQuantityUnit");
                if( (value == null) || (!value.equals(getPurgDocOrderQuantityUnit())) ) {
                    setPurgDocOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((String) value));
                }
            }
            if( values.containsKey("MaterialConditionGroup") ) {
                final Object value = values.remove("MaterialConditionGroup");
                if( (value == null) || (!value.equals(getMaterialConditionGroup())) ) {
                    setMaterialConditionGroup(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecordCategory") ) {
                final Object value = values.remove("PurchasingInfoRecordCategory");
                if( (value == null) || (!value.equals(getPurchasingInfoRecordCategory())) ) {
                    setPurchasingInfoRecordCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecord") ) {
                final Object value = values.remove("PurchasingInfoRecord");
                if( (value == null) || (!value.equals(getPurchasingInfoRecord())) ) {
                    setPurchasingInfoRecord(((String) value));
                }
            }
            if( values.containsKey("AccountTaxType") ) {
                final Object value = values.remove("AccountTaxType");
                if( (value == null) || (!value.equals(getAccountTaxType())) ) {
                    setAccountTaxType(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("BPForBillToParty") ) {
                final Object value = values.remove("BPForBillToParty");
                if( (value == null) || (!value.equals(getBPForBillToParty())) ) {
                    setBPForBillToParty(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("BPForSupplier") ) {
                final Object value = values.remove("BPForSupplier");
                if( (value == null) || (!value.equals(getBPForSupplier())) ) {
                    setBPForSupplier(((String) value));
                }
            }
            if( values.containsKey("InvoicingParty") ) {
                final Object value = values.remove("InvoicingParty");
                if( (value == null) || (!value.equals(getInvoicingParty())) ) {
                    setInvoicingParty(((String) value));
                }
            }
            if( values.containsKey("BPForInvoicingParty") ) {
                final Object value = values.remove("BPForInvoicingParty");
                if( (value == null) || (!value.equals(getBPForInvoicingParty())) ) {
                    setBPForInvoicingParty(((String) value));
                }
            }
            if( values.containsKey("DestinationCountry") ) {
                final Object value = values.remove("DestinationCountry");
                if( (value == null) || (!value.equals(getDestinationCountry())) ) {
                    setDestinationCountry(((String) value));
                }
            }
            if( values.containsKey("ActiveSupplierSubrange") ) {
                final Object value = values.remove("ActiveSupplierSubrange");
                if( (value == null) || (!value.equals(getActiveSupplierSubrange())) ) {
                    setActiveSupplierSubrange(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialType") ) {
                final Object value = values.remove("MaterialType");
                if( (value == null) || (!value.equals(getMaterialType())) ) {
                    setMaterialType(((String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("StockSegment") ) {
                final Object value = values.remove("StockSegment");
                if( (value == null) || (!value.equals(getStockSegment())) ) {
                    setStockSegment(((String) value));
                }
            }
            if( values.containsKey("AcctAssgmtTaxClassification") ) {
                final Object value = values.remove("AcctAssgmtTaxClassification");
                if( (value == null) || (!value.equals(getAcctAssgmtTaxClassification())) ) {
                    setAcctAssgmtTaxClassification(((String) value));
                }
            }
            if( values.containsKey("ImportTaxClassification") ) {
                final Object value = values.remove("ImportTaxClassification");
                if( (value == null) || (!value.equals(getImportTaxClassification())) ) {
                    setImportTaxClassification(((String) value));
                }
            }
            if( values.containsKey("TaxIndicator") ) {
                final Object value = values.remove("TaxIndicator");
                if( (value == null) || (!value.equals(getTaxIndicator())) ) {
                    setTaxIndicator(((String) value));
                }
            }
            if( values.containsKey("RegionTaxClassification") ) {
                final Object value = values.remove("RegionTaxClassification");
                if( (value == null) || (!value.equals(getRegionTaxClassification())) ) {
                    setRegionTaxClassification(((String) value));
                }
            }
            if( values.containsKey("PlantTaxClassification") ) {
                final Object value = values.remove("PlantTaxClassification");
                if( (value == null) || (!value.equals(getPlantTaxClassification())) ) {
                    setPlantTaxClassification(((String) value));
                }
            }
            if( values.containsKey("TradingContract") ) {
                final Object value = values.remove("TradingContract");
                if( (value == null) || (!value.equals(getTradingContract())) ) {
                    setTradingContract(((String) value));
                }
            }
            if( values.containsKey("VariantCondition") ) {
                final Object value = values.remove("VariantCondition");
                if( (value == null) || (!value.equals(getVariantCondition())) ) {
                    setVariantCondition(((String) value));
                }
            }
            if( values.containsKey("ValueAddedServiceChargeCode") ) {
                final Object value = values.remove("ValueAddedServiceChargeCode");
                if( (value == null) || (!value.equals(getValueAddedServiceChargeCode())) ) {
                    setValueAddedServiceChargeCode(((String) value));
                }
            }
            if( values.containsKey("IN_GSTSupplierClassification") ) {
                final Object value = values.remove("IN_GSTSupplierClassification");
                if( (value == null) || (!value.equals(getIN_GSTSupplierClassification())) ) {
                    setIN_GSTSupplierClassification(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PlantRegion") ) {
                final Object value = values.remove("PlantRegion");
                if( (value == null) || (!value.equals(getPlantRegion())) ) {
                    setPlantRegion(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("ETag") ) {
                final Object value = values.remove("ETag");
                if( (value == null) || (!value.equals(getETag())) ) {
                    setETag(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurgPrcgCndnRecdSuplmnt") ) {
                final Object value = (values).remove("to_PurgPrcgCndnRecdSuplmnt");
                if( value instanceof Iterable ) {
                    if( toPurgPrcgCndnRecdSuplmnt == null ) {
                        toPurgPrcgCndnRecdSuplmnt = Lists.newArrayList();
                    } else {
                        toPurgPrcgCndnRecdSuplmnt = Lists.newArrayList(toPurgPrcgCndnRecdSuplmnt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgPrcgCndnRecdSuplmnt entity;
                        if( toPurgPrcgCndnRecdSuplmnt.size() > i ) {
                            entity = toPurgPrcgCndnRecdSuplmnt.get(i);
                        } else {
                            entity = new PurgPrcgCndnRecdSuplmnt();
                            toPurgPrcgCndnRecdSuplmnt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PurgPrcgConditionRecord") ) {
                final Object value = (values).remove("to_PurgPrcgConditionRecord");
                if( value instanceof Map ) {
                    if( toPurgPrcgConditionRecord == null ) {
                        toPurgPrcgConditionRecord = new PurgPrcgConditionRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgPrcgConditionRecord.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgPrcgCndnRecdValidityField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgPrcgCndnRecdValidityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgPrcgCndnRecdValidityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgPrcgCndnRecdValidityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurgPrcgCndnRecdSuplmnt != null ) {
            (values).put("to_PurgPrcgCndnRecdSuplmnt", toPurgPrcgCndnRecdSuplmnt);
        }
        if( toPurgPrcgConditionRecord != null ) {
            (values).put("to_PurgPrcgConditionRecord", toPurgPrcgConditionRecord);
        }
        return values;
    }

    /**
     * Fetches the <b>PurgPrcgCndnRecdSuplmnt</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgPrcgCndnRecdSuplmnt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgPrcgCndnRecdSuplmnt> fetchPurgPrcgCndnRecdSuplmnt()
    {
        return fetchFieldAsList("to_PurgPrcgCndnRecdSuplmnt", PurgPrcgCndnRecdSuplmnt.class);
    }

    /**
     * Retrieval of associated <b>PurgPrcgCndnRecdSuplmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> of a queried <b>PurgPrcgCndnRecdValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgPrcgCndnRecdSuplmnt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgPrcgCndnRecdSuplmnt> getPurgPrcgCndnRecdSuplmntOrFetch()
    {
        if( toPurgPrcgCndnRecdSuplmnt == null ) {
            toPurgPrcgCndnRecdSuplmnt = fetchPurgPrcgCndnRecdSuplmnt();
        }
        return toPurgPrcgCndnRecdSuplmnt;
    }

    /**
     * Retrieval of associated <b>PurgPrcgCndnRecdSuplmnt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property for an entity <b>PurgPrcgCndnRecdValidity</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> is already loaded, the
     *         result will contain the <b>PurgPrcgCndnRecdSuplmnt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgPrcgCndnRecdSuplmnt>> getPurgPrcgCndnRecdSuplmntIfPresent()
    {
        return Option.of(toPurgPrcgCndnRecdSuplmnt);
    }

    /**
     * Overwrites the list of associated <b>PurgPrcgCndnRecdSuplmnt</b> entities for the loaded navigation property
     * <b>to_PurgPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> of a queried <b>PurgPrcgCndnRecdValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgPrcgCndnRecdSuplmnt</b> entities.
     */
    public void setPurgPrcgCndnRecdSuplmnt( @Nonnull final List<PurgPrcgCndnRecdSuplmnt> value )
    {
        if( toPurgPrcgCndnRecdSuplmnt == null ) {
            toPurgPrcgCndnRecdSuplmnt = Lists.newArrayList();
        }
        toPurgPrcgCndnRecdSuplmnt.clear();
        toPurgPrcgCndnRecdSuplmnt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgPrcgCndnRecdSuplmnt</b> entities. This corresponds to the OData
     * navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> of a queried <b>PurgPrcgCndnRecdValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgPrcgCndnRecdSuplmnt</b> entities.
     */
    public void addPurgPrcgCndnRecdSuplmnt( PurgPrcgCndnRecdSuplmnt... entity )
    {
        if( toPurgPrcgCndnRecdSuplmnt == null ) {
            toPurgPrcgCndnRecdSuplmnt = Lists.newArrayList();
        }
        toPurgPrcgCndnRecdSuplmnt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PurgPrcgConditionRecord</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurgPrcgConditionRecord</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurgPrcgConditionRecord</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPrcgConditionRecord fetchPurgPrcgConditionRecord()
    {
        return fetchFieldAsSingle("to_PurgPrcgConditionRecord", PurgPrcgConditionRecord.class);
    }

    /**
     * Retrieval of associated <b>PurgPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPrcgConditionRecord</b>.
     * <p>
     * If the navigation property <b>to_PurgPrcgConditionRecord</b> of a queried <b>PurgPrcgCndnRecdValidity</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgPrcgConditionRecord</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPrcgConditionRecord getPurgPrcgConditionRecordOrFetch()
    {
        if( toPurgPrcgConditionRecord == null ) {
            toPurgPrcgConditionRecord = fetchPurgPrcgConditionRecord();
        }
        return toPurgPrcgConditionRecord;
    }

    /**
     * Retrieval of associated <b>PurgPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPrcgConditionRecord</b>.
     * <p>
     * If the navigation property for an entity <b>PurgPrcgCndnRecdValidity</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgPrcgConditionRecord</b> is already loaded, the
     *         result will contain the <b>PurgPrcgConditionRecord</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurgPrcgConditionRecord> getPurgPrcgConditionRecordIfPresent()
    {
        return Option.of(toPurgPrcgConditionRecord);
    }

    /**
     * Overwrites the associated <b>PurgPrcgConditionRecord</b> entity for the loaded navigation property
     * <b>to_PurgPrcgConditionRecord</b>.
     *
     * @param value
     *            New <b>PurgPrcgConditionRecord</b> entity.
     */
    public void setPurgPrcgConditionRecord( final PurgPrcgConditionRecord value )
    {
        toPurgPrcgConditionRecord = value;
    }

    /**
     * Helper class to allow for fluent creation of PurgPrcgCndnRecdValidity instances.
     *
     */
    public final static class PurgPrcgCndnRecdValidityBuilder
    {

        private List<PurgPrcgCndnRecdSuplmnt> toPurgPrcgCndnRecdSuplmnt = Lists.newArrayList();
        private PurgPrcgConditionRecord toPurgPrcgConditionRecord;

        private PurgPrcgCndnRecdValidity.PurgPrcgCndnRecdValidityBuilder toPurgPrcgCndnRecdSuplmnt(
            final List<PurgPrcgCndnRecdSuplmnt> value )
        {
            toPurgPrcgCndnRecdSuplmnt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> for <b>PurgPrcgCndnRecdValidity</b> to multiple
         * <b>PurgPrcgCndnRecdSuplmnt</b>.
         *
         * @param value
         *            The PurgPrcgCndnRecdSuplmnts to build this PurgPrcgCndnRecdValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgPrcgCndnRecdValidity.PurgPrcgCndnRecdValidityBuilder purgPrcgCndnRecdSuplmnt(
            PurgPrcgCndnRecdSuplmnt... value )
        {
            return toPurgPrcgCndnRecdSuplmnt(Lists.newArrayList(value));
        }

        private PurgPrcgCndnRecdValidity.PurgPrcgCndnRecdValidityBuilder toPurgPrcgConditionRecord(
            final PurgPrcgConditionRecord value )
        {
            toPurgPrcgConditionRecord = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgPrcgConditionRecord</b> for <b>PurgPrcgCndnRecdValidity</b> to single
         * <b>PurgPrcgConditionRecord</b>.
         *
         * @param value
         *            The PurgPrcgConditionRecord to build this PurgPrcgCndnRecdValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgPrcgCndnRecdValidity.PurgPrcgCndnRecdValidityBuilder purgPrcgConditionRecord(
            final PurgPrcgConditionRecord value )
        {
            return toPurgPrcgConditionRecord(value);
        }

    }

}
