/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.field.PurgPrcgCndnRecordScaleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.link.PurgPrcgCndnRecordScaleOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.selectable.PurgPrcgCndnRecordScaleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Pricing Scales
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgPrcgCndnRecordScaleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgPrcgCndnRecordScale extends VdmEntity<PurgPrcgCndnRecordScale>
{

    /**
     * Selector for all available fields of PurgPrcgCndnRecordScale.
     *
     */
    public final static PurgPrcgCndnRecordScaleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<String> CONDITION_RECORD =
        new PurgPrcgCndnRecordScaleField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @return Sequential number of the condition
     */
    @Key
    @SerializedName( "ConditionSequentialNumber" )
    @JsonProperty( "ConditionSequentialNumber" )
    @Nullable
    @ODataField( odataName = "ConditionSequentialNumber" )
    private String conditionSequentialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConditionSequentialNumber</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<String> CONDITION_SEQUENTIAL_NUMBER =
        new PurgPrcgCndnRecordScaleField<String>("ConditionSequentialNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     *
     * @return Current number of the line scale
     */
    @Key
    @SerializedName( "ConditionScaleLine" )
    @JsonProperty( "ConditionScaleLine" )
    @Nullable
    @ODataField( odataName = "ConditionScaleLine" )
    private String conditionScaleLine;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleLine</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<String> CONDITION_SCALE_LINE =
        new PurgPrcgCndnRecordScaleField<String>("ConditionScaleLine");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @return Condition Scale Quantity
     */
    @SerializedName( "ConditionScaleQuantity" )
    @JsonProperty( "ConditionScaleQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantity" )
    private BigDecimal conditionScaleQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantity</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<BigDecimal> CONDITION_SCALE_QUANTITY =
        new PurgPrcgCndnRecordScaleField<BigDecimal>("ConditionScaleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleQuantityUnit" )
    @JsonProperty( "ConditionScaleQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantityUnit" )
    private String conditionScaleQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantityUnit</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<String> CONDITION_SCALE_QUANTITY_UNIT =
        new PurgPrcgCndnRecordScaleField<String>("ConditionScaleQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @return Scale Value
     */
    @SerializedName( "ConditionScaleAmount" )
    @JsonProperty( "ConditionScaleAmount" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmount" )
    private BigDecimal conditionScaleAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmount</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<BigDecimal> CONDITION_SCALE_AMOUNT =
        new PurgPrcgCndnRecordScaleField<BigDecimal>("ConditionScaleAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleAmountCurrency" )
    @JsonProperty( "ConditionScaleAmountCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmountCurrency" )
    private String conditionScaleAmountCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmountCurrency</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<String> CONDITION_SCALE_AMOUNT_CURRENCY =
        new PurgPrcgCndnRecordScaleField<String>("ConditionScaleAmountCurrency");
    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<BigDecimal> CONDITION_RATE_VALUE =
        new PurgPrcgCndnRecordScaleField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @return Condition Unit (Currency or Percentage)
     */
    @SerializedName( "ConditionRateValueUnit" )
    @JsonProperty( "ConditionRateValueUnit" )
    @Nullable
    @ODataField( odataName = "ConditionRateValueUnit" )
    private String conditionRateValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValueUnit</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<String> CONDITION_RATE_VALUE_UNIT =
        new PurgPrcgCndnRecordScaleField<String>("ConditionRateValueUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @return The eTag contained in this entity.
     */
    @SerializedName( "ETag" )
    @JsonProperty( "ETag" )
    @Nullable
    @ODataField( odataName = "ETag" )
    private String eTag;
    /**
     * Use with available fluent helpers to apply the <b>ETag</b> field to query operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleField<String> E_TAG = new PurgPrcgCndnRecordScaleField<String>("ETag");
    /**
     * Navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> for <b>PurgPrcgCndnRecordScale</b> to single
     * <b>PurgPrcgCndnRecdSuplmnt</b>.
     *
     */
    @SerializedName( "to_PurgPrcgCndnRecdSuplmnt" )
    @JsonProperty( "to_PurgPrcgCndnRecdSuplmnt" )
    @ODataField( odataName = "to_PurgPrcgCndnRecdSuplmnt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurgPrcgCndnRecdSuplmnt toPurgPrcgCndnRecdSuplmnt;
    /**
     * Navigation property <b>to_PurgPrcgConditionRecord</b> for <b>PurgPrcgCndnRecordScale</b> to single
     * <b>PurgPrcgConditionRecord</b>.
     *
     */
    @SerializedName( "to_PurgPrcgConditionRecord" )
    @JsonProperty( "to_PurgPrcgConditionRecord" )
    @ODataField( odataName = "to_PurgPrcgConditionRecord" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurgPrcgConditionRecord toPurgPrcgConditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>to_PurgPrcgCndnRecdSuplmnt</b> navigation property to query
     * operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleOneToOneLink<PurgPrcgCndnRecdSuplmnt> TO_PURG_PRCG_CNDN_RECD_SUPLMNT =
        new PurgPrcgCndnRecordScaleOneToOneLink<PurgPrcgCndnRecdSuplmnt>("to_PurgPrcgCndnRecdSuplmnt");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgPrcgConditionRecord</b> navigation property to query
     * operations.
     *
     */
    public final static PurgPrcgCndnRecordScaleOneToOneLink<PurgPrcgConditionRecord> TO_PURG_PRCG_CONDITION_RECORD =
        new PurgPrcgCndnRecordScaleOneToOneLink<PurgPrcgConditionRecord>("to_PurgPrcgConditionRecord");

    @Nonnull
    @Override
    public Class<PurgPrcgCndnRecordScale> getType()
    {
        return PurgPrcgCndnRecordScale.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     *
     * @param conditionSequentialNumber
     *            Sequential number of the condition
     */
    public void setConditionSequentialNumber( @Nullable final String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     *
     * @param conditionScaleLine
     *            Current number of the line scale
     */
    public void setConditionScaleLine( @Nullable final String conditionScaleLine )
    {
        rememberChangedField("ConditionScaleLine", this.conditionScaleLine);
        this.conditionScaleLine = conditionScaleLine;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @param conditionScaleQuantity
     *            Condition Scale Quantity
     */
    public void setConditionScaleQuantity( @Nullable final BigDecimal conditionScaleQuantity )
    {
        rememberChangedField("ConditionScaleQuantity", this.conditionScaleQuantity);
        this.conditionScaleQuantity = conditionScaleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @param conditionScaleQuantityUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleQuantityUnit( @Nullable final String conditionScaleQuantityUnit )
    {
        rememberChangedField("ConditionScaleQuantityUnit", this.conditionScaleQuantityUnit);
        this.conditionScaleQuantityUnit = conditionScaleQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @param conditionScaleAmount
     *            Scale Value
     */
    public void setConditionScaleAmount( @Nullable final BigDecimal conditionScaleAmount )
    {
        rememberChangedField("ConditionScaleAmount", this.conditionScaleAmount);
        this.conditionScaleAmount = conditionScaleAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @param conditionScaleAmountCurrency
     *            Scale Currency
     */
    public void setConditionScaleAmountCurrency( @Nullable final String conditionScaleAmountCurrency )
    {
        rememberChangedField("ConditionScaleAmountCurrency", this.conditionScaleAmountCurrency);
        this.conditionScaleAmountCurrency = conditionScaleAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 12, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Amount or Percentage
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValueUnit</b>
     * </p>
     *
     * @param conditionRateValueUnit
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionRateValueUnit( @Nullable final String conditionRateValueUnit )
    {
        rememberChangedField("ConditionRateValueUnit", this.conditionRateValueUnit);
        this.conditionRateValueUnit = conditionRateValueUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ETag</b>
     * </p>
     *
     * @param eTag
     *            The eTag to set.
     */
    public void setETag( @Nullable final String eTag )
    {
        rememberChangedField("ETag", this.eTag);
        this.eTag = eTag;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgPrcgCndnRecordScale";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionSequentialNumber", getConditionSequentialNumber());
        result.put("ConditionScaleLine", getConditionScaleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("ConditionScaleLine", getConditionScaleLine());
        values.put("ConditionScaleQuantity", getConditionScaleQuantity());
        values.put("ConditionScaleQuantityUnit", getConditionScaleQuantityUnit());
        values.put("ConditionScaleAmount", getConditionScaleAmount());
        values.put("ConditionScaleAmountCurrency", getConditionScaleAmountCurrency());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionRateValueUnit", getConditionRateValueUnit());
        values.put("ETag", getETag());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleLine") ) {
                final Object value = values.remove("ConditionScaleLine");
                if( (value == null) || (!value.equals(getConditionScaleLine())) ) {
                    setConditionScaleLine(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantity") ) {
                final Object value = values.remove("ConditionScaleQuantity");
                if( (value == null) || (!value.equals(getConditionScaleQuantity())) ) {
                    setConditionScaleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantityUnit") ) {
                final Object value = values.remove("ConditionScaleQuantityUnit");
                if( (value == null) || (!value.equals(getConditionScaleQuantityUnit())) ) {
                    setConditionScaleQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleAmount") ) {
                final Object value = values.remove("ConditionScaleAmount");
                if( (value == null) || (!value.equals(getConditionScaleAmount())) ) {
                    setConditionScaleAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleAmountCurrency") ) {
                final Object value = values.remove("ConditionScaleAmountCurrency");
                if( (value == null) || (!value.equals(getConditionScaleAmountCurrency())) ) {
                    setConditionScaleAmountCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateValueUnit") ) {
                final Object value = values.remove("ConditionRateValueUnit");
                if( (value == null) || (!value.equals(getConditionRateValueUnit())) ) {
                    setConditionRateValueUnit(((String) value));
                }
            }
            if( values.containsKey("ETag") ) {
                final Object value = values.remove("ETag");
                if( (value == null) || (!value.equals(getETag())) ) {
                    setETag(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurgPrcgCndnRecdSuplmnt") ) {
                final Object value = (values).remove("to_PurgPrcgCndnRecdSuplmnt");
                if( value instanceof Map ) {
                    if( toPurgPrcgCndnRecdSuplmnt == null ) {
                        toPurgPrcgCndnRecdSuplmnt = new PurgPrcgCndnRecdSuplmnt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgPrcgCndnRecdSuplmnt.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurgPrcgConditionRecord") ) {
                final Object value = (values).remove("to_PurgPrcgConditionRecord");
                if( value instanceof Map ) {
                    if( toPurgPrcgConditionRecord == null ) {
                        toPurgPrcgConditionRecord = new PurgPrcgConditionRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgPrcgConditionRecord.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgPrcgCndnRecordScaleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgPrcgCndnRecordScaleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgPrcgCndnRecordScaleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgPrcgCndnRecordScaleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurgPrcgCndnRecdSuplmnt != null ) {
            (values).put("to_PurgPrcgCndnRecdSuplmnt", toPurgPrcgCndnRecdSuplmnt);
        }
        if( toPurgPrcgConditionRecord != null ) {
            (values).put("to_PurgPrcgConditionRecord", toPurgPrcgConditionRecord);
        }
        return values;
    }

    /**
     * Fetches the <b>PurgPrcgCndnRecdSuplmnt</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurgPrcgCndnRecdSuplmnt</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPrcgCndnRecdSuplmnt fetchPurgPrcgCndnRecdSuplmnt()
    {
        return fetchFieldAsSingle("to_PurgPrcgCndnRecdSuplmnt", PurgPrcgCndnRecdSuplmnt.class);
    }

    /**
     * Retrieval of associated <b>PurgPrcgCndnRecdSuplmnt</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> of a queried <b>PurgPrcgCndnRecordScale</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgPrcgCndnRecdSuplmnt</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPrcgCndnRecdSuplmnt getPurgPrcgCndnRecdSuplmntOrFetch()
    {
        if( toPurgPrcgCndnRecdSuplmnt == null ) {
            toPurgPrcgCndnRecdSuplmnt = fetchPurgPrcgCndnRecdSuplmnt();
        }
        return toPurgPrcgCndnRecdSuplmnt;
    }

    /**
     * Retrieval of associated <b>PurgPrcgCndnRecdSuplmnt</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b>.
     * <p>
     * If the navigation property for an entity <b>PurgPrcgCndnRecordScale</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> is already loaded, the
     *         result will contain the <b>PurgPrcgCndnRecdSuplmnt</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurgPrcgCndnRecdSuplmnt> getPurgPrcgCndnRecdSuplmntIfPresent()
    {
        return Option.of(toPurgPrcgCndnRecdSuplmnt);
    }

    /**
     * Overwrites the associated <b>PurgPrcgCndnRecdSuplmnt</b> entity for the loaded navigation property
     * <b>to_PurgPrcgCndnRecdSuplmnt</b>.
     *
     * @param value
     *            New <b>PurgPrcgCndnRecdSuplmnt</b> entity.
     */
    public void setPurgPrcgCndnRecdSuplmnt( final PurgPrcgCndnRecdSuplmnt value )
    {
        toPurgPrcgCndnRecdSuplmnt = value;
    }

    /**
     * Fetches the <b>PurgPrcgConditionRecord</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurgPrcgConditionRecord</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurgPrcgConditionRecord</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPrcgConditionRecord fetchPurgPrcgConditionRecord()
    {
        return fetchFieldAsSingle("to_PurgPrcgConditionRecord", PurgPrcgConditionRecord.class);
    }

    /**
     * Retrieval of associated <b>PurgPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPrcgConditionRecord</b>.
     * <p>
     * If the navigation property <b>to_PurgPrcgConditionRecord</b> of a queried <b>PurgPrcgCndnRecordScale</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgPrcgConditionRecord</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPrcgConditionRecord getPurgPrcgConditionRecordOrFetch()
    {
        if( toPurgPrcgConditionRecord == null ) {
            toPurgPrcgConditionRecord = fetchPurgPrcgConditionRecord();
        }
        return toPurgPrcgConditionRecord;
    }

    /**
     * Retrieval of associated <b>PurgPrcgConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPrcgConditionRecord</b>.
     * <p>
     * If the navigation property for an entity <b>PurgPrcgCndnRecordScale</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgPrcgConditionRecord</b> is already loaded, the
     *         result will contain the <b>PurgPrcgConditionRecord</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurgPrcgConditionRecord> getPurgPrcgConditionRecordIfPresent()
    {
        return Option.of(toPurgPrcgConditionRecord);
    }

    /**
     * Overwrites the associated <b>PurgPrcgConditionRecord</b> entity for the loaded navigation property
     * <b>to_PurgPrcgConditionRecord</b>.
     *
     * @param value
     *            New <b>PurgPrcgConditionRecord</b> entity.
     */
    public void setPurgPrcgConditionRecord( final PurgPrcgConditionRecord value )
    {
        toPurgPrcgConditionRecord = value;
    }

    /**
     * Helper class to allow for fluent creation of PurgPrcgCndnRecordScale instances.
     *
     */
    public final static class PurgPrcgCndnRecordScaleBuilder
    {

        private PurgPrcgCndnRecdSuplmnt toPurgPrcgCndnRecdSuplmnt;
        private PurgPrcgConditionRecord toPurgPrcgConditionRecord;

        private PurgPrcgCndnRecordScale.PurgPrcgCndnRecordScaleBuilder toPurgPrcgCndnRecdSuplmnt(
            final PurgPrcgCndnRecdSuplmnt value )
        {
            toPurgPrcgCndnRecdSuplmnt = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgPrcgCndnRecdSuplmnt</b> for <b>PurgPrcgCndnRecordScale</b> to single
         * <b>PurgPrcgCndnRecdSuplmnt</b>.
         *
         * @param value
         *            The PurgPrcgCndnRecdSuplmnt to build this PurgPrcgCndnRecordScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgPrcgCndnRecordScale.PurgPrcgCndnRecordScaleBuilder purgPrcgCndnRecdSuplmnt(
            final PurgPrcgCndnRecdSuplmnt value )
        {
            return toPurgPrcgCndnRecdSuplmnt(value);
        }

        private PurgPrcgCndnRecordScale.PurgPrcgCndnRecordScaleBuilder toPurgPrcgConditionRecord(
            final PurgPrcgConditionRecord value )
        {
            toPurgPrcgConditionRecord = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgPrcgConditionRecord</b> for <b>PurgPrcgCndnRecordScale</b> to single
         * <b>PurgPrcgConditionRecord</b>.
         *
         * @param value
         *            The PurgPrcgConditionRecord to build this PurgPrcgCndnRecordScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgPrcgCndnRecordScale.PurgPrcgCndnRecordScaleBuilder purgPrcgConditionRecord(
            final PurgPrcgConditionRecord value )
        {
            return toPurgPrcgConditionRecord(value);
        }

    }

}
