/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PurchasingPricingConditionRecordServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService
 * PurchasingPricingConditionRecordService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultPurchasingPricingConditionRecordServiceBatch
    extends
    BatchFluentHelperBasic<PurchasingPricingConditionRecordServiceBatch, PurchasingPricingConditionRecordServiceBatchChangeSet>
    implements
    PurchasingPricingConditionRecordServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPurchasingPricingConditionRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingPricingConditionRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPurchasingPricingConditionRecordServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingPricingConditionRecordServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingPricingConditionRecordServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPurchasingPricingConditionRecordServiceBatchChangeSet(this, service);
    }

}
