/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdValidity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecordScale;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgConditionRecord;

/**
 * Implementation of the {@link PurchasingPricingConditionRecordServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService
 * PurchasingPricingConditionRecordService}.
 *
 */
public class DefaultPurchasingPricingConditionRecordServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PurchasingPricingConditionRecordServiceBatch, PurchasingPricingConditionRecordServiceBatchChangeSet>
    implements
    PurchasingPricingConditionRecordServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService service;

    @SuppressWarnings( "deprecation" )
    DefaultPurchasingPricingConditionRecordServiceBatchChangeSet(
        @Nonnull final DefaultPurchasingPricingConditionRecordServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingPricingConditionRecordServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet createPurgPrcgCndnRecdSuplmnt(
        @Nonnull final PurgPrcgCndnRecdSuplmnt purgPrcgCndnRecdSuplmnt )
    {
        return addRequestCreate(service::createPurgPrcgCndnRecdSuplmnt, purgPrcgCndnRecdSuplmnt);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet updatePurgPrcgCndnRecdSuplmnt(
        @Nonnull final PurgPrcgCndnRecdSuplmnt purgPrcgCndnRecdSuplmnt )
    {
        return addRequestUpdate(service::updatePurgPrcgCndnRecdSuplmnt, purgPrcgCndnRecdSuplmnt);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet deletePurgPrcgCndnRecdSuplmnt(
        @Nonnull final PurgPrcgCndnRecdSuplmnt purgPrcgCndnRecdSuplmnt )
    {
        return addRequestDelete(service::deletePurgPrcgCndnRecdSuplmnt, purgPrcgCndnRecdSuplmnt);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet createPurgPrcgCndnRecdValidity(
        @Nonnull final PurgPrcgCndnRecdValidity purgPrcgCndnRecdValidity )
    {
        return addRequestCreate(service::createPurgPrcgCndnRecdValidity, purgPrcgCndnRecdValidity);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet updatePurgPrcgCndnRecdValidity(
        @Nonnull final PurgPrcgCndnRecdValidity purgPrcgCndnRecdValidity )
    {
        return addRequestUpdate(service::updatePurgPrcgCndnRecdValidity, purgPrcgCndnRecdValidity);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet createPurgPrcgCndnRecordScale(
        @Nonnull final PurgPrcgCndnRecordScale purgPrcgCndnRecordScale )
    {
        return addRequestCreate(service::createPurgPrcgCndnRecordScale, purgPrcgCndnRecordScale);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet updatePurgPrcgCndnRecordScale(
        @Nonnull final PurgPrcgCndnRecordScale purgPrcgCndnRecordScale )
    {
        return addRequestUpdate(service::updatePurgPrcgCndnRecordScale, purgPrcgCndnRecordScale);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet deletePurgPrcgCndnRecordScale(
        @Nonnull final PurgPrcgCndnRecordScale purgPrcgCndnRecordScale )
    {
        return addRequestDelete(service::deletePurgPrcgCndnRecordScale, purgPrcgCndnRecordScale);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet createPurgPrcgConditionRecord(
        @Nonnull final PurgPrcgConditionRecord purgPrcgConditionRecord )
    {
        return addRequestCreate(service::createPurgPrcgConditionRecord, purgPrcgConditionRecord);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet updatePurgPrcgConditionRecord(
        @Nonnull final PurgPrcgConditionRecord purgPrcgConditionRecord )
    {
        return addRequestUpdate(service::updatePurgPrcgConditionRecord, purgPrcgConditionRecord);
    }

    @Nonnull
    @Override
    public PurchasingPricingConditionRecordServiceBatchChangeSet deletePurgPrcgConditionRecord(
        @Nonnull final PurgPrcgConditionRecord purgPrcgConditionRecord )
    {
        return addRequestDelete(service::deletePurgPrcgConditionRecord, purgPrcgConditionRecord);
    }

}
