/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdValidity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecordScale;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgConditionRecord;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingPricingConditionRecordService
 * PurchasingPricingConditionRecordService}.
 *
 */
public interface PurchasingPricingConditionRecordServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PurchasingPricingConditionRecordServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PurchasingPricingConditionRecordServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
     * PurgPrcgCndnRecdSuplmnt} entity and save it to the S/4HANA system.
     *
     * @param purgPrcgCndnRecdSuplmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
     *            PurgPrcgCndnRecdSuplmnt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        createPurgPrcgCndnRecdSuplmnt( @Nonnull final PurgPrcgCndnRecdSuplmnt purgPrcgCndnRecdSuplmnt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
     * PurgPrcgCndnRecdSuplmnt} entity and save it to the S/4HANA system.
     *
     * @param purgPrcgCndnRecdSuplmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
     *            PurgPrcgCndnRecdSuplmnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        updatePurgPrcgCndnRecdSuplmnt( @Nonnull final PurgPrcgCndnRecdSuplmnt purgPrcgCndnRecdSuplmnt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
     * PurgPrcgCndnRecdSuplmnt} entity in the S/4HANA system.
     *
     * @param purgPrcgCndnRecdSuplmnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
     *            PurgPrcgCndnRecdSuplmnt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        deletePurgPrcgCndnRecdSuplmnt( @Nonnull final PurgPrcgCndnRecdSuplmnt purgPrcgCndnRecdSuplmnt );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdValidity
     * PurgPrcgCndnRecdValidity} entity and save it to the S/4HANA system.
     *
     * @param purgPrcgCndnRecdValidity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdValidity
     *            PurgPrcgCndnRecdValidity} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        createPurgPrcgCndnRecdValidity( @Nonnull final PurgPrcgCndnRecdValidity purgPrcgCndnRecdValidity );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdValidity
     * PurgPrcgCndnRecdValidity} entity and save it to the S/4HANA system.
     *
     * @param purgPrcgCndnRecdValidity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdValidity
     *            PurgPrcgCndnRecdValidity} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        updatePurgPrcgCndnRecdValidity( @Nonnull final PurgPrcgCndnRecdValidity purgPrcgCndnRecdValidity );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecordScale
     * PurgPrcgCndnRecordScale} entity and save it to the S/4HANA system.
     *
     * @param purgPrcgCndnRecordScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecordScale
     *            PurgPrcgCndnRecordScale} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        createPurgPrcgCndnRecordScale( @Nonnull final PurgPrcgCndnRecordScale purgPrcgCndnRecordScale );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecordScale
     * PurgPrcgCndnRecordScale} entity and save it to the S/4HANA system.
     *
     * @param purgPrcgCndnRecordScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecordScale
     *            PurgPrcgCndnRecordScale} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        updatePurgPrcgCndnRecordScale( @Nonnull final PurgPrcgCndnRecordScale purgPrcgCndnRecordScale );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecordScale
     * PurgPrcgCndnRecordScale} entity in the S/4HANA system.
     *
     * @param purgPrcgCndnRecordScale
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecordScale
     *            PurgPrcgCndnRecordScale} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        deletePurgPrcgCndnRecordScale( @Nonnull final PurgPrcgCndnRecordScale purgPrcgCndnRecordScale );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgConditionRecord
     * PurgPrcgConditionRecord} entity and save it to the S/4HANA system.
     *
     * @param purgPrcgConditionRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgConditionRecord
     *            PurgPrcgConditionRecord} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        createPurgPrcgConditionRecord( @Nonnull final PurgPrcgConditionRecord purgPrcgConditionRecord );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgConditionRecord
     * PurgPrcgConditionRecord} entity and save it to the S/4HANA system.
     *
     * @param purgPrcgConditionRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgConditionRecord
     *            PurgPrcgConditionRecord} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        updatePurgPrcgConditionRecord( @Nonnull final PurgPrcgConditionRecord purgPrcgConditionRecord );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgConditionRecord
     * PurgPrcgConditionRecord} entity in the S/4HANA system.
     *
     * @param purgPrcgConditionRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgConditionRecord
     *            PurgPrcgConditionRecord} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingPricingConditionRecordServiceBatchChangeSet
        deletePurgPrcgConditionRecord( @Nonnull final PurgPrcgConditionRecord purgPrcgConditionRecord );

}
