/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt
 * PurgPrcgCndnRecdSuplmnt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.field.PurgPrcgCndnRecdSuplmntField
 * PurgPrcgCndnRecdSuplmntField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.link.PurgPrcgCndnRecdSuplmntLink
 * PurgPrcgCndnRecdSuplmntLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_RECORD
 * CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_SEQUENTIAL_NUMBER
 * CONDITION_SEQUENTIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_TABLE
 * CONDITION_TABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_VALIDITY_END_DATE
 * CONDITION_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_VALIDITY_START_DATE
 * CONDITION_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_TEXT_ID
 * CONDITION_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#PRICING_SCALE_TYPE
 * PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#PRICING_SCALE_BASIS
 * PRICING_SCALE_BASIS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_SCALE_QUANTITY
 * CONDITION_SCALE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_SCALE_QUANTITY_UNIT
 * CONDITION_SCALE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_SCALE_AMOUNT
 * CONDITION_SCALE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_SCALE_AMOUNT_CURRENCY
 * CONDITION_SCALE_AMOUNT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_CALCULATION_TYPE
 * CONDITION_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_RATE_VALUE_UNIT
 * CONDITION_RATE_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_TO_BASE_QTY_NMRTR
 * CONDITION_TO_BASE_QTY_NMRTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_TO_BASE_QTY_DNMNTR
 * CONDITION_TO_BASE_QTY_DNMNTR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_LOWER_LIMIT
 * CONDITION_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_UPPER_LIMIT
 * CONDITION_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_ALTERNATIVE_CURRENCY
 * CONDITION_ALTERNATIVE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_EXCLUSION
 * CONDITION_EXCLUSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_IS_DELETED
 * CONDITION_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#ADDITIONAL_VALUE_DAYS
 * ADDITIONAL_VALUE_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#FIXED_VALUE_DATE
 * FIXED_VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CNDN_MAX_NUMBER_OF_SALES_ORDERS
 * CNDN_MAX_NUMBER_OF_SALES_ORDERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#MINIMUM_CONDITION_BASIS_VALUE
 * MINIMUM_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#MAXIMUM_CONDITION_BASIS_VALUE
 * MAXIMUM_CONDITION_BASIS_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#MAXIMUM_CONDITION_AMOUNT
 * MAXIMUM_CONDITION_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#INCREMENTAL_SCALE
 * INCREMENTAL_SCALE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#PRICING_SCALE_LINE
 * PRICING_SCALE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#CONDITION_RELEASE_STATUS
 * CONDITION_RELEASE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#E_TAG
 * E_TAG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#TO_PURG_PRCG_CNDN_RECD_VALIDITY
 * TO_PURG_PRCG_CNDN_RECD_VALIDITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#TO_PURG_PRCG_CONDITION_RECORD
 * TO_PURG_PRCG_CONDITION_RECORD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingpricingconditionrecord.PurgPrcgCndnRecdSuplmnt#TO_PURG_PRICING_CNDN_RECD_SCALE
 * TO_PURG_PRICING_CNDN_RECD_SCALE}</li>
 * </ul>
 *
 */
public interface PurgPrcgCndnRecdSuplmntSelectable extends EntitySelectable<PurgPrcgCndnRecdSuplmnt>
{

}
