/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.field.PurchasingQuotaArrangementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.link.PurchasingQuotaArrangementLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.selectable.PurchasingQuotaArrangementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Quota Arrangement
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchasingQuotaArrangementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchasingQuotaArrangement extends VdmEntity<PurchasingQuotaArrangement>
{

    /**
     * Selector for all available fields of PurchasingQuotaArrangement.
     *
     */
    public final static PurchasingQuotaArrangementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangement</b>
     * </p>
     *
     * @return Number of quota arrangement
     */
    @Key
    @SerializedName( "QuotaArrangement" )
    @JsonProperty( "QuotaArrangement" )
    @Nullable
    @ODataField( odataName = "QuotaArrangement" )
    private String quotaArrangement;
    /**
     * Use with available fluent helpers to apply the <b>QuotaArrangement</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<String> QUOTA_ARRANGEMENT =
        new PurchasingQuotaArrangementField<String>("QuotaArrangement");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<String> MATERIAL =
        new PurchasingQuotaArrangementField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<String> PLANT =
        new PurchasingQuotaArrangementField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Quota arrangement period valid until
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<LocalDateTime> VALIDITY_END_DATE =
        new PurchasingQuotaArrangementField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Quota arrangement period valid from
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<LocalDateTime> VALIDITY_START_DATE =
        new PurchasingQuotaArrangementField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<LocalDateTime> CREATION_DATE =
        new PurchasingQuotaArrangementField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<String> CREATED_BY_USER =
        new PurchasingQuotaArrangementField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinQtyForSpltQuota</b>
     * </p>
     *
     * @return Minimum Quantity for Splitting Quota
     */
    @SerializedName( "MinQtyForSpltQuota" )
    @JsonProperty( "MinQtyForSpltQuota" )
    @Nullable
    @ODataField( odataName = "MinQtyForSpltQuota" )
    private BigDecimal minQtyForSpltQuota;
    /**
     * Use with available fluent helpers to apply the <b>MinQtyForSpltQuota</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<BigDecimal> MIN_QTY_FOR_SPLT_QUOTA =
        new PurchasingQuotaArrangementField<BigDecimal>("MinQtyForSpltQuota");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PurchasingQuotaArrangementField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>UserDescription</b>
     * </p>
     *
     * @return Description of the Technical User Account
     */
    @SerializedName( "UserDescription" )
    @JsonProperty( "UserDescription" )
    @Nullable
    @ODataField( odataName = "UserDescription" )
    private String userDescription;
    /**
     * Use with available fluent helpers to apply the <b>UserDescription</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<String> USER_DESCRIPTION =
        new PurchasingQuotaArrangementField<String>("UserDescription");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "MaterialBaseUnit" )
    @JsonProperty( "MaterialBaseUnit" )
    @Nullable
    @ODataField( odataName = "MaterialBaseUnit" )
    private String materialBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseUnit</b> field to query operations.
     *
     */
    public final static PurchasingQuotaArrangementField<String> MATERIAL_BASE_UNIT =
        new PurchasingQuotaArrangementField<String>("MaterialBaseUnit");
    /**
     * Navigation property <b>to_PurgQuotaArrangementItem</b> for <b>PurchasingQuotaArrangement</b> to multiple
     * <b>PurgQuotaArrangementItem</b>.
     *
     */
    @SerializedName( "to_PurgQuotaArrangementItem" )
    @JsonProperty( "to_PurgQuotaArrangementItem" )
    @ODataField( odataName = "to_PurgQuotaArrangementItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgQuotaArrangementItem> toPurgQuotaArrangementItem;
    /**
     * Use with available fluent helpers to apply the <b>to_PurgQuotaArrangementItem</b> navigation property to query
     * operations.
     *
     */
    public final static PurchasingQuotaArrangementLink<PurgQuotaArrangementItem> TO_PURG_QUOTA_ARRANGEMENT_ITEM =
        new PurchasingQuotaArrangementLink<PurgQuotaArrangementItem>("to_PurgQuotaArrangementItem");

    @Nonnull
    @Override
    public Class<PurchasingQuotaArrangement> getType()
    {
        return PurchasingQuotaArrangement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangement</b>
     * </p>
     *
     * @param quotaArrangement
     *            Number of quota arrangement
     */
    public void setQuotaArrangement( @Nullable final String quotaArrangement )
    {
        rememberChangedField("QuotaArrangement", this.quotaArrangement);
        this.quotaArrangement = quotaArrangement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Quota arrangement period valid until
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Quota arrangement period valid from
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MinQtyForSpltQuota</b>
     * </p>
     *
     * @param minQtyForSpltQuota
     *            Minimum Quantity for Splitting Quota
     */
    public void setMinQtyForSpltQuota( @Nullable final BigDecimal minQtyForSpltQuota )
    {
        rememberChangedField("MinQtyForSpltQuota", this.minQtyForSpltQuota);
        this.minQtyForSpltQuota = minQtyForSpltQuota;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>UserDescription</b>
     * </p>
     *
     * @param userDescription
     *            Description of the Technical User Account
     */
    public void setUserDescription( @Nullable final String userDescription )
    {
        rememberChangedField("UserDescription", this.userDescription);
        this.userDescription = userDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @param materialBaseUnit
     *            Base Unit of Measure
     */
    public void setMaterialBaseUnit( @Nullable final String materialBaseUnit )
    {
        rememberChangedField("MaterialBaseUnit", this.materialBaseUnit);
        this.materialBaseUnit = materialBaseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchasingQuotaArrangement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("QuotaArrangement", getQuotaArrangement());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("QuotaArrangement", getQuotaArrangement());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("MinQtyForSpltQuota", getMinQtyForSpltQuota());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("UserDescription", getUserDescription());
        values.put("MaterialBaseUnit", getMaterialBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("QuotaArrangement") ) {
                final Object value = values.remove("QuotaArrangement");
                if( (value == null) || (!value.equals(getQuotaArrangement())) ) {
                    setQuotaArrangement(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("MinQtyForSpltQuota") ) {
                final Object value = values.remove("MinQtyForSpltQuota");
                if( (value == null) || (!value.equals(getMinQtyForSpltQuota())) ) {
                    setMinQtyForSpltQuota(((BigDecimal) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("UserDescription") ) {
                final Object value = values.remove("UserDescription");
                if( (value == null) || (!value.equals(getUserDescription())) ) {
                    setUserDescription(((String) value));
                }
            }
            if( values.containsKey("MaterialBaseUnit") ) {
                final Object value = values.remove("MaterialBaseUnit");
                if( (value == null) || (!value.equals(getMaterialBaseUnit())) ) {
                    setMaterialBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurgQuotaArrangementItem") ) {
                final Object value = (values).remove("to_PurgQuotaArrangementItem");
                if( value instanceof Iterable ) {
                    if( toPurgQuotaArrangementItem == null ) {
                        toPurgQuotaArrangementItem = Lists.newArrayList();
                    } else {
                        toPurgQuotaArrangementItem = Lists.newArrayList(toPurgQuotaArrangementItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgQuotaArrangementItem entity;
                        if( toPurgQuotaArrangementItem.size() > i ) {
                            entity = toPurgQuotaArrangementItem.get(i);
                        } else {
                            entity = new PurgQuotaArrangementItem();
                            toPurgQuotaArrangementItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PurchasingQuotaArrangementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new PurchasingQuotaArrangementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchasingQuotaArrangementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchasingQuotaArrangementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurgQuotaArrangementItem != null ) {
            (values).put("to_PurgQuotaArrangementItem", toPurgQuotaArrangementItem);
        }
        return values;
    }

    /**
     * Fetches the <b>PurgQuotaArrangementItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PurgQuotaArrangementItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgQuotaArrangementItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgQuotaArrangementItem> fetchPurgQuotaArrangementItem()
    {
        return fetchFieldAsList("to_PurgQuotaArrangementItem", PurgQuotaArrangementItem.class);
    }

    /**
     * Retrieval of associated <b>PurgQuotaArrangementItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgQuotaArrangementItem</b>.
     * <p>
     * If the navigation property <b>to_PurgQuotaArrangementItem</b> of a queried <b>PurchasingQuotaArrangement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgQuotaArrangementItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgQuotaArrangementItem> getPurgQuotaArrangementItemOrFetch()
    {
        if( toPurgQuotaArrangementItem == null ) {
            toPurgQuotaArrangementItem = fetchPurgQuotaArrangementItem();
        }
        return toPurgQuotaArrangementItem;
    }

    /**
     * Retrieval of associated <b>PurgQuotaArrangementItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PurgQuotaArrangementItem</b>.
     * <p>
     * If the navigation property for an entity <b>PurchasingQuotaArrangement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgQuotaArrangementItem</b> is already loaded, the
     *         result will contain the <b>PurgQuotaArrangementItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgQuotaArrangementItem>> getPurgQuotaArrangementItemIfPresent()
    {
        return Option.of(toPurgQuotaArrangementItem);
    }

    /**
     * Overwrites the list of associated <b>PurgQuotaArrangementItem</b> entities for the loaded navigation property
     * <b>to_PurgQuotaArrangementItem</b>.
     * <p>
     * If the navigation property <b>to_PurgQuotaArrangementItem</b> of a queried <b>PurchasingQuotaArrangement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgQuotaArrangementItem</b> entities.
     */
    public void setPurgQuotaArrangementItem( @Nonnull final List<PurgQuotaArrangementItem> value )
    {
        if( toPurgQuotaArrangementItem == null ) {
            toPurgQuotaArrangementItem = Lists.newArrayList();
        }
        toPurgQuotaArrangementItem.clear();
        toPurgQuotaArrangementItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgQuotaArrangementItem</b> entities. This corresponds to the OData
     * navigation property <b>to_PurgQuotaArrangementItem</b>.
     * <p>
     * If the navigation property <b>to_PurgQuotaArrangementItem</b> of a queried <b>PurchasingQuotaArrangement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgQuotaArrangementItem</b> entities.
     */
    public void addPurgQuotaArrangementItem( PurgQuotaArrangementItem... entity )
    {
        if( toPurgQuotaArrangementItem == null ) {
            toPurgQuotaArrangementItem = Lists.newArrayList();
        }
        toPurgQuotaArrangementItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurchasingQuotaArrangement instances.
     *
     */
    public final static class PurchasingQuotaArrangementBuilder
    {

        private List<PurgQuotaArrangementItem> toPurgQuotaArrangementItem = Lists.newArrayList();

        private PurchasingQuotaArrangement.PurchasingQuotaArrangementBuilder toPurgQuotaArrangementItem(
            final List<PurgQuotaArrangementItem> value )
        {
            toPurgQuotaArrangementItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PurgQuotaArrangementItem</b> for <b>PurchasingQuotaArrangement</b> to multiple
         * <b>PurgQuotaArrangementItem</b>.
         *
         * @param value
         *            The PurgQuotaArrangementItems to build this PurchasingQuotaArrangement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurchasingQuotaArrangement.PurchasingQuotaArrangementBuilder purgQuotaArrangementItem(
            PurgQuotaArrangementItem... value )
        {
            return toPurgQuotaArrangementItem(Lists.newArrayList(value));
        }

    }

}
