/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.field.PurgQuotaArrangementItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.link.PurgQuotaArrangementItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.selectable.PurgQuotaArrangementItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgQuotaArrangementItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgQuotaArrangementItem extends VdmEntity<PurgQuotaArrangementItem>
{

    /**
     * Selector for all available fields of PurgQuotaArrangementItem.
     *
     */
    public final static PurgQuotaArrangementItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangement</b>
     * </p>
     *
     * @return Number of quota arrangement
     */
    @Key
    @SerializedName( "QuotaArrangement" )
    @JsonProperty( "QuotaArrangement" )
    @Nullable
    @ODataField( odataName = "QuotaArrangement" )
    private String quotaArrangement;
    /**
     * Use with available fluent helpers to apply the <b>QuotaArrangement</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> QUOTA_ARRANGEMENT =
        new PurgQuotaArrangementItemField<String>("QuotaArrangement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangementItem</b>
     * </p>
     *
     * @return Quota arrangement item
     */
    @Key
    @SerializedName( "QuotaArrangementItem" )
    @JsonProperty( "QuotaArrangementItem" )
    @Nullable
    @ODataField( odataName = "QuotaArrangementItem" )
    private String quotaArrangementItem;
    /**
     * Use with available fluent helpers to apply the <b>QuotaArrangementItem</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> QUOTA_ARRANGEMENT_ITEM =
        new PurgQuotaArrangementItemField<String>("QuotaArrangementItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementCategory</b>
     * </p>
     *
     * @return Procurement Type
     */
    @SerializedName( "MaterialProcurementCategory" )
    @JsonProperty( "MaterialProcurementCategory" )
    @Nullable
    @ODataField( odataName = "MaterialProcurementCategory" )
    private String materialProcurementCategory;
    /**
     * Use with available fluent helpers to apply the <b>MaterialProcurementCategory</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> MATERIAL_PROCUREMENT_CATEGORY =
        new PurgQuotaArrangementItemField<String>("MaterialProcurementCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementType</b>
     * </p>
     *
     * @return Special procurement type
     */
    @SerializedName( "MaterialProcurementType" )
    @JsonProperty( "MaterialProcurementType" )
    @Nullable
    @ODataField( odataName = "MaterialProcurementType" )
    private String materialProcurementType;
    /**
     * Use with available fluent helpers to apply the <b>MaterialProcurementType</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> MATERIAL_PROCUREMENT_TYPE =
        new PurgQuotaArrangementItemField<String>("MaterialProcurementType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> SUPPLIER =
        new PurgQuotaArrangementItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @return Plant from Which Material is Procured
     */
    @SerializedName( "SupplyingPlant" )
    @JsonProperty( "SupplyingPlant" )
    @Nullable
    @ODataField( odataName = "SupplyingPlant" )
    private String supplyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingPlant</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> SUPPLYING_PLANT =
        new PurgQuotaArrangementItemField<String>("SupplyingPlant");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingSourceQuota</b>
     * </p>
     *
     * @return Quota
     */
    @SerializedName( "PurchasingSourceQuota" )
    @JsonProperty( "PurchasingSourceQuota" )
    @Nullable
    @ODataField( odataName = "PurchasingSourceQuota" )
    private BigDecimal purchasingSourceQuota;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingSourceQuota</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<BigDecimal> PURCHASING_SOURCE_QUOTA =
        new PurgQuotaArrangementItemField<BigDecimal>("PurchasingSourceQuota");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaBaseQuantity</b>
     * </p>
     *
     * @return Quota Base Quantity of Quota Arrangement Item
     */
    @SerializedName( "QuotaBaseQuantity" )
    @JsonProperty( "QuotaBaseQuantity" )
    @Nullable
    @ODataField( odataName = "QuotaBaseQuantity" )
    private BigDecimal quotaBaseQuantity;
    /**
     * Use with available fluent helpers to apply the <b>QuotaBaseQuantity</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<BigDecimal> QUOTA_BASE_QUANTITY =
        new PurgQuotaArrangementItemField<BigDecimal>("QuotaBaseQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaAllocatedQuantity</b>
     * </p>
     *
     * @return Allocated Quantity of Quota Arrangement Item
     */
    @SerializedName( "QuotaAllocatedQuantity" )
    @JsonProperty( "QuotaAllocatedQuantity" )
    @Nullable
    @ODataField( odataName = "QuotaAllocatedQuantity" )
    private BigDecimal quotaAllocatedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>QuotaAllocatedQuantity</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<BigDecimal> QUOTA_ALLOCATED_QUANTITY =
        new PurgQuotaArrangementItemField<BigDecimal>("QuotaAllocatedQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaMaximumQuantity</b>
     * </p>
     *
     * @return Maximum Quantity of Quota Arrangement Item
     */
    @SerializedName( "QuotaMaximumQuantity" )
    @JsonProperty( "QuotaMaximumQuantity" )
    @Nullable
    @ODataField( odataName = "QuotaMaximumQuantity" )
    private BigDecimal quotaMaximumQuantity;
    /**
     * Use with available fluent helpers to apply the <b>QuotaMaximumQuantity</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<BigDecimal> QUOTA_MAXIMUM_QUANTITY =
        new PurgQuotaArrangementItemField<BigDecimal>("QuotaMaximumQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @return Production Version
     */
    @SerializedName( "ProductionVersion" )
    @JsonProperty( "ProductionVersion" )
    @Nullable
    @ODataField( odataName = "ProductionVersion" )
    private String productionVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProductionVersion</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> PRODUCTION_VERSION =
        new PurgQuotaArrangementItemField<String>("ProductionVersion");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMaxLotSizeQuantity</b>
     * </p>
     *
     * @return Maximum Lot Size per Quota Item
     */
    @SerializedName( "MaterialMaxLotSizeQuantity" )
    @JsonProperty( "MaterialMaxLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialMaxLotSizeQuantity" )
    private BigDecimal materialMaxLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialMaxLotSizeQuantity</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<BigDecimal> MATERIAL_MAX_LOT_SIZE_QUANTITY =
        new PurgQuotaArrangementItemField<BigDecimal>("MaterialMaxLotSizeQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMinLotSizeQuantity</b>
     * </p>
     *
     * @return Minimum Lot Size per Quota Item
     */
    @SerializedName( "MaterialMinLotSizeQuantity" )
    @JsonProperty( "MaterialMinLotSizeQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialMinLotSizeQuantity" )
    private BigDecimal materialMinLotSizeQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialMinLotSizeQuantity</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<BigDecimal> MATERIAL_MIN_LOT_SIZE_QUANTITY =
        new PurgQuotaArrangementItemField<BigDecimal>("MaterialMinLotSizeQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRoundingProfile</b>
     * </p>
     *
     * @return Rounding Profile
     */
    @SerializedName( "MaterialRoundingProfile" )
    @JsonProperty( "MaterialRoundingProfile" )
    @Nullable
    @ODataField( odataName = "MaterialRoundingProfile" )
    private String materialRoundingProfile;
    /**
     * Use with available fluent helpers to apply the <b>MaterialRoundingProfile</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> MATERIAL_ROUNDING_PROFILE =
        new PurgQuotaArrangementItemField<String>("MaterialRoundingProfile");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyIsAssignedOnce</b>
     * </p>
     *
     * @return Indicator: "Once-Only"
     */
    @SerializedName( "SourceOfSupplyIsAssignedOnce" )
    @JsonProperty( "SourceOfSupplyIsAssignedOnce" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SourceOfSupplyIsAssignedOnce" )
    private Boolean sourceOfSupplyIsAssignedOnce;
    /**
     * Use with available fluent helpers to apply the <b>SourceOfSupplyIsAssignedOnce</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<Boolean> SOURCE_OF_SUPPLY_IS_ASSIGNED_ONCE =
        new PurgQuotaArrangementItemField<Boolean>("SourceOfSupplyIsAssignedOnce");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumReleaseQuantity</b>
     * </p>
     *
     * @return Maximum Release Quantity per Period
     */
    @SerializedName( "MaximumReleaseQuantity" )
    @JsonProperty( "MaximumReleaseQuantity" )
    @Nullable
    @ODataField( odataName = "MaximumReleaseQuantity" )
    private BigDecimal maximumReleaseQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaximumReleaseQuantity</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<BigDecimal> MAXIMUM_RELEASE_QUANTITY =
        new PurgQuotaArrangementItemField<BigDecimal>("MaximumReleaseQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuotaReleasePeriodType</b>
     * </p>
     *
     * @return Period to Which the Release Quantity Relates
     */
    @SerializedName( "QuotaReleasePeriodType" )
    @JsonProperty( "QuotaReleasePeriodType" )
    @Nullable
    @ODataField( odataName = "QuotaReleasePeriodType" )
    private String quotaReleasePeriodType;
    /**
     * Use with available fluent helpers to apply the <b>QuotaReleasePeriodType</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> QUOTA_RELEASE_PERIOD_TYPE =
        new PurgQuotaArrangementItemField<String>("QuotaReleasePeriodType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfPeriodsPerRelQuantity</b>
     * </p>
     *
     * @return Number of Periods to Which the Release Quantity Relates
     */
    @SerializedName( "NumberOfPeriodsPerRelQuantity" )
    @JsonProperty( "NumberOfPeriodsPerRelQuantity" )
    @Nullable
    @ODataField( odataName = "NumberOfPeriodsPerRelQuantity" )
    private String numberOfPeriodsPerRelQuantity;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfPeriodsPerRelQuantity</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> NUMBER_OF_PERIODS_PER_REL_QUANTITY =
        new PurgQuotaArrangementItemField<String>("NumberOfPeriodsPerRelQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>QuotaDeterminationPriority</b>
     * </p>
     *
     * @return Priority for Determination of Sequence
     */
    @SerializedName( "QuotaDeterminationPriority" )
    @JsonProperty( "QuotaDeterminationPriority" )
    @Nullable
    @ODataField( odataName = "QuotaDeterminationPriority" )
    private String quotaDeterminationPriority;
    /**
     * Use with available fluent helpers to apply the <b>QuotaDeterminationPriority</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> QUOTA_DETERMINATION_PRIORITY =
        new PurgQuotaArrangementItemField<String>("QuotaDeterminationPriority");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @return Material number corresponding to manufacturer part number
     */
    @SerializedName( "ManufacturerMaterial" )
    @JsonProperty( "ManufacturerMaterial" )
    @Nullable
    @ODataField( odataName = "ManufacturerMaterial" )
    private String manufacturerMaterial;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerMaterial</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> MANUFACTURER_MATERIAL =
        new PurgQuotaArrangementItemField<String>("ManufacturerMaterial");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @return Planned Delivery Time in Days
     */
    @SerializedName( "PlannedDeliveryDurationInDays" )
    @JsonProperty( "PlannedDeliveryDurationInDays" )
    @Nullable
    @ODataField( odataName = "PlannedDeliveryDurationInDays" )
    private BigDecimal plannedDeliveryDurationInDays;
    /**
     * Use with available fluent helpers to apply the <b>PlannedDeliveryDurationInDays</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<BigDecimal> PLANNED_DELIVERY_DURATION_IN_DAYS =
        new PurgQuotaArrangementItemField<BigDecimal>("PlannedDeliveryDurationInDays");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "MaterialBaseUnit" )
    @JsonProperty( "MaterialBaseUnit" )
    @Nullable
    @ODataField( odataName = "MaterialBaseUnit" )
    private String materialBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaterialBaseUnit</b> field to query operations.
     *
     */
    public final static PurgQuotaArrangementItemField<String> MATERIAL_BASE_UNIT =
        new PurgQuotaArrangementItemField<String>("MaterialBaseUnit");
    /**
     * Navigation property <b>to_PurchasingQuotaArrangement</b> for <b>PurgQuotaArrangementItem</b> to single
     * <b>PurchasingQuotaArrangement</b>.
     *
     */
    @SerializedName( "to_PurchasingQuotaArrangement" )
    @JsonProperty( "to_PurchasingQuotaArrangement" )
    @ODataField( odataName = "to_PurchasingQuotaArrangement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurchasingQuotaArrangement toPurchasingQuotaArrangement;
    /**
     * Use with available fluent helpers to apply the <b>to_PurchasingQuotaArrangement</b> navigation property to query
     * operations.
     *
     */
    public final static PurgQuotaArrangementItemOneToOneLink<PurchasingQuotaArrangement> TO_PURCHASING_QUOTA_ARRANGEMENT =
        new PurgQuotaArrangementItemOneToOneLink<PurchasingQuotaArrangement>("to_PurchasingQuotaArrangement");

    @Nonnull
    @Override
    public Class<PurgQuotaArrangementItem> getType()
    {
        return PurgQuotaArrangementItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangement</b>
     * </p>
     *
     * @param quotaArrangement
     *            Number of quota arrangement
     */
    public void setQuotaArrangement( @Nullable final String quotaArrangement )
    {
        rememberChangedField("QuotaArrangement", this.quotaArrangement);
        this.quotaArrangement = quotaArrangement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaArrangementItem</b>
     * </p>
     *
     * @param quotaArrangementItem
     *            Quota arrangement item
     */
    public void setQuotaArrangementItem( @Nullable final String quotaArrangementItem )
    {
        rememberChangedField("QuotaArrangementItem", this.quotaArrangementItem);
        this.quotaArrangementItem = quotaArrangementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementCategory</b>
     * </p>
     *
     * @param materialProcurementCategory
     *            Procurement Type
     */
    public void setMaterialProcurementCategory( @Nullable final String materialProcurementCategory )
    {
        rememberChangedField("MaterialProcurementCategory", this.materialProcurementCategory);
        this.materialProcurementCategory = materialProcurementCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialProcurementType</b>
     * </p>
     *
     * @param materialProcurementType
     *            Special procurement type
     */
    public void setMaterialProcurementType( @Nullable final String materialProcurementType )
    {
        rememberChangedField("MaterialProcurementType", this.materialProcurementType);
        this.materialProcurementType = materialProcurementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @param supplyingPlant
     *            Plant from Which Material is Procured
     */
    public void setSupplyingPlant( @Nullable final String supplyingPlant )
    {
        rememberChangedField("SupplyingPlant", this.supplyingPlant);
        this.supplyingPlant = supplyingPlant;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingSourceQuota</b>
     * </p>
     *
     * @param purchasingSourceQuota
     *            Quota
     */
    public void setPurchasingSourceQuota( @Nullable final BigDecimal purchasingSourceQuota )
    {
        rememberChangedField("PurchasingSourceQuota", this.purchasingSourceQuota);
        this.purchasingSourceQuota = purchasingSourceQuota;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaBaseQuantity</b>
     * </p>
     *
     * @param quotaBaseQuantity
     *            Quota Base Quantity of Quota Arrangement Item
     */
    public void setQuotaBaseQuantity( @Nullable final BigDecimal quotaBaseQuantity )
    {
        rememberChangedField("QuotaBaseQuantity", this.quotaBaseQuantity);
        this.quotaBaseQuantity = quotaBaseQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaAllocatedQuantity</b>
     * </p>
     *
     * @param quotaAllocatedQuantity
     *            Allocated Quantity of Quota Arrangement Item
     */
    public void setQuotaAllocatedQuantity( @Nullable final BigDecimal quotaAllocatedQuantity )
    {
        rememberChangedField("QuotaAllocatedQuantity", this.quotaAllocatedQuantity);
        this.quotaAllocatedQuantity = quotaAllocatedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuotaMaximumQuantity</b>
     * </p>
     *
     * @param quotaMaximumQuantity
     *            Maximum Quantity of Quota Arrangement Item
     */
    public void setQuotaMaximumQuantity( @Nullable final BigDecimal quotaMaximumQuantity )
    {
        rememberChangedField("QuotaMaximumQuantity", this.quotaMaximumQuantity);
        this.quotaMaximumQuantity = quotaMaximumQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @param productionVersion
     *            Production Version
     */
    public void setProductionVersion( @Nullable final String productionVersion )
    {
        rememberChangedField("ProductionVersion", this.productionVersion);
        this.productionVersion = productionVersion;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMaxLotSizeQuantity</b>
     * </p>
     *
     * @param materialMaxLotSizeQuantity
     *            Maximum Lot Size per Quota Item
     */
    public void setMaterialMaxLotSizeQuantity( @Nullable final BigDecimal materialMaxLotSizeQuantity )
    {
        rememberChangedField("MaterialMaxLotSizeQuantity", this.materialMaxLotSizeQuantity);
        this.materialMaxLotSizeQuantity = materialMaxLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialMinLotSizeQuantity</b>
     * </p>
     *
     * @param materialMinLotSizeQuantity
     *            Minimum Lot Size per Quota Item
     */
    public void setMaterialMinLotSizeQuantity( @Nullable final BigDecimal materialMinLotSizeQuantity )
    {
        rememberChangedField("MaterialMinLotSizeQuantity", this.materialMinLotSizeQuantity);
        this.materialMinLotSizeQuantity = materialMinLotSizeQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialRoundingProfile</b>
     * </p>
     *
     * @param materialRoundingProfile
     *            Rounding Profile
     */
    public void setMaterialRoundingProfile( @Nullable final String materialRoundingProfile )
    {
        rememberChangedField("MaterialRoundingProfile", this.materialRoundingProfile);
        this.materialRoundingProfile = materialRoundingProfile;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyIsAssignedOnce</b>
     * </p>
     *
     * @param sourceOfSupplyIsAssignedOnce
     *            Indicator: "Once-Only"
     */
    public void setSourceOfSupplyIsAssignedOnce( @Nullable final Boolean sourceOfSupplyIsAssignedOnce )
    {
        rememberChangedField("SourceOfSupplyIsAssignedOnce", this.sourceOfSupplyIsAssignedOnce);
        this.sourceOfSupplyIsAssignedOnce = sourceOfSupplyIsAssignedOnce;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumReleaseQuantity</b>
     * </p>
     *
     * @param maximumReleaseQuantity
     *            Maximum Release Quantity per Period
     */
    public void setMaximumReleaseQuantity( @Nullable final BigDecimal maximumReleaseQuantity )
    {
        rememberChangedField("MaximumReleaseQuantity", this.maximumReleaseQuantity);
        this.maximumReleaseQuantity = maximumReleaseQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>QuotaReleasePeriodType</b>
     * </p>
     *
     * @param quotaReleasePeriodType
     *            Period to Which the Release Quantity Relates
     */
    public void setQuotaReleasePeriodType( @Nullable final String quotaReleasePeriodType )
    {
        rememberChangedField("QuotaReleasePeriodType", this.quotaReleasePeriodType);
        this.quotaReleasePeriodType = quotaReleasePeriodType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfPeriodsPerRelQuantity</b>
     * </p>
     *
     * @param numberOfPeriodsPerRelQuantity
     *            Number of Periods to Which the Release Quantity Relates
     */
    public void setNumberOfPeriodsPerRelQuantity( @Nullable final String numberOfPeriodsPerRelQuantity )
    {
        rememberChangedField("NumberOfPeriodsPerRelQuantity", this.numberOfPeriodsPerRelQuantity);
        this.numberOfPeriodsPerRelQuantity = numberOfPeriodsPerRelQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>QuotaDeterminationPriority</b>
     * </p>
     *
     * @param quotaDeterminationPriority
     *            Priority for Determination of Sequence
     */
    public void setQuotaDeterminationPriority( @Nullable final String quotaDeterminationPriority )
    {
        rememberChangedField("QuotaDeterminationPriority", this.quotaDeterminationPriority);
        this.quotaDeterminationPriority = quotaDeterminationPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerMaterial</b>
     * </p>
     *
     * @param manufacturerMaterial
     *            Material number corresponding to manufacturer part number
     */
    public void setManufacturerMaterial( @Nullable final String manufacturerMaterial )
    {
        rememberChangedField("ManufacturerMaterial", this.manufacturerMaterial);
        this.manufacturerMaterial = manufacturerMaterial;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedDeliveryDurationInDays</b>
     * </p>
     *
     * @param plannedDeliveryDurationInDays
     *            Planned Delivery Time in Days
     */
    public void setPlannedDeliveryDurationInDays( @Nullable final BigDecimal plannedDeliveryDurationInDays )
    {
        rememberChangedField("PlannedDeliveryDurationInDays", this.plannedDeliveryDurationInDays);
        this.plannedDeliveryDurationInDays = plannedDeliveryDurationInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialBaseUnit</b>
     * </p>
     *
     * @param materialBaseUnit
     *            Base Unit of Measure
     */
    public void setMaterialBaseUnit( @Nullable final String materialBaseUnit )
    {
        rememberChangedField("MaterialBaseUnit", this.materialBaseUnit);
        this.materialBaseUnit = materialBaseUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgQuotaArrangementItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("QuotaArrangement", getQuotaArrangement());
        result.put("QuotaArrangementItem", getQuotaArrangementItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("QuotaArrangement", getQuotaArrangement());
        values.put("QuotaArrangementItem", getQuotaArrangementItem());
        values.put("MaterialProcurementCategory", getMaterialProcurementCategory());
        values.put("MaterialProcurementType", getMaterialProcurementType());
        values.put("Supplier", getSupplier());
        values.put("SupplyingPlant", getSupplyingPlant());
        values.put("PurchasingSourceQuota", getPurchasingSourceQuota());
        values.put("QuotaBaseQuantity", getQuotaBaseQuantity());
        values.put("QuotaAllocatedQuantity", getQuotaAllocatedQuantity());
        values.put("QuotaMaximumQuantity", getQuotaMaximumQuantity());
        values.put("ProductionVersion", getProductionVersion());
        values.put("MaterialMaxLotSizeQuantity", getMaterialMaxLotSizeQuantity());
        values.put("MaterialMinLotSizeQuantity", getMaterialMinLotSizeQuantity());
        values.put("MaterialRoundingProfile", getMaterialRoundingProfile());
        values.put("SourceOfSupplyIsAssignedOnce", getSourceOfSupplyIsAssignedOnce());
        values.put("MaximumReleaseQuantity", getMaximumReleaseQuantity());
        values.put("QuotaReleasePeriodType", getQuotaReleasePeriodType());
        values.put("NumberOfPeriodsPerRelQuantity", getNumberOfPeriodsPerRelQuantity());
        values.put("QuotaDeterminationPriority", getQuotaDeterminationPriority());
        values.put("ManufacturerMaterial", getManufacturerMaterial());
        values.put("PlannedDeliveryDurationInDays", getPlannedDeliveryDurationInDays());
        values.put("MaterialBaseUnit", getMaterialBaseUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("QuotaArrangement") ) {
                final Object value = values.remove("QuotaArrangement");
                if( (value == null) || (!value.equals(getQuotaArrangement())) ) {
                    setQuotaArrangement(((String) value));
                }
            }
            if( values.containsKey("QuotaArrangementItem") ) {
                final Object value = values.remove("QuotaArrangementItem");
                if( (value == null) || (!value.equals(getQuotaArrangementItem())) ) {
                    setQuotaArrangementItem(((String) value));
                }
            }
            if( values.containsKey("MaterialProcurementCategory") ) {
                final Object value = values.remove("MaterialProcurementCategory");
                if( (value == null) || (!value.equals(getMaterialProcurementCategory())) ) {
                    setMaterialProcurementCategory(((String) value));
                }
            }
            if( values.containsKey("MaterialProcurementType") ) {
                final Object value = values.remove("MaterialProcurementType");
                if( (value == null) || (!value.equals(getMaterialProcurementType())) ) {
                    setMaterialProcurementType(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplyingPlant") ) {
                final Object value = values.remove("SupplyingPlant");
                if( (value == null) || (!value.equals(getSupplyingPlant())) ) {
                    setSupplyingPlant(((String) value));
                }
            }
            if( values.containsKey("PurchasingSourceQuota") ) {
                final Object value = values.remove("PurchasingSourceQuota");
                if( (value == null) || (!value.equals(getPurchasingSourceQuota())) ) {
                    setPurchasingSourceQuota(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuotaBaseQuantity") ) {
                final Object value = values.remove("QuotaBaseQuantity");
                if( (value == null) || (!value.equals(getQuotaBaseQuantity())) ) {
                    setQuotaBaseQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuotaAllocatedQuantity") ) {
                final Object value = values.remove("QuotaAllocatedQuantity");
                if( (value == null) || (!value.equals(getQuotaAllocatedQuantity())) ) {
                    setQuotaAllocatedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuotaMaximumQuantity") ) {
                final Object value = values.remove("QuotaMaximumQuantity");
                if( (value == null) || (!value.equals(getQuotaMaximumQuantity())) ) {
                    setQuotaMaximumQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductionVersion") ) {
                final Object value = values.remove("ProductionVersion");
                if( (value == null) || (!value.equals(getProductionVersion())) ) {
                    setProductionVersion(((String) value));
                }
            }
            if( values.containsKey("MaterialMaxLotSizeQuantity") ) {
                final Object value = values.remove("MaterialMaxLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaterialMaxLotSizeQuantity())) ) {
                    setMaterialMaxLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialMinLotSizeQuantity") ) {
                final Object value = values.remove("MaterialMinLotSizeQuantity");
                if( (value == null) || (!value.equals(getMaterialMinLotSizeQuantity())) ) {
                    setMaterialMinLotSizeQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialRoundingProfile") ) {
                final Object value = values.remove("MaterialRoundingProfile");
                if( (value == null) || (!value.equals(getMaterialRoundingProfile())) ) {
                    setMaterialRoundingProfile(((String) value));
                }
            }
            if( values.containsKey("SourceOfSupplyIsAssignedOnce") ) {
                final Object value = values.remove("SourceOfSupplyIsAssignedOnce");
                if( (value == null) || (!value.equals(getSourceOfSupplyIsAssignedOnce())) ) {
                    setSourceOfSupplyIsAssignedOnce(((Boolean) value));
                }
            }
            if( values.containsKey("MaximumReleaseQuantity") ) {
                final Object value = values.remove("MaximumReleaseQuantity");
                if( (value == null) || (!value.equals(getMaximumReleaseQuantity())) ) {
                    setMaximumReleaseQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuotaReleasePeriodType") ) {
                final Object value = values.remove("QuotaReleasePeriodType");
                if( (value == null) || (!value.equals(getQuotaReleasePeriodType())) ) {
                    setQuotaReleasePeriodType(((String) value));
                }
            }
            if( values.containsKey("NumberOfPeriodsPerRelQuantity") ) {
                final Object value = values.remove("NumberOfPeriodsPerRelQuantity");
                if( (value == null) || (!value.equals(getNumberOfPeriodsPerRelQuantity())) ) {
                    setNumberOfPeriodsPerRelQuantity(((String) value));
                }
            }
            if( values.containsKey("QuotaDeterminationPriority") ) {
                final Object value = values.remove("QuotaDeterminationPriority");
                if( (value == null) || (!value.equals(getQuotaDeterminationPriority())) ) {
                    setQuotaDeterminationPriority(((String) value));
                }
            }
            if( values.containsKey("ManufacturerMaterial") ) {
                final Object value = values.remove("ManufacturerMaterial");
                if( (value == null) || (!value.equals(getManufacturerMaterial())) ) {
                    setManufacturerMaterial(((String) value));
                }
            }
            if( values.containsKey("PlannedDeliveryDurationInDays") ) {
                final Object value = values.remove("PlannedDeliveryDurationInDays");
                if( (value == null) || (!value.equals(getPlannedDeliveryDurationInDays())) ) {
                    setPlannedDeliveryDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialBaseUnit") ) {
                final Object value = values.remove("MaterialBaseUnit");
                if( (value == null) || (!value.equals(getMaterialBaseUnit())) ) {
                    setMaterialBaseUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurchasingQuotaArrangement") ) {
                final Object value = (values).remove("to_PurchasingQuotaArrangement");
                if( value instanceof Map ) {
                    if( toPurchasingQuotaArrangement == null ) {
                        toPurchasingQuotaArrangement = new PurchasingQuotaArrangement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurchasingQuotaArrangement.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgQuotaArrangementItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgQuotaArrangementItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgQuotaArrangementItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgQuotaArrangementItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurchasingQuotaArrangement != null ) {
            (values).put("to_PurchasingQuotaArrangement", toPurchasingQuotaArrangement);
        }
        return values;
    }

    /**
     * Fetches the <b>PurchasingQuotaArrangement</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PurchasingQuotaArrangement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurchasingQuotaArrangement</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchasingQuotaArrangement fetchPurchasingQuotaArrangement()
    {
        return fetchFieldAsSingle("to_PurchasingQuotaArrangement", PurchasingQuotaArrangement.class);
    }

    /**
     * Retrieval of associated <b>PurchasingQuotaArrangement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurchasingQuotaArrangement</b>.
     * <p>
     * If the navigation property <b>to_PurchasingQuotaArrangement</b> of a queried <b>PurgQuotaArrangementItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurchasingQuotaArrangement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurchasingQuotaArrangement getPurchasingQuotaArrangementOrFetch()
    {
        if( toPurchasingQuotaArrangement == null ) {
            toPurchasingQuotaArrangement = fetchPurchasingQuotaArrangement();
        }
        return toPurchasingQuotaArrangement;
    }

    /**
     * Retrieval of associated <b>PurchasingQuotaArrangement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurchasingQuotaArrangement</b>.
     * <p>
     * If the navigation property for an entity <b>PurgQuotaArrangementItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurchasingQuotaArrangement</b> is already loaded, the
     *         result will contain the <b>PurchasingQuotaArrangement</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurchasingQuotaArrangement> getPurchasingQuotaArrangementIfPresent()
    {
        return Option.of(toPurchasingQuotaArrangement);
    }

    /**
     * Overwrites the associated <b>PurchasingQuotaArrangement</b> entity for the loaded navigation property
     * <b>to_PurchasingQuotaArrangement</b>.
     *
     * @param value
     *            New <b>PurchasingQuotaArrangement</b> entity.
     */
    public void setPurchasingQuotaArrangement( final PurchasingQuotaArrangement value )
    {
        toPurchasingQuotaArrangement = value;
    }

    /**
     * Helper class to allow for fluent creation of PurgQuotaArrangementItem instances.
     *
     */
    public final static class PurgQuotaArrangementItemBuilder
    {

        private PurchasingQuotaArrangement toPurchasingQuotaArrangement;

        private PurgQuotaArrangementItem.PurgQuotaArrangementItemBuilder toPurchasingQuotaArrangement(
            final PurchasingQuotaArrangement value )
        {
            toPurchasingQuotaArrangement = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurchasingQuotaArrangement</b> for <b>PurgQuotaArrangementItem</b> to single
         * <b>PurchasingQuotaArrangement</b>.
         *
         * @param value
         *            The PurchasingQuotaArrangement to build this PurgQuotaArrangementItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgQuotaArrangementItem.PurgQuotaArrangementItemBuilder purchasingQuotaArrangement(
            final PurchasingQuotaArrangement value )
        {
            return toPurchasingQuotaArrangement(value);
        }

    }

}
