/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.selectable.PurgQuotaArrangementItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
 * PurgQuotaArrangementItem} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class PurgQuotaArrangementItemByKeyFluentHelper
    extends
    FluentHelperByKey<PurgQuotaArrangementItemByKeyFluentHelper, PurgQuotaArrangementItem, PurgQuotaArrangementItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     * PurgQuotaArrangementItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PurgQuotaArrangementItem}
     * @param quotaArrangement
     *            Number of quota arrangement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param quotaArrangementItem
     *            Quota arrangement item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PurgQuotaArrangementItem}
     */
    public PurgQuotaArrangementItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String quotaArrangement,
        final String quotaArrangementItem )
    {
        super(servicePath, entityCollection);
        this.key.put("QuotaArrangement", quotaArrangement);
        this.key.put("QuotaArrangementItem", quotaArrangementItem);
    }

    @Override
    @Nonnull
    protected Class<PurgQuotaArrangementItem> getEntityClass()
    {
        return PurgQuotaArrangementItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
