/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PurchasingQuotaArrangementServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService
 * PurchasingQuotaArrangementService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPurchasingQuotaArrangementServiceBatch
    extends
    BatchFluentHelperBasic<PurchasingQuotaArrangementServiceBatch, PurchasingQuotaArrangementServiceBatchChangeSet>
    implements
    PurchasingQuotaArrangementServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPurchasingQuotaArrangementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingQuotaArrangementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPurchasingQuotaArrangementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPurchasingQuotaArrangementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingQuotaArrangementServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingQuotaArrangementServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPurchasingQuotaArrangementServiceBatchChangeSet(this, service);
    }

}
