/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem;

/**
 * Implementation of the {@link PurchasingQuotaArrangementServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService
 * PurchasingQuotaArrangementService}.
 *
 */
public class DefaultPurchasingQuotaArrangementServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PurchasingQuotaArrangementServiceBatch, PurchasingQuotaArrangementServiceBatchChangeSet>
    implements
    PurchasingQuotaArrangementServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService service;

    @SuppressWarnings( "deprecation" )
    DefaultPurchasingQuotaArrangementServiceBatchChangeSet(
        @Nonnull final DefaultPurchasingQuotaArrangementServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPurchasingQuotaArrangementServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PurchasingQuotaArrangementServiceBatchChangeSet createPurchasingQuotaArrangement(
        @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement )
    {
        return addRequestCreate(service::createPurchasingQuotaArrangement, purchasingQuotaArrangement);
    }

    @Nonnull
    @Override
    public PurchasingQuotaArrangementServiceBatchChangeSet updatePurchasingQuotaArrangement(
        @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement )
    {
        return addRequestUpdate(service::updatePurchasingQuotaArrangement, purchasingQuotaArrangement);
    }

    @Nonnull
    @Override
    public PurchasingQuotaArrangementServiceBatchChangeSet deletePurchasingQuotaArrangement(
        @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement )
    {
        return addRequestDelete(service::deletePurchasingQuotaArrangement, purchasingQuotaArrangement);
    }

    @Nonnull
    @Override
    public PurchasingQuotaArrangementServiceBatchChangeSet createPurgQuotaArrangementItem(
        @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem )
    {
        return addRequestCreate(service::createPurgQuotaArrangementItem, purgQuotaArrangementItem);
    }

    @Nonnull
    @Override
    public PurchasingQuotaArrangementServiceBatchChangeSet updatePurgQuotaArrangementItem(
        @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem )
    {
        return addRequestUpdate(service::updatePurgQuotaArrangementItem, purgQuotaArrangementItem);
    }

    @Nonnull
    @Override
    public PurchasingQuotaArrangementServiceBatchChangeSet deletePurgQuotaArrangementItem(
        @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem )
    {
        return addRequestDelete(service::deletePurgQuotaArrangementItem, purgQuotaArrangementItem);
    }

}
