/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingQuotaArrangementService
 * PurchasingQuotaArrangementService}.
 *
 */
public interface PurchasingQuotaArrangementServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PurchasingQuotaArrangementServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PurchasingQuotaArrangementServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     * PurchasingQuotaArrangement} entity and save it to the S/4HANA system.
     *
     * @param purchasingQuotaArrangement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *            PurchasingQuotaArrangement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementServiceBatchChangeSet
        createPurchasingQuotaArrangement( @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     * PurchasingQuotaArrangement} entity and save it to the S/4HANA system.
     *
     * @param purchasingQuotaArrangement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *            PurchasingQuotaArrangement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementServiceBatchChangeSet
        updatePurchasingQuotaArrangement( @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     * PurchasingQuotaArrangement} entity in the S/4HANA system.
     *
     * @param purchasingQuotaArrangement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurchasingQuotaArrangement
     *            PurchasingQuotaArrangement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementServiceBatchChangeSet
        deletePurchasingQuotaArrangement( @Nonnull final PurchasingQuotaArrangement purchasingQuotaArrangement );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     * PurgQuotaArrangementItem} entity and save it to the S/4HANA system.
     *
     * @param purgQuotaArrangementItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *            PurgQuotaArrangementItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementServiceBatchChangeSet
        createPurgQuotaArrangementItem( @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     * PurgQuotaArrangementItem} entity and save it to the S/4HANA system.
     *
     * @param purgQuotaArrangementItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *            PurgQuotaArrangementItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementServiceBatchChangeSet
        updatePurgQuotaArrangementItem( @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     * PurgQuotaArrangementItem} entity in the S/4HANA system.
     *
     * @param purgQuotaArrangementItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
     *            PurgQuotaArrangementItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PurchasingQuotaArrangementServiceBatchChangeSet
        deletePurgQuotaArrangementItem( @Nonnull final PurgQuotaArrangementItem purgQuotaArrangementItem );

}
