/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.selectable.PurgQuotaArrangementItemSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
 * PurgQuotaArrangementItem} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class PurgQuotaArrangementItemLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<PurgQuotaArrangementItemLink<ObjectT>, PurgQuotaArrangementItem, ObjectT>
    implements
    PurgQuotaArrangementItemSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public PurgQuotaArrangementItemLink( final String fieldName )
    {
        super(fieldName);
    }

    private PurgQuotaArrangementItemLink(
        final EntityLink<PurgQuotaArrangementItemLink<ObjectT>, PurgQuotaArrangementItem, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected PurgQuotaArrangementItemLink<ObjectT> translateLinkType(
        final EntityLink<PurgQuotaArrangementItemLink<ObjectT>, PurgQuotaArrangementItem, ObjectT> link )
    {
        return new PurgQuotaArrangementItemLink<ObjectT>(link);
    }

}
