/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem
 * PurgQuotaArrangementItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.field.PurgQuotaArrangementItemField
 * PurgQuotaArrangementItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.link.PurgQuotaArrangementItemLink
 * PurgQuotaArrangementItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#QUOTA_ARRANGEMENT
 * QUOTA_ARRANGEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#QUOTA_ARRANGEMENT_ITEM
 * QUOTA_ARRANGEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#MATERIAL_PROCUREMENT_CATEGORY
 * MATERIAL_PROCUREMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#MATERIAL_PROCUREMENT_TYPE
 * MATERIAL_PROCUREMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#SUPPLYING_PLANT
 * SUPPLYING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#PURCHASING_SOURCE_QUOTA
 * PURCHASING_SOURCE_QUOTA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#QUOTA_BASE_QUANTITY
 * QUOTA_BASE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#QUOTA_ALLOCATED_QUANTITY
 * QUOTA_ALLOCATED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#QUOTA_MAXIMUM_QUANTITY
 * QUOTA_MAXIMUM_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#PRODUCTION_VERSION
 * PRODUCTION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#MATERIAL_MAX_LOT_SIZE_QUANTITY
 * MATERIAL_MAX_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#MATERIAL_MIN_LOT_SIZE_QUANTITY
 * MATERIAL_MIN_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#MATERIAL_ROUNDING_PROFILE
 * MATERIAL_ROUNDING_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#SOURCE_OF_SUPPLY_IS_ASSIGNED_ONCE
 * SOURCE_OF_SUPPLY_IS_ASSIGNED_ONCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#MAXIMUM_RELEASE_QUANTITY
 * MAXIMUM_RELEASE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#QUOTA_RELEASE_PERIOD_TYPE
 * QUOTA_RELEASE_PERIOD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#NUMBER_OF_PERIODS_PER_REL_QUANTITY
 * NUMBER_OF_PERIODS_PER_REL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#QUOTA_DETERMINATION_PRIORITY
 * QUOTA_DETERMINATION_PRIORITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#MANUFACTURER_MATERIAL
 * MANUFACTURER_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#PLANNED_DELIVERY_DURATION_IN_DAYS
 * PLANNED_DELIVERY_DURATION_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#MATERIAL_BASE_UNIT
 * MATERIAL_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingquotaarrangement.PurgQuotaArrangementItem#TO_PURCHASING_QUOTA_ARRANGEMENT
 * TO_PURCHASING_QUOTA_ARRANGEMENT}</li>
 * </ul>
 *
 */
public interface PurgQuotaArrangementItemSelectable extends EntitySelectable<PurgQuotaArrangementItem>
{

}
