/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.field.PurchasingSourceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.purchasingsource.selectable.PurchasingSourceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Purchasing Source Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurchasingSourceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurchasingSource extends VdmEntity<PurchasingSource>
{

    /**
     * Selector for all available fields of PurchasingSource.
     *
     */
    public final static PurchasingSourceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> MATERIAL = new PurchasingSourceField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> PLANT = new PurchasingSourceField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SourceListRecord</b>
     * </p>
     *
     * @return Number of Source List Record
     */
    @Key
    @SerializedName( "SourceListRecord" )
    @JsonProperty( "SourceListRecord" )
    @Nullable
    @ODataField( odataName = "SourceListRecord" )
    private String sourceListRecord;
    /**
     * Use with available fluent helpers to apply the <b>SourceListRecord</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> SOURCE_LIST_RECORD =
        new PurchasingSourceField<String>("SourceListRecord");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<LocalDateTime> CREATION_DATE =
        new PurchasingSourceField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserName</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUserName" )
    @JsonProperty( "CreatedByUserName" )
    @Nullable
    @ODataField( odataName = "CreatedByUserName" )
    private String createdByUserName;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUserName</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> CREATED_BY_USER_NAME =
        new PurchasingSourceField<String>("CreatedByUserName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Source List Record Valid From
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<LocalDateTime> VALIDITY_START_DATE =
        new PurchasingSourceField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Source List Record Valid To
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<LocalDateTime> VALIDITY_END_DATE =
        new PurchasingSourceField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier's Account Number
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> SUPPLIER = new PurchasingSourceField<String>("Supplier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierIsFixed</b>
     * </p>
     *
     * @return Indicator: Fixed Supplier
     */
    @SerializedName( "SupplierIsFixed" )
    @JsonProperty( "SupplierIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SupplierIsFixed" )
    private Boolean supplierIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>SupplierIsFixed</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<Boolean> SUPPLIER_IS_FIXED =
        new PurchasingSourceField<Boolean>("SupplierIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOutlineAgreement</b>
     * </p>
     *
     * @return Agreement Number
     */
    @SerializedName( "PurchaseOutlineAgreement" )
    @JsonProperty( "PurchaseOutlineAgreement" )
    @Nullable
    @ODataField( odataName = "PurchaseOutlineAgreement" )
    private String purchaseOutlineAgreement;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOutlineAgreement</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> PURCHASE_OUTLINE_AGREEMENT =
        new PurchasingSourceField<String>("PurchaseOutlineAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOutlineAgreementItem</b>
     * </p>
     *
     * @return Agreement Item
     */
    @SerializedName( "PurchaseOutlineAgreementItem" )
    @JsonProperty( "PurchaseOutlineAgreementItem" )
    @Nullable
    @ODataField( odataName = "PurchaseOutlineAgreementItem" )
    private String purchaseOutlineAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOutlineAgreementItem</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> PURCHASE_OUTLINE_AGREEMENT_ITEM =
        new PurchasingSourceField<String>("PurchaseOutlineAgreementItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @return Plant from Which Material is Procured
     */
    @SerializedName( "SupplyingPlant" )
    @JsonProperty( "SupplyingPlant" )
    @Nullable
    @ODataField( odataName = "SupplyingPlant" )
    private String supplyingPlant;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingPlant</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> SUPPLYING_PLANT =
        new PurchasingSourceField<String>("SupplyingPlant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyIsBlocked</b>
     * </p>
     *
     * @return Blocked Source of Supply
     */
    @SerializedName( "SourceOfSupplyIsBlocked" )
    @JsonProperty( "SourceOfSupplyIsBlocked" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SourceOfSupplyIsBlocked" )
    private Boolean sourceOfSupplyIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>SourceOfSupplyIsBlocked</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<Boolean> SOURCE_OF_SUPPLY_IS_BLOCKED =
        new PurchasingSourceField<Boolean>("SourceOfSupplyIsBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> PURCHASING_ORGANIZATION =
        new PurchasingSourceField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MRPSourcingControl</b>
     * </p>
     *
     * @return Source List Usage in Materials Planning
     */
    @SerializedName( "MRPSourcingControl" )
    @JsonProperty( "MRPSourcingControl" )
    @Nullable
    @ODataField( odataName = "MRPSourcingControl" )
    private String mRPSourcingControl;
    /**
     * Use with available fluent helpers to apply the <b>MRPSourcingControl</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> MRP_SOURCING_CONTROL =
        new PurchasingSourceField<String>("MRPSourcingControl");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<String> ORDER_QUANTITY_UNIT =
        new PurchasingSourceField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new PurchasingSourceField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IssgPlantIsFixed</b>
     * </p>
     *
     * @return Fixed issuing plant in case of stock transport order
     */
    @SerializedName( "IssgPlantIsFixed" )
    @JsonProperty( "IssgPlantIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IssgPlantIsFixed" )
    private Boolean issgPlantIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>IssgPlantIsFixed</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<Boolean> ISSG_PLANT_IS_FIXED =
        new PurchasingSourceField<Boolean>("IssgPlantIsFixed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurOutlineAgreementIsFixed</b>
     * </p>
     *
     * @return Fixed Outline Purchase Agreement Item
     */
    @SerializedName( "PurOutlineAgreementIsFixed" )
    @JsonProperty( "PurOutlineAgreementIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurOutlineAgreementIsFixed" )
    private Boolean purOutlineAgreementIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>PurOutlineAgreementIsFixed</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<Boolean> PUR_OUTLINE_AGREEMENT_IS_FIXED =
        new PurchasingSourceField<Boolean>("PurOutlineAgreementIsFixed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyIsFixed</b>
     * </p>
     *
     * @return Fixed Source of Supply
     */
    @SerializedName( "SourceOfSupplyIsFixed" )
    @JsonProperty( "SourceOfSupplyIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SourceOfSupplyIsFixed" )
    private Boolean sourceOfSupplyIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>SourceOfSupplyIsFixed</b> field to query operations.
     *
     */
    public final static PurchasingSourceField<Boolean> SOURCE_OF_SUPPLY_IS_FIXED =
        new PurchasingSourceField<Boolean>("SourceOfSupplyIsFixed");

    @Nonnull
    @Override
    public Class<PurchasingSource> getType()
    {
        return PurchasingSource.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SourceListRecord</b>
     * </p>
     *
     * @param sourceListRecord
     *            Number of Source List Record
     */
    public void setSourceListRecord( @Nullable final String sourceListRecord )
    {
        rememberChangedField("SourceListRecord", this.sourceListRecord);
        this.sourceListRecord = sourceListRecord;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserName</b>
     * </p>
     *
     * @param createdByUserName
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUserName( @Nullable final String createdByUserName )
    {
        rememberChangedField("CreatedByUserName", this.createdByUserName);
        this.createdByUserName = createdByUserName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Source List Record Valid From
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Source List Record Valid To
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier's Account Number
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SupplierIsFixed</b>
     * </p>
     *
     * @param supplierIsFixed
     *            Indicator: Fixed Supplier
     */
    public void setSupplierIsFixed( @Nullable final Boolean supplierIsFixed )
    {
        rememberChangedField("SupplierIsFixed", this.supplierIsFixed);
        this.supplierIsFixed = supplierIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOutlineAgreement</b>
     * </p>
     *
     * @param purchaseOutlineAgreement
     *            Agreement Number
     */
    public void setPurchaseOutlineAgreement( @Nullable final String purchaseOutlineAgreement )
    {
        rememberChangedField("PurchaseOutlineAgreement", this.purchaseOutlineAgreement);
        this.purchaseOutlineAgreement = purchaseOutlineAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOutlineAgreementItem</b>
     * </p>
     *
     * @param purchaseOutlineAgreementItem
     *            Agreement Item
     */
    public void setPurchaseOutlineAgreementItem( @Nullable final String purchaseOutlineAgreementItem )
    {
        rememberChangedField("PurchaseOutlineAgreementItem", this.purchaseOutlineAgreementItem);
        this.purchaseOutlineAgreementItem = purchaseOutlineAgreementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingPlant</b>
     * </p>
     *
     * @param supplyingPlant
     *            Plant from Which Material is Procured
     */
    public void setSupplyingPlant( @Nullable final String supplyingPlant )
    {
        rememberChangedField("SupplyingPlant", this.supplyingPlant);
        this.supplyingPlant = supplyingPlant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyIsBlocked</b>
     * </p>
     *
     * @param sourceOfSupplyIsBlocked
     *            Blocked Source of Supply
     */
    public void setSourceOfSupplyIsBlocked( @Nullable final Boolean sourceOfSupplyIsBlocked )
    {
        rememberChangedField("SourceOfSupplyIsBlocked", this.sourceOfSupplyIsBlocked);
        this.sourceOfSupplyIsBlocked = sourceOfSupplyIsBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MRPSourcingControl</b>
     * </p>
     *
     * @param mRPSourcingControl
     *            Source List Usage in Materials Planning
     */
    public void setMRPSourcingControl( @Nullable final String mRPSourcingControl )
    {
        rememberChangedField("MRPSourcingControl", this.mRPSourcingControl);
        this.mRPSourcingControl = mRPSourcingControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IssgPlantIsFixed</b>
     * </p>
     *
     * @param issgPlantIsFixed
     *            Fixed issuing plant in case of stock transport order
     */
    public void setIssgPlantIsFixed( @Nullable final Boolean issgPlantIsFixed )
    {
        rememberChangedField("IssgPlantIsFixed", this.issgPlantIsFixed);
        this.issgPlantIsFixed = issgPlantIsFixed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurOutlineAgreementIsFixed</b>
     * </p>
     *
     * @param purOutlineAgreementIsFixed
     *            Fixed Outline Purchase Agreement Item
     */
    public void setPurOutlineAgreementIsFixed( @Nullable final Boolean purOutlineAgreementIsFixed )
    {
        rememberChangedField("PurOutlineAgreementIsFixed", this.purOutlineAgreementIsFixed);
        this.purOutlineAgreementIsFixed = purOutlineAgreementIsFixed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfSupplyIsFixed</b>
     * </p>
     *
     * @param sourceOfSupplyIsFixed
     *            Fixed Source of Supply
     */
    public void setSourceOfSupplyIsFixed( @Nullable final Boolean sourceOfSupplyIsFixed )
    {
        rememberChangedField("SourceOfSupplyIsFixed", this.sourceOfSupplyIsFixed);
        this.sourceOfSupplyIsFixed = sourceOfSupplyIsFixed;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurchasingSource";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        result.put("Plant", getPlant());
        result.put("SourceListRecord", getSourceListRecord());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("SourceListRecord", getSourceListRecord());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUserName", getCreatedByUserName());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("Supplier", getSupplier());
        values.put("SupplierIsFixed", getSupplierIsFixed());
        values.put("PurchaseOutlineAgreement", getPurchaseOutlineAgreement());
        values.put("PurchaseOutlineAgreementItem", getPurchaseOutlineAgreementItem());
        values.put("SupplyingPlant", getSupplyingPlant());
        values.put("SourceOfSupplyIsBlocked", getSourceOfSupplyIsBlocked());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("MRPSourcingControl", getMRPSourcingControl());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("IssgPlantIsFixed", getIssgPlantIsFixed());
        values.put("PurOutlineAgreementIsFixed", getPurOutlineAgreementIsFixed());
        values.put("SourceOfSupplyIsFixed", getSourceOfSupplyIsFixed());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("SourceListRecord") ) {
                final Object value = values.remove("SourceListRecord");
                if( (value == null) || (!value.equals(getSourceListRecord())) ) {
                    setSourceListRecord(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUserName") ) {
                final Object value = values.remove("CreatedByUserName");
                if( (value == null) || (!value.equals(getCreatedByUserName())) ) {
                    setCreatedByUserName(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("SupplierIsFixed") ) {
                final Object value = values.remove("SupplierIsFixed");
                if( (value == null) || (!value.equals(getSupplierIsFixed())) ) {
                    setSupplierIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("PurchaseOutlineAgreement") ) {
                final Object value = values.remove("PurchaseOutlineAgreement");
                if( (value == null) || (!value.equals(getPurchaseOutlineAgreement())) ) {
                    setPurchaseOutlineAgreement(((String) value));
                }
            }
            if( values.containsKey("PurchaseOutlineAgreementItem") ) {
                final Object value = values.remove("PurchaseOutlineAgreementItem");
                if( (value == null) || (!value.equals(getPurchaseOutlineAgreementItem())) ) {
                    setPurchaseOutlineAgreementItem(((String) value));
                }
            }
            if( values.containsKey("SupplyingPlant") ) {
                final Object value = values.remove("SupplyingPlant");
                if( (value == null) || (!value.equals(getSupplyingPlant())) ) {
                    setSupplyingPlant(((String) value));
                }
            }
            if( values.containsKey("SourceOfSupplyIsBlocked") ) {
                final Object value = values.remove("SourceOfSupplyIsBlocked");
                if( (value == null) || (!value.equals(getSourceOfSupplyIsBlocked())) ) {
                    setSourceOfSupplyIsBlocked(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("MRPSourcingControl") ) {
                final Object value = values.remove("MRPSourcingControl");
                if( (value == null) || (!value.equals(getMRPSourcingControl())) ) {
                    setMRPSourcingControl(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("IssgPlantIsFixed") ) {
                final Object value = values.remove("IssgPlantIsFixed");
                if( (value == null) || (!value.equals(getIssgPlantIsFixed())) ) {
                    setIssgPlantIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("PurOutlineAgreementIsFixed") ) {
                final Object value = values.remove("PurOutlineAgreementIsFixed");
                if( (value == null) || (!value.equals(getPurOutlineAgreementIsFixed())) ) {
                    setPurOutlineAgreementIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("SourceOfSupplyIsFixed") ) {
                final Object value = values.remove("SourceOfSupplyIsFixed");
                if( (value == null) || (!value.equals(getSourceOfSupplyIsFixed())) ) {
                    setSourceOfSupplyIsFixed(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurchasingSourceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurchasingSourceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurchasingSourceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurchasingSourceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PurchasingSourceService.DEFAULT_SERVICE_PATH);
    }

}
